<?php 
function Get_taac_RtData($memData, &$dataArray, $extraPara = false){
    if(empty($memData)){
        $dataArray['无数据'] = true;
        $dataArray['错误'] = '数据长度不一致';
        $dataArray['更新时间'] = '无';
    }else{
        $dataArray['无数据'] = false;
        $v = unpack('S*',substr($memData, 4 , 44*2));
        $dataArray['AlertArray'] = array();
        $dataArray['S1状态'] = $v[1] == 1 ? '合闸' : '分闸';
        $dataArray['S2状态'] = $v[2] == 1 ? '合闸' : '分闸';
        $dataArray['S1-AB线电压'] = ($v[4]/100).' V';
        $dataArray['S1-BC线电压'] = ($v[5]/100).' V';
        $dataArray['S1-CA线电压'] = ($v[6]/100).' V';
        $dataArray['S2-AB线电压'] = ($v[7]/100).' V';
        $dataArray['S2-BC线电压'] = ($v[8]/100).' V';
        $dataArray['S2-CA线电压'] = ($v[9]/100).' V';
        $dataArray['S1频率'] = ($v[10]/100).' Hz';
        $dataArray['S2频率'] = ($v[11]/100).' Hz';
        $dataArray['相角差A'] = $v[12].' °';
        $dataArray['相角差B'] = $v[13].' °';
        $dataArray['相角差C'] = $v[14].' °';
        $dataArray['就地状态'] = $v[15] == 1 ? '就地' : '非就地';
        $dataArray['报警状态'] = $v[18] == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['报警状态'] = $v[18] == 1;
        $dataArray['S1电压状态'] = $v[19] == 0 ? '不正常' : '正常';
        $dataArray['AlertArray']['S1电压状态'] = $v[19] == 0;
        $dataArray['S2电压状态'] = $v[20] == 0 ? '不正常' : '正常';
        $dataArray['AlertArray']['S2电压状态'] = $v[20] == 0;
        $dataArray['欠压阈值'] = $v[21].' V';
        $dataArray['过压阈值'] = $v[22].' V';
        $dataArray['主电分闸延时'] = $v[25].' S';
        $dataArray['主电合闸延时'] = $v[26].' S';
        $dataArray['备电分闸延时'] = $v[27].' S';
        $dataArray['备电合闸延时'] = $v[28].' S';
        $dataArray['发电机启动延时'] = $v[31].' S';
        $dataArray['发电机停机延时'] = $v[32].' S';
        $dataArray['全分延时'] = $v[33].' S';
        $dataArray['延时T10'] = $v[34].' S';
        $dataArray['电压差设定值'] = $v[35].' V';
        $dataArray['频率差设定值'] = $v[36].' Hz';
        $dataArray['相角差设定值'] = $v[37].' °';
        $dataArray['通讯地址'] = $v[38];
        $dataArray['波特率'] = $v[39] == 1 ? '19200 bps' : '9600 bps';
        $dataArray['奇偶校验'] = $v[40] == 2 ? '奇校验' : $v[40] == 1 ? '偶校验' : '无';
        $dataArray['转换动作记录'] = $v[41] == 1 ? '开通' : '关闭';
        $dataArray['应用模式选择'] = $v[42] == 1 ? '市电-发电机' : '市电-市电';
        switch($v[43]){
            case 1: $dataArray['工作方式'] = '自复'; break;
            case 2: $dataArray['工作方式'] = '不自复'; break;
            case 3: $dataArray['工作方式'] = '手动'; break;
            case 4: $dataArray['工作方式'] = '并列'; break;
            case 5: $dataArray['工作方式'] = '通讯控制'; break;
            default: $dataArray['工作方式'] = '无效状态';
        }
        $dataArray['显示语言'] = $v[44] == 1 ? '英文' : '中文';
        
        $v = unpack('v', substr($memData, 4 + 44*2 , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 44 * 2 + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}




?>
