<?php


function Get_gassensor_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
        /* $dataObj->isEmpty = true;
        $dataObj->update_datetime = '无'; */
    } else {
        $dataArray["无数据"] = false;
        $dataArray['AlertArray'] = array();
        $v = unpack('S*', substr($memData, 4, 2*8));
        $dataArray["浓度"] = $v[1];
        $dataArray["精度"] = $v[2];
        $dataArray["状态"] = $v[3];
        $dataArray["气体种类"] = $v[4];
        $dataArray["气体单位"] = $v[5];
        $dataArray["低报值"] = $v[6];
        $dataArray["高报值"] = $v[7];
        $dataArray["量程值"] = $v[8];
        switch($dataArray["状态"]){
            case 0:
                $dataArray["状态"] = "预热中";
                break;
            case 1:
                $dataArray["状态"] = "正常工作中";
                break;
            case 3:
                $dataArray["状态"] = "传感器错误/故障";
                $dataArray['AlertArray']["状态"] = true;
                break;
            case 4:
                $dataArray["状态"] = "预警";
                $dataArray['AlertArray']["状态"] = true;
                break;
            case 5:
                $dataArray["状态"] = "一级报警";
                $dataArray['AlertArray']["状态"] = true;
                break;
            case 6:
                $dataArray["状态"] = "二级报警";
                $dataArray['AlertArray']["状态"] = true;
                break;
        }
        switch($dataArray["精度"])
        {
            case 1:
                $dataArray["浓度"] = number_format($dataArray["浓度"]/10, 1);
                break;
            case 2:
                $dataArray["浓度"] = number_format($dataArray["浓度"]/100, 2);
                break;
            case 2:
                $dataArray["浓度"] = number_format($dataArray["浓度"]/1000, 3);
                break;

        }
        switch($dataArray["气体单位"])
        {
            case 1:
                $dataArray["浓度"] .= "%LEL";
                break;
            case 2:
                $dataArray["浓度"] .= "%VOL";
                break;
            case 3:
                $dataArray["浓度"] .= "PPM";
                break;
            case 4:
                $dataArray["浓度"] .= "umol/mol";
                break;
            case 5:
                $dataArray["浓度"] .= "mg/m3";
                break;
            case 6:
                $dataArray["浓度"] .= "ug/m3";
                break;
            case 7:
                $dataArray["浓度"] .= "°C";
                break;
            case 8:
                $dataArray["浓度"] .= "%";
                break;
            case 9:
                $dataArray["浓度"] .= "%RH";
                break;
            case 0xA:
                $dataArray["浓度"] .= "PPB";
                break;
        }
        switch($dataArray["气体种类"])
        {
            case 1:
                $dataArray["气体种类"] = "甲烷";
                break;
            case 2:
                $dataArray["气体种类"] = "氨气";
                break;
            case 3:
                $dataArray["气体种类"] = "硫化氢";
                break;
            case 4:
                $dataArray["气体种类"] = "一氧化碳";
                break;
            case 5:
                $dataArray["气体种类"] = "氧气";
                break;
            case 6:
                $dataArray["气体种类"] = "氢气";
                break;
            case 7:
                $dataArray["气体种类"] = "乙烷";
                break;
            case 8:
                $dataArray["气体种类"] = "乙烯";
                break;
            case 9:
                $dataArray["气体种类"] = "乙炔";
                break;
        }
        $dataArray["气体种类"] = "可燃气体";
        $v = unpack('v', substr($memData, 4 + 2*8, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 2*8 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}


?>
