<?php

function Get_general_temp_humid_Signals($type){
    switch($type){
        case "AI":
            return array("911143000001");
        case "DI":
            return array();
        case "AO":
            return array();
        case "DO":
            return array();
        case "ALARM":
            return array();
        default:
            return array();
    }

}


function Get_general_temp_humid_UnicomCategory()
{
    return "911";
}


function Get_general_temp_humid_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;

        $v = unpack('f*', substr($memData, 4, 4*2));
        $dataArray["温度"] = number_format($v[1], 2)."℃";
        $dataArray["湿度"] = number_format($v[2], 2)."%";

        $v = unpack('v',substr($memData, 4 + 4*2, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData,4 + 4*2 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}
