<?php
function _ShowAlert(&$dataArray, $label, $value, $vsValue)
{
    if($value == 0x80){
    	$dataArray[$label] = '未监测';
	return;
    }
    $dataArray[$label] = $value == $vsValue ? '正常' : '告警';
    $dataArray['AlertArray'][$label] = $value != $vsValue;
}
 
function _ShowProtect(&$dataArray, $label, $value, $vsValue)
{
    if($value == 0x80){
        $dataArray[$label] = '未监测';
        return;
    }
    $dataArray[$label] = $value == $vsValue ? '正常' : '保护';
    $dataArray['AlertArray'][$label] = $value != $vsValue;
}


function Get_gree_DeviceIoControl_ErrorMsg($ret){
    switch($ret){
        case 1:
            return "执行成功";
        case 3:
            return "执行失败，校验不符";
        default:
            return "未知错误";
        }
}

function Get_gree_DeviceIoControl_Parameter($action, $parameter)
{
    if($action == 106 && count($parameter) == 1){
        return pack("S", intval($parameter[0]));
    }
    return -1;
}


function Get_gree_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '温度设定点':
            return array(0,  $dataArray['温度设定点']);
        case '回风温度':
            return array(0, $dataArray['室内温度']);
        case '开关机状态':
            return array(0, $dataArray['空调状态']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_gree_RtData($memData , &$dataArray , $extraPara = false)
{
        if (empty($memData)) {
            $dataArray['无数据'] = true;
            $dataArray['更新时间'] = '无';
            $dataArray['错误'] = '数据长度不一致';
        }else{
            $dataArray['无数据'] = false;
	    $v = unpack('C*', substr($memData, 4, 9));
	    $dataArray["空调状态"] = $v[1] == 0 ? "开机" : "关机";
	    $dataArray["主从机"] = $v[3] == 0x81 ? "主机" : "从机";
	    switch($v[4]){
		case 0x81:
		    $dataArray["模式"] = "制冷";
		    break;
		case 0x82:
		    $dataArray["模式"] = "制热";
		    break;
		case 0x83:
		    $dataArray["模式"] = "除湿";
		    break;
		case 0x84:
		    $dataArray["模式"] = "送风";
		    break;
		case 0x85:
		    $dataArray["模式"] = "自动制冷";
		    break;
		case 0x86:
                    $dataArray["模式"] = "自动制热";
                    break;
                case 0x87:
                    $dataArray["模式"] = "自动除湿";
                    break;
                case 0x88:
                    $dataArray["模式"] = "自动送风";
                    break;
	    }	
	    switch($v[5]){
                case 0x81:
                    $dataArray["内风机运行状态"] = "停";
                    break;
                case 0x82:
                    $dataArray["内风机运行状态"] = "微风";
                    break;
                case 0x83:
                    $dataArray["内风机运行状态"] = "低";
                    break;
                case 0x84:
                    $dataArray["内风机运行状态"] = "中";
                    break;
                case 0x85:
                    $dataArray["内风机运行状态"] = "高";
                    break;
                case 0x86:
                    $dataArray["内风机运行状态"] = "超高";
                    break;
	    }
	    $dataArray["是否屏蔽本地控制"] = $v[6] == 0x81 ? "不屏蔽" : "屏蔽";
	    $dataArray["压缩机启停"] = $v[7] == 0x81 ? "停止" : "运行";
	    $dataArray["扫风"] = $v[8] == 0x81 ? "关" : "开";
	    $dataArray["是否有故障"] = $v[9] == 0x81 ? "有故障" : "无故障";
	    $v = unpack('C*', substr($memData, 4 + 9, 31));
	    _ShowAlert($dataArray, "主机工作线/相电压AB/A", $v[1], 0x82);
	    _ShowAlert($dataArray, "主机工作线/相电压BC/B", $v[2], 0x82);
	    _ShowAlert($dataArray, "主机工作线/相电压CA/C", $v[3], 0x82);
	    _ShowAlert($dataArray, "主机工作相电流A", $v[4], 0x82);
	    _ShowAlert($dataArray, "主机工作相电流B", $v[5], 0x82);
	    _ShowAlert($dataArray, "主机工作相电流C", $v[6], 0x82);
	    _ShowAlert($dataArray, "回风温度", $v[7], 0x82);
	    _ShowAlert($dataArray, "回风湿度", $v[8], 0x82);
	    _ShowAlert($dataArray, "过滤器", $v[9], 0x82);
	    _ShowAlert($dataArray, "压缩机", $v[10], 0x82);
	    _ShowAlert($dataArray, "风机", $v[11], 0x82);
		
	    _ShowProtect($dataArray, "系统高压保护", $v[13], 0x0);
	    _ShowProtect($dataArray, "系统低压保护", $v[14], 0x0);
	    _ShowProtect($dataArray, "压缩机排气保护", $v[15], 0x0);
	    _ShowProtect($dataArray, "低电压过流保护", $v[16], 0x0);
	    _ShowProtect($dataArray, "室内环境感温包开短路", $v[17], 0x0);
	    _ShowProtect($dataArray, "室内蒸发器感温包开短路", $v[18], 0x0);
	    _ShowProtect($dataArray, "室外环境感温包开短路", $v[19], 0x0);
	    _ShowProtect($dataArray, "室外冷凝器感温包开短路", $v[20], 0x0);
	    _ShowProtect($dataArray, "室外排气感温包开短路", $v[21], 0x0);
	    _ShowProtect($dataArray, "系统异常室内外管温过高", $v[22], 0x0);
	    _ShowProtect($dataArray, "防冻结", $v[23], 0x0);
	    _ShowProtect($dataArray, "监控终端ST内部通讯故障", $v[24], 0x0);
	    _ShowProtect($dataArray, "压缩机过载保护", $v[25], 0x0);
	    _ShowProtect($dataArray, "模块保护", $v[26], 0x0);
	    _ShowProtect($dataArray, "压缩机失步故障", $v[27], 0x0);
	    _ShowProtect($dataArray, "PFC保护", $v[28], 0x0);
	    _ShowProtect($dataArray, "水满保护", $v[29], 0x0);
	    _ShowProtect($dataArray, "PG电机堵转", $v[30], 0x0);
	    _ShowProtect($dataArray, "跳线冒故障", $v[31], 0x0);
            $v = unpack('s*', substr($memData, 4 + 40, 4));
            $dataArray['温度设定值'] = $v[1].' ℃';
            $dataArray['环境温度'] = $v[2].' ℃';

            $v = unpack('v', substr($memData, 4 + 40 + 4 , 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, 4 + 40 + 4 + 2, 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}
