<?php

function Get_gtr85_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();

        $v = unpack('C', substr($memData, 4, 1));
        $dataArray['程序版本'] = $v[1];
        $v = unpack('f*', substr($memData, 4 + 1, 4*10));
        $dataArray["RS相电压"] = $v[1];
        $dataArray["ST相电压"] = $v[2];
        $dataArray["TR相电压"] = $v[3];
        $dataArray["频率"] = $v[4];
        $dataArray["RN线电压"] = $v[5];
        $dataArray["SN线电压"] = $v[6];
        $dataArray["TN线电压"] = $v[7];
        $dataArray["功率因素"] = $v[8];
        $dataArray["功率"] = $v[9];
        $dataArray["电能"] = $v[10];
        $v = unpack('C', substr($memData, 4 + 1 + 4*10, 1));
        $dataArray["单位"] = $v[1] == 0 ? "公制" : "英制";
        $v = unpack('S', substr($memData, 4 + 1 + 4*10 + 1, 2));
        $dataArray["转速"] = $v[1];
        $v = unpack('f*', substr($memData, 4 + 1 + 4*10 + 1 + 2, 4*2));
        $dataArray["电池电压"] = number_format($v[1], 2);
        $dataArray["充电电流"] = number_format($v[2], 2);
        $v = unpack('C*', substr($memData, 4 + 1 + 4*10 + 1 + 2 + 4*2, 11));
        $output = $v[1];
        //start
        $dataArray["辅助输出继电器0"] = $v[1] & 0x1 ? "开启" : "关闭";
        $dataArray["辅助输出继电器1"] = ($v[1] >> 1) & 0x1 ? "开启" : "关闭";
        $dataArray["辅助输出继电器2"] = ($v[1] >> 2) & 0x1 ? "开启" : "关闭";

        $dataArray["继电器跳开保护"] = ($v[1] >> 3) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["继电器跳开保护"] = ($v[1] >> 3) & 0x1;

        $dataArray["继电器告警"] = ($v[1] >> 4) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["继电器告警"] = ($v[1] >> 4) & 0x1;

        $dataArray["辅助输出继电器3"] = ($v[1] >> 5) & 0x1 ? "开启" : "关闭";
        $dataArray["启动马达继电器"] = ($v[1] >> 6) & 0x1 ? "开启" : "关闭";
        $dataArray["油阀继电器"] = ($v[1] >> 7) & 0x1 ? "开启" : "关闭";
        //end
        $dataArray["错误代码"] = intval($v[2]);
        $dataArray["状态代码"] = intval($v[3]);
        $do_a = $v[4];
        $dataArray["油机启动"] = $do_a & 0x1 ? "开启" : "关闭";
        $dataArray["油机停车"] = ($do_a >> 1) & 0x1 ? "开启" : "关闭";
        $dataArray["空开跳开保护"] = ($do_a >> 2) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["空开跳开保护"] = ($do_a >> 2) & 0x1;
        $dataArray["油机告警"] = ($do_a >> 3) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["油机告警"] = ($do_a >> 3) & 0x1;
        $dataArray["过盘车告警"] = ($do_a >> 4) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["过盘车告警"] = ($do_a >> 4) & 0x1;
        $dataArray["高水温告警"] = ($do_a >> 5) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["高水温告警"] = ($do_a >> 5) & 0x1;
        $dataArray["超速告警"] = ($do_a >> 6) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["超速告警"] = ($do_a >> 6) & 0x1;
        $dataArray["低油压告警"] = ($do_a >> 7) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["低油压告警"] = ($do_a >> 7) & 0x1;
        $do_b = $v[5];
        $dataArray["辅助输入2亮灯"] = $do_b & 0x1 ? "开启" : "关闭";

        $dataArray["低电瓶电压告警"] = ($do_b >> 1) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["低电瓶电压告警"] = ($do_b >> 1) & 0x1;

        $dataArray["频率低告警"] = ($do_b >> 2) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["频率低告警"] = ($do_b >> 2) & 0x1;

        $dataArray["过电压告警"] = ($do_b >> 3) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["过电压告警"] = ($do_b >> 3) & 0x1;

        $dataArray["低电压告警"] = ($do_b >> 4) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["低电压告警"] = ($do_b >> 4) & 0x1;

        $dataArray["过载告警"] = ($do_b >> 5) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["过载告警"] = ($do_b >> 5) & 0x1;

        $dataArray["短路告警"] = ($do_b >> 6) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["短路告警"] = ($do_b >> 6) & 0x1;

        $dataArray["LCD背光"] = ($do_a >> 7) & 0x1 ? "开启" : "关闭";
        $dataArray['输入A组状态'] = $v[6];
        $dataArray['输入B组状态'] = $v[7];
        $dataArray["累计运行时长"] = ($v[11]*100 + $v[10])."小时".$v[9]."分钟".$v[8]."秒";

        $v = unpack('f*', substr($memData, 4 + 1 + 4*10 + 1 + 2 + 4*2 + 11, 4*3));
        $dataArray["R相电流"] = $v[1];
        $dataArray["S相电流"] = $v[2];
        $dataArray["T相电流"] = $v[3];

        $v = unpack('C*', substr($memData, 4 + 1 + 4*10 + 1 + 2 + 4*2 + 11 + 4*3, 3));
        $dataArray["水温"] = $v[1];
        $dataArray["油压"] = $v[2];
        $dataArray["油位"] = $v[3];

        $v = unpack('f*', substr($memData, 4 + 1 + 4*10 + 1 + 2 + 4*2 + 11 + 4*3 + 3, 4));
        $dataArray["视在功率"] = $v[1];

        $v = unpack('S', substr($memData, 4 + 1 + 4*10 + 1 + 2 + 4*2 + 11 + 4*3 + 3 + 4, 2));
        $dataArray["充电机转速"] = $v[1];
        $v = unpack('C*', substr($memData, 4 + 1 + 4*10 + 1 + 2 + 4*2 + 11 + 4*3 + 3 + 4 + 2, 5));
        $dataArray["辅助输入1标志"] = $v[1];
        $dataArray["辅助输入1状态"] = $v[2];
        $dataArray["系统状态"] = $v[3];
        switch($v[4])
        {
            case 0:
                $dataArray['电流比值'] = "20:5";
                break;
            case 1:
                $dataArray['电流比值'] = "30:5";
                break;
            case 2:
                $dataArray['电流比值'] = "40:5";
                break;
            case 3:
                $dataArray['电流比值'] = "50:5";
                break;
            case 4:
                $dataArray['电流比值'] = "60:5";
                break;
            case 5:
                $dataArray['电流比值'] = "80:5";
                break;
            case 6:
                $dataArray['电流比值'] = "100:5";
                break;
            case 7:
                $dataArray['电流比值'] = "150:5";
                break;
            case 8:
                $dataArray['电流比值'] = "200:5";
                break;
            case 9:
                $dataArray['电流比值'] = "300:5";
                break;
            case 10:
                $dataArray['电流比值'] = "400:5";
                break;
            case 11:
                $dataArray['电流比值'] = "500:5";
                break;
            case 12:
                $dataArray['电流比值'] = "600:5";
                break;
            case 13:
                $dataArray['电流比值'] = "800:5";
                break;
            case 14:
                $dataArray['电流比值'] = "900:5";
                break;
            case 15:
                $dataArray['电流比值'] = "1000:5";
                break;
            case 16:
                $dataArray['电流比值'] = "1500:5";
                break;
            case 17:
                $dataArray['电流比值'] = "2000:5";
                break;
            case 18:
                $dataArray['电流比值'] = "3000:5";
                break;
            case 19:
                $dataArray['电流比值'] = "4000:5";
                break;
            case 20:
                $dataArray['电流比值'] = "5000:5";
                break;
            case 21:
                $dataArray['电流比值'] = "6000:5";
                break;
            case 22:
                $dataArray['电流比值'] = "10:5";
                break;
            case 23:
                $dataArray['电流比值'] = "15:5";
                break;
            case 24:
                $dataArray['电流比值'] = "75:5";
                break;
            case 25:
                $dataArray['电流比值'] = "250:5";
                break;
            case 26:
                $dataArray['电流比值'] = "750:5";
                break;
            case 27:
                $dataArray['电流比值'] = "1200:5";
                break;
            case 28:
                $dataArray['电流比值'] = "2500:5";
                break;
        }
        switch( $v[5])
        {
            case 0:
                $dataArray['电压比值'] = "110V";
                break;
            case 1:
                $dataArray['电压比值'] = "120V";
                break;
            case 2:
                $dataArray['电压比值'] = "190V";
                break;
            case 3:
                $dataArray['电压比值'] = "208V";
                break;
            case 4:
                $dataArray['电压比值'] = "220V";
                break;
            case 5:
                $dataArray['电压比值'] = "380V";
                break;
            case 6:
                $dataArray['电压比值'] = "440V";
                break;
            case 7:
                $dataArray['电压比值'] = "480V";
                break;
            case 8:
                $dataArray['电压比值'] = "3300V";
                break;
            default:
                $dataArray['电压比值'] = "无";
                break;
        }

        $v = unpack('v',substr($memData,  4 + 1 + 4*10 + 1 + 2 + 4*2 + 11 + 4*3 + 3 + 4 + 2 + 5, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData, 4 + 1 + 4*10 + 1 + 2 + 4*2 + 11 + 4*3 + 3 + 4 + 2 + 5 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}
