<?php


function _GetGu320aAlarm($v)
{
    switch ($v) {
        case 0: return "正常";
        case 1: return "无传感器信号";
        case 2: return "超速故障";
        case 3: return "低速故障";
        case 4: return "油压传感器开路";
        case 5: return "低油压故障";
        case 6: return "水温传感器开路";
        case 7: return "高水温故障";
        case 8: return "启动失败故障";
        case 9: return "停机失败故障";
        case 10: return "低电池电压告警";
        case 11: return "充电失败告警";
        case 12: return "电压低故障";
        case 13: return "电压高故障";
        case 16: return "电流高故障";
    }
    return "正常";
}

function _GetGu320aStatus($v)
{
    switch ($v) {
        case 3: return "油机停机";
        case 4: return "油机启动";
        case 5: return "进入测试状态";
        case 6: return "进入手动状态";
        case 7: return "进入自动状态";
        case 8: return "复位";
        default:
            return "无";
    }
    return "无效";
}


function Get_gu320a_RtData($memData , &$dataArray , $extraPara){
        if(empty($memData)){
            $dataArray['无数据'] = true;
            $dataArray['更新时间'] = '无';
            $dataArray['错误'] = '数据长度不一致';
        }else{
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            //GU320A_0_F_Data_t
            $v = unpack('S*', substr($memData, 4, 2 * 16));
            $dataArray["C相相电压"] = $v[1]."V";
            $dataArray["B相相电压"] = $v[2]."V";
            $dataArray["A相相电压"] = $v[3]."V";
            $dataArray["AC相线电压"] = $v[4]."V";
            $dataArray["BC相线电压"] = $v[5]."V";
            $dataArray["AB相线电压"] = $v[6]."V";
            $dataArray["C相相电流"] = $v[7]."A";
            $dataArray["B相相电流"] = $v[8]."A";
            $dataArray["A相相电流"] = $v[9]."A";
            $dataArray["C相功率因数"] = $v[10];
            $dataArray["B相功率因数"] = $v[11];
            $dataArray["A相功率因数"] = $v[12];
            $dataArray["发电频率"] = ($v[13]/10)."Hz";
            $dataArray["C相视在功率"] = $v[14]."kVA";
            $dataArray["B相视在功率"] = $v[15]."kVA";
            $dataArray["A相视在功率"] = $v[16]."kVA";
            //GU320A_10_1F_Data_t
            $v = unpack('S*', substr($memData, 4 + 2 * 16, 2 * 14));
            $dataArray["C相有功功率"] = $v[1]."kW";
            $dataArray["B相有功功率"] = $v[2]."kW";
            $dataArray["A相有功功率"] = $v[3]."kW";
            $dataArray["C相无功功率"] = $v[4]."kVAr";
            $dataArray["B相无功功率"] = $v[5]."kVAr";
            $dataArray["A相无功功率"] = $v[6]."kVAr";
            $dataArray["速度传感器转速"] = $v[7]."RPM";
            $dataArray["油压传感器值"] = $v[8]."kPa";
            $dataArray["水温传感器值"] = $v[9]."℃";
            $dataArray["电池电压"] = ($v[10]/10)."V";
            $dataArray["充电励磁电压"] = $v[11]."V";
            $dataArray["备用输入电压"] = $v[12]."mV";
            //$dataArray->alarm_1 = Realtime::_GetGu320aAlarm1($v[13]);
            //$dataArray->alarm_2 = Realtime::_GetGu320aAlarm1($v[14]);
            //GU320A_20_22_Data_t
            $v = unpack('S*', substr($memData, 4 + 2 * 30, 2 * 3));

            $dataArray["无传感器信号"] = $v[1] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']["无传感器信号"] = $v[1] == 1;
            $dataArray["超速故障"] = $v[1] == 2 ? '告警' : '正常';
            $dataArray['AlertArray']["超速故障"] = $v[1] == 2;
            $dataArray["低速故障"] = $v[1] == 3 ? '告警' : '正常';
            $dataArray['AlertArray']["低速故障"] = $v[1] == 3;
            $dataArray["油压传感器开路"] = $v[1] == 4 ? '告警' : '正常';
            $dataArray['AlertArray']["油压传感器开路"] = $v[1] == 4;
            $dataArray["低油压故障"] = $v[1] == 5 ? '告警' : '正常';
            $dataArray['AlertArray']["低油压故障"] = $v[1] == 5;
            $dataArray["水温传感器开路"] = $v[1] == 6 ? '告警' : '正常';
            $dataArray['AlertArray']["水温传感器开路"] = $v[1] == 6;
            $dataArray["高水温故障"] = $v[1] == 7 ? '告警' : '正常';
            $dataArray['AlertArray']["高水温故障"] = $v[1] == 7;
            $dataArray["启动失败故障"] = $v[1] == 8 ? '告警' : '正常';
            $dataArray['AlertArray']["启动失败故障"] = $v[1] == 8;
            $dataArray["停机失败故障"] = $v[1] == 9 ? '告警' : '正常';
            $dataArray['AlertArray']["停机失败故障"] = $v[1] == 9;
            $dataArray["低电池电压告警"] = $v[1] == 10 ? '告警' : '正常';
            $dataArray['AlertArray']["低电池电压告警"] = $v[1] == 10;
            $dataArray["充电失败告警"] = $v[1] == 11 ? '告警' : '正常';
            $dataArray['AlertArray']["充电失败告警"] = $v[1] == 11;
            $dataArray["电压低故障"] = $v[1] == 12 ? '告警' : '正常';
            $dataArray['AlertArray']["电压低故障"] = $v[1] == 12;
            $dataArray["电压高故障"] = $v[1] == 13 ? '告警' : '正常';
            $dataArray['AlertArray']["电压高故障"] = $v[1] == 13;
            $dataArray["电流高故障"] = $v[1] == 16 ? '告警' : '正常';
            $dataArray['AlertArray']["电流高故障"] = $v[1] == 16;


            $dataArray["油机状态"] = _GetGu320aStatus($v[2]);
            //$dataArray->SN = $v[3];
            //GU320A_2001_200F_Data_t
            $v = unpack('S*', substr($memData, 4 + 2 * 33, 2 * 9));
            //$dataArray->CommAddress = $v[1];
            //$dataArray->language = $v[2];
            //$dataArray->CT = $v[3];
            //$dataArray->GEN_V_Low_Alarm = $v[4];
            //$dataArray->GEN_V_Low_preALM = $v[5];
            //$dataArray->GEN_VHigh_preALM = $v[6];
            //$dataArray->GEN_V_High_Alarm = $v[7];
           // $dataArray->I_High_preALM = $v[8];
            //$dataArray->I_High_Alarm = $v[9];
            //GU320A_2010_201F_Data_t
            $v = unpack('S*', substr($memData, 4 + 2 * 42, 2 * 1));
            $dataArray["故障延时"] = $v[1]."S";
            $v = unpack('i*', substr($memData, 4 + 2 * 43, 4 * 2));
            $dataArray["有功电度"] = $v[1]."Kwh";
            $dataArray["无功电度"] = $v[2]."KVArh";
            $v = unpack('S*', substr($memData, 4 + 2 * 43 + 4 * 2, 2 * 10));
            /*$dataArray->VT = $v[1];
            //$dataArray->reserve = $v[2];保留
            $dataArray["发动机运行速度"] = $v[3]."RPM";
            $dataArray->PickupFrequency = $v[4];
            $dataArray->FuelMode = $v[5];
            $dataArray->T_sensorMode = $v[6];
            $dataArray->P_sensorMode = $v[7];
            $dataArray->H_sensorMode = $v[8];
            $dataArray->Start_delay = $v[9];
            $dataArray->Crank_attempt = $v[10];
            //GU320A_2020_202F_Data_t
            $v = unpack('S*', substr($memData, 4 + 2 * 53 + 4 * 2, 2 * 16));
            $dataArray->Crank_time = $v[1];
            $dataArray->Crank_rest = $v[2];
            $dataArray->Crank_disconnect = $v[3];
            $dataArray->Idle_delay = $v[4];
            $dataArray->Safety_on_delay = $v[5];
            $dataArray->Cooling_delay = $v[6];
            $dataArray->Stop_delay = $v[7];
            $dataArray->Under_SP_Alarm = $v[8];
            $dataArray->Under_SP_preALM = $v[9];
            $dataArray->Over_SP_preALM = $v[10];
            $dataArray->Over_SP_Alarm = $v[11];
            $dataArray->Oil_P_Low_Alarm = $v[12];
            $dataArray->Oil_P_Low_preALM = $v[13];
            $dataArray->Coolant_preALM = $v[14];
            $dataArray->Coolant_Alarm = $v[15];
            $dataArray->Batt_low_preALM = $v[16];
            //GU320A_2030_2032_Data_t
            $v = unpack('S*', substr($memData, 4 + 2 * 69 + 4 * 2, 2 * 3));
            $dataArray->RUNHr = $v[1];
            $dataArray->External_Alarm = $v[2];
            $dataArray->Fuel_level_input = $v[3];
            //GU320A_2040_204A_data_t
            $v = unpack('S*', substr($memData, 4 + 2 * 72 + 4 * 2, 2 * 11));
            $dataArray->V1_calibration = $v[1];
            $dataArray->V2_calibration = $v[2];
            $dataArray->V3_calibration = $v[3];
            $dataArray->I1_calibration = $v[4];
            $dataArray->I2_calibration = $v[5];
            $dataArray->I3_calibration = $v[6];
            $dataArray->Oil_pressure__calibration = $v[7];
            $dataArray->water_calibration = $v[8];
            $dataArray->battery_voltage_calibration = $v[9];
            $dataArray->magnetCharge_calibration = $v[10];
            $dataArray->assistInuputVoltage_calibration = $v[11];*/
            $v = unpack('v', substr($memData, 4 + 2 * 83 + 4 * 2, 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, 6 + 2 * 83 + 4 * 2, 5));
            $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    		
        }
}
