<?php
function Get_gu631a_RtData($memData , &$dataArray , $extraPara){
        if(empty($memData)){
            $dataArray['无数据'] = true;
            $dataArray['更新时间'] = '无';
            $dataArray['错误'] = '数据长度不一致';
        }else{
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            //GU631A_0_1A_t
            $v = unpack('s*',substr($memData,4, 27*2));
            $gen_data = array();
            $gen_data['C相电压'] = $v[1].' V';
            $gen_data['B相电压'] = $v[2].' V';
            $gen_data['A相电压'] = $v[3].' V';
            $gen_data['CA线电压'] = $v[4].' V';
            $gen_data['BC线电压'] = $v[5].' V';
            $gen_data['AB线电压'] = $v[6].' V';
            $gen_data['C相电流'] = $v[7].' A';
            $gen_data['B相电流'] = $v[8].' A';
            $gen_data['A相电流'] = $v[9].' A';
            $gen_data['C相功率因数'] = $v[10] / 100;
            $gen_data['B相功率因数'] = $v[11] / 100;
            $gen_data['A相功率因数'] = $v[12] / 100;
            $gen_data['发电频率'] = ($v[13] / 10).' Hz';
            $gen_data['C相视在功率'] = $v[14].' KVA';
            $gen_data['B相视在功率'] = $v[15].' KVA';
            $gen_data['A相视在功率'] = $v[16].' KVA';
            $gen_data['C相有功功率'] = $v[17].' KW';
            $gen_data['B相有功功率'] = $v[18].' KW';
            $gen_data['A相有功功率'] = $v[19].' KW';
            $gen_data['C相无功功率'] = $v[20].' Kvar';
            $gen_data['B相无功功率'] = $v[21].' kvar';
            $gen_data['A相无功功率'] = $v[22].' kvar';
            $dataArray['转速'] = $v[23].' RPM';
            $dataArray['油压'] = $v[24] == 9999 ? '开路' : ($v[24] / 10).' BAR';
            $dataArray['水温'] = $v[25] == -999 ? '开路' : $v[25].' ℃';
            $dataArray['电池电压'] = ($v[26] / 10).' V';
            $dataArray['充电励磁电压'] = ($v[27] / 10).' V';
            $dataArray['发电数据'] = $gen_data;
            
            //GU631A_1F_21_t
            $v = unpack('S*',substr($memData,4 + 27*2, 3*2));
            //$v[1]  预告警
            $dataArray['发电低电压1级'] = $v[2] == 1 ? '告警' : '正常';
            $dataArray['发电低电压2级'] = $v[2] == 2 ? '告警' : '正常';
            $dataArray['发电高电压1级'] = $v[2] == 3 ? '告警' : '正常';
            $dataArray['发电高电压2级'] = $v[2] == 4 ? '告警' : '正常';
            $dataArray['发电低频率1级'] = $v[2] == 5 ? '告警' : '正常';
            $dataArray['发电低频率2级'] = $v[2] == 6 ? '告警' : '正常';
            $dataArray['发电高频率1级'] = $v[2] == 7 ? '告警' : '正常';
            $dataArray['发电高频率2级'] = $v[2] == 8 ? '告警' : '正常';
            $dataArray['发电过流1级'] = $v[2] == 9 ? '告警' : '正常';
            $dataArray['发电过流2级'] = $v[2] == 10 ? '告警' : '正常';
            $dataArray['超负载1级'] = $v[2] == 13 ? '告警' : '正常';
            $dataArray['超负载2级'] = $v[2] == 14 ? '告警' : '正常';
            $dataArray['超速1级'] = $v[2] == 20 ? '告警' : '正常';
            $dataArray['超速2级'] = $v[2] == 21 ? '告警' : '正常';
            $dataArray['低速1级'] = $v[2] == 22 ? '告警' : '正常';
            $dataArray['低速2级'] = $v[2] == 23 ? '告警' : '正常';
            $dataArray['启动失败'] = $v[2] == 24 ? '告警' : '正常';
            $dataArray['停机失败'] = $v[2] == 25 ? '告警' : '正常';
            $dataArray['充电失败'] = $v[2] == 26 ? '告警' : '正常';
            $dataArray['发电合闸故障'] = $v[2] == 27 ? '告警' : '正常';
            $dataArray['市电合闸故障'] = $v[2] == 29 ? '告警' : '正常';
            $dataArray['电池高电压'] = $v[2] == 31 ? '告警' : '正常';
            $dataArray['电池低电压'] = $v[2] == 32 ? '告警' : '正常';
            $dataArray['低油压1级'] = $v[2] == 33 ? '告警' : '正常';
            $dataArray['低油压2级'] = $v[2] == 34 ? '告警' : '正常';
            $dataArray['高温1级'] = $v[2] == 35 ? '告警' : '正常';
            $dataArray['高温2级'] = $v[2] == 36 ? '告警' : '正常';
            $dataArray['低油位1级'] = $v[2] == 37 ? '告警' : '正常';
            $dataArray['低油位2级'] = $v[2] == 38 ? '告警' : '正常';
            $dataArray['辅助1低温1级'] = $v[2] == 40 ? '告警' : '正常';
            $dataArray['辅助1低温2级'] = $v[2] == 41 ? '告警' : '正常';
            $dataArray['辅助1高温1级'] = $v[2] == 42 ? '告警' : '正常';
            $dataArray['辅助1高温2级'] = $v[2] == 43 ? '告警' : '正常';
            $dataArray['开关量输入1'] = $v[2] == 52 ? '告警' : '正常';
            $dataArray['开关量输入2'] = $v[2] == 53 ? '告警' : '正常';
            $dataArray['开关量输入3'] = $v[2] == 54 ? '告警' : '正常';
            $dataArray['开关量输入4'] = $v[2] == 55 ? '告警' : '正常';
            $dataArray['开关量输入5'] = $v[2] == 56 ? '告警' : '正常';
            $dataArray['开关量输入6'] = $v[2] == 57 ? '告警' : '正常';
            $dataArray['开关量输入7'] = $v[2] == 58 ? '告警' : '正常';
            $dataArray['速度信号丢失'] = $v[2] == 64 ? '告警' : '正常';
            $dataArray['油压传感器开路'] = $v[2] == 65 ? '告警' : '正常';
            $dataArray['AlertArray']['发电低电压1级'] = $v[2] == 1;
            $dataArray['AlertArray']['发电低电压2级'] = $v[2] == 2;
            $dataArray['AlertArray']['发电高电压1级'] = $v[2] == 3;
            $dataArray['AlertArray']['发电高电压2级'] = $v[2] == 4;
            $dataArray['AlertArray']['发电低频率1级'] = $v[2] == 5;
            $dataArray['AlertArray']['发电低频率2级'] = $v[2] == 6;
            $dataArray['AlertArray']['发电高频率1级'] = $v[2] == 7;
            $dataArray['AlertArray']['发电高频率2级'] = $v[2] == 8;
            $dataArray['AlertArray']['发电过流1级'] = $v[2] == 9;
            $dataArray['AlertArray']['发电过流2级'] = $v[2] == 10;
            $dataArray['AlertArray']['超负载1级'] = $v[2] == 13;
            $dataArray['AlertArray']['超负载2级'] = $v[2] == 14;
            $dataArray['AlertArray']['超速1级'] = $v[2] == 20;
            $dataArray['AlertArray']['超速2级'] = $v[2] == 21;
            $dataArray['AlertArray']['低速1级'] = $v[2] == 22;
            $dataArray['AlertArray']['低速2级'] = $v[2] == 23;
            $dataArray['AlertArray']['启动失败'] = $v[2] == 24;
            $dataArray['AlertArray']['停机失败'] = $v[2] == 25;
            $dataArray['AlertArray']['充电失败'] = $v[2] == 26;
            $dataArray['AlertArray']['发电合闸故障'] = $v[2] == 27;
            $dataArray['AlertArray']['市电合闸故障'] = $v[2] == 29;
            $dataArray['AlertArray']['电池高电压'] = $v[2] == 31;
            $dataArray['AlertArray']['电池低电压'] = $v[2] == 32;
            $dataArray['AlertArray']['低油压1级'] = $v[2] == 33;
            $dataArray['AlertArray']['低油压2级'] = $v[2] == 34;
            $dataArray['AlertArray']['高温1级'] = $v[2] == 35;
            $dataArray['AlertArray']['高温2级'] = $v[2] == 36;
            $dataArray['AlertArray']['低油位1级'] = $v[2] == 37;
            $dataArray['AlertArray']['低油位2级'] = $v[2] == 38;
            $dataArray['AlertArray']['辅助1低温1级'] = $v[2] == 40;
            $dataArray['AlertArray']['辅助1低温2级'] = $v[2] == 41;
            $dataArray['AlertArray']['辅助1高温1级'] = $v[2] == 42;
            $dataArray['AlertArray']['辅助1高温2级'] = $v[2] == 43;
            $dataArray['AlertArray']['开关量输入1'] = $v[2] == 52;
            $dataArray['AlertArray']['开关量输入2'] = $v[2] == 53;
            $dataArray['AlertArray']['开关量输入3'] = $v[2] == 54;
            $dataArray['AlertArray']['开关量输入4'] = $v[2] == 55;
            $dataArray['AlertArray']['开关量输入5'] = $v[2] == 56;
            $dataArray['AlertArray']['开关量输入6'] = $v[2] == 57;
            $dataArray['AlertArray']['开关量输入7'] = $v[2] == 58;
            $dataArray['AlertArray']['速度信号丢失'] = $v[2] == 64;
            $dataArray['AlertArray']['油压传感器开路'] = $v[2] == 65;
            switch($v[3]){
                case 1 : $dataArray['系统运行模式'] = '手动转换到市电侧'; break;
                case 2 : $dataArray['系统运行模式'] = '手动转换到发电侧'; break;
                case 3 : $dataArray['系统运行模式'] = '油机停机'; break;
                case 4 : $dataArray['系统运行模式'] = '油机启动'; break;
                case 5 : $dataArray['系统运行模式'] = '进入测试状态'; break;
                case 6 : $dataArray['系统运行模式'] = '进入手动状态'; break;
                case 7 : $dataArray['系统运行模式'] = '进入自动状态'; break;
                case 8 : $dataArray['系统运行模式'] = '复位'; break;
                default : $dataArray['系统运行模式'] = '无效';
            }
            //GU631A_26_2F_t
            $v = unpack('s*',substr($memData,4 + 30*2, 10*2));
            $dataArray['发电相序'] = ($v[1] & 0x1) === 0 ? '相序正确' : '相序错误';
            $dataArray['市电相序'] = (($v[1] >> 1) & 0x1) === 0 ? '相序正确' : '相序错误';
            //rsv 1
            $city_data = array();
            $city_data['市电频率'] = ($v[3] / 10).' Hz';
            $city_data['C相电压'] = $v[4].' V';
            $city_data['B相电压'] = $v[5].' V';
            $city_data['A相电压'] = $v[6].' V';
            $city_data['CA线电压'] = $v[7].' V';
            $city_data['BC线电压'] = $v[8].' V';
            $city_data['AB线电压'] = $v[9].' V';
            //$dataArray['辅助输入2'] = $v[10];
            //GU631A_3F_62_t
            $v = unpack('s*',substr($memData,4 + 40*2, 37*2));
            $city_data['C相电流'] = $v[1].' A';
            $city_data['B相电流'] = $v[2].' A';
            $city_data['A相电流'] = $v[3].' A';
            $city_data['C相视在功率'] = $v[4].' KVA';
            $city_data['B相视在功率'] = $v[5].' KVA';
            $city_data['A相视在功率'] = $v[6].' KVA';
            $city_data['C相有功功率'] = $v[7].' KW';
            $city_data['B相有功功率'] = $v[8].' KW';
            $city_data['A相有功功率'] = $v[9].' KW';
            $city_data['C相无功功率'] = $v[10].' Kvar';
            $city_data['B相无功功率'] = $v[11].' Kvar';
            $city_data['A相无功功率'] = $v[12].' Kvar';
            $city_data['C相功率因数'] = $v[13] / 100;
            $city_data['B相功率因数'] = $v[14] / 100;
            $city_data['A相功率因数'] = $v[15] / 100;
            //rsv 1
            $ecu_data= array();
            $ecu_data['ECU发动机转速'] = $v[17].' RPM';
            $ecu_data['机油油压'] = $v[18].' BAR';
            $ecu_data['ECU发动机水温'] = $v[19].' ℃';
            $ecu_data['机油温度'] = $v[20].' ℃';
            $ecu_data['歧管压力'] = $v[21];
            $ecu_data['负载率'] = $v[22];
            $ecu_data['扭矩'] = $v[23];
            $ecu_data['油耗比率'] = $v[24];
            $ecu_data['累计运行时间'] = $v[25];
            //rsv 1
            $ecu_data['气门位置'] = $v[27];
            $ecu_data['冷却压力'] = $v[28].' KPa';
            $ecu_data['燃油油压'] = $v[29].' KPa';
            $ecu_data['进气温度'] = $v[30].' ℃';
            $ecu_data['燃油温度'] = $v[31].' ℃';
            $ecu_data['排气温度'] = $v[32].' ℃';
            $ecu_data['进气压力'] = $v[33].' KPa';
            //$v[34] - $v[35]  rsv
            //GU631A_E0_E3_t
            $v = unpack('s*',substr($memData,4 + 77*2, 4*2));
            $ecu_data['左排气温度'] = $v[1].' ℃';
            $ecu_data['右排气温度'] = $v[2].' ℃';
            $ecu_data['机油滤压差'] = $v[3];
            $ecu_data['燃油滤压差'] = $v[4];
            $dataArray['ECU数据'] = $ecu_data;
            //GU631A_1_F_t
            $v = unpack('s*',substr($memData,4 + 81*2, 15*2));
            $dataArray['通讯地址'] = $v[1];
            $dataArray['电压变比'] = $v[2] / 10;
            $dataArray['电流变比'] = $v[3];
            $config_data = array();
            $config_data['发电低电压2限值'] = $v[4].' %';
            $config_data['发电低电压1限值'] = $v[5].' %';
            $config_data['发电高电压1限值'] = $v[6].' %';
            $config_data['发电高电压2限值'] = $v[7].' %';
            $config_data['发电过流1限值'] = $v[8].' %';
            $config_data['发电过流2限值'] = $v[9].' %';
            $config_data['发电低频率2限值'] = ($v[10] / 10).' Hz';
            $config_data['发电低频率1限值'] = ($v[11] / 10).' Hz';
            $config_data['发电高频率1限值'] = ($v[12] / 10).' Hz';
            $config_data['发电高频率2限值'] = ($v[13] / 10).' Hz';
            $config_data['发电超负载1限值'] = $v[14].' %';
            $config_data['发电超负载2限值'] = $v[15].' %';
            //GU631A_12_48_t
            $v = unpack('I*',substr($memData,4 + 96*2, 4*2));
            $dataArray['有功电度'] = $v[1].' KWh';
            $dataArray['无功电度'] = $v[2].' KVarh';
            $v = unpack('S*',substr($memData,4 + 96*2 + 4*2, 51*2));
            $dataArray['飞轮齿数'] = $v[1];
            $dataArray['发电机极对数'] = $v[2];
            $dataArray['发动机额定转速'] = $v[3].' RPM';
            $dataArray['发电故障确认时间'] = $v[4];
            $dataArray['供油阀类型'] = $v[5] == 0 ? '常闭型' : $v[5] == 1 ? '常开型' : '无效';
            $dataArray['温度传感器类型'] = $v[6] == 0 ? '常闭型' : $v[6] == 1 ? '常开型' : '无效';
            $dataArray['压力传感器类型'] = $v[7] == 0 ? '常闭型' : $v[7] == 1 ? '常开型' : '无效';
            $dataArray['速度传感器输入'] = $v[8] == 1 ? '是' : '否';
            $dataArray['启动延时'] = $v[9].' S';
            $dataArray['盘车尝试次数'] = $v[10];
            $dataArray['盘车时间'] = $v[11].' S';
            $dataArray['盘车间隔时间'] = $v[12].' S';
            $dataArray['盘车切断转速'] = $v[13].' RPM';
            $dataArray['怠速时间'] = $v[14].' S';
            $dataArray['安全监察延时'] = $v[15].' S';
            $dataArray['冷却时间'] = $v[16].' S';
            $dataArray['停机时间'] = $v[17].' S';
            $config_data['低速2级限值'] = $v[18].' RPM';
            $config_data['低速1级限值'] = $v[19].' RPM';
            $config_data['超速1级限值'] = $v[20].' RPM';
            $config_data['超速2级限值'] = $v[21].' RPM';
            $config_data['低油压2级限值'] = ($v[22] / 10).' BAR';
            $config_data['低油压1级限值'] = ($v[23] / 10).' BAR';
            $config_data['高温1级限值'] = $v[24].' ℃';
            $config_data['高温2级限值'] = $v[25].' ℃';
            $config_data['电池低电压限值'] = ($v[26] / 10).' V';
            $dataArray['预热模式'] = $v[27] == 1 ? '是' : '否';
            // rsv 4
            $dataArray['预热时间'] = $v[32].' S';
            $dataArray['油泵开水平值'] = $v[33].' %';
            $dataArray['油泵停水平值'] = $v[34].' %';
            $dataArray['危急盘车次数'] = $v[35];
            $dataArray['启动警报'] = $v[36] == 1 ? '启动' : '未启动';
            $dataArray['复位至手动模式'] = $v[37] == 1 ? '是' : '否';
            $dataArray['电池高电压限值'] = ($v[38] / 10).' V';
            $dataArray['充电失败限值'] = ($v[39] / 10).' V';
            $dataArray['油压单位'] = $v[40] == 1 ? 'PSI' : 'BAR';
            $dataArray['温度单位'] = $v[41] == 1 ? '℉' : '℃';
            $config_data['发电电压V1校准修正'] = $v[42].' ±10%';
            $config_data['发电电压V2校准修正'] = $v[43].' ±10%';
            $config_data['发电电压V3校准修正'] = $v[44].' ±10%';
            $config_data['电流I1校准修正'] = $v[45].' ±10%';
            $config_data['电流I2校准修正'] = $v[46].' ±10%';
            $config_data['电流I3校准修正'] = $v[47].' ±10%';
            //rsv
            $config_data['市电电压V1校准修正'] = $v[49].' ±10%';
            $config_data['市电电压V2校准修正'] = $v[50].' ±10%';
            $config_data['市电电压V3校准修正'] = $v[51].' ±10%';
            $dataArray['系统配置数据'] = $config_data;
            //GU631A_97_B9_t
            $v = unpack('S*',substr($memData,4 + 147*2 + 4*2, 10*2));
            switch ($v[1]){
                case 0 : $dataArray['开启模式'] = '手动'; break;
                case 1 : $dataArray['开启模式'] = '自动'; break;
                case 2 : $dataArray['开启模式'] = '最后'; break;
                default : $dataArray['开启模式'] = '无效';
            }
            switch ($v[2]){
                case 0 : $dataArray['冷却模式'] = '全速'; break;
                case 1 : $dataArray['冷却模式'] = '怠速'; break;
                default : $dataArray['冷却模式'] = '无效';
            }
            $dataArray['盘车切断发电电压'] = ($v[3] / 10).' V';
            $dataArray['盘车切断充电电压'] = ($v[4] / 10).' V';
            $dataArray['市电故障发电负载'] = $v[5];
            $dataArray['发电电压监测类型'] = $v[6] == 0 ? '相-相' : $v[6] == 1 ? '相-零' : '无效';
            $dataArray['额定电压值'] = $v[7].' V';
            $dataArray['额定电流值'] = $v[8].' A';
            $dataArray['额定有功功率'] = $v[9].' KW';
            $dataArray['软卸载时间'] = $v[10].' S';
            //GU631A_B5_C3_t
            $v = unpack('S*',substr($memData,4 + 157*2 + 4*2, 8*2));
            $dataArray['市电电压监测类型'] = $v[1] == 0 ? '相-相' : $v[1] == 1 ? '相-零' : '无效';
            $dataArray['测试模式'] = $v[2] == 0 ? '空载' : $v[2] == 1 ? '带载' : '无效';
            $dataArray['发电带载频率'] = ($v[3] / 10).' Hz';
            $dataArray['发电带载电压'] = $v[4].' V';
            $dataArray['外部盘车允许'] = $v[5] == 1 ? '是' : '否';
            $dataArray['盘车时间增加'] = $v[6].' S';
            $dataArray['盘车切断油压'] = ($v[7] / 10).' BAR';
            $dataArray['盘车切断油压延时'] = $v[8].' S';
            //GU631A_7E_80_t
            $v = unpack('I*',substr($memData,4 + 165*2 + 4*2, 4*2));
            $city_data['市电有功电度'] = $v[1].' KWh';
            $city_data['市电无功电度'] = $v[2].' Kvarh';
            $dataArray['市电数据'] = $city_data;
            //GU631A_37_3B_t
            ///SHORT  rev 5
            $v = unpack('v', substr($memData,4 + 170*2 + 4*4,2));
            $year = $v[1];
            $v = unpack('C*', substr($memData,4 + 170*2 + 4*4 + 2, 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}
