<?php

function Get_h3gtabatterybalancer160_DeviceIoControl_Parameter($action, $parameter)
{
    switch($action)
    {
        case 2://START_RESIST
        {
            return "";
        }
        case 8://READ_MODULE_ADDR
        {

            return "";
        }
        case 10://WRITE_MODULE_ADDR
        {
            if(count($parameter) != 1)
            {
                return "";
            }
            return pack("S", $parameter[0]);
        }
        case 12://ADJUST_VOLTAGE
        {
            if(count($parameter) != 6)
            {
                return "";
            }
            return pack("S*", $parameter[0], $parameter[1], $parameter[2], $parameter[3], $parameter[4], $parameter[5]);
        }
        case 14://ADJUST_RESIST
        {
            if(count($parameter) != 6)
            {
                return "";
            }
            return pack("S*", $parameter[0], $parameter[1], $parameter[2], $parameter[3], $parameter[4], $parameter[5]);
        }
        case 16://TWEAK_VOLTAGE
        {
            if(count($parameter) != 3)
            {
                return "";
            }
            return pack("S*", $parameter[0], $parameter[1], $parameter[2]);
        }
        case 18://TWEAK_RESIST
        {
            if(count($parameter) != 6)
            {
                return "";
            }
            return pack("S*", $parameter[0], $parameter[1], $parameter[2], $parameter[3], $parameter[4], $parameter[5]);
        }
        case 20://ADJUST_CURRENT
        {
            if(count($parameter) != 8)
            {
                return "";
            }
            return pack("S*", $parameter[0], $parameter[1], $parameter[2], $parameter[3], $parameter[4], $parameter[5], $parameter[6], $parameter[7]);
        }
        default:
            return "";
    }
}

function Get_h3gtabatterybalancer160_Standard_Variable($dataArray, $varname){
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_h3gtabatterybalancer160_UnicomCategory()
{
    return "461";
}


function Is_h3gtabatterybalancer160_NeedExtraPara(){
    return true;
}

// include_once "application/helpers/unicom_b/461.php";
function Get_h3gtabatterybalancer160_Signals($type){
    switch($type){
        case "AI":
            $aiArr = array();
            for($i=1; $i<=12; $i++){
                $aiArr[] = "461127100".str_pad($i, 3, '0',STR_PAD_LEFT);
                $aiArr[] = "461127200".str_pad($i, 3, '0',STR_PAD_LEFT);
                $aiArr[] = "461127300".str_pad($i, 3, '0',STR_PAD_LEFT);
            }
            return $aiArr;
        default:
            return get_461_Signals($type);
    }

}

function Get_h3gtabatterybalancer160_RtData($memData, &$dataArray, $extraPara = false)
{
    if ($memData == false) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
        /* $dataObj->isEmpty = true;
        $dataObj->update_datetime = '无'; */
    } else {
        $number = 160;
        if(strlen($memData) == 1461)
        {
            $number = 240;
        }
        $dataArray["无数据"] = false;
        $dataArray['AlertArray'] = array();
        $v = unpack('s*', substr($memData, 4, 2*3*$number));

        $vIndex = 1;
        for($i=1; $i<=$number; $i++)
        {
            $dataArray["电池".$i."电压"] = number_format($v[$vIndex++]/1000, 3).'V';
            $dataArray["AI"]["461127100".str_pad($i, 3, '0',STR_PAD_LEFT)] = "电池".$i."电压";
        }
        for($i=1; $i<=$number; $i++)
        {       
            $dataArray["电池".$i."内阻"] = number_format($v[$vIndex++]/1000, 3).'mΩ';
            $dataArray["AI"]["461127300".str_pad($i, 3, '0',STR_PAD_LEFT)] = "电池".$i."内阻";
        }
        for($i=1; $i<=$number; $i++)
        {
	    $sign = ($v[$vIndex] >> 15) & 0x1 ? -1 : 1;
            $dataArray["电池".$i."温度"] = number_format( $sign * ($v[$vIndex++] & 0x7FFF )/10, 1).'°C';
            $dataArray["AI"]["461127200".str_pad($i, 3, '0',STR_PAD_LEFT)] = "电池".$i."温度";
        }
        $v = unpack('i', substr($memData, 4 + 2*(3*$number), 4));
        $dataArray["整组电压"] = number_format($v[1]/1000, 3).'V';
        $v = unpack('S*', substr($memData, 4 + 2*(3*$number) + 4, 2*3));
        $dataArray["充放电电流"] = number_format($v[2]/1000, 3).'A';
        $dataArray["环境温度1"] = number_format($v[3]/10, 1);
        $dataArray["环境温度2"] = number_format($v[3]/10, 1);
        $v = unpack('v', substr($memData, 4 + 2*(3*$number) + 4 + 2*3, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 2*(3*$number) + 4 + 2*3 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}


?>
