<?php

function Get_hat400_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        $v = unpack('C*', substr($memData, 4, 1 * 28));
        //状态
        $dataArray['1#开关合闸/分闸'] = $v[1] == 1 ? '合闸' : '分闸';
        $dataArray['1#电压正常'] = $v[2] == 1 ? '正常' : '异常';
        $dataArray['2#开关合闸/分闸'] = $v[3] == 1 ? '合闸' : '分闸';
        $dataArray['2#电压正常'] = $v[4] == 1 ? '正常' : '异常';
        $dataArray['自动/手动'] = $v[5] == 1 ? '自动' : '手动';
        $dataArray['1#主用/备用'] = $v[6] == 1 ? '主用' : '备用';
        $dataArray['2#主用/备用'] = $v[7] == 1 ? '主用' : '备用';
        $dataArray['油机起动输出'] = $v[8] == 1 ? '开机输出' : '停机输出';
        //告警
        if($v[1] == 1){//1#合闸  告警
            $dataArray['1#开关故障'] = $v[10] == 1 ? '告警' : '正常';
            $dataArray['1#合闸失败'] = $v[12] == 1 ? '告警' : '正常';
            $dataArray['1#分闸失败'] = $v[14] == 1 ? '告警' : '正常';
            $dataArray['1#电压过高'] = $v[18] == 1 ? '告警' : '正常';
            $dataArray['1#电压过低'] = $v[19] == 1 ? '告警' : '正常';
            $dataArray['1#缺相'] = $v[20] == 1 ? '告警' : '正常';
            $dataArray['1#过频'] = $v[25] == 1 ? '告警' : '正常';
            $dataArray['1#欠频'] = $v[26] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['1#开关故障'] = $v[10] == 1;
            $dataArray['AlertArray']['1#合闸失败'] = $v[12] == 1;
            $dataArray['AlertArray']['1#分闸失败'] = $v[14] == 1;
            $dataArray['AlertArray']['1#电压过高'] = $v[18] == 1;
            $dataArray['AlertArray']['1#电压过低'] = $v[19] == 1;
            $dataArray['AlertArray']['1#缺相'] = $v[20] == 1;
            $dataArray['AlertArray']['1#过频'] = $v[25] == 1;
            $dataArray['AlertArray']['1#欠频'] = $v[26] == 1;
        }else{
            $dataArray['1#开关故障'] = '正常';
            $dataArray['1#合闸失败'] = '正常';
            $dataArray['1#分闸失败'] = '正常';
            $dataArray['1#电压过高'] = '正常';
            $dataArray['1#电压过低'] = '正常';
            $dataArray['1#缺相'] = '正常';
            $dataArray['1#过频'] = '正常';
            $dataArray['1#欠频'] = '正常';
            $dataArray['AlertArray']['1#开关故障'] = false;
            $dataArray['AlertArray']['1#合闸失败'] = false;
            $dataArray['AlertArray']['1#分闸失败'] = false;
            $dataArray['AlertArray']['1#电压过高'] = false;
            $dataArray['AlertArray']['1#电压过低'] = false;
            $dataArray['AlertArray']['1#缺相'] = false;
            $dataArray['AlertArray']['1#过频'] = false;
            $dataArray['AlertArray']['1#欠频'] = false;
        }
        if($v[3] == 1){//2#合闸  告警
            $dataArray['2#开关故障'] = $v[11] == 1 ? '告警' : '正常';
            $dataArray['2#合闸失败'] = $v[13] == 1 ? '告警' : '正常';
            $dataArray['2#分闸失败'] = $v[15] == 1 ? '告警' : '正常';
            $dataArray['2#电压过高'] = $v[21] == 1 ? '告警' : '正常';
            $dataArray['2#电压过低'] = $v[22] == 1 ? '告警' : '正常';
            $dataArray['2#缺相'] = $v[23] == 1 ? '告警' : '正常';
            $dataArray['2#过频'] = $v[27] == 1 ? '告警' : '正常';
            $dataArray['2#欠频'] = $v[28] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['2#开关故障'] = $v[11] == 1;
            $dataArray['AlertArray']['2#合闸失败'] = $v[13] == 1;
            $dataArray['AlertArray']['2#分闸失败'] = $v[15] == 1;
            $dataArray['AlertArray']['2#电压过高'] = $v[21] == 1;
            $dataArray['AlertArray']['2#电压过低'] = $v[22] == 1;
            $dataArray['AlertArray']['2#缺相'] = $v[23] == 1;
            $dataArray['AlertArray']['2#过频'] = $v[27] == 1;
            $dataArray['AlertArray']['2#欠频'] = $v[28] == 1;
        }else{
            $dataArray['2#开关故障'] = '正常';
            $dataArray['2#合闸失败'] = '正常';
            $dataArray['2#分闸失败'] = '正常';
            $dataArray['2#电压过高'] = '正常';
            $dataArray['2#电压过低'] = '正常';
            $dataArray['2#缺相'] = '正常';
            $dataArray['2#过频'] = '正常';
            $dataArray['2#欠频'] = '正常';
            $dataArray['AlertArray']['2#开关故障'] = false;
            $dataArray['AlertArray']['2#合闸失败'] = false;
            $dataArray['AlertArray']['2#分闸失败'] = false;
            $dataArray['AlertArray']['2#电压过高'] = false;
            $dataArray['AlertArray']['2#电压过低'] = false;
            $dataArray['AlertArray']['2#缺相'] = false;
            $dataArray['AlertArray']['2#过频'] = false;
            $dataArray['AlertArray']['2#欠频'] = false;
        }
        $dataArray['严重故障'] = $v[9] == 1 ? '告警' : '正常';
        //$v[16] 保留一位
        $dataArray['一般告警'] = $v[17] == 1 ? '告警' : '正常';
        $dataArray['负载过流'] = $v[24] == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['严重故障'] = $v[9] == 1;
        //保留
        $dataArray['AlertArray']['一般告警'] = $v[17] == 1;
        $dataArray['AlertArray']['负载过流'] = $v[24] == 1;
        $v = unpack('S*', substr($memData, 32, 2 * 19));
        $dataArray['1# AB相电压'] = $v[1].' V';
        $dataArray['1# BC相电压'] = $v[2].' V';
        $dataArray['1# CA相电压'] = $v[3].' V';
        $dataArray['2# AB相电压'] = $v[4].' V';
        $dataArray['2# BC相电压'] = $v[5].' V';
        $dataArray['2# CA相电压'] = $v[6].' V';
        $dataArray['1# A相电压'] = $v[7].' V';
        $dataArray['1# B相电压'] = $v[8].' V';
        $dataArray['1# C相电压'] = $v[9].' V';
        $dataArray['2# A相电压'] = $v[10].' V';
        $dataArray['2# B相电压'] = $v[11].' V';
        $dataArray['2# C相电压'] = $v[12].' V';
        $dataArray['A相负载电流'] = $v[13].' A';
        $dataArray['B相负载电流'] = $v[14].' A';
        $dataArray['C相负载电流'] = $v[15].' A';
        $dataArray['1# 频率'] = number_format($v[16] / 10 , 2).' Hz';
        $dataArray['2# 频率'] = number_format($v[17] / 10 , 2).' Hz';
        $dataArray['视在功率'] = $v[19].' KVA';
        $v = unpack('v', substr($memData, 32 + 2 * 19, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 34 + 2 * 19, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

?>
