<?php
function Get_hc33_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['A相电压2'] * 1.732);
        case '[B相电压]':
            return array(0, $dataArray['B相电压2'] * 1.732);
        case '[C相电压]':
            return array(0, $dataArray['C相电压2'] * 1.732);
        case '[总功率]':
            return array(0, $dataArray['总有功功率2']);
        case '合相电能':
            return array(0,$dataArray['正向总有功电度']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_hc33_Active_Power($dataArray){
    return array(0 , $dataArray['正向总有功电度']);
}

function _GetHc33Baudrate($value){
    switch($value){
        case 3: return '1200 bps';
        case 4: return '2400 bps';
        case 5: return '4800 bps';
        case 6: return '9600 bps';
        case 7: return '19200 bps';
        case 8: return '38400 bps';
    }
    return '无效';
}

function Get_hc33_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $dataArray["无数据"] = false;
        //HC33_REG_0_13_t
        $v = unpack('s*',substr($memData,4,5*2));
        $dataArray['设备型号'] = $v[1];
        $dataArray['版本信息'] = $v[2];
        $dataArray['电压量程'] = $v[3].' V';
        $dataArray['电流量程'] = $v[4].' A';
        $dataArray['设备地址'] = $v[5];
        $v = unpack('c*',substr($memData,4 + 5*2,2*1));
        //$dataObj->dataCase = $v[1];
        $dataArray['波特率'] = _GetHc33Baudrate($v[2]);
        $v = unpack('s*',substr($memData,4 + 5*2 +2*1,6*2));
        $dataArray['电压变比'] = $v[1].' V';
        $dataArray['电流变比'] = $v[2].' A';
        $dataArray['A相接线方式'] = $v[3] == 0 ? '正向' : '反向';
        $dataArray['B相接线方式'] = $v[4] == 0 ? '正向' : '反向';
        $dataArray['C相接线方式'] = $v[5] == 0 ? '正向' : '反向';
        //$dataObj->Ts = $v[6];
        //HC33_REG_40_4B_t
        $v = unpack('f*',substr($memData,4 + 11*2 +2*1, 4*4));
        $dataArray['正向总有功电度'] = number_format($v[1] , 3, ".", "").' KWh';
        $dataArray['反向总有功电度'] = number_format($v[2] , 3).' KWh';
        $dataArray['绝对值和有功电度'] = number_format($v[3] , 3).' KWh';
        $dataArray['净有功电度'] = number_format($v[4] , 3).' KWh';
        //HC33_Inp_0_1D_t
        $v = unpack('f*',substr($memData,4 + 11*2 +2*1 + 4*4, 4*15));
        $dataArray['A相电压'] = number_format($v[1] , 2).' V';
        $dataArray['A相电压2'] = number_format($v[1] , 2);
        $dataArray['B相电压'] = number_format($v[2] , 2).' V';
        $dataArray['B相电压2'] = number_format($v[2] , 2);
        $dataArray['C相电压'] = number_format($v[3] , 2).' V';
        $dataArray['C相电压2'] = number_format($v[3] , 2);
        $dataArray['A相电流'] = number_format($v[4] , 2).' A';
        $dataArray['B相电流'] = number_format($v[5] , 2).' A';
        $dataArray['C相电流'] = number_format($v[6] , 2).' A';
        $dataArray['A相有功功率'] = number_format($v[7] , 2).' W';
        $dataArray['B相有功功率'] = number_format($v[8] , 2).' W';
        $dataArray['C相有功功率'] = number_format($v[9] , 2).' W';
        $dataArray['总有功功率'] = number_format($v[10] , 2).' W';
        if(4159584277 == $dataArray["数据ID"]){
          $dataArray['B相电流'] = $dataArray['A相电流'];
          $dataArray['B相有功功率'] = $dataArray['A相有功功率'];
          $dataArray['总有功功率2'] = 2*$v[7]/1000 + $v[9]/1000;
          $dataArray['总有功功率'] = number_format(2*$v[7]/1000 + $v[9]/1000 , 2).' W';
        }else{
          $dataArray['总有功功率2'] = number_format($v[10] / 1000 , 3,'.','');
        }
        $dataArray['总无功功率'] = number_format($v[11] , 2).' Var';
        $dataArray['总视在功率'] = number_format($v[12] , 2).' VA';
        $dataArray['总功率因数'] = number_format($v[13] , 2);
        $dataArray['频率'] = number_format($v[14] , 2).' Hz';
        $dataArray['模块内部温度'] = number_format($v[15] , 2).' ℃';
        /* $dataObj->Ua = $v[1];
        $dataObj->Ub = $v[2];
        $dataObj->Uc = $v[3];
        $dataObj->Ia = $v[4];
        $dataObj->Ib = $v[5];
        $dataObj->Ic = $v[6];
        $dataObj->Pa = $v[7];
        $dataObj->Pb = $v[8];
        $dataObj->Pc = $v[9];
        $dataObj->Psum = $v[10];
        $dataObj->Qsum = $v[11];
        $dataObj->Ssum = $v[12];
        $dataObj->PF = $v[13];
        $dataObj->FR = $v[14];
        $dataObj->Temp = $v[15]; */
        $v = unpack('v',substr($memData, 4 + 11*2 +2*1 + 4*19, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData,4 + 11*2 +2*1 + 4*19 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}


?>
