<?php
function _Get_hgm6100_engine_state($value){
    switch ($value){
        case 0: return '待机';
        case 1: return '预热';
        case 2: return '燃油输出';
        case 3: return '起动';
        case 4: return '起动间隔';
        case 5: return '安全延时';
        case 6: return '开机怠速';
        case 7: return '高速暖机';
        case 8: return '等待带载';
        case 9: return '正常运行';
        case 10: return '高速散热';
        case 11: return '停机怠速';
        case 12: return '得电停机';
        case 13: return '等待停稳';
        case 14: return '过停稳';
        case 15: return '停机失败';
    }
    return '无效';
}

function _Get_hgm6100_switch_state($value){
    switch ($value){
        case 0: return '负载断开';
        case 1: return '市电带载';
        case 2: return '发电带载';
        case 3: return '分闸延时';
        case 4: return '开关转换延时';
        case 5: return '市电合闸延时';
        case 6: return '发电合闸延时';
        case 7: return '等待分闸';
        case 8: return '等待发电合闸';
        case 9: return '等待市电合闸';
        case 10: return '正常';
    }
    return '无效';
}
function Get_hgm6100_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray["无数据"] = false;
        $dataArray['AlertArray'] = array();
        //alarm
        $v = unpack('C*',substr($memData, 4, 80));
        $dataArray['公共报警'] = $v[1] == 1 ? '告警' : '正常';
        $dataArray['公共警告报警'] = $v[2] == 1 ? '告警' : '正常';
        $dataArray['公共停机报警'] = $v[3] == 1 ? '告警' : '正常';

        $dataArray['紧急停机报警'] = $v[9] == 1 ? '告警' : '正常';
        $dataArray['超速报警停机'] = $v[10] == 1 ? '告警' : '正常';
        $dataArray['欠速报警停机'] = $v[0xb] == 1 ? '告警' : '正常';
        $dataArray['速度信号丢失报警'] = $v[0xc]  == 1 ? '告警' : '正常';
        $dataArray['超频报警停机'] = $v[0xd]  == 1 ? '告警' : '正常';

        $dataArray['欠频报警停机'] = $v[0xe]  == 1 ? '告警' : '正常';
        $dataArray['过压报警停机'] = $v[0xf]  == 1 ? '告警' : '正常';
        $dataArray['欠压报警停机'] = $v[0x10]  == 1 ? '告警' : '正常';
        $dataArray['发电过流停机'] = $v[0x11]  == 1 ? '告警' : '正常';
        $dataArray['起动失败报警'] = $v[0x12]  == 1 ? '告警' : '正常';
        $dataArray['水温高报警停机'] = $v[0x13]  == 1 ? '告警' : '正常';
        $dataArray['油压低报警停机'] = $v[0x14]  == 1 ? '告警' : '正常';
        $dataArray['频率丢失报警'] = $v[0x15]  == 1 ? '告警' : '正常';
        $dataArray['输入口停机报警'] = $v[0x16]  == 1 ? '告警' : '正常';
        $dataArray['燃油位低停机报警'] = $v[0x17]  == 1 ? '告警' : '正常';
        $dataArray['冷却液低停机报警'] = $v[0x18]  == 1 ? '告警' : '正常';
        $dataArray['水温高警告报警'] = $v[0x19]  == 1 ? '告警' : '正常';
        $dataArray['油压低警告报警'] = $v[0x1a]  == 1 ? '告警' : '正常';
        $dataArray['发电过流警告报警'] = $v[0x1b]  == 1 ? '告警' : '正常';
        $dataArray['停机失败警告报警'] = $v[0x1c]  == 1 ? '告警' : '正常';
        $dataArray['油位低警告'] = $v[0x1d]  == 1 ? '告警' : '正常';
        $dataArray['充电失败警告'] = $v[0x1e]  == 1 ? '告警' : '正常';
        $dataArray['电池电压过低警告报警'] = $v[0x1f]  == 1 ? '告警' : '正常';
        $dataArray['电池电压过高警告报警'] = $v[0x20]  == 1 ? '告警' : '正常';
        $dataArray['输入口警告报警'] = $v[0x21]  == 1 ? '告警' : '正常';
        $dataArray['速度信号丢失警告'] = $v[0x22]  == 1 ? '告警' : '正常';
        $dataArray['冷却液低警告'] = $v[0x23]  == 1 ? '告警' : '正常';
        $dataArray['温度传感器开路警告'] = $v[0x24]  == 1 ? '告警' : '正常';
        $dataArray['油压传感器开路警告'] = $v[0x25]  == 1 ? '告警' : '正常';
        $dataArray['维护时间到警告'] = $v[0x26]  == 1 ? '告警' : '正常';
        $dataArray['充电器充电失败警告'] = $v[0x27]  == 1 ? '告警' : '正常';
        $dataArray['过功率警告'] = $v[0x28]  == 1 ? '告警' : '正常';
        $dataArray['系统在测试模式'] = $v[0x29]  == 1 ? '告警' : '正常';
        $dataArray['系统在手动模式'] = $v[0x2b]  == 1 ? '告警' : '正常';
        $dataArray['温度传感器器开路停机'] = $v[0x2d]  == 1 ? '告警' : '正常';
        $dataArray['油压传感器开路停机'] = $v[0x2e]  == 1 ? '告警' : '正常';
        $dataArray['维护时间到停机报警'] = $v[0x2f]  == 1 ? '告警' : '正常';
        $dataArray['过功率停机报警'] = $v[0x30]  == 1 ? '告警' : '正常';
        $dataArray['紧急停机输入'] = $v[0x31]  == 1 ? '告警' : '正常';
        $dataArray['市电故障'] = $v[0x41]  == 1 ? '告警' : '正常';
        $dataArray['市电过压'] = $v[0x43]  == 1 ? '告警' : '正常';
        $dataArray['市电欠压'] = $v[0x44]  == 1 ? '告警' : '正常';
        $dataArray['市电缺相'] = $v[0x45]  == 1 ? '告警' : '正常';
        $dataArray['发电过压'] = $v[0x4a]  == 1 ? '告警' : '正常';
        $dataArray['发电过频'] = $v[0x4c]  == 1 ? '告警' : '正常';
        $dataArray['发电过流警告'] = $v[0x4e]  == 1 ? '告警' : '正常';
        $dataArray['定时不开机时间内'] = $v[0x4f]  == 1 ? '告警' : '正常';
        $dataArray['ECU警告'] = $v[0x50]  == 1 ? '告警' : '正常';


        $dataArray['AlertArray']['公共报警'] = $v[1] == 1;
        $dataArray['AlertArray']['公共警告报警'] = $v[2] == 1;
        $dataArray['AlertArray']['公共停机报警'] = $v[3] == 1;

        $dataArray['AlertArray']['紧急停机报警'] = $v[9] == 1;
        $dataArray['AlertArray']['超速报警停机'] = $v[10] == 1;
        $dataArray['AlertArray']['欠速报警停机'] = $v[0xb] == 1;
        $dataArray['AlertArray']['速度信号丢失报警'] = $v[0xc]  == 1;
        $dataArray['AlertArray']['超频报警停机'] = $v[0xd]  == 1;

        $dataArray['AlertArray']['欠频报警停机'] = $v[0xe]  == 1;
        $dataArray['AlertArray']['过压报警停机'] = $v[0xf]  == 1;
        $dataArray['AlertArray']['欠压报警停机'] = $v[0x10]  == 1;
        $dataArray['AlertArray']['发电过流停机'] = $v[0x11]  == 1;
        $dataArray['AlertArray']['起动失败报警'] = $v[0x12]  == 1;
        $dataArray['AlertArray']['水温高报警停机'] = $v[0x13]  == 1;
        $dataArray['AlertArray']['油压低报警停机'] = $v[0x14]  == 1;
        $dataArray['AlertArray']['频率丢失报警'] = $v[0x15]  == 1;
        $dataArray['AlertArray']['输入口停机报警'] = $v[0x16]  == 1;
        $dataArray['AlertArray']['燃油位低停机报警'] = $v[0x17]  == 1;
        $dataArray['AlertArray']['冷却液低停机报警'] = $v[0x18]  == 1;
        $dataArray['AlertArray']['水温高警告报警'] = $v[0x19]  == 1;
        $dataArray['AlertArray']['油压低警告报警'] = $v[0x1a]  == 1;
        $dataArray['AlertArray']['发电过流警告报警'] = $v[0x1b]  == 1;
        $dataArray['AlertArray']['停机失败警告报警'] = $v[0x1c]  == 1;
        $dataArray['AlertArray']['油位低警告'] = $v[0x1d]  == 1;
        $dataArray['AlertArray']['充电失败警告'] = $v[0x1e]  == 1;
        $dataArray['AlertArray']['电池电压过低警告报警'] = $v[0x1f]  == 1;
        $dataArray['AlertArray']['电池电压过高警告报警'] = $v[0x20]  == 1;
        $dataArray['AlertArray']['输入口警告报警'] = $v[0x21]  == 1;
        $dataArray['AlertArray']['速度信号丢失警告'] = $v[0x22]  == 1;
        $dataArray['AlertArray']['冷却液低警告'] = $v[0x23]  == 1;
        $dataArray['AlertArray']['温度传感器开路警告'] = $v[0x24]  == 1;
        $dataArray['AlertArray']['油压传感器开路警告'] = $v[0x25]  == 1;
        $dataArray['AlertArray']['维护时间到警告'] = $v[0x26]  == 1;
        $dataArray['AlertArray']['充电器充电失败警告'] = $v[0x27]  == 1;
        $dataArray['AlertArray']['过功率警告'] = $v[0x28]  == 1;
        $dataArray['AlertArray']['系统在测试模式'] = $v[0x29]  == 1;
        $dataArray['AlertArray']['系统在手动模式'] = $v[0x2b]  == 1;
        $dataArray['AlertArray']['温度传感器器开路停机'] = $v[0x2d]  == 1;
        $dataArray['AlertArray']['油压传感器开路停机'] = $v[0x2e]  == 1;
        $dataArray['AlertArray']['维护时间到停机报警'] = $v[0x2f]  == 1;
        $dataArray['AlertArray']['过功率停机报警'] = $v[0x30]  == 1;
        $dataArray['AlertArray']['紧急停机输入'] = $v[0x31]  == 1;
        $dataArray['AlertArray']['市电故障'] = $v[0x41]  == 1;
        $dataArray['AlertArray']['市电过压'] = $v[0x43]  == 1;
        $dataArray['AlertArray']['市电欠压'] = $v[0x44]  == 1;
        $dataArray['AlertArray']['市电缺相'] = $v[0x45]  == 1;
        $dataArray['AlertArray']['发电过压'] = $v[0x4a]  == 1;
        $dataArray['AlertArray']['发电过频'] = $v[0x4c]  == 1;
        $dataArray['AlertArray']['发电过流警告'] = $v[0x4e]  == 1;
        $dataArray['AlertArray']['定时不开机时间内'] = $v[0x4f]  == 1;
        $dataArray['AlertArray']['ECU警告'] = $v[0x50]  == 1;

        
        //模拟量
        $v = unpack('S*',substr($memData, 4 + 80,  45*2));
        $dataArray['市电UA'] = $v[1].' V';
        $dataArray['市电UB'] = $v[2].' V';
        $dataArray['市电UC'] = $v[3].' V';
        $dataArray['市电UAB'] = $v[4].' V';
        $dataArray['市电UBC'] = $v[5].' V';
        $dataArray['市电UCA'] = $v[6].' V';
        $dataArray['市电频率'] = ($v[7] / 10).' Hz';

        $dataArray['发电UA'] = $v[8].' V';
        $dataArray['发电UB'] = $v[9].' V';
        $dataArray['发电UC'] = $v[10].' V';
        $dataArray['发电UAB'] = $v[11].' V';
        $dataArray['发电UBC'] = $v[12].' V';
        $dataArray['发电UCA'] = $v[13].' V';
        $dataArray['发电频率'] = ($v[14] / 10).' Hz';        
        $dataArray['A相电流'] = ($v[15]).' A';
        $dataArray['B相电流'] = ($v[16]).' A';
        $dataArray['C相电流'] = ($v[17]).' A';
        $dataArray['水温温度值'] = $v[18];
        $dataArray['水温电阻值'] = $v[19];
        $dataArray['油压值'] = $v[20];
        $dataArray['油压电阻值'] = $v[21];
        $dataArray['液位值'] = $v[22];
        $dataArray['液位电阻值'] = $v[23];
        $dataArray['转速'] = $v[24].' r/min';
        $dataArray['电池电压'] = number_format($v[25]/10 , 1).' V';
        $dataArray['D+电压'] = number_format($v[26]/10 , 1).' V';
        $dataArray['有功功率'] = ($v[27]).' kW';
        $dataArray['无功功率'] = ($v[28]).' kVar';
        $dataArray['视在功率'] = ($v[29]).' kVA';
        $dataArray['功率因数'] = $v[30]/100;
        $dataArray["维护倒计时"] = $v[31].":".$v[32];
        $dataArray['控制器运行状态'] = _Get_hgm6100_engine_state($v[33]);
        switch($v[34])
        {
            case 0:
                $dataArray["自动运行状态"] = "开机";
                break;
            case 1:
                $dataArray["自动运行状态"] = "停机";
                break;
            case 2:
                $dataArray["自动运行状态"] = "无延时";
                break;
            default:
                $dataArray["自动运行状态"] = "无效:".$v[34];
                    break;
        }
        switch($v[35])
        {
            case 0:
                $dataArray["ATS运行状态"] = "无延时";
                break;
            case 1:
                $dataArray["ATS运行状态"] = "转换间隔";
                break;
            default:
                $dataArray["ATS运行状态"] = "无效:".$v[35];
                    break;
        }
        switch($v[36])
        {
            case 0:
                $dataArray["市电状态"] = "正常";
                break;
            case 1:
                $dataArray["市电状态"] = "异常";
                break;
            case 2:
                $dataArray["市电状态"] = "无延时";
                break;
            default:
                $dataArray["市电状态"] = "无效:".$v[36];
                    break;
        }
        

        $dataArray['油机运行累计计时'] = (($v[37]<<16) + $v[38])."小时".$v[39]."分钟".$v[40]."秒";
        $dataArray['累计开机次数'] = (($v[41]<<16) + $v[42]);
        $dataArray['累计电能'] = (($v[43]<<16) + $v[44]);
        $dataArray["软件版本"] = $v[45]/10;
        $v = unpack('v', substr($memData, 4 + 80 + 45*2, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData,  4 + 80 + 45*2 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}


?>
