<?php
function _Get_hgm9300_engine_state($value){
    switch ($value){
        case 0: return '待机';
        case 1: return '预热';
        case 2: return '燃油输出';
        case 3: return '起动';
        case 4: return '起动间隔';
        case 5: return '安全延时';
        case 6: return '开机怠速';
        case 7: return '高速暖机';
        case 8: return '等待带载';
        case 9: return '正常运行';
        case 10: return '高速散热';
        case 11: return '停机怠速';
        case 12: return '得电停机';
        case 13: return '等待停稳';
        case 14: return '过停稳';
        case 15: return '停机失败';
    }
    return '无效';
}

function _Get_hgm9300_switch_state($value){
    switch ($value){
        case 0: return '负载断开';
        case 1: return '市电带载';
        case 2: return '发电带载';
        case 3: return '分闸延时';
        case 4: return '开关转换延时';
        case 5: return '市电合闸延时';
        case 6: return '发电合闸延时';
        case 7: return '等待分闸';
        case 8: return '等待发电合闸';
        case 9: return '等待市电合闸';
        case 10: return '正常';
    }
    return '无效';
}
function Get_hgm9300_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray["无数据"] = false;
        $dataArray['AlertArray'] = array();
        //alarm
        $v = unpack('S*',substr($memData, 4, 36*2));
        $dataArray['公共报警'] = ($v[1] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['公共停机报警'] = (($v[1] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['公共警告报警'] = (($v[1] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['公共跳闸停机报警'] = (($v[1] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['公共分闸不停机'] = (($v[1] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['公共跳闸停机报警和公共停机报警'] = (($v[1] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['系统在测试模式'] = (($v[1] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['系统在手动模式'] = (($v[1] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['公共报警'] = ($v[1] & 0x1) == 1;
        $dataArray['AlertArray']['公共停机报警'] = (($v[1] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['公共警告报警'] = (($v[1] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['公共跳闸停机报警'] = (($v[1] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['公共分闸不停机'] = (($v[1] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['公共跳闸停机报警和公共停机报警'] = (($v[1] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['系统在测试模式'] = (($v[1] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['系统在手动模式'] = (($v[1] >> 10) & 0x1) == 1;
        $dataArray['测试模式'] = (($v[1] >> 8) & 0x1) == 1 ? '是' : '否';
        $dataArray['自动模式'] = (($v[1] >> 9) & 0x1) == 1 ? '是' : '否';
        $dataArray['手动模式'] = (($v[1] >> 10) & 0x1) == 1 ? '是' : '否';
        $dataArray['停机模式'] = (($v[1] >> 11) & 0x1) == 1 ? '是' : '否';
        
        $dataArray['紧急停机报警'] = ($v[2] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['超速报警停机'] = (($v[2] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['欠速停机'] = (($v[2] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['速度信号丢失报警'] = (($v[2] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电过频报警停机'] = (($v[2] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电欠频停机'] = (($v[2] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电过压停机'] = (($v[2] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电欠压停机'] = (($v[2] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['起动失败报警'] = (($v[2] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电过流停机'] = (($v[2] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['维护时间到报警停机'] = (($v[2] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['逆功率报警停机'] = (($v[2] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['过功率报警停机'] = (($v[2] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['温度高输入报警停机'] = (($v[2] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['油压低输入报警停机'] = (($v[2] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['紧急停机报警'] = ($v[2] & 0x1) == 1;
        $dataArray['AlertArray']['超速报警停机'] = (($v[2] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['欠速停机'] = (($v[2] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['速度信号丢失报警'] = (($v[2] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['发电过频报警停机'] = (($v[2] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['发电欠频停机'] = (($v[2] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['发电过压停机'] = (($v[2] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['发电欠压停机'] = (($v[2] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['起动失败报警'] = (($v[2] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['发电过流停机'] = (($v[2] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['维护时间到报警停机'] = (($v[2] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['逆功率报警停机'] = (($v[2] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['过功率报警停机'] = (($v[2] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['温度高输入报警停机'] = (($v[2] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['油压低输入报警停机'] = (($v[2] >> 15) & 0x1) == 1;
        
        $dataArray['ECU通信失败报警停机'] = ($v[3] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['温度传感器开路报警停机'] = (($v[3] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['温度高报警停机'] = (($v[3] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['压力传感器开路报警停机'] = (($v[3] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['压力低报警停机'] = (($v[3] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['ECU通信失败报警停机'] = ($v[3] & 0x1) == 1;
        $dataArray['AlertArray']['温度传感器开路报警停机'] = (($v[3] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['温度高报警停机'] = (($v[3] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['压力传感器开路报警停机'] = (($v[3] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['压力低报警停机'] = (($v[3] >> 14) & 0x1) == 1;
        
        $dataArray['液位传感器开路报警停机'] = ($v[4] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['可编程传感器1开路报警停机'] = (($v[4] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['可编程传感器1高报警停机'] = (($v[4] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['可编程传感器1低报警停机'] = (($v[4] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['可编程传感器2开路报警停机'] = (($v[4] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['可编程传感器2高报警停机'] = (($v[4] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['可编程传感器2低报警停机'] = (($v[4] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['液位传感器开路报警停机'] = ($v[4] & 0x1) == 1;
        $dataArray['AlertArray']['可编程传感器1开路报警停机'] = (($v[4] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['可编程传感器1高报警停机'] = (($v[4] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['可编程传感器1低报警停机'] = (($v[4] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['可编程传感器2开路报警停机'] = (($v[4] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['可编程传感器2高报警停机'] = (($v[4] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['可编程传感器2低报警停机'] = (($v[4] >> 10) & 0x1) == 1;
        
        $dataArray['输入口1停机'] = ($v[9] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['输入口2停机'] = (($v[9] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['输入口3停机'] = (($v[9] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['输入口4停机'] = (($v[9] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['输入口5停机'] = (($v[9] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['输入口6停机'] = (($v[9] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['输入口7停机'] = (($v[9] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['输入口1停机'] = ($v[9] & 0x1) == 1;
        $dataArray['AlertArray']['输入口2停机'] = (($v[9] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['输入口3停机'] = (($v[9] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['输入口4停机'] = (($v[9] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['输入口5停机'] = (($v[9] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['输入口6停机'] = (($v[9] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['输入口7停机'] = (($v[9] >> 6) & 0x1) == 1;
        
        $dataArray['过流跳闸停机'] = ($v[13] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['维护时间到跳闸停机'] = (($v[13] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['逆功率跳闸停机'] = (($v[13] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['过功率跳闸停机'] = (($v[13] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['过流跳闸停机'] = ($v[13] & 0x1) == 1;
        $dataArray['AlertArray']['维护时间到跳闸停机'] = (($v[13] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['逆功率跳闸停机'] = (($v[13] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['过功率跳闸停机'] = (($v[13] >> 3) & 0x1) == 1;
        
        $dataArray['过流跳闸不停机'] = ($v[17] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['维护时间到跳闸不停机'] = (($v[17] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['逆功率跳闸不停机'] = (($v[17] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['过功率跳闸不停机'] = (($v[17] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['过流跳闸不停机'] = ($v[17] & 0x1) == 1;
        $dataArray['AlertArray']['维护时间到跳闸不停机'] = (($v[17] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['逆功率跳闸不停机'] = (($v[17] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['过功率跳闸不停机'] = (($v[17] >> 3) & 0x1) == 1;
        
        $dataArray['发电超速警告'] = ($v[21] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电欠速警告'] = (($v[21] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['速度信号丢失警告'] = (($v[21] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电过频警告'] = (($v[21] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电欠频警告'] = (($v[21] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电过压警告'] = (($v[21] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电欠压警告'] = (($v[21] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电过流'] = (($v[21] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['停机失败警告'] = (($v[21] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['充电失败警告'] = (($v[21] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池过压警告'] = (($v[21] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池欠压警告'] = (($v[21] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['维护时间到警告'] = (($v[21] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['逆功率警告'] = (($v[21] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['过功率警告'] = (($v[21] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['发电超速警告'] = ($v[21] & 0x1) == 1;
        $dataArray['AlertArray']['发电欠速警告'] = (($v[21] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['速度信号丢失警告'] = (($v[21] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['发电过频警告'] = (($v[21] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['发电欠频警告'] = (($v[21] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['发电过压警告'] = (($v[21] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['发电欠压警告'] = (($v[21] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['发电过流'] = (($v[21] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['停机失败警告'] = (($v[21] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['充电失败警告'] = (($v[21] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['电池过压警告'] = (($v[21] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['电池欠压警告'] = (($v[21] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['维护时间到警告'] = (($v[21] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['逆功率警告'] = (($v[21] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['过功率警告'] = (($v[21] >> 14) & 0x1) == 1;
        
        $dataArray['发电相序错误警告'] = ($v[22] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['开关转换失败警告'] = (($v[22] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['温度传感器开路警告'] = (($v[22] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['温度高警告'] = (($v[22] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['温度低警告'] = (($v[22] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['压力传感器开路警告'] = (($v[22] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['压力低警告'] = (($v[22] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['发电相序错误警告'] = ($v[22] & 0x1) == 1;
        $dataArray['AlertArray']['开关转换失败警告'] = (($v[22] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['温度传感器开路警告'] = (($v[22] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['温度高警告'] = (($v[22] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['温度低警告'] = (($v[22] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['压力传感器开路警告'] = (($v[22] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['压力低警告'] = (($v[22] >> 14) & 0x1) == 1;
        
        $dataArray['液位传感器开路警告'] = ($v[23] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['液位低警告'] = (($v[23] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['液位传感器开路警告'] = ($v[23] & 0x1) == 1;
        $dataArray['AlertArray']['液位低警告'] = (($v[23] >> 2) & 0x1) == 1;
        
        $dataArray['市电异常'] = ($v[35] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['市电过压'] = (($v[35] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['市电欠压'] = (($v[35] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['市电过频'] = (($v[35] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['市电欠频'] = (($v[35] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['市电缺相'] = (($v[35] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['市电逆相序'] = (($v[35] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['市电无'] = (($v[35] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['市电异常'] = ($v[35] & 0x1) == 1;
        $dataArray['AlertArray']['市电过压'] = (($v[35] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['市电欠压'] = (($v[35] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['市电过频'] = (($v[35] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['市电欠频'] = (($v[35] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['市电缺相'] = (($v[35] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['市电逆相序'] = (($v[35] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['市电无'] = (($v[35] >> 7) & 0x1) == 1;
        
        //模拟量
        $v = unpack('S*',substr($memData, 4 + 36*2, 6*2));
        $dataArray['市电UAB'] = $v[1].' V';
        $dataArray['市电UBC'] = $v[2].' V';
        $dataArray['市电UCA'] = $v[3].' V';
        $dataArray['市电UA'] = $v[4].' V';
        $dataArray['市电UB'] = $v[5].' V';
        $dataArray['市电UC'] = $v[6].' V';
        $v = unpack('s*',substr($memData, 4 + 42*2, 3*2));
        $dataArray['市电UA相位'] = $v[1];
        $dataArray['市电UB相位'] = $v[2];
        $dataArray['市电UC相位'] = $v[3];
        $v = unpack('S*',substr($memData, 4 + 45*2, 7*2));
        $dataArray['市电频率'] = ($v[1] / 10).' Hz';
        $dataArray['发电UAB'] = $v[2].' V';
        $dataArray['发电UBC'] = $v[3].' V';
        $dataArray['发电UCA'] = $v[4].' V';
        $dataArray['发电UA'] = $v[5].' V';
        $dataArray['发电UB'] = $v[6].' V';
        $dataArray['发电UC'] = $v[7].' V';
        $v = unpack('s*',substr($memData, 4 + 52*2, 3*2));
        $dataArray['发电UA相位'] = $v[1];
        $dataArray['发电UB相位'] = $v[2];
        $dataArray['发电UC相位'] = $v[3];
        $v = unpack('S*',substr($memData, 4 + 55*2, 4*2));
        $dataArray['发电频率'] = ($v[1] / 10).' Hz';
        $dataArray['A相电流'] = ($v[2] / 10).' A';
        $dataArray['B相电流'] = ($v[3] / 10).' A';
        $dataArray['C相电流'] = ($v[4] / 10).' A';
        $v = unpack('i*',substr($memData, 4 + 59*2, 12*4));
        $dataArray['A相有功功率'] = ($v[1] / 10).' kW';
        $dataArray['B相有功功率'] = ($v[2] / 10).' kW';
        $dataArray['C相有功功率'] = ($v[3] / 10).' kW';
        $dataArray['总有功功率'] = ($v[4] / 10).' kW';
        $dataArray['A相无功功率'] = ($v[5] / 10).' kVar';
        $dataArray['B相无功功率'] = ($v[6] / 10).' kVar';
        $dataArray['C相无功功率'] = ($v[7] / 10).' kVar';
        $dataArray['总无功功率'] = ($v[8] / 10).' kVar';
        $dataArray['A相视在功率'] = ($v[9] / 10).' kVA';
        $dataArray['B相视在功率'] = ($v[10] / 10).' kVA';
        $dataArray['C相视在功率'] = ($v[11] / 10).' kVA';
        $dataArray['总视在功率'] = ($v[12] / 10).' kVA';
        $v = unpack('s*',substr($memData, 4 + 59*2 + 12*4, 4*2));
        $dataArray['A相功率因数'] = $v[1]/100;
        $dataArray['B相功率因数'] = $v[2]/100;
        $dataArray['C相功率因数'] = $v[3]/100;
        $dataArray['平均功率因数'] = $v[4]/100;
        $v = unpack('S*',substr($memData, 4 + 63*2 + 12*4, 1*2));
        $dataArray['发动机转速'] = $v[1].' r/min';
        $v = unpack('f*',substr($memData, 4 + 64*2 + 12*4, 2*4));
        $dataArray['电池电压'] = number_format($v[1] , 1).' V';
        $dataArray['充电机电压'] = number_format($v[2] , 1).' V';
        $v = unpack('S*',substr($memData, 4 + 64*2 + 14*4, 1*2));
        $dataArray['GSM信号强度'] = $v[1];
        $v = unpack('f*',substr($memData, 4 + 65*2 + 14*4, 5*4));
        $dataArray['温度'] = number_format($v[1] , 1).' ℃';
        $dataArray['压力'] = number_format($v[2] , 1).' kPa';
        $dataArray['液位'] = $v[3] > 3276 ? '无效' : number_format($v[3] , 1).' %';
        $dataArray['可编程传感器1数值'] = $v[4] > 3276 ? '无效' : number_format($v[4] , 1);
        $dataArray['可编程传感器2数值'] = $v[5] > 3276 ? '无效' : number_format($v[5] , 1);
        $v = unpack('s*',substr($memData, 4 + 65*2 + 19*4, 9*2));
        $dataArray['冷却液位'] = $v[1].' %';
        $dataArray['机油温度'] = $v[2].' ℃';
        $dataArray['冷却液压力'] = $v[3].' Bar';
        $dataArray['燃油压力'] = $v[4].' Bar';
        $dataArray['燃油温度'] = $v[5].' ℃';
        $dataArray['进气口温度'] = $v[6].' ℃';
        $dataArray['排气口温度'] = $v[7].' ℃';
        $dataArray['涡轮压力'] = $v[8].' kPa';
        $dataArray['燃油消耗'] = $v[9];
        $v = unpack('i*',substr($memData, 4 + 74*2 + 19*4, 1*4));
        $dataArray['累计燃油消耗'] = $v[1];
        $v = unpack('S*',substr($memData, 4 + 74*2 + 20*4, 12*2));
        $dataArray['发电机状态'] = _Get_hgm9300_engine_state($v[1]);
        $dataArray['发电延时值'] = $v[2];
        switch($v[3]){
            case 0: $dataArray['远程开机状态'] = '无延时'; break;
            case 1: $dataArray['远程开机状态'] = '开机延时'; break;
            case 2: $dataArray['远程开机状态'] = '停机延时'; break;
            default: $dataArray['远程开机状态'] = '无效';
        }
        $dataArray['远程开机延时值'] = $v[4];
        $dataArray['开关状态'] = _Get_hgm9300_switch_state($v[5]);
        $dataArray['开关转换延时值'] = $v[6];
        switch($v[7]){
            case 0: $dataArray['市电状态'] = '市电正常'; break;
            case 1: $dataArray['市电状态'] = '市电正常延时'; break;
            case 2: $dataArray['市电状态'] = '市电异常'; break;
            case 3: $dataArray['市电状态'] = '市电异常延时'; break;
            default: $dataArray['市电状态'] = '无效';
        }
        $dataArray['市电延时值'] = $v[8];
        $dataArray['累计运行小时'] = $v[9].' h';
        $dataArray['累计运行分钟'] = $v[10].' m';
        $dataArray['累计运行秒钟'] = $v[11].' s';
        $dataArray['累计开机次数'] = $v[12];
        $v = unpack('I*',substr($memData, 4 + 86*2 + 20*4, 3*4));
        $dataArray['累计有功电能'] = ($v[1] / 10).' kWh';
        $dataArray['累计无功电能'] = ($v[2] / 10).' kVarh';
        $dataArray['累计视在电能'] = ($v[3] / 10).' kVAh';
        $v = unpack('v', substr($memData, 268, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 270, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}


?>
