<?php
function _Get_hgm9420n_engine_state($value){
    switch ($value){
        case 0: return '待机';
        case 1: return '预热';
        case 2: return '燃油输出';
        case 3: return '起动';
        case 4: return '起动间隔';
        case 5: return '安全延时';
        case 6: return '开机怠速';
        case 7: return '高速暖机';
        case 8: return '等待带载';
        case 9: return '正常运行';
        case 10: return '高速散热';
        case 11: return '停机怠速';
        case 12: return '得电停机';
        case 13: return '等待停稳';
        case 14: return '过停稳';
        case 15: return '停机失败';
    }
    return '无效';
}

function _Get_hgm9420n_switch_state($value){
    switch ($value){
        case 0: return '负载断开';
        case 1: return '市电合闸';
        case 2: return '发电合闸';
        case 3: return '分闸延时';
        case 4: return '开关转换延时';
        case 5: return '市电合闸延时';
        case 6: return '发电合闸延时';
        case 7: return '等待分闸';
        case 8: return '等待发电合闸';
        case 9: return '等待市电合闸';
        case 10: return '正常';
    }
    return '无效';
}
function Get_hgm9420n_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray["无数据"] = false;
        $dataArray['AlertArray'] = array();
        //alarm
        $v = unpack('C*',substr($memData, 4, 4));
        $dataArray['公共报警'] = ($v[1] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['公共停机报警'] = (($v[1] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['公共警告报警'] = (($v[1] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['公共跳闸停机报警'] = (($v[1] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['公共跳闸报警'] = (($v[1] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['公共闭锁报警'] = (($v[1] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['公共报警'] = ($v[1] & 0x1) == 1;
        $dataArray['AlertArray']['公共停机报警'] = (($v[1] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['公共警告报警'] = (($v[1] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['公共跳闸停机报警'] = (($v[1] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['公共跳闸报警'] = (($v[1] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['公共闭锁报警'] = (($v[1] >> 7) & 0x1) == 1;


        $dataArray['自动模式'] = $v[2] ? '是' : '否';
        $dataArray['AlertArray']['自动模式'] = $v[2] != 1;
        $dataArray['手动模式'] = $v[3] ? '是' : '否';
        $dataArray['停机模式'] = $v[4] ? '是' : '否';
       
        $v = unpack('S*',substr($memData, 4 + 4, 2*100));
        
        $dataArray['紧急停机报警'] = ($v[1] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['超速报警停机'] = (($v[1] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['欠速停机'] = (($v[1] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['速度信号丢失报警'] = (($v[1] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电过频报警停机'] = (($v[1] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电欠频停机'] = (($v[1] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电过压停机'] = (($v[1] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电欠压停机'] = (($v[1] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['起动失败报警'] = (($v[1] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电过流停机'] = (($v[1] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电流不平衡'] = (($v[1] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['接地故障'] = (($v[1] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['逆功率报警停机'] = (($v[1] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['过功率报警停机'] = (($v[1] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['失磁故障'] = (($v[1] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['ECU通信失败'] = (($v[1] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['紧急停机报警'] = ($v[1] & 0x1) == 1;
        $dataArray['AlertArray']['超速报警停机'] = (($v[1] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['欠速停机'] = (($v[1] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['速度信号丢失报警'] = (($v[1] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['发电过频报警停机'] = (($v[1] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['发电欠频停机'] = (($v[1] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['发电过压停机'] = (($v[1] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['发电欠压停机'] = (($v[1] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['起动失败报警'] = (($v[1] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['发电过流停机'] = (($v[1] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['电流不平衡'] = (($v[1] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['接地故障'] = (($v[1] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['逆功率报警停机'] = (($v[1] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['过功率报警停机'] = (($v[1] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['失磁故障'] = (($v[1] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['ECU通信失败'] = (($v[1] >> 15) & 0x1) == 1;
        
        $dataArray['ECU报警'] = ($v[2] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['温度高输入报警'] = (($v[2] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['油压低输入报警'] = (($v[2] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['温度传感器开路'] = (($v[2] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发动机温度高'] = (($v[2] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发动机温度低'] = (($v[2] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['温度传感器错误'] = (($v[2] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['油压传感器开路'] = (($v[2] >> 11) & 0x1) == 1 ? '告警' : '正常';        
        $dataArray['油压高'] = (($v[2] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['油压低'] = (($v[2] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['油压传感器错误'] = (($v[2] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['燃油位传感器开路'] = (($v[2] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['ECU报警'] = ($v[2] & 0x1) == 1;
        $dataArray['AlertArray']['温度高输入报警'] = (($v[2] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['油压低输入报警'] = (($v[2] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['温度传感器开路'] = (($v[2] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['发动机温度高'] = (($v[2] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['发动机温度低'] = (($v[2] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['温度传感器错误'] = (($v[2] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['油压传感器开路'] = (($v[2] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['油压高'] = (($v[2] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['油压低'] = (($v[2] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['油压传感器错误'] = (($v[2] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['燃油位传感器开路'] = (($v[2] >> 15) & 0x1) == 1;
        
        $dataArray['燃油位高'] = ($v[3] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['燃油位低'] = (($v[3] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['燃油位传感器错误'] = (($v[3] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['可编程传感器1开路'] = (($v[3] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['可编程传感器1高'] = (($v[3] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['可编程传感器1低'] = (($v[3] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['可编程传感器1错误'] = (($v[3] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['可编程传感器2开路'] = (($v[3] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['可编程传感器2高'] = (($v[3] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['可编程传感器2低'] = (($v[3] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['可编程传感器2错误'] = (($v[3] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['停机失败'] = (($v[3] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['充电失败'] = (($v[3] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池过压'] = (($v[3] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池欠压'] = (($v[3] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['同步失败'] = (($v[3] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['燃油位高'] = ($v[3] & 0x1) == 1;
        $dataArray['AlertArray']['燃油位低'] = (($v[3] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['燃油位传感器错误'] = (($v[3] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['可编程传感器1开路'] = (($v[3] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['可编程传感器1高'] = (($v[3] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['可编程传感器1低'] = (($v[3] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['可编程传感器1错误'] = (($v[3] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['可编程传感器2开路'] = (($v[3] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['可编程传感器2高'] = (($v[3] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['可编程传感器2低'] = (($v[3] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['可编程传感器2错误'] = (($v[3] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['停机失败'] = (($v[3] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['充电失败'] = (($v[3] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['电池过压'] = (($v[3] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['电池欠压'] = (($v[3] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['同步失败'] = (($v[3] >> 15) & 0x1) == 1;

        $dataArray['电压不同步'] = (($v[4] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['频率不同步'] = (($v[4] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['相位不同步'] = (($v[4] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['市电开关报警'] = (($v[4] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电开关报警'] = (($v[4] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['市电合闸失败'] = (($v[4] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电合闸失败'] = (($v[4] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['市电分闸失败'] = (($v[4] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电分闸失败'] = (($v[4] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['市电过频'] = (($v[4] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['市电欠频'] = (($v[4] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['市电过压'] = (($v[4] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['市电欠压'] = (($v[4] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['电压不同步'] = (($v[4] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['频率不同步'] = (($v[4] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['相位不同步'] = (($v[4] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['市电开关报警'] = (($v[4] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['发电开关报警'] = (($v[4] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['市电合闸失败'] = (($v[4] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['发电合闸失败'] = (($v[4] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['市电分闸失败'] = (($v[4] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['发电分闸失败'] = (($v[4] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['市电过频'] = (($v[4] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['市电欠频'] = (($v[4] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['市电过压'] = (($v[4] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['市电欠压'] = (($v[4] >> 15) & 0x1) == 1;
        
        $dataArray['维护1时间到'] = (($v[5] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['维护2时间到'] = (($v[5] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['维护3时间到'] = (($v[5] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['水位低报警'] = (($v[5] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['爆震报警'] = (($v[5] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['燃气泄漏报警'] = (($v[5] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电逆相序'] = (($v[5] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电缺相'] = (($v[5] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['开关转换失败'] = (($v[5] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['维护1时间到'] = (($v[5] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['维护2时间到'] = (($v[5] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['维护3时间到'] = (($v[5] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['水位低报警'] = (($v[5] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['爆震报警'] = (($v[5] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['燃气泄漏报警'] = (($v[5] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['发电逆相序'] = (($v[5] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['发电缺相'] = (($v[5] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['开关转换失败'] = (($v[5] >> 15) & 0x1) == 1;

        $dataArray['开关量输入口1'] = ($v[6] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['开关量输入口2'] = (($v[6] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['开关量输入口3'] = (($v[6] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['开关量输入口4'] = (($v[6] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['开关量输入口5'] = (($v[6] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['开关量输入口6'] = (($v[6] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['开关量输入口7'] = (($v[6] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['开关量输入口8'] = (($v[6] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['开关量输入口9'] = (($v[6] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['开关量输入口10'] = (($v[6] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['开关量输入口11'] = (($v[6] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['开关量输入口12'] = (($v[6] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PLC功能1'] = (($v[6] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PLC功能2'] = (($v[6] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PLC功能3'] = (($v[6] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PLC功能4'] = (($v[6] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['开关量输入口1'] = ($v[6] & 0x1) == 1;
        $dataArray['AlertArray']['开关量输入口2'] = (($v[6] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['开关量输入口3'] = (($v[6] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['开关量输入口4'] = (($v[6] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['开关量输入口5'] = (($v[6] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['开关量输入口6'] = (($v[6] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['开关量输入口7'] = (($v[6] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['开关量输入口8'] = (($v[6] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['开关量输入口9'] = (($v[6] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['开关量输入口10'] = (($v[6] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['开关量输入口11'] = (($v[6] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['开关量输入口12'] = (($v[6] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['PLC功能1'] = (($v[6] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['PLC功能2'] = (($v[6] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['PLC功能3'] = (($v[6] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['PLC功能4'] = (($v[6] >> 15) & 0x1) == 1;
        
        $dataArray['PLC功能5'] = ($v[7] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PLC功能6'] = (($v[7] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PLC功能7'] = (($v[7] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PLC功能8'] = (($v[7] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PLC功能9'] = (($v[7] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PLC功能10'] = (($v[7] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PLC功能11'] = (($v[7] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PLC功能12'] = (($v[7] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PLC功能13'] = (($v[7] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PLC功能14'] = (($v[7] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PLC功能15'] = (($v[7] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PLC功能16'] = (($v[7] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PLC功能17'] = (($v[7] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PLC功能18'] = (($v[7] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PLC功能19'] = (($v[7] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PLC功能20'] = (($v[7] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['PLC功能5'] = ($v[7] & 0x1) == 1;
        $dataArray['AlertArray']['PLC功能6'] = (($v[7] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['PLC功能7'] = (($v[7] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['PLC功能8'] = (($v[7] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['PLC功能9'] = (($v[7] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['PLC功能10'] = (($v[7] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['PLC功能11'] = (($v[7] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['PLC功能12'] = (($v[7] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['PLC功能13'] = (($v[7] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['PLC功能14'] = (($v[7] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['PLC功能15'] = (($v[7] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['PLC功能16'] = (($v[7] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['PLC功能17'] = (($v[7] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['PLC功能18'] = (($v[7] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['PLC功能19'] = (($v[7] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['PLC功能20'] = (($v[7] >> 15) & 0x1) == 1;
        
        $dataArray['DIN16通信失败'] = ($v[8] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DIN16输入1'] = (($v[8] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DIN16输入2'] = (($v[8] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DIN16输入3'] = (($v[8] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DIN16输入4'] = (($v[8] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DIN16输入5'] = (($v[8] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DIN16输入6'] = (($v[8] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DIN16输入7'] = (($v[8] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DIN16输入8'] = (($v[8] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DIN16输入9'] = (($v[8] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DIN16输入10'] = (($v[8] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DIN16输入11'] = (($v[8] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DIN16输入12'] = (($v[8] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DIN16输入13'] = (($v[8] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DIN16输入14'] = (($v[8] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DIN16输入15'] = (($v[8] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['DIN16通信失败'] = ($v[8] & 0x1) == 1;
        $dataArray['AlertArray']['DIN16输入1'] = (($v[8] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['DIN16输入2'] = (($v[8] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['DIN16输入3'] = (($v[8] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['DIN16输入4'] = (($v[8] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['DIN16输入5'] = (($v[8] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['DIN16输入6'] = (($v[8] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['DIN16输入7'] = (($v[8] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['DIN16输入8'] = (($v[8] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['DIN16输入9'] = (($v[8] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['DIN16输入10'] = (($v[8] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['DIN16输入11'] = (($v[8] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['DIN16输入12'] = (($v[8] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['DIN16输入13'] = (($v[8] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['DIN16输入14'] = (($v[8] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['DIN16输入15'] = (($v[8] >> 15) & 0x1) == 1;
        
        $dataArray['DIN16输入16'] = ($v[9] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DOUT16通信失败'] = (($v[9] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1通信失败'] = (($v[9] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1缸温高'] = (($v[9] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1排温高'] = (($v[9] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1缸温差大'] = (($v[9] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器15开路'] = (($v[9] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器15高'] = (($v[9] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器15低'] = (($v[9] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器16开路'] = (($v[9] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器16高'] = (($v[9] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器16低'] = (($v[9] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器17开路'] = (($v[9] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器17高'] = (($v[9] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器17低'] = (($v[9] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器18开路'] = (($v[9] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['DIN16输入16'] = ($v[9] & 0x1) == 1;
        $dataArray['AlertArray']['DOUT16通信失败'] = (($v[9] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1通信失败'] = (($v[9] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1缸温高'] = (($v[9] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1排温高'] = (($v[9] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1缸温差大'] = (($v[9] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器15开路'] = (($v[9] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器15高'] = (($v[9] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器15低'] = (($v[9] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器16开路'] = (($v[9] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器16高'] = (($v[9] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器16低'] = (($v[9] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器17开路'] = (($v[9] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器17高'] = (($v[9] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器17低'] = (($v[9] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器18开路'] = (($v[9] >> 15) & 0x1) == 1;

        $dataArray['AIN24 1传感器18高'] = ($v[10] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器18低'] = (($v[10] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器19开路'] = (($v[10] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器19高'] = (($v[10] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器19低'] = (($v[10] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器20开路'] = (($v[10] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器20高'] = (($v[10] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器20低'] = (($v[10] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器21开路'] = (($v[10] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器21高'] = (($v[10] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器21低'] = (($v[10] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器22开路'] = (($v[10] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器22高'] = (($v[10] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器22低'] = (($v[10] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器23开路'] = (($v[10] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 1传感器23高'] = (($v[10] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['AIN24 1传感器18高'] = ($v[10] & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器18低'] = (($v[10] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器19开路'] = (($v[10] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器19高'] = (($v[10] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器19低'] = (($v[10] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器20开路'] = (($v[10] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器20高'] = (($v[10] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器20低'] = (($v[10] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器21开路'] = (($v[10] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器21高'] = (($v[10] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器21低'] = (($v[10] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器22开路'] = (($v[10] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器22高'] = (($v[10] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器22低'] = (($v[10] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器23开路'] = (($v[10] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 1传感器23高'] = (($v[10] >> 15) & 0x1) == 1;

        $dataArray['AIN24 传感器23低'] = ($v[11] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 传感器24开路'] = (($v[11] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 传感器24高'] = (($v[11] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 传感器24低'] = (($v[11] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2通信失败'] = (($v[11] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2缸温高'] = (($v[11] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2排温高'] = (($v[11] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2缸温差大'] = (($v[11] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器15开路'] = (($v[11] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器15高'] = (($v[11] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器15低'] = (($v[11] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器16开路'] = (($v[11] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器16高'] = (($v[11] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器16低'] = (($v[11] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器17开路'] = (($v[11] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器17高'] = (($v[11] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['AIN24 传感器23低'] = ($v[11] & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 传感器24开路'] = (($v[11] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 传感器24高'] = (($v[11] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 传感器24低'] = (($v[11] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2通信失败'] = (($v[11] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2缸温高'] = (($v[11] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2排温高'] = (($v[11] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2缸温差大'] = (($v[11] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器15开路'] = (($v[11] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器15高'] = (($v[11] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器15低'] = (($v[11] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器16开路'] = (($v[11] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器16高'] = (($v[11] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器16低'] = (($v[11] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器17开路'] = (($v[11] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器17高'] = (($v[11] >> 15) & 0x1) == 1;

        $dataArray['AIN24 2传感器17低'] = ($v[12] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器18开路'] = (($v[12] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器18高'] = (($v[12] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器18低'] = (($v[12] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器19开路'] = (($v[12] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器19高'] = (($v[12] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器19低'] = (($v[12] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器20开路'] = (($v[12] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器20高'] = (($v[12] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器20低'] = (($v[12] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器21开路'] = (($v[12] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器21高'] = (($v[12] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器21低'] = (($v[12] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器22开路'] = (($v[12] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器22高'] = (($v[12] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器22低'] = (($v[12] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['AIN24 2传感器17低'] = ($v[12] & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器18开路'] = (($v[12] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器18高'] = (($v[12] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器18低'] = (($v[12] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器19开路'] = (($v[12] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器19高'] = (($v[12] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器19低'] = (($v[12] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器20开路'] = (($v[12] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器20高'] = (($v[12] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器20低'] = (($v[12] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器21开路'] = (($v[12] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器21高'] = (($v[12] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器21低'] = (($v[12] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器22开路'] = (($v[12] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器22高'] = (($v[12] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器22低'] = (($v[12] >> 15) & 0x1) == 1;
        
        $dataArray['AIN24 2传感器23开路'] = ($v[13] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器23高'] = (($v[13] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器23低'] = (($v[13] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器24开路'] = (($v[13] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器24高'] = (($v[13] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN24 2传感器24低'] = (($v[13] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['功率因数低'] = (($v[13] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['波形失真度高'] = (($v[13] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电电压不平衡'] = (($v[13] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['AIN24 2传感器23开路'] = ($v[13] & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器23高'] = (($v[13] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器23低'] = (($v[13] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器24开路'] = (($v[13] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器24高'] = (($v[13] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['AIN24 2传感器24低'] = (($v[13] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['功率因数低'] = (($v[13] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['波形失真度高'] = (($v[13] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['发电电压不平衡'] = (($v[13] >> 8) & 0x1) == 1;

        $dataArray['可编程传感器3开路'] = (($v[15] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['可编程传感器3高'] = (($v[15] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['可编程传感器3低'] = (($v[15] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['可编程传感器3错误'] = (($v[15] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['循环开机通信失败'] = (($v[15] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['SGE02-4G通信失败'] = (($v[15] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['可编程传感器3开路'] = (($v[15] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['可编程传感器3高'] = (($v[15] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['可编程传感器3低'] = (($v[15] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['可编程传感器3错误'] = (($v[15] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['循环开机通信失败'] = (($v[15] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['SGE02-4G通信失败'] = (($v[15] >> 13) & 0x1) == 1;

        $dataArray['AIN16M02 1通信失败'] = ($v[16] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器1开路'] = (($v[16] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器1高'] = (($v[16] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器1低'] = (($v[16] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器2开路'] = (($v[16] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器2高'] = (($v[16] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器2低'] = (($v[16] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器3开路'] = (($v[16] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器3高'] = (($v[16] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器3低'] = (($v[16] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器4开路'] = (($v[16] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器4高'] = (($v[16] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器4低'] = (($v[16] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器5开路'] = (($v[16] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器5高'] = (($v[16] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器5低'] = (($v[16] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['AIN16M02 1通信失败'] = ($v[16] & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器1开路'] = (($v[16] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器1高'] = (($v[16] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器1低'] = (($v[16] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器2开路'] = (($v[16] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器2高'] = (($v[16] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器2低'] = (($v[16] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器3开路'] = (($v[16] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器3高'] = (($v[16] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器3低'] = (($v[16] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器4开路'] = (($v[16] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器4高'] = (($v[16] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器4低'] = (($v[16] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器5开路'] = (($v[16] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器5高'] = (($v[16] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器5低'] = (($v[16] >> 15) & 0x1) == 1;

        $dataArray['AIN16M02 1传感器6开路'] = ($v[17] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器6高'] = (($v[17] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器6低'] = (($v[17] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器7开路'] = (($v[17] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器7高'] = (($v[17] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器7低'] = (($v[17] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器8开路'] = (($v[17] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器8高'] = (($v[17] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器8低'] = (($v[17] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器9开路'] = (($v[17] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器9高'] = (($v[17] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器9低'] = (($v[17] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器10开路'] = (($v[17] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器10高'] = (($v[17] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器10低'] = (($v[17] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器11开路'] = (($v[17] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['AIN16M02 1传感器6开路'] = ($v[17] & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器6高'] = (($v[17] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器6低'] = (($v[17] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器7开路'] = (($v[17] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器7高'] = (($v[17] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器7低'] = (($v[17] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器8开路'] = (($v[17] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器8高'] = (($v[17] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器8低'] = (($v[17] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器9开路'] = (($v[17] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器9高'] = (($v[17] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器9低'] = (($v[17] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器10开路'] = (($v[17] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器10高'] = (($v[17] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器10低'] = (($v[17] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器11开路'] = (($v[17] >> 15) & 0x1) == 1;

        $dataArray['AIN16M02 1传感器11高'] = ($v[18] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器11低'] = (($v[18] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器12开路'] = (($v[18] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器12高'] = (($v[18] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 1传感器12低'] = (($v[18] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2通信失败'] = (($v[18] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器1开路'] = (($v[18] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器1高'] = (($v[18] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器1低'] = (($v[18] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器2开路'] = (($v[18] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器2高'] = (($v[18] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器2低'] = (($v[18] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器3开路'] = (($v[18] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器3高'] = (($v[18] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器3低'] = (($v[18] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器4开路'] = (($v[18] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['AIN16M02 1传感器11高'] = ($v[18] & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器11低'] = (($v[18] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器12开路'] = (($v[18] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器12高'] = (($v[18] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 1传感器12低'] = (($v[18] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2通信失败'] = (($v[18] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器1开路'] = (($v[18] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器1高'] = (($v[18] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器1低'] = (($v[18] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器2开路'] = (($v[18] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器2高'] = (($v[18] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器2低'] = (($v[18] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器3开路'] = (($v[18] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器3高'] = (($v[18] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器3低'] = (($v[18] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器4开路'] = (($v[18] >> 15) & 0x1) == 1;

        $dataArray['AIN16M02 2传感器4高'] = ($v[19] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器4低'] = (($v[19] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器5开路'] = (($v[19] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器5高'] = (($v[19] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器5低'] = (($v[19] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器6开路'] = (($v[19] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器6高'] = (($v[19] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器6低'] = (($v[19] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器7开路'] = (($v[19] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器7高'] = (($v[19] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器7低'] = (($v[19] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器8开路'] = (($v[19] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器8高'] = (($v[19] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器8低'] = (($v[19] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器9开路'] = (($v[19] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器9高'] = (($v[19] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['AIN16M02 2传感器4高'] = ($v[19] & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器4低'] = (($v[19] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器5开路'] = (($v[19] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器5高'] = (($v[19] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器5低'] = (($v[19] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器6开路'] = (($v[19] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器6高'] = (($v[19] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器6低'] = (($v[19] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器7开路'] = (($v[19] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器7高'] = (($v[19] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器7低'] = (($v[19] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器8开路'] = (($v[19] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器8高'] = (($v[19] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器8低'] = (($v[19] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器9开路'] = (($v[19] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器9高'] = (($v[19] >> 15) & 0x1) == 1;

        $dataArray['AIN16M02 2传感器9低'] = ($v[20] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器10开路'] = (($v[20] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器10高'] = (($v[20] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器10低'] = (($v[20] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器11开路'] = (($v[20] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器11高'] = (($v[20] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器11低'] = (($v[20] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器12开路'] = (($v[20] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器12高'] = (($v[20] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AIN16M02 2传感器12低'] = (($v[20] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['BAC150CAN通信失败'] = (($v[20] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['AIN16M02 2传感器9低'] = ($v[20] & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器10开路'] = (($v[20] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器10高'] = (($v[20] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器10低'] = (($v[20] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器11开路'] = (($v[20] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器11高'] = (($v[20] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器11低'] = (($v[20] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器12开路'] = (($v[20] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器12高'] = (($v[20] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['AIN16M02 2传感器12低'] = (($v[20] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['BAC150CAN通信失败'] = (($v[20] >> 10) & 0x1) == 1;
        //模拟量
        $v = unpack('C*',substr($memData, 4 + 4 + 2*100, 2));
        $dataArray["市电正常"] = $v[1] & 0x1 ? "是" : "否";
        $dataArray["市电合闸"] = ($v[1] >> 1) & 0x1 ? "是" : "否";
        $dataArray["发电正常"] = ($v[1] >> 2) & 0x1 ? "是" : "否";
        $dataArray["发电合闸"] = ($v[1] >> 3) & 0x1 ? "是" : "否";
        $dataArray["运行状态灯"] = ($v[1] >> 4) & 0x1 ? "是" : "否";
        $dataArray["静音指示灯"] = ($v[1] >> 5) & 0x1 ? "是" : "否";

        $dataArray["市电异常"] = $v[2] & 0x1 ? "是" : "否";
        $dataArray["市电过压"] = ($v[2] >> 1) & 0x1 ? "是" : "否";
        $dataArray["市电欠压"] = ($v[2] >> 2) & 0x1 ? "是" : "否";
        $dataArray["市电过频"] = ($v[2] >> 3) & 0x1 ? "是" : "否";
        $dataArray["市电欠频"] = ($v[2] >> 4) & 0x1 ? "是" : "否";
        $dataArray["市电缺相"] = ($v[2] >> 5) & 0x1 ? "是" : "否";
        $dataArray["市电逆相序"] = ($v[2] >> 6) & 0x1 ? "是" : "否";
        $dataArray["市电无"] = ($v[2] >> 7) & 0x1 ? "是" : "否";

        $v = unpack('f*',substr($memData, 4 + 4 + 2*100 + 2, 4 * 51));
        $dataArray['市电UAB'] = $v[1].' V';
        $dataArray['市电UBC'] = $v[2].' V';
        $dataArray['市电UCA'] = $v[3].' V';
        $dataArray['市电UA'] = $v[4].' V';
        $dataArray['市电UB'] = $v[5].' V';
        $dataArray['市电UC'] = $v[6].' V';
        $dataArray['市电UA相位'] = $v[7];
        $dataArray['市电UB相位'] = $v[8];
        $dataArray['市电UC相位'] = $v[9];
        $dataArray['市电频率'] = ($v[10]).' Hz';
        $dataArray['发电UAB'] = $v[11].' V';
        $dataArray['发电UBC'] = $v[12].' V';
        $dataArray['发电UCA'] = $v[13].' V';
        $dataArray['发电UA'] = $v[14].' V';
        $dataArray['发电UB'] = $v[15].' V';
        $dataArray['发电UC'] = $v[16].' V';
        $dataArray['发电UA相位'] = $v[17];
        $dataArray['发电UB相位'] = $v[18];
        $dataArray['发电UC相位'] = $v[19];
        $dataArray['发电频率'] = ($v[20]).' Hz';
        $dataArray["电压差"] = $v[21];
        $dataArray["频率差"] = $v[22];
        $dataArray["相位差"] = $v[23];
        $dataArray['A相电流'] = ($v[24]).' A';
        $dataArray['B相电流'] = ($v[25]).' A';
        $dataArray['C相电流'] = ($v[26]).' A';
        $dataArray['接地电流'] = ($v[27]).' A';

        $dataArray['A相有功功率'] = ($v[28]).' kW';
        $dataArray['B相有功功率'] = ($v[29]).' kW';
        $dataArray['C相有功功率'] = ($v[30]).' kW';
        $dataArray['总有功功率'] = ($v[31]).' kW';
        $dataArray['A相无功功率'] = ($v[32]).' kVar';
        $dataArray['B相无功功率'] = ($v[33]).' kVar';
        $dataArray['C相无功功率'] = ($v[34]).' kVar';
        $dataArray['总无功功率'] = ($v[35]).' kVar';
        $dataArray['A相视在功率'] = ($v[36]).' kVA';
        $dataArray['B相视在功率'] = ($v[37]).' kVA';
        $dataArray['C相视在功率'] = ($v[38]).' kVA';
        $dataArray['总视在功率'] = ($v[39]).' kVA';

        $dataArray['A相功率因数'] = $v[40];
        $dataArray['B相功率因数'] = $v[41];
        $dataArray['C相功率因数'] = $v[42];
        $dataArray['平均功率因数'] = $v[43];
        $dataArray["不平衡电流"] = $v[44];
        $dataArray["DC电压"] = $v[45];
        $dataArray['发动机转速'] = $v[46].' r/min';
        $dataArray['电池电压'] = number_format($v[47] , 2).' V';
        $dataArray['充电机电压'] = number_format($v[48] , 2).' V';
        $dataArray['温度传感器'] = $v[49].' ℃';
        $dataArray["压力传感器"] = $v[50].' kPa';
        $dataArray["液位传感器"] = $v[51];

        $v = unpack('s*',substr($memData, 4 + 4 + 2*100 + 2 + 4 * 51, 2*9));
        $dataArray['负载百分比'] = $v[1].' %';
        $dataArray['冷却液位'] = $v[2].' %';
        $dataArray['机油温度'] = $v[3].' ℃';
        $dataArray['冷却液压力'] = $v[4].' Bar';
        $dataArray['燃油压力'] = $v[5].' Bar';
        $dataArray['燃油温度'] = $v[6].' ℃';
        $dataArray['进气口温度'] = $v[7].' ℃';
        $dataArray['排气口温度'] = $v[8].' ℃';
        $dataArray['涡轮压力'] = $v[9].' kPa';
      
        $v = unpack('f*',substr($memData, 4 + 4 + 2*100 + 2 + 4 * 51 + 2*9, 4*2));
        $dataArray['燃油消耗'] = number_format($v[1] , 1);
        $dataArray['累计燃油消耗'] = number_format($v[2] , 2);

        $v = unpack('S*',substr($memData, 4 + 4 + 2*100 + 2 + 4 * 51 + 2*9 + 4*2, 12*2));
        $dataArray['发电机状态'] = _Get_hgm9420n_engine_state($v[1]);
        $dataArray['发电延时值'] = $v[2];
        switch($v[3]){
            case 0: $dataArray['远程开机状态'] = '无延时'; break;
            case 1: $dataArray['远程开机状态'] = '开机延时'; break;
            case 2: $dataArray['远程开机状态'] = '停机延时'; break;
            default: $dataArray['远程开机状态'] = '无效';
        }
        $dataArray['远程开机延时值'] = $v[4];
        $dataArray['开关状态'] = _Get_hgm9420n_switch_state($v[5]);
        $dataArray['开关转换延时值'] = $v[6];
        switch($v[7]){
            case 0: $dataArray['市电状态'] = '市电正常'; break;
            case 1: $dataArray['市电状态'] = '市电正常延时'; break;
            case 2: $dataArray['市电状态'] = '市电异常'; break;
            case 3: $dataArray['市电状态'] = '市电异常延时'; break;
            default: $dataArray['市电状态'] = '无效';
        }
        $dataArray['市电延时值'] = $v[8];
        $dataArray['累计运行小时'] = $v[9].' h';
        $dataArray['累计运行分钟'] = $v[10].' m';
        $dataArray['累计运行秒钟'] = $v[11].' s';
        $dataArray['累计开机次数'] = $v[12];
        $v = unpack('f*',substr($memData, 4 + 4 + 2*100 + 2 + 4 * 51 + 2*9 + 4*2 + 12*2, 3*4));
        $dataArray['累计有功电能'] = ($v[1]).' kWh';
        $dataArray['累计无功电能'] = ($v[2]).' kVarh';
        $dataArray['累计视在电能'] = ($v[3]).' kVAh';

        $v = unpack('S*',substr($memData, 4 + 4 + 2*100 + 2 + 4 * 51 + 2*9 + 4*2 + 12*2 + 3*4, 14*2));
        $dataArray['开关状态选择'] = $v[1];
        $dataArray['控制器型号'] = $v[2];
        $dataArray['控制器软件版本'] = $v[3];
        $dataArray['控制器硬件版本'] = $v[4];
        $dataArray['控制器发布年'] = $v[5];
        $dataArray['控制器发布月'] = $v[6];
        $dataArray['控制器发布日'] = $v[7];
        $dataArray['控制器时间：年'] = $v[8];
        $dataArray['控制器时间：月'] = $v[9];
        $dataArray['控制器时间：日'] = $v[10];
        $dataArray['控制器时间：星期'] = $v[11];
        $dataArray['控制器时间：时'] = $v[12];
        $dataArray['控制器时间：分'] = $v[13];
        $dataArray['控制器时间：秒'] = $v[14];
        $v = unpack('v', substr($memData, 4 + 4 + 2*100 + 2 + 4 * 51 + 2*9 + 4*2 + 12*2 + 3*4 + 14*2, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 4 + 2*100 + 2 + 4 * 51 + 2*9 + 4*2 + 12*2 + 3*4 + 14*2 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}


?>
