<?php

function Get_hisense_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '温度设定点':
            return array(0,  $dataArray['温度设定点']);
        case '回风温度':
            return array(0, $dataArray['回风温度']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_hisense_RtData($memData , &$dataArray , $extraPara = false)
{
    if($memData == false ){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $v = unpack('f*', substr($memData, 4 , 4 * 12));
        $dataArray["回风温度"] =  $v[8];

        $v = unpack('f*', substr($memData, 4*24 + 44 , 4));
        $dataArray['温度设定点'] = number_format($v[1], 2);
        $v = unpack('v', substr($memData, 4*24 + 44 + 4, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4*24+ 44 + 4 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

?>
