<?php

function Get_hisense_v3_UnicomCategory()
{
    return "911";
}

function _hisense_v3_ShowAlert(&$dataArray, $label, $value, $vsValue)
{
    $dataArray[$label] = ($value != $vsValue) ? '正常' : '告警';
    $dataArray['AlertArray'][$label] = $value == $vsValue;
}

function Get_hisense_v3_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $offset = 4;
        $v = unpack('C*', substr($memData, 4, 12));
	if($v[1] == 0x08){
	  $dataArray["空调状态"] = "通信故障";
	}else if($v[1] == 0x1){
	  $dataArray["空调状态"] = "开机";
	}else if($v[1] == 0x0){
	  $dataArray["空调状态"] = "关机";
	}
	switch($v[2] & 0x07){
	  case 0:
	    $dataArray["运行方式"] = "送风";
	    break;
	  case 1:
	    $dataArray["运行方式"] = "制热";
	    break;
	  case 2:
	    $dataArray["运行方式"] = "制冷";
	    break;
	  case 3:
	    $dataArray["运行方式"] = "除湿";
	    break;
	}
	if($v[2] >> 3){
	    $dataArray["运行方式"] .= ";加湿";
	}else{
	    $dataArray["运行方式"] .= ";不加湿";
	}
	$dataArray["室内湿度"] = $v[3]/2-20;
	$dataArray["室内温度"] = $v[4]/2-20;	
	$dataArray["室外温度"] = $v[5]/2-20;
	$dataArray["室内盘管温度"] = $v[6]/2-20;
	$dataArray["室外盘管温度"] = $v[7]/2-20;
	switch($v[8]){
	  case 0:
	    $dataArray["导风叶片位置"] = "关闭";
	    break;
	  case 1:
	    $dataArray["导风叶片位置"] = "扫略";
	    break;
	  case 2:
	    $dataArray["导风叶片位置"] = "自动";
	    break;
	  default:
	    $dataArray["导风叶片位置"] = "位置".($v[8]-2);
	    break;
	}
	switch($v[9]){
          case 0:
            $dataArray["风速"] = "停转";
            break;
          case 1:
            $dataArray["风速"] = "低速";
            break;
          case 2:
            $dataArray["风速"] = "中速";
            break;
          default:
            $dataArray["风速"] = "高速";
            break;
        }
	switch($v[10]>>4){
	  case 0:
	    $dataArray["压机状态"] = "压机停转，四通阀停止";
	    break;
	  case 0x10:
	    $dataArray["压机状态"] = "压机运转";
	    break;
	  case 0x20:
	    $dataArray["压机状态"] = "四通阀通电";
	    break;
	  case 0x40:
	    $dataArray["压机状态"] = "压机运转四通阀通电";
	    break;
	}
	switch($v[10]&0x0F){
          case 0:
            $dataArray["外风机状态"] = "外风机停转";
            break;
          case 0x10:
            $dataArray["外风机状态"] = "外风机运转低速";
            break;
          case 0x20:
            $dataArray["外风机状态"] = "外风机运转中速";
            break;
          case 0x40:
            $dataArray["外风机状态"] = "外风机运转高速";
            break;
        }
	
	_hisense_v3_ShowAlert($dataArray, "防冻结", $v[11] , 1);
	_hisense_v3_ShowAlert($dataArray, "除霜", $v[11] , 2);
	_hisense_v3_ShowAlert($dataArray, "内盘过热", $v[11] , 4);
	_hisense_v3_ShowAlert($dataArray, "压机高低压保护（系统保护）", $v[11] , 0x10);
	_hisense_v3_ShowAlert($dataArray, "压机排气温度保护", $v[11] , 0x20);
	_hisense_v3_ShowAlert($dataArray, "电压过压欠压保护", $v[11] , 0x40);
	_hisense_v3_ShowAlert($dataArray, "内外通讯故障", $v[11] , 0x80);

	_hisense_v3_ShowAlert($dataArray, "室内环境温度传感器故障", $v[12] , 1);
	_hisense_v3_ShowAlert($dataArray, "室内盘管温度传感器故障", $v[12] , 2);
	_hisense_v3_ShowAlert($dataArray, "室内EEPROM故障", $v[12] , 4);
	_hisense_v3_ShowAlert($dataArray, "室外环境温度传感器故障", $v[12] , 0x10);
	_hisense_v3_ShowAlert($dataArray, "室外盘管温度传感器故障", $v[12] , 0x20);
	_hisense_v3_ShowAlert($dataArray, "室外电流保护（包括相不平衡和过流）", $v[12] , 0x40);
	_hisense_v3_ShowAlert($dataArray, "湿度传感器故障", $v[12] , 0x80);
	
	$v = unpack('v', substr($memData, 4+12, 2));
	$year = $v[1];
	$v = unpack('C*', substr($memData, 4 + 12 + 2 , 5));
	$dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
   }
}


