<?php
use helpers\RealtimeHelper;

function Get_hisenses_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '温度设定点':
            return array(0,  $dataArray['温度设定点']);
        case '回风温度':
            return array(0, $dataArray['回风温度']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Is_hisenses_NeedExtraPara(){
    return true;
}
function Get_hisenses_RtData($memData , &$dataArray , $extraPara = false)
{
    if($memData == false){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $v = unpack('f*', substr($memData, 4 , 4 * 15));
        $dataArray['A相电压'] = number_format($v[1], 2) . 'V';
        $dataArray['B相电压'] = number_format($v[2], 2) . 'V';
        $dataArray['C相电压'] = number_format($v[3], 2) . 'V';
        $dataArray['A相电流'] = number_format($v[4], 2) . 'A';
        $dataArray['B相电流'] = number_format($v[5], 2) . 'A';
        $dataArray['C相电流'] = number_format($v[6], 2) . 'A';
        $dataArray['送风温度'] = number_format($v[7], 2) . '℃';
        $dataArray['回风温度'] = number_format($v[8], 2) . '℃';
        $dataArray['送风湿度'] = number_format($v[9], 2) . 'HR';
        $dataArray['回风湿度'] = number_format($v[10], 2) . 'HR';
        $dataArray['压缩机吸气压力'] = number_format($v[11], 2);
        $dataArray['压缩机排气压力'] = number_format($v[12], 2);
        $dataArray['室外环境温度'] = number_format($v[13], 2). '℃';
        $dataArray['室外排气温度'] = number_format($v[14], 2). '℃';
        $dataArray['室外湿度(1)'] = number_format($v[15], 2). 'HR';

        $v = unpack("s*" , substr($memData , 4 + 4 * 15, 13 * 2));
        $dataArray['室内盘管入口'] = $v[1];
        $dataArray['室内盘管中部'] = $v[2];
        $dataArray['室内盘管出口'] = $v[3];
        $dataArray['室外盘管入口'] = $v[4];
        $dataArray['室外盘管中部'] = $v[5];
        $dataArray['室外盘管出口'] = $v[6];
        $dataArray['室内风扇转速'] = $v[7];
        $dataArray['室外风扇转速'] = $v[8];
        $dataArray['压缩机运转频率'] = $v[9];
        $dataArray['膨胀阀开度'] = $v[10];
        $dataArray['其它介质温度'] = $v[11];
        $dataArray['加湿电流数据'] = $v[12];
        $dataArray['泵电流数据'] = $v[13];

        $v = unpack("C*" , substr($memData , 4 + 4 * 15 + 13 * 2, 17));
        $dataArray['空调机工作状态'] = $v[1] == 0 ? '开机' : '关机';;
        //$dataArray['自定义数据量'] = $v[2];
        switch($v[3]){
            case 0:
                $dataArray['内风扇转速'] = '停';
                break;
            case 1:
                $dataArray['内风扇转速'] = '小';
                break;
            case 2:
                $dataArray['内风扇转速'] = '中';
                break;
            case 3:
                $dataArray['内风扇转速'] = '大';
                break;
            default:
                $dataArray['内风扇转速'] = '无效';
        }
        switch($v[4]){
            case 0:
                $dataArray['外风扇转速'] = '停';
                break;
            case 1:
                $dataArray['外风扇转速'] = '小';
                break;
            case 2:
                $dataArray['外风扇转速'] = '中';
                break;
            case 3:
                $dataArray['外风扇转速'] = '大';
                break;
            default:
                $dataArray['外风扇转速'] = '无效';
        }
        $dataArray['压缩机状态'] = $v[5] == 1 ? '运行' : '停止';
        $dataArray['四通阀状态'] = $v[6] == 1 ? '运行' : '停止';
        $dataArray['电加热状态'] = $v[7] == 1 ? '运行' : '停止';
        $dataArray['电加热带状态'] = $v[8] == 1 ? '运行' : '停止';
        $dataArray['水泵'] = $v[9] == 1 ? '运行' : '停止';
        $dataArray['风阀执行器状态'] = $v[10] == 1 ? '运行' : '停止';
        //$dataArray['状态信息1'] = $v[11];
        //$dataArray['状态信息2'] = $v[12];
        $dataArray['三通阀'] = $v[13] == 1 ? '运行' : '停止';
        $dataArray['加湿器'] = $v[14] == 1 ? '运行' : '停止';
        $dataArray['氟泵'] = $v[15] == 1 ? '运行' : '停止';
        $dataArray['并联阀'] = $v[16] == 1 ? '运行' : '停止';
        $dataArray['电子膨胀阀用阀'] = $v[17] == 1 ? '运行' : '停止';

        $v = unpack("C*" , substr($memData , 4 + 4 * 15 + 13 * 2 + 17, 31));
        $dataArray['A相电压过低'] = $v[1] == 1 ? '告警' : '正常';
        $dataArray['A相电压过高'] = $v[1] == 2 ? '告警' : '正常';
        $dataArray['A相输入电源故障'] = $v[1] == 0xF0 ? '告警' : '正常';
	$dataArray['B相电压过低'] = $v[2] == 1 ? '告警' : '正常';
        $dataArray['B相电压过高'] = $v[2] == 2 ? '告警' : '正常';
        $dataArray['B相输入电源故障'] = $v[2] == 0xF0 ? '告警' : '正常';
	$dataArray['C相电压过低'] = $v[3] == 1 ? '告警' : '正常';
        $dataArray['C相电压过高'] = $v[3] == 2 ? '告警' : '正常';
        $dataArray['C相输入电源故障'] = $v[3] == 0xF0 ? '告警' : '正常';

        $dataArray['A相电流告警'] = $v[4] == 0 ? '正常' : '告警';
        $dataArray['B相电流告警'] = $v[5] == 0 ? '正常' : '告警';
        $dataArray['C相电流告警'] = $v[6] == 0 ? '正常' : '告警';
        $dataArray['回风温度告警'] = $v[7] == 0 ? '正常' : '告警';
        $dataArray['回风湿度告警'] = $v[8] == 0 ? '正常' : '告警';
        $dataArray['过滤器 堵塞'] = $v[9] == 0 ? "正常" : "告警";
        $dataArray['压缩机'] = $v[10] == 0 ? "正常" : "告警";
        $dataArray['风机'] = $v[11] == 0 ? "正常" : "告警";
        $dataArray['系统高压保护'] = $v[12] == 0 ? "正常" : "故障";
        $dataArray['系统低压保护'] = $v[13] == 0 ? "正常" : "故障";
        $dataArray['排气保护'] = $v[14] == 0 ? "正常" : "故障";
        $dataArray['内外通信故障'] = $v[15] == 0 ? "正常" : "故障";
        $dataArray['内盘入口'] = $v[16] == 0 ? "正常" : "故障";
        $dataArray['内盘中部'] = $v[17] == 0 ? "正常" : "故障";
        $dataArray['内盘出口'] = $v[18] == 0 ? "正常" : "故障";
        $dataArray['外环'] = $v[19] == 0 ? "正常" : "故障";
        $dataArray['外盘入口'] = $v[20] == 0 ? "正常" : "故障";
        $dataArray['外盘中部'] = $v[21] == 0 ? "正常" : "故障";
        $dataArray['外盘出口'] = $v[22] == 0 ? "正常" : "故障";
        $dataArray['相序错误'] = $v[23] == 0 ? "正常" : "故障";
        $dataArray['缺相错误'] = $v[24] == 0 ? "正常" : "故障";
        $dataArray['外风机'] = $v[25] == 0 ? "正常" : "告警";
        $dataArray['EEPROM'] = $v[26] == 0 ? "正常" : "故障";
        $dataArray['外部告警'] = $v[27] == 0 ? "正常" : "告警";
        $dataArray['室外湿度(2)'] = $v[28] == 0 ? "正常" : "告警";
        $dataArray['水位报警'] = $v[29] == 0 ? "正常" : "告警";
        $dataArray['加湿器报警'] = $v[30] == 0 ? "正常" : "告警";
        $dataArray['系统保护'] = $v[31] == 0 ? "正常" : "告警";

        $dataArray['AlertArray']['A相电压过低报警'] = $v[1] == 1;
        $dataArray['AlertArray']['A相电压过高报警'] = $v[1] == 2;
        $dataArray['AlertArray']['A相输入电源故障告警'] = $v[1] == 0xF0;
        $dataArray['AlertArray']['B相电压过低报警'] = $v[2] == 1;
        $dataArray['AlertArray']['B相电压过高报警'] = $v[2] == 2;
        $dataArray['AlertArray']['B相输入电源故障告警'] = $v[2] == 0xF0;
        $dataArray['AlertArray']['C相电压过低报警'] = $v[3] == 1;
        $dataArray['AlertArray']['C相电压过高报警'] = $v[3] == 2;
        $dataArray['AlertArray']['C相输入电源故障告警'] = $v[3] == 0xF0;

        $dataArray['AlertArray']['A相电流告警'] = $v[4] == 1;
        $dataArray['AlertArray']['B相电流告警'] = $v[5] == 1;
        $dataArray['AlertArray']['C相电流告警'] = $v[6] == 1 ;
        $dataArray['AlertArray']['回风温度告警'] = $v[7] == 1;
        $dataArray['AlertArray']['回风湿度告警'] = $v[8] == 1;
        $dataArray['AlertArray']['过滤器 堵塞'] = $v[9] == 1;
        $dataArray['AlertArray']['压缩机'] = $v[10] == 1;
        $dataArray['AlertArray']['风机'] = $v[11] == 1;
        $dataArray['AlertArray']['系统高压保护'] = $v[12] == 1;
        $dataArray['AlertArray']['系统低压保护'] = $v[13] == 1;
        $dataArray['AlertArray']['排气保护'] = $v[14] == 1;
        $dataArray['AlertArray']['内外通信故障'] = $v[15] == 1;
        $dataArray['AlertArray']['内盘入口'] = $v[16] == 1;
        $dataArray['AlertArray']['内盘中部'] = $v[17] == 1;
        $dataArray['AlertArray']['内盘出口'] = $v[18] == 1;
        $dataArray['AlertArray']['外环'] = $v[19] == 1;
        $dataArray['AlertArray']['外盘入口'] = $v[20] == 1;
        $dataArray['AlertArray']['外盘中部'] = $v[21] == 1;
        $dataArray['AlertArray']['外盘出口'] = $v[22] == 1;
        $dataArray['AlertArray']['相序错误'] = $v[23] == 1;
        $dataArray['AlertArray']['缺相错误'] = $v[24] == 1;
        $dataArray['AlertArray']['外风机'] = $v[25] == 1;
        $dataArray['AlertArray']['EEPROM'] = $v[26] == 1;
        $dataArray['AlertArray']['外部告警'] = $v[27] == 1;
        $dataArray['AlertArray']['室外湿度(2)'] = $v[28] == 1;
        $dataArray['AlertArray']['水位报警'] = $v[29] == 1;
        $dataArray['AlertArray']['加湿器报警'] = $v[30] == 1;
        $dataArray['AlertArray']['系统保护'] = $v[31] == 1;
	if($extraPara && isset($extraPara->ref_data_id)){
	$refDataArray = RealtimeHelper::Get_Device_DataArray($extraPara->ref_data_id, "unicom_nhbaccontroller");
	if ($refDataArray && !$refDataArray["无数据"]) {
	    $dataArray["进风温度2"] = $refDataArray["送风温度"];
	    $dataArray["回风温度2"] = $refDataArray["回风温度/室内环境温度"];
    	}
	}
	$v = unpack('f', substr($memData, 4 + 4 * 15 + 13 * 2 + 17 + 31, 4));
	$dataArray["温度设定值"] = $v[1];
        $v = unpack('v', substr($memData, 4 + 4 * 15 + 13 * 2 + 17 + 31 + 4 , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 4 * 15 + 13 * 2 + 17 + 31 + 4 + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

?>
