<?php

function Get_hiwave_ac_RtData($memData,&$dataArray,$extraPara = false) {
	if (empty($memData)) {
		$dataArray['无数据'] = true;
		$dataArray['更新时间'] = '无';
		$dataArray['错误'] = '数据长度不一致';
	} else {
		$dataArray['无数据'] = false;

		$v = unpack('C*', substr($memData,4,3 * 1));

		$dataArray["开关机"] = $v[1] == 1 ? "开机" : "关机";
		$dataArray["远程开关"] = $v[2] == 1 ? "开启" : "停止";
		$dataArray["机械节能制冷"] = $v[3] == 1 ? "节能制冷" : "机械制冷";

		$v = unpack('C*', substr($memData,4 + 3 * 1,79 * 1 ));
		$dataArray["电源故障"] = $v[1] == 1 ? "故障" : "正常";
		$dataArray["相序错误"] = $v[2] == 1 ? "故障" : "正常";
		$dataArray["缺相错误"] = $v[3] == 1 ? "故障" : "正常";
		$dataArray["电加热保护"] = $v[4] == 1 ? "故障" : "正常";
		$dataArray["加湿器报警"] = $v[5] == 1 ? "故障" : "正常";
		$dataArray["烟雾报警"] = $v[6] == 1 ? "故障" : "正常";
		$dataArray["水浸报警"] = $v[7] == 1 ? "故障" : "正常";
		$dataArray["湿膜低水位报警"] = $v[8] == 1 ? "故障" : "正常";
		$dataArray["湿膜水位开关故障"] = $v[9] == 1 ? "故障" : "正常";
		$dataArray["EEPROM故障"] = $v[10] == 1 ? "故障" : "正常";
		$dataArray["本地联网通讯故障"] = $v[13] == 1 ? "故障" : "正常";
		$dataArray["扩展板通讯故障"] = $v[14] == 1 ? "故障" : "正常";
		$dataArray["远程内温探头故障"] = $v[15] == 1 ? "故障" : "正常";
		$dataArray["滤网堵塞报警"] = $v[16] == 1 ? "故障" : "正常";
		$dataArray["风机1转速反馈故障"] = $v[17] == 1 ? "故障" : "正常";
		$dataArray["风机2转速反馈故障"] = $v[18] == 1 ? "故障" : "正常";
		$dataArray["风机3转速反馈故障"] = $v[19] == 1 ? "故障" : "正常";
		$dataArray["风机4转速反馈故障"] = $v[20] == 1 ? "故障" : "正常";
		$dataArray["风机5转速反馈故障"] = $v[21] == 1 ? "故障" : "正常";
		$dataArray["风机6转速反馈故障"] = $v[22] == 1 ? "故障" : "正常";
		$dataArray["风机7转速反馈故障"] = $v[23] == 1 ? "故障" : "正常";
		$dataArray["风机8转速反馈故障"] = $v[24] == 1 ? "故障" : "正常";
		$dataArray["风机过载故障"] = $v[25] == 1 ? "故障" : "正常";
		$dataArray["气流丢失故障"] = $v[26] == 1 ? "故障" : "正常";
		$dataArray["高温报警"] = $v[27] == 1 ? "故障" : "正常";
		$dataArray["低温报警"] = $v[28] == 1 ? "故障" : "正常";
		$dataArray["高湿报警"] = $v[29] == 1 ? "故障" : "正常";
		$dataArray["低湿报警"] = $v[30] == 1 ? "故障" : "正常";
		$dataArray["送风高温报警"] = $v[31] == 1 ? "故障" : "正常";
		$dataArray["送风低温报警"] = $v[32] == 1 ? "故障" : "正常";
		$dataArray["回风温度探头1故障"] = $v[33] == 1 ? "故障" : "正常";
		$dataArray["回风温度探头2故障"] = $v[34] == 1 ? "故障" : "正常";
		$dataArray["回风温度探头3故障"] = $v[35] == 1 ? "故障" : "正常";
		$dataArray["回风湿度探头故障"] = $v[36] == 1 ? "故障" : "正常";
		$dataArray["送风温度1探头故障"] = $v[37] == 1 ? "故障" : "正常";
		$dataArray["送风温度2探头故障"] = $v[38] == 1 ? "故障" : "正常";
		$dataArray["送风温度3探头故障"] = $v[39] == 1 ? "故障" : "正常";
		$dataArray["送风湿度探头故障"] = $v[40] == 1 ? "故障" : "正常";
		$dataArray["风机电流探头故障"] = $v[45] == 1 ? "故障" : "正常";
		$dataArray["电量检测故障"] = $v[46] == 1 ? "故障" : "正常";
		$dataArray["风机欠流"] = $v[47] == 1 ? "故障" : "正常";
		$dataArray["外风机脏堵"] = $v[48] == 1 ? "故障" : "正常";
		$dataArray["系统1高压保护"] = $v[49] == 1 ? "故障" : "正常";
		$dataArray["系统1低压保护"] = $v[50] == 1 ? "故障" : "正常";
		$dataArray["高压开关1故障"] = $v[51] == 1 ? "故障" : "正常";
		$dataArray["低压开关1故障"] = $v[52] == 1 ? "故障" : "正常";
		$dataArray["吸气温度1探头故障"] = $v[53] == 1 ? "故障" : "正常";
		$dataArray["排气温度1探头故障"] = $v[54] == 1 ? "故障" : "正常";
		$dataArray["系统1蒸发温度过低"] = $v[55] == 1 ? "故障" : "正常";
		$dataArray["系统1排气高温"] = $v[56] == 1 ? "故障" : "正常";
		$dataArray["系统1吸气压力传感器故障"] = $v[59] == 1 ? "故障" : "正常";
		$dataArray["系统2高压保护"] = $v[65] == 1 ? "故障" : "正常";
		$dataArray["系统2低压保护"] = $v[66] == 1 ? "故障" : "正常";
		$dataArray["高压开关2故障"] = $v[67] == 1 ? "故障" : "正常";
		$dataArray["低压开关2故障"] = $v[68] == 1 ? "故障" : "正常";
		$dataArray["吸气温度2探头故障"] = $v[69] == 1 ? "故障" : "正常";
		$dataArray["排气温度2探头故障"] = $v[70] == 1 ? "故障" : "正常";
		$dataArray["系统2蒸发温度过低"] = $v[71] == 1 ? "故障" : "正常";
		$dataArray["系统2排气高温"] = $v[72] == 1 ? "故障" : "正常";
		$dataArray["系统2吸气压力传感器故障"] = $v[75] == 1 ? "故障" : "正常";
		$dataArray["液管温度2探头故障"] = $v[76] == 1 ? "故障" : "正常";
		$dataArray["系统2吸气高温"] = $v[77] == 1 ? "故障" : "正常";
		
		$v = unpack('S*', substr($memData,4 + 3 * 1+79 * 1,12 * 2 ));

		$val = 0;
		for($i = 0; $i<= 9;$i++) {
			if (($v[1] >> $i) & 0x1 == 1){
				$val = $i+1;
				break;
			}
		}
		switch ($val) {
			case 0:
				$run_mode = "停机";
				break;
			case 1:
				$run_mode = "制冷";
				break;
			case 2:
				$run_mode = "制热";
				break;
			case 3:
				$run_mode = "加湿";
				break;
			case 4:
				$run_mode = "除湿";
				break;
			case 5:
				$run_mode = "待机";
				break;
			case 6:
				$run_mode = "故障停机";
				break;
			case 7:
				$run_mode = "手动关机";
				break;
			case 8:
				$run_mode = "主备";
				break;
			case 9:
				$run_mode = "断网";
				break;
			case 10:
				$run_mode = "干接点关机";
				break;
			default:
				$run_mode = "未知";
				break;
		}

		$dataArray["系统运行模式"] = $run_mode;

		$dataArray["烟雾报警"] = $v[2] == 1 ? "报警" : "正常";
		$dataArray["送风温度（℃）"] = number_format($v[3] / 10,2);
		$dataArray["室内温度（℃）"] = number_format($v[4] / 10,2);
		$dataArray["回风温度（℃）"] = number_format($v[5] / 10,2);
		$dataArray["回风湿度（％）"] = number_format($v[6] / 10,2);
		$dataArray["机组累计运行时间（小时）"] = number_format($v[7] / 10,2);
		$dataArray["电源电压（V）"] = number_format($v[8],2);
		$dataArray["送风湿度（％）"] = number_format($v[9] / 10,2);
		$dataArray["计算温度（℃）"] = number_format($v[10] / 10,2);
		$dataArray["计算湿度（％）"] = number_format($v[11] / 10,2);
		$dataArray["内风机风速"] = $v[12] > 0 ? "开启":"停止";


		$v = unpack('S*', substr($memData,4 + 3 * 1+79 * 1 + 12 * 2,9 * 1 ));

		$dataArray["室外机1状态"] = $v[1] == 1 ? "开启" : "关闭";
		$dataArray["室外机1外风机变频驱动通讯故障"] = $v[2] == 1 ? "故障" : "正常";
		$dataArray["室外机1室外温度传感器故障"] = $v[3] == 1 ? "故障" : "正常";
		$dataArray["室外机1压力传感器故障"] = $v[4] == 1 ? "故障" : "正常";
		$dataArray["室外机1系统高压保护"] = $v[5] == 1 ? "故障" : "正常";
		$dataArray["室外机1系统低压保护"] = $v[6] == 1 ? "故障" : "正常";
		$dataArray["室外机1外风机变频驱动故障"] = $v[1] == 1 ? "故障" : "正常";
		$dataArray["室外机1风机过热保护"] = $v[7] == 1 ? "故障" : "正常";
		$dataArray["室外机1与室内机通讯故障"] = $v[8] == 1 ? "故障" : "正常";

		$v = unpack('S*', substr($memData,4 + 3 * 1+79 * 1 + 12 * 2 + 9 * 1+5 * 2 ));

		$dataArray["室外机1出水水温（℃）"] = number_format($v[1],2);
		$dataArray["室外机1外风机转速（Hz）"] = number_format($v[2],2);
		$dataArray["室外机1风冷风串水：室外温度（℃）"] = number_format($v[3] / 10,2);
		$dataArray["室外机1水冷风串水：回水水温（℃）"] = number_format($v[4] / 10,2);
		$dataArray["室外机1比例水阀开度（％）"] = number_format($v[5],2);

		$v = unpack('S*', substr($memData,4 + 3 * 1+79 * 1 + 12 * 2 + 9 * 1+5 * 2 ,11 * 1));

		$dataArray["氟泵1"] = $v[1] == 1 ? "开启" : "关闭";
		$dataArray["泵柜1高扬程锁定告警"] = $v[1] == 1 ? "故障" : "正常";
		$dataArray["泵柜1低扬程锁定告警"] = $v[1] == 1 ? "故障" : "正常";
		$dataArray["泵柜1进口压力传感器故障"] = $v[1] == 1 ? "故障" : "正常";
		$dataArray["泵柜1出口压力传感器故障"] = $v[1] == 1 ? "故障" : "正常";
		$dataArray["泵柜1相序错误"] = $v[1] == 1 ? "故障" : "正常";
		$dataArray["泵柜1环温传感器故障报警"] = $v[1] == 1 ? "故障" : "正常";
		$dataArray["泵柜1驱动故障报警"] = $v[1] == 1 ? "故障" : "正常";
		$dataArray["泵柜1驱动通讯故障"] = $v[1] == 1 ? "故障" : "正常";
		$dataArray["泵柜1过温锁定告警"] = $v[1] == 1 ? "故障" : "正常";
		$dataArray["泵柜1与室内机通讯故障"] = $v[1] == 1 ? "故障" : "正常";

		$v = unpack('S*', substr($memData,4 + 3 * 1+79 * 1 + 12 * 2 + 9 * 1+5 * 2 + 11 * 1,9*1));
		$dataArray["室外机2状态"] = $v[1] == 1 ? "开启" : "关闭";
		$dataArray["室外机2外风机变频驱动通讯故障"] = $v[2] == 1 ? "故障" : "正常";
		$dataArray["室外机2室外温度传感器故障"] = $v[3] == 1 ? "故障" : "正常";
		$dataArray["室外机2压力传感器故障"] = $v[4] == 1 ? "故障" : "正常";
		$dataArray["室外机2系统高压保护"] = $v[5] == 1 ? "故障" : "正常";
		$dataArray["室外机2系统低压保护"] = $v[6] == 1 ? "故障" : "正常";
		$dataArray["室外机2外风机变频驱动故障"] = $v[1] == 1 ? "故障" : "正常";
		$dataArray["室外机2风机过热保护"] = $v[7] == 1 ? "故障" : "正常";
		$dataArray["室外机2与室内机通讯故障"] = $v[8] == 1 ? "故障" : "正常";

		$v = unpack('S*', substr($memData,4 + 3 * 1+79 * 1 + 12 * 2 + 9 * 1+5 * 2 + 11 * 1 + 9*1,5*2));
		$dataArray["室外机2出水水温（℃）"] = number_format($v[1],2);
		$dataArray["室外机2外风机转速（Hz）"] = number_format($v[2],2);
		$dataArray["室外机2风冷风串水：室外温度（℃）"] = number_format($v[3] / 10,2);
		$dataArray["室外机2水冷风串水：回水水温（℃）"] = number_format($v[4] / 10,2);
		$dataArray["室外机2比例水阀开度（％）"] = number_format($v[5],2);

		$v = unpack('S*', substr($memData,4 + 3 * 1+79 * 1 + 12 * 2 + 9 * 1+5 * 2 + 11 * 1 + 9*1+5*2,11*1));
		$dataArray["氟泵2"] = $v[1] == 1 ? "开启" : "关闭";
		$dataArray["泵柜2高扬程锁定告警"] = $v[1] == 1 ? "故障" : "正常";
		$dataArray["泵柜2低扬程锁定告警"] = $v[1] == 1 ? "故障" : "正常";
		$dataArray["泵柜2进口压力传感器故障"] = $v[1] == 1 ? "故障" : "正常";
		$dataArray["泵柜2出口压力传感器故障"] = $v[1] == 1 ? "故障" : "正常";
		$dataArray["泵柜2相序错误"] = $v[1] == 1 ? "故障" : "正常";
		$dataArray["泵柜2环温传感器故障报警"] = $v[1] == 1 ? "故障" : "正常";
		$dataArray["泵柜2驱动故障报警"] = $v[1] == 1 ? "故障" : "正常";
		$dataArray["泵柜2驱动通讯故障"] = $v[1] == 1 ? "故障" : "正常";
		$dataArray["泵柜2过温锁定告警"] = $v[1] == 1 ? "故障" : "正常";
		$dataArray["泵柜2与室内机通讯故障"] = $v[1] == 1 ? "故障" : "正常";

		$v = unpack('S*', substr($memData,4 + 3 * 1+79 * 1 + 12 * 2 + 9 * 1+5 * 2 + 11 * 1 + 9*1+5*2+11*1,9*2));


		$dataArray["回风温度设定值（℃）"] = number_format($v[1] / 10,2);
		$dataArray["出风温度设定值（℃）"] = number_format($v[2] / 10,2);
		$dataArray["远程温度设定值（℃）"] = number_format($v[3] / 10,2);
		$dataArray["设定湿度（％）"] = number_format($v[4] / 10,2);
		$dataArray["高温报警（℃）"] = number_format($v[5] / 10,2);
		$dataArray["低温报警（℃）"] = number_format($v[6] / 10,2);
		$dataArray["高湿报警（％）"] = number_format($v[7] / 10,2);
		$dataArray["低湿报警（％）"] = number_format($v[8] / 10,2);
		$dataArray["启动延迟（秒）"] =  number_format($v[9] / 10,2);

		$v = unpack('L*', substr($memData,4 + 3 * 1+79 * 1 + 12 * 2 + 9 * 1+5 * 2 + 11 * 1 + 9*1+5*2+11*1+9*2,4*2));
		$dataArray["电量统计数值（Kwh）"] = number_format($v[1] / 10,2);
		$dataArray["当日电量（Kwh）"] = number_format($v[2] / 10,2);
		

		$v = unpack('v', substr($memData, 4 + 3 * 1+79 * 1 + 12 * 2 + 9 * 1+5 * 2 + 11 * 1 + 9*1+5*2+11*1+9*2 + 4*2, 2));
        $year = $v[1];
		$v = unpack('C*', substr($memData, 4 + 3 * 1+79 * 1 + 12 * 2 + 9 * 1+5 * 2 + 11 * 1 + 9*1+5*2+11*1+9*2 + 4*2+ 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));








	}
}





?>
