<?php
function Get_hongyindz_Standard_Variable($dataArray, $varname)
{
    switch ($varname) {
        case "[总电能]":
            return array(0, $dataArray['正向有功总电能2']);
    }
    return array(1, '设备无此信号数据:' . $varname);
}

function Get_hongyindz_Size()
{
    return 189;
}


function Get_hongyindz_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $v = unpack("f*", substr($memData, 4, 4*31));
        $dataArray['A相电压'] = number_format($v[1], 2)."V";
        $dataArray['B相电压'] = number_format($v[2], 2)."V";
        $dataArray['C相电压'] = number_format($v[3], 2)."V";

        $dataArray['AB线电压'] = number_format($v[4], 2)."V";
        $dataArray['CA线电压'] = number_format($v[5], 2)."V";
        $dataArray['BC线电压'] = number_format($v[6], 2)."V";

        $dataArray['A相电流'] = number_format($v[7], 2)."A";
        $dataArray['B相电流'] = number_format($v[8], 2)."A";
        $dataArray['C相电流'] = number_format($v[9], 2)."A";
        $dataArray['三相电流矢量和'] = number_format($v[10], 2)."A";

        $dataArray['A相有功功率'] = ($v[11]/1000)."KW";
        $dataArray['B相有功功率'] = ($v[12]/1000)."KW";
        $dataArray['C相有功功率'] = ($v[13]/1000)."KW";
        $dataArray['总有功功率'] = ($v[14]/1000)."KW";
    
        $dataArray['A相无功功率'] = ($v[15]/1000)."KVar";
        $dataArray['B相无功功率'] = ($v[16]/1000)."KVar";
        $dataArray['C相无功功率'] = ($v[17]/1000)."KVar";
        $dataArray['总无功功率'] = ($v[18]/1000)."KVar";

        $dataArray['A相视在功率'] = ($v[19]/1000)."KVA";
        $dataArray['B相视在功率'] = ($v[20]/1000)."KVA";
        $dataArray['C相视在功率'] = ($v[21]/1000)."KVA";
        $dataArray['总视在功率'] = ($v[22]/1000)."KVA";

        $dataArray['A相功率因数'] = number_format($v[23], 3);
        $dataArray['B相功率因数'] = number_format($v[24], 3);
        $dataArray['C相功率因数'] = number_format($v[25], 3);
        $dataArray['总功率因数'] = number_format($v[26], 3);

        $dataArray['频率'] = number_format($v[27], 2)."Hz";

        $dataArray['正有功电能'] = number_format($v[28], 3)."KWh";
        $dataArray['负有功电能'] = number_format($v[29], 3)."KWh";
        $dataArray['感性无功电能'] = number_format($v[30], 3)."KVarh";
        $dataArray['容性无功电能'] = number_format($v[31], 3)."KVars";


        $offset = 4 + 4*31;
        $v = unpack('v', substr($memData, $offset, 2));
        $offset += 2;
        $year = $v[1];
        $v = unpack('C*', substr($memData, $offset, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
