<?php
function Get_hvdy_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
        case '[B相电压]':
        case '[C相电压]':
            $dataArr = explode(' ' , $dataArray['Ⅰ路电压']);
            return array(0, $dataArr[0]);
        case '[总功率]':
            return array(0, $dataArray['Ⅰ路有功功率2'] + $dataArray['Ⅱ路有功功率2']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_hvdy_Active_Power($dataArray){
    $active_power = $dataArray['Ⅰ路有功电能2'] + $dataArray['Ⅱ路有功电能2'];
    return array(0 , $active_power);
}

function Get_hvdy_RtData($memData, &$dataArray, $extraPara = false){
        if(empty($memData)){
            $dataArray['无数据'] = true;
            $dataArray['更新时间'] = '无';
            $dataArray['错误'] = '数据长度不一致';
        }else{
            //HVDY_30_t   一路
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            $v = unpack('S*',substr($memData, 4 , 2*2));
            $dataArray['Ⅰ路电压'] = ($v[1] / 10).' V';
            $dataArray['Ⅰ路电流'] = ($v[2] / 10).' A';
            $v = unpack('I*',substr($memData, 4 + 2*2 , 4*2));
            $dataArray['Ⅰ路有功功率'] = number_format($v[1] / 10000 , 2).' kW';
            $dataArray['Ⅰ路有功功率2'] = number_format($v[1] / 10000 , 3,'.','');
            $dataArray['Ⅰ路有功电能'] = ($v[2] / 100).' KWh';
            $dataArray['Ⅰ路有功电能2'] = $v[2] / 100;
            $v = unpack('C*',substr($memData, 4 + 2*2 + 4*2 , 1*8));
            $dataArray['Ⅰ路电压超限告警'] = $v[1] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['Ⅰ路电压超限告警'] = $v[1] == 1;
            $dataArray['Ⅰ路电压低限告警'] = $v[2] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['Ⅰ路电压低限告警'] = $v[2] == 1;
            $dataArray['Ⅰ路电流超限告警'] = $v[3] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['Ⅰ路电流超限告警'] = $v[3] == 1;
            $dataArray['Ⅰ路功率超限告警'] = $v[4] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['Ⅰ路功率超限告警'] = $v[4] == 1;
            $dataArray['Ⅰ路进线开关状态'] = $v[5] == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路防雷故障状态'] = $v[6] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['Ⅰ路防雷故障状态'] = $v[6] == 1;
            //reserve 2
            //HVDY_31_t
            $v = unpack('S*',substr($memData, 4 + 2*2 + 4*2 + 1*8, 2*2));
            $dataArray['Ⅰ路电流需量'] = ($v[1] / 10).' A';
            $dataArray['Ⅰ路最大电流需量'] = ($v[2] / 10).' A';
            $v = unpack('I*',substr($memData, 4 + 2*4 + 4*2 + 1*8, 4*2));
            $dataArray['Ⅰ路功率需量'] = number_format($v[1] / 1000 , 2).' KW';
            $dataArray['Ⅰ路最大功率需量'] = number_format($v[2] / 1000 , 2).' KW';
            $v = unpack('C*',substr($memData, 4 + 2*4 + 4*4 + 1*8, 1*8));
            $dataArray['Ⅰ路开关1状态'] = $v[1] & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关2状态'] = ($v[1] >> 1) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关3状态'] = ($v[1] >> 2) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关4状态'] = ($v[1] >> 3) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关5状态'] = ($v[1] >> 4) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关6状态'] = ($v[1] >> 5) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关7状态'] = ($v[1] >> 6) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关8状态'] = ($v[1] >> 7) & 0x1 == 1 ? '合闸' : '分闸';
            
            $dataArray['Ⅰ路开关9状态'] = $v[2] & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关10状态'] = ($v[2] >> 1) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关11状态'] = ($v[2] >> 2) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关12状态'] = ($v[2] >> 3) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关13状态'] = ($v[2] >> 4) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关14状态'] = ($v[2] >> 5) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关15状态'] = ($v[2] >> 6) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关16状态'] = ($v[2] >> 7) & 0x1 == 1 ? '合闸' : '分闸';
            
            $dataArray['Ⅰ路开关17状态'] = $v[3] & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关18状态'] = ($v[3] >> 1) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关19状态'] = ($v[3] >> 2) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关20状态'] = ($v[3] >> 3) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关21状态'] = ($v[3] >> 4) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关22状态'] = ($v[3] >> 5) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关23状态'] = ($v[3] >> 6) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关24状态'] = ($v[3] >> 7) & 0x1 == 1 ? '合闸' : '分闸';
            
            $dataArray['Ⅰ路开关25状态'] = $v[4] & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关26状态'] = ($v[4] >> 1) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关27状态'] = ($v[4] >> 2) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关28状态'] = ($v[4] >> 3) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关29状态'] = ($v[4] >> 4) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关30状态'] = ($v[4] >> 5) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关31状态'] = ($v[4] >> 6) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关32状态'] = ($v[4] >> 7) & 0x1 == 1 ? '合闸' : '分闸';
            
            $dataArray['Ⅰ路开关33状态'] = $v[5] & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关34状态'] = ($v[5] >> 1) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关35状态'] = ($v[5] >> 2) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关36状态'] = ($v[5] >> 3) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关37状态'] = ($v[5] >> 4) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关38状态'] = ($v[5] >> 5) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关39状态'] = ($v[5] >> 6) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关40状态'] = ($v[5] >> 7) & 0x1 == 1 ? '合闸' : '分闸';
            
            $dataArray['Ⅰ路开关41状态'] = $v[6] & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关42状态'] = ($v[6] >> 1) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关43状态'] = ($v[6] >> 2) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关44状态'] = ($v[6] >> 3) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关45状态'] = ($v[6] >> 4) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关46状态'] = ($v[6] >> 5) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关47状态'] = ($v[6] >> 6) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅰ路开关48状态'] = ($v[6] >> 7) & 0x1 == 1 ? '合闸' : '分闸';
            //reserve 2
            //HVDY_40_t    二路
            $v = unpack('S*',substr($memData, 4 + 2*4 + 4*4 + 1*16, 2*2));
            $dataArray['Ⅱ路电压'] = ($v[1] / 10).' V';
            $dataArray['Ⅱ路电流'] = ($v[2] / 10).' A';
            $v = unpack('I*',substr($memData, 4 + 2*6 + 4*4 + 1*16, 4*2));
            $dataArray['Ⅱ路有功功率'] = number_format($v[1] / 10000 , 2).' KW';
            $dataArray['Ⅱ路有功功率2'] = number_format($v[1] / 10000 , 3,'.','');
            $dataArray['Ⅱ路有功电能'] = ($v[2] / 100).' KWh';
            $dataArray['Ⅱ路有功电能2'] = $v[2] / 100;
            $v = unpack('C*',substr($memData, 4 + 2*6 + 4*6 + 1*16, 1*8));
            $dataArray['Ⅱ路电压超限告警'] = $v[1] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['Ⅱ路电压超限告警'] = $v[1] == 1;
            $dataArray['Ⅱ路电压低限告警'] = $v[2] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['Ⅱ路电压低限告警'] = $v[2] == 1;
            $dataArray['Ⅱ路电流超限告警'] = $v[3] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['Ⅱ路电流超限告警'] = $v[3] == 1;
            $dataArray['Ⅱ路功率超限告警'] = $v[4] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['Ⅱ路功率超限告警'] = $v[4] == 1;
            $dataArray['Ⅱ路进线开关状态'] = $v[5] == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路防雷故障状态'] = $v[6] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['Ⅱ路防雷故障状态'] = $v[6] == 1;
            //reserve 2
            //HVDY_41_t
            $v = unpack('S*',substr($memData, 4 + 2*6 + 4*6 + 1*24, 2*2));
            $dataArray['Ⅱ路电流需量'] = ($v[1] / 10).' A';
            $dataArray['Ⅱ路最大电流需量'] = ($v[2] / 10).' A';
            $v = unpack('I*',substr($memData, 4 + 2*8 + 4*6 + 1*24, 4*2));
            $dataArray['Ⅱ路功率需量'] = number_format($v[1] / 1000).' KW';
            $dataArray['Ⅱ路最大功率需量'] = number_format($v[2] / 1000).' KW';
            $v = unpack('C*',substr($memData, 4 + 2*8 + 4*8 + 1*24, 1*8));
            $dataArray['Ⅱ路开关1状态'] = $v[1] & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关2状态'] = ($v[1] >> 1) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关3状态'] = ($v[1] >> 2) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关4状态'] = ($v[1] >> 3) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关5状态'] = ($v[1] >> 4) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关6状态'] = ($v[1] >> 5) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关7状态'] = ($v[1] >> 6) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关8状态'] = ($v[1] >> 7) & 0x1 == 1 ? '合闸' : '分闸';
            
            $dataArray['Ⅱ路开关9状态'] = $v[2] & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关10状态'] = ($v[2] >> 1) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关11状态'] = ($v[2] >> 2) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关12状态'] = ($v[2] >> 3) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关13状态'] = ($v[2] >> 4) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关14状态'] = ($v[2] >> 5) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关15状态'] = ($v[2] >> 6) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关16状态'] = ($v[2] >> 7) & 0x1 == 1 ? '合闸' : '分闸';
            
            $dataArray['Ⅱ路开关17状态'] = $v[3] & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关18状态'] = ($v[3] >> 1) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关19状态'] = ($v[3] >> 2) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关20状态'] = ($v[3] >> 3) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关21状态'] = ($v[3] >> 4) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关22状态'] = ($v[3] >> 5) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关23状态'] = ($v[3] >> 6) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关24状态'] = ($v[3] >> 7) & 0x1 == 1 ? '合闸' : '分闸';
            
            $dataArray['Ⅱ路开关25状态'] = $v[4] & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关26状态'] = ($v[4] >> 1) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关27状态'] = ($v[4] >> 2) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关28状态'] = ($v[4] >> 3) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关29状态'] = ($v[4] >> 4) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关30状态'] = ($v[4] >> 5) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关31状态'] = ($v[4] >> 6) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关32状态'] = ($v[4] >> 7) & 0x1 == 1 ? '合闸' : '分闸';
            
            $dataArray['Ⅱ路开关33状态'] = $v[5] & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关34状态'] = ($v[5] >> 1) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关35状态'] = ($v[5] >> 2) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关36状态'] = ($v[5] >> 3) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关37状态'] = ($v[5] >> 4) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关38状态'] = ($v[5] >> 5) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关39状态'] = ($v[5] >> 6) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关40状态'] = ($v[5] >> 7) & 0x1 == 1 ? '合闸' : '分闸';
            
            $dataArray['Ⅱ路开关41状态'] = $v[6] & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关42状态'] = ($v[6] >> 1) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关43状态'] = ($v[6] >> 2) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关44状态'] = ($v[6] >> 3) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关45状态'] = ($v[6] >> 4) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关46状态'] = ($v[6] >> 5) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关47状态'] = ($v[6] >> 6) & 0x1 == 1 ? '合闸' : '分闸';
            $dataArray['Ⅱ路开关48状态'] = ($v[6] >> 7) & 0x1 == 1 ? '合闸' : '分闸';
            //reserve 2
            $v = unpack('v', substr($memData, 4 + 2*8 + 4*8 + 1*32, 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, 4 + 2*8 + 4*8 + 1*32 + 2, 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}
