<?php

function _Get_igntc_EngineState($v)
{
    switch ($v) {
        case 0: return "起始";
        case 1: return "候命中";
        case 2: return "未预备";
        case 3: return "预起动";
        case 4: return "起动中";
        case 5: return "间歇";
        case 6: return "起动中";
        case 7: return "运行中";
        case 8: return "已合闸";
        case 9: return "慢卸载中";
        case 10: return "冷却中";
        case 11: return "停机";
        case 12: return "停机";
        case 13: return "通风中";
        case 14: return "应急手动";
        case 15: return "冷却中";
        case 16: return "分闸运行";
        case 17: return "慢加载中";
        case 18: return "等待停机";
        case 19: return "加热中";
        case 20: return "停机排空";
    }
    return "无效";
}

function _Get_igntc_Breaker($v)
{
    switch($v)
    {
        case 0: return "起始";
        case 1: return "断路全分";
        case 2: return "岛运行";
        case 3: return "市电合闸";
        case 4: return "并网运行";
        case 5: return "反向同步";
        case 6: return "同步中";
        case 7: return "市电故障";
        case 8: return "市障确认";
        case 9: return "市电回复";
        case 10: return "多台岛并";
        case 11: return "多台市并";
        case 12: return "应急手动";
        case 13: return "起动同步";
        default: return "未知状态";
    }
}
function _Get_igntc_ControllerMode($v)
{
    switch ($v) {
        case 0: return "关闭";
        case 1: return "手动";
        case 2: return "自动";
    }
    return "无效";
}

function _Get_Ignitc_AlarmLow(&$dataArray,$v, $label)
{
    $dataArray[$label] = ( ($v & 0x7) == 2 || ($v & 0x7) == 6 ) ? "告警" : "正常";
    $dataArray["AlertArray"][$label] = ( ($v & 0x7) == 2 || ($v & 0x7) == 6 );
    $dataArray[$label."传感器失效"] = ( (($v  >> 6) & 0x3) == 1 || (($v  >> 6) & 0x3) == 3 ) ? "告警" : "正常";
    $dataArray["AlertArray"][$label."传感器失效"] = ( (($v  >> 6) & 0x3) == 1 || (($v  >> 6) & 0x3) == 3 );
}

function _Get_Ignitc_AlarmHigh(&$dataArray,$v, $label)
{
    $dataArray[$label] = ( ( ($v >> 8) & 0x7) == 2 || ( ($v >> 8) & 0x7) == 6 ) ? "告警" : "正常";
    $dataArray["AlertArray"][$label] = ( ( ($v >> 8) & 0x7) == 2 || ( ($v >> 8) & 0x7) == 6 );
    $dataArray[$label."传感器失效"] = ( (($v  >> 14) & 0x3) == 1 || (($v  >> 14) & 0x3) == 3 ) ? "告警" : "正常";
    $dataArray["AlertArray"][$label."传感器失效"] = ( (($v  >> 14) & 0x3) == 1 || (($v  >> 14) & 0x3) == 3 );
}

function Get_igntc_RtData($memData, &$dataArray, $extraPara = false)
{
    //后台多浪费点存储，反正一段时间后就回收了
    if (empty($memData)) {
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    } else {
        $dataArray["无数据"] = false;
        $dataArray["AlertArray"] = array();
        $v = unpack('S*', substr($memData, 4, 2 * 138));
        $dataArray["电池电压(V)"] = number_format($v[1]/10, 1) .' V';
        $dataArray["CPU温度"] = number_format($v[2]/10, 1);
        $dataArray["D+"] = number_format($v[3], 1);
        $dataArray["机油压"] = $v[4] != 0x8000 ? number_format($v[4], 2) : "无效";
        $dataArray["水温"] = $v[5] != 0x8000 ? number_format($v[5], 2) : "无效";
        $dataArray["燃油位"] = $v[6] != 0x8000 ? number_format($v[6], 2) : "无效";
        $dataArray["发动机状态"] = _Get_igntc_EngineState($v[7]);
        $dataArray["断路器状态"] = _Get_igntc_Breaker($v[8]);
        $dataArray["IG模式"] = _Get_igntc_ControllerMode($v[9]);
        $dataArray["发电压1"] = number_format($v[10], 2) .' V';
        $dataArray["发电压2"] = number_format($v[11], 2) .' V';
        $dataArray["发电压3"] = number_format($v[12], 2) .' V';
        $dataArray["发电压"] = number_format($v[13], 2) .' V';

        $dataArray["发电12线压"] = number_format($v[14], 2) .' V';
        $dataArray["发电23线压"] = number_format($v[15], 2) .' V';
        $dataArray["发电31线压"] = number_format($v[16], 2) .' V';
        $dataArray["发电频率"] = number_format($v[17]/10, 2) .' Hz';

        $dataArray["发电流1"] = number_format($v[18], 2) .' A';
        $dataArray["发电流2"] = number_format($v[19], 2) .' A';
        $dataArray["发电流3"] = number_format($v[20], 2) .' A';
        $dataArray["功率因数"] = number_format($v[21], 2);

        $dataArray["有功功率"] = number_format($v[22], 2);
        $dataArray["有功功率L1"] = number_format($v[23], 2);
        $dataArray["有功功率L2"] = number_format($v[24], 2);
        $dataArray["有功功率L3"] = number_format($v[25], 2);

        $dataArray["无功功率"] = number_format($v[26], 2);
        $dataArray["无功功率L1"] = number_format($v[27], 2);
        $dataArray["无功功率L2"] = number_format($v[28], 2);
        $dataArray["无功功率L3"] = number_format($v[29], 2);

        $dataArray["视在功率"] = number_format($v[30], 2);
        $dataArray["视在功率L1"] = number_format($v[31], 2);
        $dataArray["视在功率L2"] = number_format($v[32], 2);
        $dataArray["视在功率L3"] = number_format($v[33], 2);

        $dataArray["功率因数L1"] = number_format($v[34], 2);
        $dataArray["功率因数L2"] = number_format($v[35], 2);
        $dataArray["功率因数L3"] = number_format($v[36], 2);

        $dataArray["发电压不平衡"] = number_format($v[37], 2);
        $dataArray["发电流不平衡"] = number_format($v[38], 2);
        $dataArray["检查接线"] = number_format($v[39], 2);

        $dataArray["母排压1"] = number_format($v[40], 2) .' V';
        $dataArray["母排电压2"] = number_format($v[41], 2) .' V';
        $dataArray["母排电压3"] = number_format($v[42], 2) .' V';
        $dataArray["排电压"] = number_format($v[43], 2) .' V';
        $dataArray["母排12线压"] = number_format($v[44], 2) .' V';
        $dataArray["母排23线压"] = number_format($v[45], 2) .' V';
        $dataArray["母排31线压"] = number_format($v[46], 2) .' V';

        $dataArray["接地故障电流"] = number_format($v[47], 2) .' A';
        $dataArray["母排频率"] = number_format($v[48]/10, 2) .' Hz';
        $dataArray["排电压不平衡"] = number_format($v[49], 2);

        $dataArray["频率差"] = number_format($v[50], 2);
        $dataArray["相角"] = $v[51] != 0x8000 ? number_format($v[51], 2) : "无效";
        $dataArray["RPM"] = number_format($v[52], 2);
        //alarm1告警判断
        _Get_Ignitc_AlarmLow($dataArray, $v[53], "MCB反馈");
        _Get_Ignitc_AlarmHigh($dataArray, $v[53], "GCB反馈");

        _Get_Ignitc_AlarmLow($dataArray, $v[54], "紧急停");
        _Get_Ignitc_AlarmHigh($dataArray, $v[54], "系统起动/停止");

        _Get_Ignitc_AlarmLow($dataArray, $v[55], "遥控关");
        _Get_Ignitc_AlarmHigh($dataArray, $v[55], "模式锁内置");

        _Get_Ignitc_AlarmLow($dataArray, $v[56], "警告8");
        _Get_Ignitc_AlarmHigh($dataArray, $v[56], "警告7");

        _Get_Ignitc_AlarmLow($dataArray, $v[57], "警告10");
        _Get_Ignitc_AlarmHigh($dataArray, $v[57], "警告9");

        _Get_Ignitc_AlarmLow($dataArray, $v[58], "警告12");
        _Get_Ignitc_AlarmHigh($dataArray, $v[58], "警告11");
        //alarm2
        _Get_Ignitc_AlarmLow($dataArray, $v[59], "水温告警");
        _Get_Ignitc_AlarmHigh($dataArray, $v[59], "机油压告警");

        _Get_Ignitc_AlarmHigh($dataArray, $v[60], "燃油位告警");
        //alarm3
        _Get_Ignitc_AlarmLow($dataArray, $v[61], "配置错误");
        _Get_Ignitc_AlarmHigh($dataArray, $v[61], "ECU分析封锁");

        _Get_Ignitc_AlarmLow($dataArray, $v[62], "系统故障");
        _Get_Ignitc_AlarmHigh($dataArray, $v[62], "模块电池缺电");

        _Get_Ignitc_AlarmLow($dataArray, $v[63], "报警/历史信息1");
        _Get_Ignitc_AlarmHigh($dataArray, $v[63], "这是盗版模块");

        _Get_Ignitc_AlarmLow($dataArray, $v[64], "报警/历史信息3");
        _Get_Ignitc_AlarmHigh($dataArray, $v[64], "电池电压");

        _Get_Ignitc_AlarmLow($dataArray, $v[65], "发电流不平衡告警");
        _Get_Ignitc_AlarmHigh($dataArray, $v[65], "发电压不平衡告警");

        _Get_Ignitc_AlarmLow($dataArray, $v[66], "报警/历史信息7");
        _Get_Ignitc_AlarmHigh($dataArray, $v[66], "排电压不平衡告警");

        _Get_Ignitc_AlarmLow($dataArray, $v[67], "报警/历史信息9");
        _Get_Ignitc_AlarmHigh($dataArray, $v[67], "报警/历史信息8");

        _Get_Ignitc_AlarmLow($dataArray, $v[68], "报警/历史信息11");
        _Get_Ignitc_AlarmHigh($dataArray, $v[68], "报警/历史信息10");

        _Get_Ignitc_AlarmLow($dataArray, $v[69], "报警/历史信息13");
        _Get_Ignitc_AlarmHigh($dataArray, $v[69], "报警/历史信息12");

        _Get_Ignitc_AlarmLow($dataArray, $v[70], "报警/历史信息15");
        _Get_Ignitc_AlarmHigh($dataArray, $v[70], "报警/历史信息14");

        _Get_Ignitc_AlarmLow($dataArray, $v[71], "Dongle不对");
        _Get_Ignitc_AlarmHigh($dataArray, $v[71], "报警/历史信息16");

        _Get_Ignitc_AlarmLow($dataArray, $v[72], "RPM告警");
        _Get_Ignitc_AlarmHigh($dataArray, $v[72], "紧急停");

        _Get_Ignitc_AlarmLow($dataArray, $v[73], "充电机故障");
        _Get_Ignitc_AlarmHigh($dataArray, $v[73], "CAN2空");

        _Get_Ignitc_AlarmLow($dataArray, $v[74], "超速");
        _Get_Ignitc_AlarmHigh($dataArray, $v[74], "停机失败停机");

        _Get_Ignitc_AlarmLow($dataArray, $v[75], "速度传感故障");
        _Get_Ignitc_AlarmHigh($dataArray, $v[75], "低速");

        _Get_Ignitc_AlarmLow($dataArray, $v[76], "维修警告1+2");
        _Get_Ignitc_AlarmHigh($dataArray, $v[76], "外电池耗尽停机");

        _Get_Ignitc_AlarmLow($dataArray, $v[77], "没有润滑");
        _Get_Ignitc_AlarmHigh($dataArray, $v[77], "维修警告3+4");

        _Get_Ignitc_AlarmLow($dataArray, $v[78], "开始封锁");
        _Get_Ignitc_AlarmHigh($dataArray, $v[78], "起动失败");

        _Get_Ignitc_AlarmLow($dataArray, $v[79], "缸温2警告");
        _Get_Ignitc_AlarmHigh($dataArray, $v[79], "缸温1警告");

        _Get_Ignitc_AlarmLow($dataArray, $v[80], "缸温4警告");
        _Get_Ignitc_AlarmHigh($dataArray, $v[80], "缸温3警告");

        _Get_Ignitc_AlarmLow($dataArray, $v[81], "缸温6警告");
        _Get_Ignitc_AlarmHigh($dataArray, $v[81], "缸温5警告");

        _Get_Ignitc_AlarmLow($dataArray, $v[82], "缸温8警告");
        _Get_Ignitc_AlarmHigh($dataArray, $v[82], "缸温7警告");

        _Get_Ignitc_AlarmLow($dataArray, $v[83], "缸温10警告");
        _Get_Ignitc_AlarmHigh($dataArray, $v[83], "缸温9警告");

        _Get_Ignitc_AlarmLow($dataArray, $v[84], "缸温12警告");
        _Get_Ignitc_AlarmHigh($dataArray, $v[84], "缸温11警告");

        _Get_Ignitc_AlarmLow($dataArray, $v[85], "缸温14警告");
        _Get_Ignitc_AlarmHigh($dataArray, $v[85], "缸温13警告");

        _Get_Ignitc_AlarmLow($dataArray, $v[86], "缸温16警告");
        _Get_Ignitc_AlarmHigh($dataArray, $v[86], "缸温15警告");

        _Get_Ignitc_AlarmLow($dataArray, $v[87], "缸温18警告");
        _Get_Ignitc_AlarmHigh($dataArray, $v[87], "缸温17警告");

        _Get_Ignitc_AlarmLow($dataArray, $v[88], "缸温20警告");
        _Get_Ignitc_AlarmHigh($dataArray, $v[88], "缸温19警告");

        _Get_Ignitc_AlarmLow($dataArray, $v[89], "缸温22警告");
        _Get_Ignitc_AlarmHigh($dataArray, $v[89], "缸温21警告");

        _Get_Ignitc_AlarmLow($dataArray, $v[90], "缸温24警告");
        _Get_Ignitc_AlarmHigh($dataArray, $v[90], "缸温23警告");

        _Get_Ignitc_AlarmLow($dataArray, $v[91], "缸温26警告");
        _Get_Ignitc_AlarmHigh($dataArray, $v[91], "缸温25警告");

        _Get_Ignitc_AlarmLow($dataArray, $v[92], "缸温28警告");
        _Get_Ignitc_AlarmHigh($dataArray, $v[92], "缸温27警告");

        _Get_Ignitc_AlarmLow($dataArray, $v[93], "缸温30警告");
        _Get_Ignitc_AlarmHigh($dataArray, $v[93], "缸温29警告");

        _Get_Ignitc_AlarmLow($dataArray, $v[94], "缸温32警告");
        _Get_Ignitc_AlarmHigh($dataArray, $v[94], "缸温31警告");

        _Get_Ignitc_AlarmLow($dataArray, $v[95], "GCB故障停机");
        _Get_Ignitc_AlarmHigh($dataArray, $v[95], "MCB故障警告");

        _Get_Ignitc_AlarmLow($dataArray, $v[96], "逆同步故障警告");
        _Get_Ignitc_AlarmHigh($dataArray, $v[96], "油压B低停机");

        _Get_Ignitc_AlarmLow($dataArray, $v[97], "L1低分闸冷却");
        _Get_Ignitc_AlarmHigh($dataArray, $v[97], "同步失败停机");

        _Get_Ignitc_AlarmLow($dataArray, $v[98], "L3低分闸冷却");
        _Get_Ignitc_AlarmHigh($dataArray, $v[98], "L2低分闸冷却");

        _Get_Ignitc_AlarmLow($dataArray, $v[99], "L2高分闸冷却");
        _Get_Ignitc_AlarmHigh($dataArray, $v[99], "L1高分闸冷却");

        _Get_Ignitc_AlarmLow($dataArray, $v[100], "L1电压高停机");
        _Get_Ignitc_AlarmHigh($dataArray, $v[100], "L3高分闸冷却");

        _Get_Ignitc_AlarmLow($dataArray, $v[101], "L3电压高停机");
        _Get_Ignitc_AlarmHigh($dataArray, $v[101], "L2电压高停机");

        _Get_Ignitc_AlarmLow($dataArray, $v[102], "L23低分闸冷");
        _Get_Ignitc_AlarmHigh($dataArray, $v[102], "L12低分闸冷");

        _Get_Ignitc_AlarmLow($dataArray, $v[103], "L12高分闸冷");
        _Get_Ignitc_AlarmHigh($dataArray, $v[103], "L31低分闸冷");

        _Get_Ignitc_AlarmLow($dataArray, $v[104], "L31高分闸冷");
        _Get_Ignitc_AlarmHigh($dataArray, $v[104], "L23高分闸冷");

        _Get_Ignitc_AlarmLow($dataArray, $v[105], "L23高停机");
        _Get_Ignitc_AlarmHigh($dataArray, $v[105], "L12高停机");

        _Get_Ignitc_AlarmLow($dataArray, $v[106], "发电压1告警");
        _Get_Ignitc_AlarmHigh($dataArray, $v[106], "L31高停机");

        _Get_Ignitc_AlarmLow($dataArray, $v[107], "发电压3告警");
        _Get_Ignitc_AlarmHigh($dataArray, $v[107], "发电压2告警");

        _Get_Ignitc_AlarmLow($dataArray, $v[108], "发电23线压告警");
        _Get_Ignitc_AlarmHigh($dataArray, $v[108], "发电12线压告警");

        _Get_Ignitc_AlarmLow($dataArray, $v[109], "发电频率告警");
        _Get_Ignitc_AlarmHigh($dataArray, $v[109], "发电31线压告警");

        //alarm4
        _Get_Ignitc_AlarmLow($dataArray, $v[110], "频率高分闸冷却");
        _Get_Ignitc_AlarmHigh($dataArray, $v[110], "频率低分闸冷却");

        _Get_Ignitc_AlarmLow($dataArray, $v[111], "市电压L1低");
        _Get_Ignitc_AlarmHigh($dataArray, $v[111], "逆功分闸冷却");

        _Get_Ignitc_AlarmLow($dataArray, $v[112], "市电压L3低");
        _Get_Ignitc_AlarmHigh($dataArray, $v[112], "市电压L2低");

        _Get_Ignitc_AlarmLow($dataArray, $v[113], "市电压L2高");
        _Get_Ignitc_AlarmHigh($dataArray, $v[113], "市电压L1高");

        _Get_Ignitc_AlarmLow($dataArray, $v[114], "市电压L12低");
        _Get_Ignitc_AlarmHigh($dataArray, $v[114], "市电压L3高");

        _Get_Ignitc_AlarmLow($dataArray, $v[115], "市电压L31低");
        _Get_Ignitc_AlarmHigh($dataArray, $v[115], "市电压L23低");

        _Get_Ignitc_AlarmLow($dataArray, $v[116], "市电压L23高");
        _Get_Ignitc_AlarmHigh($dataArray, $v[116], "市电压L12高");

        _Get_Ignitc_AlarmLow($dataArray, $v[117], "市频率低");
        _Get_Ignitc_AlarmHigh($dataArray, $v[117], "市电压L31高");

        _Get_Ignitc_AlarmLow($dataArray, $v[118], "平均市压>V");
        _Get_Ignitc_AlarmHigh($dataArray, $v[118], "市频率高");

        _Get_Ignitc_AlarmLow($dataArray, $v[119], "母排电压2告警");
        _Get_Ignitc_AlarmHigh($dataArray, $v[119], "母排电压1告警");

        _Get_Ignitc_AlarmLow($dataArray, $v[120], "母排12线压告警");
        _Get_Ignitc_AlarmHigh($dataArray, $v[120], "母排电压3告警");

        _Get_Ignitc_AlarmLow($dataArray, $v[121], "母排31线压告警");
        _Get_Ignitc_AlarmHigh($dataArray, $v[121], "母排23线压告警");

        _Get_Ignitc_AlarmLow($dataArray, $v[122], "母排测量错误");
        _Get_Ignitc_AlarmHigh($dataArray, $v[122], "母排频率告警");

        _Get_Ignitc_AlarmLow($dataArray, $v[123], "IDMT分闸冷");
        _Get_Ignitc_AlarmHigh($dataArray, $v[123], "操作冲突");

        _Get_Ignitc_AlarmLow($dataArray, $v[124], "过载分闸冷却");
        _Get_Ignitc_AlarmHigh($dataArray, $v[124], "电流短路分闸冷");

        _Get_Ignitc_AlarmLow($dataArray, $v[125], "功率数设错警告");
        _Get_Ignitc_AlarmHigh($dataArray, $v[125], "中CB坏分闸冷");

        _Get_Ignitc_AlarmLow($dataArray, $v[126], "市电恢复");
        _Get_Ignitc_AlarmHigh($dataArray, $v[126], "警号地址错误");

        _Get_Ignitc_AlarmLow($dataArray, $v[127], "调速限制警告");
        _Get_Ignitc_AlarmHigh($dataArray, $v[127], "试负载失败警告");

        _Get_Ignitc_AlarmLow($dataArray, $v[128], "发电相反");
        _Get_Ignitc_AlarmHigh($dataArray, $v[128], "调压限制警告");

        _Get_Ignitc_AlarmLow($dataArray, $v[129], "发电相序错");
        _Get_Ignitc_AlarmHigh($dataArray, $v[129], "发电相反及序错1");

        _Get_Ignitc_AlarmLow($dataArray, $v[130], "市电相反及序错2");
        _Get_Ignitc_AlarmHigh($dataArray, $v[130], "市电相位反");

        _Get_Ignitc_AlarmLow($dataArray, $v[131], "警告燃油被盗");
        _Get_Ignitc_AlarmHigh($dataArray, $v[131], "市电序错");

        _Get_Ignitc_AlarmLow($dataArray, $v[132], "清洗中");
        _Get_Ignitc_AlarmHigh($dataArray, $v[132], "禁止输入密码");

        _Get_Ignitc_AlarmLow($dataArray, $v[133], "接地流高BOC");
        _Get_Ignitc_AlarmHigh($dataArray, $v[133], "BOC失去励磁");

        _Get_Ignitc_AlarmLow($dataArray, $v[134], "NoBankCUdetect");
        _Get_Ignitc_AlarmHigh($dataArray, $v[134], "附件不匹配");

        _Get_Ignitc_AlarmLow($dataArray, $v[135], "SUS顺序封锁");
        _Get_Ignitc_AlarmHigh($dataArray, $v[135], "SUS最小功率");

        _Get_Ignitc_AlarmLow($dataArray, $v[136], "Sd Engine fail");
        _Get_Ignitc_AlarmHigh($dataArray, $v[136], "BOC LossEngPwr");

        _Get_Ignitc_AlarmLow($dataArray, $v[137], "Wrn HEST Lamp");
        _Get_Ignitc_AlarmHigh($dataArray, $v[137], "Wrn DPF Lamp");

        _Get_Ignitc_AlarmLow($dataArray, $v[138], "WrnDEFLwLvlLmp");
        _Get_Ignitc_AlarmHigh($dataArray, $v[138], "Wrn MalfnctLmp");

        $v = unpack('v', substr($memData, 4 + 2 * 138, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 2 * 138 + 2, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));

    }
}


?>
