<?php

function Get_ita_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case 'A相输出电流':
            return array(0, $dataArray["A相输出电流（A）"]);
        case 'B相输出电流':
            return array(0, $dataArray["B相输出电流（A）"]);
        case 'C相输出电流':
            return array(0, $dataArray["C相输出电流（A）"]);
        case 'A相输出负载百分比':    
            return array(0,$dataArray['e2整机']['-A相输出负载百分比']);
        case 'B相输出负载百分比':    
            return array(0,$dataArray['e2整机']['-B相输出负载百分比']);
        case 'C相输出负载百分比':    
            return array(0,$dataArray['e2整机']['-C相输出负载百分比']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}


function Get_ita_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $v = unpack('f*', substr($memData, 4, 4 * 11));
        $dataArray["A相输入电压（V）"] = number_format($v[1], 2);
        $dataArray["B相输入电压（V）"] = number_format($v[2], 2);
        $dataArray["C相输入电压（V）"] = number_format($v[3], 2);
        $dataArray["A相输出电压（V）"] = number_format($v[4], 2);
        $dataArray["B相输出电压（V）"] = number_format($v[5], 2);
        $dataArray["C相输出电压（V）"] = number_format($v[6], 2);
        $dataArray["A相输出电流（A）"] = number_format($v[7], 2);
        $dataArray["B相输出电流（A）"] = number_format($v[8], 2);
        $dataArray["C相输出电流（A）"] = number_format($v[9], 2);
        $dataArray["电池组1电池电压（V）"] = number_format($v[10], 2);
        $dataArray["频率（Hz）"] = number_format($v[11], 2);

        $v = unpack('C*', substr($memData, 4 + 4 * 11,1 * 3));
        $dataArray["整机标识电池数量m"] = $v[1];
        $dataArray["整机标识温度数量n"] = $v[2];
        $dataArray["用户自定义遥测内容数量(1)"] = $v[3];

        $v = unpack('f*', substr($memData, 4 + 4 * 11 + 1 * 3,1 * 4));
        $dataArray["电池组2电池电压（V）"] = number_format($v[1], 2);
         
        $v = unpack('C*', substr($memData, 4 + 4 * 11 + 1 * 3 + 1 * 4,27 * 1));
        switch ($v[1]){
            case 0: $dataArray['供电方式'] = 'UPS供电';break;
            case 1: $dataArray['供电方式'] = '旁路供电';break;
            case 0xE9: $dataArray['供电方式'] = '均不供电';break;
            default: $dataArray['供电方式'] = '不支持';
        }
        $dataArray["用户自定义数量"] = $v[2];
        switch ($v[3]){
            case 0xE0: $dataArray['电池自检状态'] = '自检中';break;
            case 0xE1: $dataArray['电池自检状态'] = '没在自检';break;
            default: $dataArray['电池自检状态'] = '不支持';
        }
        switch ($v[4]){
            case 0xE0: $dataArray['电池充电状态'] = '浮充';break;
            case 0xE1: $dataArray['电池充电状态'] = '均充';break;
            case 0xE2: $dataArray['电池充电状态'] = '非充电状态';break;
            default: $dataArray['电池充电状态'] = '不支持';
        }
        switch ($v[5]){
            case 0xE0: $dataArray['逆变器开机/关机'] = '开机';break;
            case 0xE1: $dataArray['逆变器开机/关机'] = '关机';break;
            default: $dataArray['逆变器开机/关机'] = '不支持';
        }
        switch ($v[6]){
            case 0xE0: $dataArray['整流器供电状态'] = '主路逆变供电';break;
            case 0xE1: $dataArray['整流器供电状态'] = '电池逆变供电';break;
            case 0xE3: $dataArray['整流器供电状态'] = '主路电池均不供电';break;
            default: $dataArray['整流器供电状态'] = '不支持';
        }
        switch ($v[7]){
            case 0xE0: $dataArray['整机发电机接入事件'] = '发电机接入';break;
            case 0xE1: $dataArray['整机发电机接入事件'] = '发电机未接入';break;
            default: $dataArray['整机发电机接入事件'] = '不支持';
        }
        #$v[8]预留
        switch ($v[9]){
            case 0xE0: $dataArray['维修旁路空开状态'] = '断开状态';break;
            case 0xE1: $dataArray['维修旁路空开状态'] = '闭合状态 ';break;
            default: $dataArray['维修旁路空开状态'] = '不支持';
        }
        #$v[10]预留
        switch ($v[11]){
            case 0xE0: $dataArray['输出空开状态'] = '断开状态';break;
            case 0xE1: $dataArray['输出空开状态'] = '闭合状态 ';break;
            default: $dataArray['输出空开状态'] = '不支持';
        }
        #$v[12]预留
        switch ($v[13]){
            case 0xE0: $dataArray['并机系统供电状态'] = '均不供电';break;
            case 0xE1: $dataArray['并机系统供电状态'] = '旁路供电 ';break;
            case 0xE2: $dataArray['并机系统供电状态'] = '市电供电 ';break;
            case 0xE3: $dataArray['并机系统供电状态'] = '电池逆变供电 ';break;
            case 0xE5: $dataArray['并机系统供电状态'] = '输出禁止 ';break;
            default: $dataArray['并机系统供电状态'] = '不支持';
        }
        #$v[14]预留
        #$v[15]预留
        $index = 1;
        for($i = 16;$i <= 25;$i++) {
            switch ($v[$i]){
                case 0xE0: $dataArray["模块{$index}在线状态"] = '在线';break;
                case 0xE1: $dataArray["模块{$index}在线状态"] = '不在线 ';break;
                default: $dataArray["模块{$index}在线状态"] = '不支持';
            }
            $index++;
        }

        switch ($v[26]){
            case 0xE0: $dataArray['ECO模式状态'] = '正常模式';break;
            case 0xE1: $dataArray['ECO模式状态'] = 'ECO模式 ';break;
            default: $dataArray['ECO模式状态'] = '不支持';
        }

        switch ($v[27]){
            case 0: $dataArray['BCB状态'] = '未接入';break;
            case 0xE0: $dataArray['BCB状态'] = '闭合';break;
            case 0xE1: $dataArray['BCB状态'] = '断开 ';break;
            default: $dataArray['BCB状态'] = '不支持';
        }

        $v = unpack('C*', substr($memData, 4 + 4 * 11 + 1 * 3 + 1 * 4 + 27 * 1,95 * 1));

        $alarmArray = [];
        $alarmArray["主路电压"] = $v[2];
        $alarmArray["整流器"] = $v[3];
        $alarmArray["逆变器"] = $v[4];
        $alarmArray["LBS异常"] = $v[19];
        $alarmArray["风扇异常"] = $v[21];
        $alarmArray["旁路晶闸管故障"] = $v[24];
        $alarmArray["旁路相序反"] = $v[25];
        $alarmArray["旁路过流"] = $v[26];
        $alarmArray["旁路异常关机"] = $v[27];
        $alarmArray["切换次数限"] = $v[28];
        $alarmArray["BCB状态异常"] = $v[36];
        $alarmArray["电池变换器故障"] = $v[39];
        $alarmArray["充电器故障"] = $v[45];
        $alarmArray["电池需维护"] = $v[47];
        $alarmArray["电池温度过温"] = $v[49];
        $alarmArray["主路频率异"] = $v[53];
        $alarmArray["整流器过温"] = $v[56];
        $alarmArray["辅助电源掉电"] = $v[60];
        $alarmArray["主路相序"] = $v[61];
        $alarmArray["软启动失"] = $v[63];
        $alarmArray["逆变继电器故障"] = $v[66];
        $alarmArray["用户操作错误"] = $v[67];
        $alarmArray["输出熔丝断"] = $v[68];
        $alarmArray["模块输出过载"] = $v[69];
        $alarmArray["系统过载"] = $v[70];
        $alarmArray["模块过载超时"] = $v[71];
        $alarmArray["负载冲击转旁路"] = $v[74];
        $alarmArray["均流异常"] = $v[75];
        $alarmArray["母线异常关机"] = $v[76];
        $alarmArray["邻机请求转旁路"] = $v[77];
        $alarmArray["直流母线过压"] = $v[78];
        $alarmArray["通讯故障"] = $v[80];
        $alarmArray["输入缺零故障"] = $v[83];
        $alarmArray["输入电流异常"] = $v[86];
        $alarmArray["输出电压异常"] = $v[87];
        $alarmArray["输入电流超限"] = $v[88];
        $alarmArray["邻机旁路晶闸管故障"] = $v[90];
        $alarmArray["主路反灌"] = $v[93];
        $alarmArray["放电电流限流"] = $v[94];
        $alarmArray["输出隔离变压器过温"] = $v[95];
       
        foreach ($alarmArray as $k => $val) {
            switch ($val){
                case 0: $dataArray[$k] = '正常';break;
                case 0xF0: 
                    $dataArray[$k] = '异常';
                    $dataArray['AlertArray'][$k] = 1;
                    break;
                default: $dataArray[$k] = '不支持';
            }
        }


        switch ($v[1]){
            case 0: $dataArray['逆变器同步/不同步'] = '正常';break;
            case 3: 
                $dataArray['逆变器同步/不同步'] = '不同步';
                $dataArray['AlertArray']['逆变器同步/不同步'] = 1;
                break;
            default: $dataArray['逆变器同步/不同步'] = '不支持';
        }


        switch ($v[5]){
            case 0: $dataArray['旁路状态（电压或频率）'] = '正常';break;
            case 0xF0: 
                $dataArray['旁路状态（电压或频率）'] = '超限';
                $dataArray['AlertArray']['旁路状态（电压或频率）'] = 1;
                break;
            default: $dataArray['旁路状态（电压或频率）'] = '不支持';
        }

        switch ($v[6]){
            case 0: $dataArray['电池状态'] = '正常';break;
            case 0xF2: 
                $dataArray['电池状态'] = '电池无';
                $dataArray['AlertArray']['电池状态'] = 1;
                break;
            case 0xF3: 
                $dataArray['电池状态'] = '预告警';
                $dataArray['AlertArray']['电池状态'] = 1;
                break;
            case 0xF3: 
                $dataArray['电池状态'] = '电池接反';
                $dataArray['AlertArray']['电池状态'] = 1;
                break;
            default: $dataArray['电池状态'] = '不支持';
        }

        $dataArray['电池数量'] = $v[7];
        $dataArray['用户自定义告警数量'] = $v[8];

        $index = 1;
        for($i = 9;$i <= 18;$i++) {
            switch ($v[$i]){
                case 0: $dataArray["功率模块{$index}故障"] = '正常';break;
                case 0xF0: 
                    $dataArray["功率模块{$index}故障"] = '异常';
                    $dataArray['AlertArray']["功率模块{$index}故障"] = 1;
                    break;
                default: $dataArray["功率模块{$index}故障"] = '不支持';
            }
            $index++;
        }

        switch ($v[23]){
            case 0: $dataArray['紧急关机'] = '正常';break;
            case 0xF0: 
                $dataArray['紧急关机'] = '紧急关机';
                $dataArray['AlertArray']["紧急关机"] = 1;
                break;
            default: $dataArray['紧急关机'] = '不支持';
        }

        $start = 4 + 4 * 11 + 1 * 3 + 1 * 4 + 27 * 1 + 95 * 1;
        for($i = 0;$i < 11;$i++) {
            $v = unpack('C*', substr($memData, $start,1*2));           
            if ($i == 0) 
                $modelName = "e1整机";
            else
                $modelName = "e1模块{$i}";
            $dataArray[$modelName.'-模块号'] = $v[1];
            $dataArray[$modelName.'-模拟量个数'] = $v[2];
            $start += 1*2;
            $v = unpack('f*', substr($memData, $start,4 * 14));
            $dataArray[$modelName.'-交流输入线电压AB（V）'] = number_format($v[1],2);
            $dataArray[$modelName.'-交流输入线电压BC（V）'] = number_format($v[2],2);
            $dataArray[$modelName.'-交流输入线电压CA（V）'] = number_format($v[3],2);
            $dataArray[$modelName.'-A相输入电流（A）'] = number_format($v[4],2);
            $dataArray[$modelName.'-B相输入电流（A）'] = number_format($v[5],2);
            $dataArray[$modelName.'-C相输入电流（A）'] = number_format($v[6],2);
            $dataArray[$modelName.'-输入频率（Hz）'] = number_format($v[7],2);
            $dataArray[$modelName.'-A相输入功率因数'] = number_format($v[8],2);
            $dataArray[$modelName.'-B相输入功率因数'] = number_format($v[9],2);
            $dataArray[$modelName.'-C相输入功率因数'] = number_format($v[10],2);
            $dataArray[$modelName.'-A相输入电流（A）'] = number_format($v[11],2);
            $dataArray[$modelName.'-B相输入电流（A）'] = number_format($v[12],2);
            $dataArray[$modelName.'-C相输入电流（A）'] = number_format($v[13],2);
            $dataArray[$modelName.'-旁路频率（Hz）'] = number_format($v[14],2);
            $start += 4 * 14;
        }

        for($i = 0;$i < 11;$i++) {
            $v = unpack('C*', substr($memData, $start,1 * 2));
            if ($i == 0) 
                $modelName = "e2整机";
            else
                $modelName = "e2模块{$i}";
            $dataArray[$modelName.'-模块号'] = $v[1];
            $dataArray[$modelName.'-模拟量个数'] = $v[2];
            $start += 1 * 2;
            $v = unpack('f*', substr($memData, 4 + 4 * 11 + 1 * 3 + 1 * 4 + 27 * 1 + 95 * 1 + 1*2 + 4 * 14 + 1 * 2,4 * 18));
            $dataArray[$modelName.'-A相输入功率因数'] = number_format($v[1],2);
            $dataArray[$modelName.'-B相输入功率因数'] = number_format($v[2],2);
            $dataArray[$modelName.'-C相输入功率因数'] = number_format($v[3],2);
            $dataArray[$modelName.'-A相输出峰值比'] = number_format($v[4],2);
            $dataArray[$modelName.'-B相输出峰值比'] = number_format($v[5],2);
            $dataArray[$modelName.'-C相输出峰值比'] = number_format($v[6],2);
            $dataArray[$modelName.'-A相输出有功功率'] = number_format($v[7],2);
            $dataArray[$modelName.'-B相输出有功功率'] = number_format($v[8],2);
            $dataArray[$modelName.'-C相输出有功功率'] = number_format($v[9],2);
            $dataArray[$modelName.'-A相输出无功功率'] = number_format($v[10],2);
            $dataArray[$modelName.'-B相输出无功功率'] = number_format($v[11],2);
            $dataArray[$modelName.'-C相输出无功功率'] = number_format($v[12],2);
            $dataArray[$modelName.'-A相输出视在功率'] = number_format($v[13],2);
            $dataArray[$modelName.'-B相输出视在功率'] = number_format($v[14],2);
            $dataArray[$modelName.'-C相输出视在功率'] = number_format($v[15],2);
            $dataArray[$modelName.'-A相输出负载百分比'] = number_format($v[16],2);
            $dataArray[$modelName.'-B相输出负载百分比'] = number_format($v[17],2);
            $dataArray[$modelName.'-C相输出负载百分比'] = number_format($v[18],2);
            $start += 4 * 18;
        }

        $v = unpack('C*', substr($memData, $start,1 * 1));
        $start += 1;
        $dataArray['模拟量个数'] = $v[1];
        $v = unpack('f*', substr($memData, $start,4 * 9));
        $start += 4 * 9;
        $dataArray['系统A相输出有功功率'] = number_format($v[1],2);
        $dataArray['系统B相输出有功功率'] = number_format($v[2],2);
        $dataArray['系统C相输出有功功率'] = number_format($v[3],2);
        $dataArray['系统A相输出视在功率'] = number_format($v[4],2);
        $dataArray['系统B相输出视在功率'] = number_format($v[5],2);
        $dataArray['系统C相输出视在功率'] = number_format($v[6],2);
        $dataArray['系统A相输出无功功率'] = number_format($v[7],2);
        $dataArray['系统B相输出无功功率'] = number_format($v[8],2);
        $dataArray['系统C相输出无功功率'] = number_format($v[9],2);

        for($i = 1;$i <= 2;$i++) {
            $modelName = "电池组$i";
            $v = unpack('C*', substr($memData, $start,1 * 2));
            $start += 1 * 2;
            $dataArray[$modelName.'-模拟量个数'] = $v[2];
            $v = unpack('f*', substr($memData, $start,4 * 8));
            $start += 4 * 8; 
            $dataArray[$modelName.'-电池后备时间'] = number_format($v[1],2);
            $dataArray[$modelName.'-正电池电压'] = number_format($v[2],2);
            $dataArray[$modelName.'-正电池电流'] = number_format($v[3],2);
            $dataArray[$modelName.'-负电池电压'] = number_format($v[4],2);
            $dataArray[$modelName.'-负电池电流'] = number_format($v[5],2);
            $dataArray[$modelName.'-电池老化系数'] = number_format($v[6],2);
            $dataArray[$modelName.'-电池温度'] = number_format($v[7],2);
            $dataArray[$modelName.'-环境温度'] = number_format($v[8],2);
        }

        $v = unpack('v', substr($memData, $start, 2));
        $start += 2;
        $year = $v[1];
        $v = unpack('C*', substr($memData,  $start, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
   }
}
?>
