<?php
function _iteaqcoolrow5000_ShowAlert(&$dataArray, $label, $value, $vsValue)
{
    $dataArray[$label] = $value == $vsValue ? '正常' : '告警';
    $dataArray['AlertArray'][$label] = $value != $vsValue;
}


function Get_iteaqcoolrow5000_RtData($memData, &$dataArray, $extraPara = false){
    if($memData == false){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        $offset = 4;
            $v = unpack("s*" , substr($memData , $offset, 2*33));
      
        $dataArray["回风温度测量值"] = number_format($v[1]/10, 2)."℃";
      

      
        $dataArray["回风湿度测量值"] = number_format($v[2]/10, 2)."%";
      

      
        $dataArray["送风温度1测量值"] = number_format($v[3]/10, 2)."℃";
      

      
        $dataArray["送风温度2测量值"] = number_format($v[4]/10, 2)."℃";
      

      
        $dataArray["排气压力"] = number_format($v[5]/10, 2)."Bar";
      

      
        $dataArray["吸气压力"] = number_format($v[6]/10, 2)."Bar";
      

      
        $dataArray["排气温度"] = number_format($v[7]/10, 2)."℃";
      

      
        $dataArray["吸气温度"] = number_format($v[8]/10, 2)."℃";
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "高压告警", ($v[9] & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "高压锁定", (($v[9]>>1) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "低压告警", (($v[9]>>2) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "低压锁定", (($v[9]>>3) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "排气高温", (($v[9]>>4) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "排气锁定", (($v[9]>>5) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "过热度低", (($v[9]>>6) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "过热低锁定", (($v[9]>>7) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "送风低温", (($v[9]>>8) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "送风高温", (($v[9]>>9) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "回风高温", (($v[9]>>10) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "回风高湿", (($v[9]>>11) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "回风低湿", (($v[9]>>12) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "低压传感故障", (($v[9]>>13) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "高压传感故障", (($v[9]>>14) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "回温故障", (($v[9]>>15) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "回湿故障", ($v[10] & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "送温故障", (($v[10]>>1) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "排温故障", (($v[10]>>2) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "吸温故障", (($v[10]>>3) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "风机故障", (($v[10]>>4) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "EEV 通信故障", (($v[10]>>5) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "压驱通信故障", (($v[10]>>6) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "地板溢水", (($v[10]>>7) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "远程关机", (($v[10]>>8) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "压缩机驱动故障", (($v[10]>>9) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "电源丢失", (($v[10]>>10) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "过滤网堵", (($v[10]>>11) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "远温故障", (($v[10]>>12) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "烟感告警", (($v[10]>>13) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "电源过压", (($v[10]>>14) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "电源欠压", (($v[10]>>15) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "电源缺相", ($v[11] & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "显示通信故障", (($v[11]>>1) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "压驱故障锁定", (($v[11]>>2) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "高压异常告警", (($v[11]>>3) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "DI模块通信故障", (($v[11]>>4) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "加热故障", (($v[11]>>5) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "电源反相", (($v[11]>>6) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "电源频偏", (($v[11]>>7) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "冷凝水高水位", (($v[11]>>8) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "排水故障", (($v[11]>>9) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "加湿大电流", (($v[11]>>10) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "加湿小电流", (($v[11]>>11) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "加湿器维护", (($v[11]>>12) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "加湿板故障", (($v[11]>>13) & 0x1), 0);
      

      
        _iteaqcoolrow5000_ShowAlert($dataArray, "组网故障", (($v[11]>>14) & 0x1), 0);
      

      
        switch(($v[12] & 0x1)){
          case 0:
          $dataArray["制冷"] = "待机";
            break;
          case 1:
          $dataArray["制冷"] = "工作";
            break;
          default:
            $dataArray["制冷"] = "无效值";
            break;
        }
      

      
        switch((($v[12]>>1) & 0x1)){
          case 0:
          $dataArray["加热"] = "待机";
            break;
          case 1:
          $dataArray["加热"] = "工作";
            break;
          default:
            $dataArray["加热"] = "无效值";
            break;
        }
      

      
        switch((($v[12]>>2) & 0x1)){
          case 0:
          $dataArray["加湿"] = "待机";
            break;
          case 1:
          $dataArray["加湿"] = "工作";
            break;
          default:
            $dataArray["加湿"] = "无效值";
            break;
        }
      

      
        switch((($v[12]>>3) & 0x1)){
          case 0:
          $dataArray["除湿"] = "待机";
            break;
          case 1:
          $dataArray["除湿"] = "工作";
            break;
          default:
            $dataArray["除湿"] = "无效值";
            break;
        }
      

      
        switch($v[13]){
          case 0:
          $dataArray["机组运行状态"] = "本地关机";
            break;
          case 1:
          $dataArray["机组运行状态"] = "远程关机";
            break;
          case 2:
          $dataArray["机组运行状态"] = "待机";
            break;
          case 3:
          $dataArray["机组运行状态"] = "监控关机";
            break;
          case 4:
          $dataArray["机组运行状态"] = "电源保护";
            break;
          case 5:
          $dataArray["机组运行状态"] = "气流保护";
            break;
          case 6:
          $dataArray["机组运行状态"] = "压机保护";
            break;
          case 7:
          $dataArray["机组运行状态"] = "系统开机";
            break;
          default:
            $dataArray["机组运行状态"] = "无效值";
            break;
        }
      

      
        $dataArray["送风温度设定点"] = number_format($v[30]/10, 2)."℃";
      

      
        $dataArray["回风温度设定点"] = number_format($v[31]/10, 2)."℃";
      

      
        $dataArray["远程温度设定点"] = number_format($v[32]/10, 2)."℃";
      

      
        $dataArray["湿度设定点"] = number_format($v[33]/10, 2)."℃";
      

      $offset += 66;

        $v = unpack('v', substr($memData, $offset , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, $offset + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

