<?php
function _iteaqupsur_ShowAlert(&$dataArray, $label, $value, $vsValue)
{
    $dataArray[$label] = $value == $vsValue ? '正常' : '告警';
    $dataArray['AlertArray'][$label] = $value != $vsValue;
}

function Get_iteaqupsur_RtData($memData, &$dataArray, $extraPara = false){
    if($memData == false){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        $offset = 4;
        $v = unpack("S*" , substr($memData , $offset, 2*28));
        $dataArray["A相输入电压"] = number_format($v[1]/10, 2)."V";
        $dataArray["B相输入电压"] = number_format($v[2]/10, 2)."V";
        $dataArray["C相输入电压"] = number_format($v[3]/10, 2)."V";
        $dataArray["输入频率"] = number_format($v[4]/10, 2)."Hz";
        $dataArray["A相旁路电压"] = number_format($v[5]/10, 2)."V";
        $dataArray["B相旁路电压"] = number_format($v[6]/10, 2)."V";
        $dataArray["C相旁路电压"] = number_format($v[7]/10, 2)."V";
        $dataArray["旁路频率"] = number_format($v[8]/10, 2)."Hz";
        $dataArray["A相输出电压"] = number_format($v[9]/10, 2)."V";
        $dataArray["B相输出电压"] = number_format($v[10]/10, 2)."V";
        $dataArray["C相输出电压"] = number_format($v[11]/10, 2)."V";
        $dataArray["A相输出电流"] = number_format($v[12]/10, 2)."A";
        $dataArray["B相输出电流"] = number_format($v[13]/10, 2)."A";
        $dataArray["C相输出电流"] = number_format($v[14]/10, 2)."A";
        $dataArray["输出频率"] = number_format($v[15]/10, 2)."Hz";
        $dataArray["A相输出有功功率"] = number_format($v[16]/10, 2)."kW";
        $dataArray["B相输出有功功率"] = number_format($v[17]/10, 2)."kW";
        $dataArray["C相输出有功功率"] = number_format($v[18]/10, 2)."kW";
        $dataArray["A相输出视在功率"] = number_format($v[19]/10, 2)."kVA";
        $dataArray["B相输出视在功率"] = number_format($v[20]/10, 2)."kVA";
        $dataArray["C相输出视在功率"] = number_format($v[21]/10, 2)."kVA";
        $dataArray["A相负载率"] = number_format($v[22]/10, 2)."%";
        $dataArray["B相负载率"] = number_format($v[23]/10, 2)."%";
        $dataArray["C相负载率"] = number_format($v[24]/10, 2)."%";
        switch($v[25]){
          case 0:
          $dataArray["供电模式"] = "均不供电";
            break;
          case 1:
          $dataArray["供电模式"] = "旁路供电";
            break;
          case 2:
          $dataArray["供电模式"] = "主路供电";
            break;
          case 3:
          $dataArray["供电模式"] = "电池供电";
            break;
          case 5:
          $dataArray["供电模式"] = "主路ECO";
            break;
          case 6:
          $dataArray["供电模式"] = "电池ECO";
            break;
          default:
            $dataArray["供电模式"] = "无效值";
            break;
        }
        switch($v[26]){
          case 0:
          $dataArray["输入制式"] = "单相";
            break;
          case 1:
          $dataArray["输入制式"] = "三相";
            break;
          default:
            $dataArray["输入制式"] = "无效值";
            break;
        }
        switch($v[27]){
          case 0:
          $dataArray["输出制式"] = "单相";
            break;
          case 1:
          $dataArray["输出制式"] = "三相";
            break;
          default:
            $dataArray["输出制式"] = "无效值";
            break;
        }
        $dataArray["机内温度"] = number_format($v[28]/10, 2)."℃";
        $offset += 56;
        $v = unpack("S*" , substr($memData , $offset, 2*7));
        $dataArray["电池电压"] = number_format($v[1]/10, 2)."V";
        $dataArray["电池电流"] = number_format($v[2]/10, 2)."A";
        switch($v[3]){
          case 2:
          $dataArray["电池状态"] = "休眠";
            break;
          case 3:
          $dataArray["电池状态"] = "浮充";
            break;
          case 4:
          $dataArray["电池状态"] = "均充";
            break;
          case 5:
          $dataArray["电池状态"] = "放电";
            break;
          default:
            $dataArray["电池状态"] = "无效值";
            break;
        }
        $dataArray["电池剩余容量"] = number_format($v[4], 2)."%";
        $dataArray["电池后备时间"] = ($v[5] << 16 + $v[6]);
        $dataArray["电池温度"] = number_format($v[7]/10, 2)."℃";
        $offset += 14;
        $v = unpack("S*" , substr($memData , $offset, 2*28));
        //_iteaqupsur_ShowAlert($dataArray, "模块UPS模块故障告警", (($v[20] >> 12) && 0x1), 0);
        //_iteaqupsur_ShowAlert($dataArray, "UPS主机旁路运行状态告警", (($v[20] >> 13) && 0x1), 0);
        $dataArray["模块UPS模块故障告警"]  =  (($v[20] >> 12) && 0x1);
        $dataArray["UPS主机旁路运行状态告警"]  =  (($v[20] >> 13) && 0x1);
        $offset += 56;
        $v = unpack('v', substr($memData, $offset , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, $offset + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));

    }
}

