<?php

function Get_jbatterybalancer160_DeviceIoControl_Parameter($action, $parameter)
{
    switch($action)
    {
        case 2://START_RESIST
        {
            return "";
        }
        case 4://START_BALANCE
        {
            if(count($parameter) != 1)
            {
                return "";
            }
            return pack("S", $parameter[0]);
        }
        case 6://STOP_BALANCE
        {
            return "";
        }
        case 8://READ_MODULE_ADDR
        {

            return "";
        }
        case 10://WRITE_MODULE_ADDR
        {
            if(count($parameter) != 1)
            {
                return "";
            }
            return pack("S", $parameter[0]);
        }
        case 12://ADJUST_VOLTAGE
        {
            if(count($parameter) != 6)
            {
                return "";
            }
            return pack("S*", $parameter[0], $parameter[1], $parameter[2], $parameter[3], $parameter[4], $parameter[5]);
        }
        case 14://ADJUST_RESIST
        {
            if(count($parameter) != 6)
            {
                return "";
            }
            return pack("S*", $parameter[0], $parameter[1], $parameter[2], $parameter[3], $parameter[4], $parameter[5]);
        }
        case 16://TWEAK_VOLTAGE
        {
            if(count($parameter) != 3)
            {
                return "";
            }
            return pack("S*", $parameter[0], $parameter[1], $parameter[2]);
        }
        case 18://TWEAK_RESIST
        {
            if(count($parameter) != 6)
            {
                return "";
            }
            return pack("S*", $parameter[0], $parameter[1], $parameter[2], $parameter[3], $parameter[4], $parameter[5]);
        }
        case 20://ADJUST_CURRENT
        {
            if(count($parameter) != 8)
            {
                return "";
            }
            return pack("S*", $parameter[0], $parameter[1], $parameter[2], $parameter[3], $parameter[4], $parameter[5], $parameter[6], $parameter[7]);
        }
        default:
            return "";
    }
}
function Get_jbatterybalancer160_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
        /* $dataObj->isEmpty = true;
        $dataObj->update_datetime = '无'; */
    } else {
        $dataArray["无数据"] = false;
        $dataArray['AlertArray'] = array();
        $v = unpack('S*', substr($memData, 4, 2*(480+4)));
        $dataArray["总电压"] = ($v[1]/100)."V";
        $dataArray["充电电流"] = ($v[2]/10)."A";
        $dataArray["环境温度"] = ($v[3]/10)."°C";
        $dataArray["放电电流"] = ($v[4]/10)."A";

        $vIndex = 1;
        for($i=1; $i<=160; $i++)
        {
            $dataArray["电池".$i."电压"] = number_format($v[4 + $vIndex++]/1000, 3).'V';   
        }
        for($i=1; $i<=160; $i++)
        {       
            $dataArray["电池".$i."内阻"] = number_format($v[4 + $vIndex++]/1000, 3).'mΩ';
        }
        for($i=1; $i<=160; $i++)
        {
            $dataArray["电池".$i."温度"] = number_format($v[4 + $vIndex++]/10, 1).'°C';
        }
        $v = unpack('v', substr($memData, 4 + 2*(480+4), 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 2*(480+4) + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}


?>
