<?php


function Get_jk070sw_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $v = unpack('S*', substr($memData, 4, 2 * 597));
        $dataArray["1路交流AB电压"] = number_format($v[1]/10, 1)." V";
        $dataArray["1路交流AC电压"] = number_format($v[2]/10, 1)." V";
        $dataArray["1路交流BC电压"] = number_format($v[3]/10, 1)." V";
        $dataArray["2路交流AB电压"] = number_format($v[4]/10, 1)." V";
        $dataArray["2路交流AC电压"] = number_format($v[5]/10, 1)." V";
        $dataArray["2路交流BC电压"] = number_format($v[6]/10, 1)." V";

        $dataArray["电池1电压"] = number_format($v[7]/10, 1)." V";
        $dataArray["电池1电流"] = number_format($v[8]/10, 1)." A";
        $dataArray["电池温度1"] = number_format($v[9]/10, 1)." C°";
        $dataArray["控母1电压"] = number_format($v[10]/10, 1)." V";
        $dataArray["控母1电流"] = number_format($v[11]/10, 1)." A";
        $dataArray["合母1电压"] = number_format($v[12]/10, 1)." V";

        $dataArray["电池2电压"] = number_format($v[13]/10, 1)." V";
        $dataArray["电池2电流"] = number_format($v[14]/10, 1)." A";
        $dataArray["电池温度2"] = number_format($v[15]/10, 1)." C°";
        $dataArray["控母2电压"] = number_format($v[16]/10, 1)." V";
        $dataArray["控母2电流"] = number_format($v[17]/10, 1)." A";
        $dataArray["合母2电压"] = number_format($v[18]/10, 1)." V";

        $dataArray["母线1正对地电阻"] = number_format($v[19]/10, 1)." Ω";
        $dataArray["母线1负对地电阻"] = number_format($v[20]/10, 1)." Ω";
        $dataArray["母线1正对地电压"] = number_format($v[21]/10, 1)." V";
        $dataArray["母线1负对地电压"] = number_format($v[22]/10, 1)." V";
        $dataArray["母线2正对地电阻"] = number_format($v[23]/10, 1)." Ω";
        $dataArray["母线2负对地电阻"] = number_format($v[24]/10, 1)." Ω";
        $dataArray["母线2正对地电压"] = number_format($v[25]/10, 1)." V";
        $dataArray["母线2负对地电压"] = number_format($v[26]/10, 1)." V";
        $dataArray["模块均充电压"] = number_format($v[27]/10, 1)." V";
        $dataArray["模块浮充电压"] = number_format($v[28]/10, 1)." V";
        
        $offset = 28;
        for($i=1;$i<=16;$i++){
            $dataArray["1组模块".$i."输出电压"] = number_format($v[$offset + 2*$i - 1 ]/10, 1)." V";
            $dataArray["1组模块".$i."输出电流"] = number_format($v[$offset + 2*$i ]/10, 1)." A";
        }
        
        $offset = 60;
        for($i=1;$i<=16;$i++){
            $dataArray["2组模块".$i."输出电压"] = number_format($v[$offset + 2*$i-1 ]/10, 1)." V";
            $dataArray["2组模块".$i."输出电流"] = number_format($v[$offset + 2*$i ]/10, 1)." A";
        }
        
        $offset = 92;
        for($i=1; $i<=120;$i++){
            $dataArray["1组".$i."#电池电压"] = number_format($v[$offset + $i]/100, 1)." V";
        }

        $offset = 212;
        for($i=1; $i<=120;$i++){
            $dataArray["2组".$i."#电池电压"] = number_format($v[$offset + $i]/100, 1)." V";
        }

        $offset = 332;
        for($i=1; $i<=32; $i++){
            $dataArray["1段支路".$i."正对地电阻"] = number_format($v[$offset + 2*$i - 1]/10, 1)." Ω";
            $dataARray["1段支路".$i."负对地电阻"] = number_format($v[$offset + 2*$i]/10, 1)." Ω";
        }

        $offset = 460;
        for($i=1; $i<=32; $i++){
            $dataArray["2段支路".$i."正对地电阻"] = number_format($v[$offset + 2*$i - 1]/10, 1)." Ω";
            $dataARray["2段支路".$i."负对地电阻"] = number_format($v[$offset + 2*$i]/10, 1)." Ω";
        }
        $offset = 588;
        $dataArray["I组充电模块输出电压"] = number_format($v[589]/10, 1)." V";
        $dataArray["I组充电模块输出电流"] = number_format($v[590]/10, 1)." A";
        $dataArray["II组充电模块输出电压"] = number_format($v[591]/10, 1)." V";
        $dataArray["II组充电模块输出电流"] = number_format($v[592]/10, 1)." A";
        $dataArray["1段母线交流串入电压"] = number_format($v[593]/10, 1)." V";
        $dataArray["2段母线交流串入电压"] = number_format($v[594]/10, 1)." V";

        $dataArray["电池漏电流"] = number_format($v[595]/1000, 1)." A";
        $dataArray["电池漏电流位置"] = $v[596];
        $dataArray["母线对地电容"] = number_format($v[597]/10, 1);

        $v = unpack('v', substr($memData, 4 + 2 * 597, 2));
        $year = $v[1] ;
        $v = unpack('C*', substr($memData, 4 + 2 * 597 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
