<?php 
function Get_jpmc_RtData($memData, &$dataArray, $extraPara = false)
{
   if(empty($memData)) {
       $dataArray['无数据'] = true;
       $dataArray['更新时间'] = '无';
       $dataArray['错误'] = '数据长度不一致';
   } else {
        $dataArray['无数据'] = false;
        $v = unpack('f*', substr($memData, 4, 4 * 34 + 18 * 72 * 4));
        
        $dataArray["A相功率因数PFa"] = number_format($v[1], 2);
        $dataArray["B相功率因数PFb"] = number_format($v[2], 2);
        $dataArray["C相功率因数PFc"] = number_format($v[3], 2);
        $dataArray["A相电流Ia（A）"] = number_format($v[4], 2);
        $dataArray["B相电流Ib（A）"] = number_format($v[5], 2);
        $dataArray["C相电流Ic（A）"] = number_format($v[6], 2);
        $dataArray["A相电压Ua（V）"] = number_format($v[7], 2);
        $dataArray["B相电压Ub（V）"] = number_format($v[8], 2);
        $dataArray["C相电压Uc（V）"] = number_format($v[9], 2);
        $dataArray["A相有功功率Pa（kW）"] = number_format($v[10], 2);
        $dataArray["B相有功功率Pb（kW）"] = number_format($v[11], 2);
        $dataArray["C相有功功率Pc（kW）"] = number_format($v[12], 2);
        $dataArray["A相无功功率Qa（kVAR）"] = number_format($v[13], 2);
        $dataArray["B相无功功率Qb（kVAR）"] = number_format($v[14], 2);
        $dataArray["C相无功功率Qc（kVAR）"] = number_format($v[15], 2);
        $dataArray["A相现在功率Sa（kVA）"] = number_format($v[16], 2);
        $dataArray["B相现在功率Sb（kVA）"] = number_format($v[17], 2);
        $dataArray["C相现在功率Sc（kVA）"] = number_format($v[18], 2);
        $dataArray["频率F（Hz）"] = number_format($v[19], 2);
        $dataArray["线电压Uab（V）"] = number_format($v[20], 2);
        $dataArray["线电压Ubc（V）"] = number_format($v[21], 2);
        $dataArray["线电压Uca（V）"] = number_format($v[22], 2);
        $dataArray["三相总功率因数PFav"] = number_format($v[23], 2);
        $dataArray["三相有功功率Psum（kW）"] = number_format($v[24], 2);
        $dataArray["三相无功功率Qsum（kVAR）"] = number_format($v[25], 2);
        $dataArray["三相视在功率Ssum（kVA）"] = number_format($v[26], 2);
        $dataArray["零线电流（A）"] = number_format($v[27], 2);
        $dataArray["零线电压（V）"] = number_format($v[28], 2);
        $dataArray["环境温度（℃）"] = number_format($v[29], 2);
        $dataArray["环境湿度（%）"] = number_format($v[30], 2);
        $dataArray["电流不平衡率（%）"] = number_format($v[31], 2);
        $dataArray["电压不平衡率（%）"] = number_format($v[32], 2);
        $dataArray["有功电能Wh（kWh）"] = number_format($v[33], 2);
        $dataArray["无功电能Qh（kVARh）"] = number_format($v[34], 2);

        for($i = 0;$i < 72;$i++) {
            $line = $i + 1;
            $dataArray["1段{$line}路馈出电流（A）"] = number_format($v[35][$i], 2);
            $dataArray["2段{$line}路馈出电流（A）"] = number_format($v[36][$i], 2);
            $dataArray["1段{$line}路馈出负载百分比（%）"] = number_format($v[37][$i], 2);
            $dataArray["2段{$line}路馈出负载百分比（%）"] = number_format($v[38][$i], 2);
            $dataArray["1段{$line}路馈出功率因数"] = number_format($v[39][$i], 2);
            $dataArray["2段{$line}路馈出功率因数"] = number_format($v[40][$i], 2);
            $dataArray["1段{$line}路馈出电压（V）"] = number_format($v[41][$i], 2);
            $dataArray["2段{$line}路馈出电压（V）"] = number_format($v[42][$i], 2);
            $dataArray["1段{$line}路馈出有功功率（kW）"] = number_format($v[43][$i], 2);
            $dataArray["2段{$line}路馈出有功功率（kW）"] = number_format($v[44][$i], 2);
            $dataArray["1段{$line}路馈出无功功率（kVAR）"] = number_format($v[45][$i], 2);
            $dataArray["2段{$line}路馈出无功功率（kVAR）"] = number_format($v[46][$i], 2);
            $dataArray["1段{$line}路馈出现在功率（kVA）"] = number_format($v[47][$i], 2);
            $dataArray["2段{$line}路馈出现在功率（kVA）"] = number_format($v[48][$i], 2);
            $dataArray["1段{$line}路馈出有功电能（kWh）"] = number_format($v[49][$i], 2);
            $dataArray["2段{$line}路馈出有功电能（kWh）"] = number_format($v[50][$i], 2);
            $dataArray["1段{$line}路馈出无功电能（kVARh）"] = number_format($v[51][$i], 2);
            $dataArray["2段{$line}路馈出无功电能（kVARh）"] = number_format($v[52][$i], 2);
        }

        $v = unpack('S*', substr($memData, 4 + 4 * 34 + 18 * 72 * 4, 2 * 2 * 3 + 2 * 3 + 2 * 9 * 5 + 2 * 3));
        $dataArray['A相电流下下限告警'] = $v[1][0] & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['A相电流下下限告警'] = $v[1][0] & 0x1 == 1;
        $dataArray['B相电流下下限告警'] = ($v[1][0] >> 1) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['B相电流下下限告警'] = ($v[1][0] >> 1) & 0x1 == 1;
        $dataArray['C相电流下下限告警'] = ($v[1][0] >> 2) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['C相电流下下限告警'] = ($v[1][0] >> 2) & 0x1 == 1;
        $dataArray['A相电流下限告警'] = ($v[1][0] >> 3) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['A相电流下限告警'] = ($v[1][0] >> 3) & 0x1 == 1;
        $dataArray['B相电流下限告警'] = ($v[1][0] >> 4) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['B相电流下限告警'] = ($v[1][0] >> 4) & 0x1 == 1;
        $dataArray['C相电流下限告警'] = ($v[1][0] >> 5) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['C相电流下限告警'] = ($v[1][0] >> 5) & 0x1 == 1;
        $dataArray['A相电流上限告警'] = ($v[1][0] >> 6) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['A相电流上限告警'] = ($v[1][0] >> 6) & 0x1 == 1;
        $dataArray['B相电流上限告警'] = ($v[1][0] >> 7) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['B相电流上限告警'] = ($v[1][0] >> 7) & 0x1 == 1;
        $dataArray['C相电流上限告警'] = ($v[1][0] >> 8) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['C相电流上限告警'] = ($v[1][0] >> 8) & 0x1 == 1;
        $dataArray['A相电流上上限告警'] = ($v[1][0] >> 9) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['A相电流上上限告警'] = ($v[1][0] >> 9) & 0x1 == 1;
        $dataArray['B相电流上上限告警'] = ($v[1][0] >> 10) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['B相电流上上限告警'] = ($v[1][0] >> 10) & 0x1 == 1;
        $dataArray['C相电流上上限告警'] = ($v[1][0] >> 11) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['C相电流上上限告警'] = ($v[1][0] >> 11) & 0x1 == 1;
        $dataArray['零线电流上限告警'] = ($v[1][0] >> 12) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['零线电流上限告警'] = ($v[1][0] >> 12) & 0x1 == 1;
        $dataArray['电流不平衡告警'] = ($v[1][0] >> 13) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['电流不平衡告警'] = ($v[1][0] >> 13) & 0x1 == 1;
        $dataArray['A相电压下限告警'] = $v[1][1] & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['A相电压下限告警'] = $v[1][1] & 0x1 == 1;
        $dataArray['B相电压下限告警'] = ($v[1][1] >> 1) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['B相电压下限告警'] = ($v[1][1] >> 1) & 0x1 == 1;
        $dataArray['C相电压下限告警'] = ($v[1][1] >> 2) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['C相电压下限告警'] = ($v[1][1] >> 2) & 0x1 == 1;
        $dataArray['A相电压上限告警'] = ($v[1][1] >> 3) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['A相电压上限告警'] = ($v[1][1] >> 3) & 0x1 == 1;
        $dataArray['B相电压上限告警'] = ($v[1][1] >> 4) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['B相电压上限告警'] = ($v[1][1] >> 4) & 0x1 == 1;
        $dataArray['C相电压上限告警'] = ($v[1][1] >> 5) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['C相电压上限告警'] = ($v[1][1] >> 5) & 0x1 == 1;
        $dataArray['零地电压上限告警'] = ($v[1][1] >> 6) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['零地电压上限告警'] = ($v[1][1] >> 6) & 0x1 == 1;
        $dataArray['电压不平衡告警'] = ($v[1][1] >> 7) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['电压不平衡告警'] = ($v[1][1] >> 7) & 0x1 == 1;
        $dataArray['输入欠频告警'] = ($v[1][1] >> 8) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['输入欠频告警'] = ($v[1][1] >> 8) & 0x1 == 1;
        $dataArray['输入过频告警'] = ($v[1][1] >> 9) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['输入过频告警'] = ($v[1][1] >> 9) & 0x1 == 1;
        $dataArray['一路A相电流下下限告警'] = $v[2][0] & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路A相电流下下限告警'] = $v[2][0] & 0x1 == 1;
        $dataArray['一路B相电流下下限告警'] = ($v[2][0] >> 1) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路B相电流下下限告警'] = ($v[2][0] >> 1) & 0x1 == 1;
        $dataArray['一路C相电流下下限告警'] = ($v[2][0] >> 2) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路C相电流下下限告警'] = ($v[2][0] >> 2) & 0x1 == 1;
        $dataArray['一路A相电流下限告警'] = ($v[2][0] >> 3) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路A相电流下限告警'] = ($v[2][0] >> 3) & 0x1 == 1;
        $dataArray['一路B相电流下限告警'] = ($v[2][0] >> 4) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路B相电流下限告警'] = ($v[2][0] >> 4) & 0x1 == 1;
        $dataArray['一路C相电流下限告警'] = ($v[2][0] >> 5) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路C相电流下限告警'] = ($v[2][0] >> 5) & 0x1 == 1;
        $dataArray['一路A相电流上限告警'] = ($v[2][0] >> 6) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路A相电流上限告警'] = ($v[2][0] >> 6) & 0x1 == 1;
        $dataArray['一路B相电流上限告警'] = ($v[2][0] >> 7) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路B相电流上限告警'] = ($v[2][0] >> 7) & 0x1 == 1;
        $dataArray['一路C相电流上限告警'] = ($v[2][0] >> 8) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路C相电流上限告警'] = ($v[2][0] >> 8) & 0x1 == 1;
        $dataArray['一路A相电流上上限告警'] = ($v[2][0] >> 9) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路A相电流上上限告警'] = ($v[2][0] >> 9) & 0x1 == 1;
        $dataArray['一路B相电流上上限告警'] = ($v[2][0] >> 10) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路B相电流上上限告警'] = ($v[2][0] >> 10) & 0x1 == 1;
        $dataArray['一路C相电流上上限告警'] = ($v[2][0] >> 11) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路C相电流上上限告警'] = ($v[2][0] >> 11) & 0x1 == 1;
        $dataArray['一路零线电流上限告警'] = ($v[2][0] >> 12) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路零线电流上限告警'] = ($v[2][0] >> 12) & 0x1 == 1;
        $dataArray['一路电流不平衡告警'] = ($v[2][0] >> 13) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路电流不平衡告警'] = ($v[2][0] >> 13) & 0x1 == 1;
        $dataArray['一路A相电压下限告警'] = $v[2][1] & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路A相电压下限告警'] = $v[2][1] & 0x1 == 1;
        $dataArray['一路B相电压下限告警'] = ($v[2][1] >> 1) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路B相电压下限告警'] = ($v[2][1] >> 1) & 0x1 == 1;
        $dataArray['一路C相电压下限告警'] = ($v[2][1] >> 2) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路C相电压下限告警'] = ($v[2][1] >> 2) & 0x1 == 1;
        $dataArray['一路A相电压上限告警'] = ($v[2][1] >> 3) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路A相电压上限告警'] = ($v[2][1] >> 3) & 0x1 == 1;
        $dataArray['一路B相电压上限告警'] = ($v[2][1] >> 4) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路B相电压上限告警'] = ($v[2][1] >> 4) & 0x1 == 1;
        $dataArray['一路C相电压上限告警'] = ($v[2][1] >> 5) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路C相电压上限告警'] = ($v[2][1] >> 5) & 0x1 == 1;
        $dataArray['一路零地电压上限告警'] = ($v[2][1] >> 6) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路零地电压上限告警'] = ($v[2][1] >> 6) & 0x1 == 1;
        $dataArray['一路电压不平衡告警'] = ($v[2][1] >> 7) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路电压不平衡告警'] = ($v[2][1] >> 7) & 0x1 == 1;
        $dataArray['一路输入欠频告警'] = ($v[2][1] >> 8) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路输入欠频告警'] = ($v[2][1] >> 8) & 0x1 == 1;
        $dataArray['一路输入过频告警'] = ($v[2][1] >> 9) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路输入过频告警'] = ($v[2][1] >> 9) & 0x1 == 1;
        $dataArray['二路A相电流下下限告警'] = $v[3][0] & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路A相电流下下限告警'] = $v[3][0] & 0x1 == 1;
        $dataArray['二路B相电流下下限告警'] = ($v[3][0] >> 1) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路B相电流下下限告警'] = ($v[3][0] >> 1) & 0x1 == 1;
        $dataArray['二路C相电流下下限告警'] = ($v[3][0] >> 2) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路C相电流下下限告警'] = ($v[3][0] >> 2) & 0x1 == 1;
        $dataArray['二路A相电流下限告警'] = ($v[3][0] >> 3) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路A相电流下限告警'] = ($v[3][0] >> 3) & 0x1 == 1;
        $dataArray['二路B相电流下限告警'] = ($v[3][0] >> 4) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路B相电流下限告警'] = ($v[3][0] >> 4) & 0x1 == 1;
        $dataArray['二路C相电流下限告警'] = ($v[3][0] >> 5) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路C相电流下限告警'] = ($v[3][0] >> 5) & 0x1 == 1;
        $dataArray['二路A相电流上限告警'] = ($v[3][0] >> 6) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路A相电流上限告警'] = ($v[3][0] >> 6) & 0x1 == 1;
        $dataArray['二路B相电流上限告警'] = ($v[3][0] >> 7) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路B相电流上限告警'] = ($v[3][0] >> 7) & 0x1 == 1;
        $dataArray['二路C相电流上限告警'] = ($v[3][0] >> 8) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路C相电流上限告警'] = ($v[3][0] >> 8) & 0x1 == 1;
        $dataArray['二路A相电流上上限告警'] = ($v[3][0] >> 9) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路A相电流上上限告警'] = ($v[3][0] >> 9) & 0x1 == 1;
        $dataArray['二路B相电流上上限告警'] = ($v[3][0] >> 10) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路B相电流上上限告警'] = ($v[3][0] >> 10) & 0x1 == 1;
        $dataArray['二路C相电流上上限告警'] = ($v[3][0] >> 11) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路C相电流上上限告警'] = ($v[3][0] >> 11) & 0x1 == 1;
        $dataArray['二路零线电流上限告警'] = ($v[3][0] >> 12) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路零线电流上限告警'] = ($v[3][0] >> 12) & 0x1 == 1;
        $dataArray['二路电流不平衡告警'] = ($v[3][0] >> 13) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路电流不平衡告警'] = ($v[3][0] >> 13) & 0x1 == 1;
        $dataArray['二路A相电压下限告警'] = $v[3][1] & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路A相电压下限告警'] = $v[3][1] & 0x1 == 1;
        $dataArray['二路B相电压下限告警'] = ($v[3][1] >> 1) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路B相电压下限告警'] = ($v[3][1] >> 1) & 0x1 == 1;
        $dataArray['二路C相电压下限告警'] = ($v[3][1] >> 2) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路C相电压下限告警'] = ($v[3][1] >> 2) & 0x1 == 1;
        $dataArray['二路A相电压上限告警'] = ($v[3][1] >> 3) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路A相电压上限告警'] = ($v[3][1] >> 3) & 0x1 == 1;
        $dataArray['二路B相电压上限告警'] = ($v[3][1] >> 4) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路B相电压上限告警'] = ($v[3][1] >> 4) & 0x1 == 1;
        $dataArray['二路C相电压上限告警'] = ($v[3][1] >> 5) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路C相电压上限告警'] = ($v[3][1] >> 5) & 0x1 == 1;
        $dataArray['二路零地电压上限告警'] = ($v[3][1] >> 6) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路零地电压上限告警'] = ($v[3][1] >> 6) & 0x1 == 1;
        $dataArray['二路电压不平衡告警'] = ($v[3][1] >> 7) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路电压不平衡告警'] = ($v[3][1] >> 7) & 0x1 == 1;
        $dataArray['二路输入欠频告警'] = ($v[3][1] >> 8) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路输入欠频告警'] = ($v[3][1] >> 8) & 0x1 == 1;
        $dataArray['二路输入过频告警'] = ($v[3][1] >> 9) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路输入过频告警'] = ($v[3][1] >> 9) & 0x1 == 1;
        $dataArray['输入开关分闸'] = $v[4] & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['输入开关分闸'] = $v[4] & 0x1 == 1;
        $dataArray['防雷故障'] = ($v[4] >> 1) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['防雷故障'] = ($v[4] >> 1) & 0x1 == 1;
        $dataArray['一路输入开关分闸'] = ($v[4] >> 2) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['一路输入开关分闸'] = ($v[4] >> 2) & 0x1 == 1;
        $dataArray['二路输入开关分闸'] = ($v[4] >> 3) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['二路输入开关分闸'] = ($v[4] >> 3) & 0x1 == 1;
        $dataArray['1段防雷故障'] = ($v[4] >> 4) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['1段防雷故障'] = ($v[4] >> 4) & 0x1 == 1;
        $dataArray['2段防雷故障'] = ($v[4] >> 5) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['2段防雷故障'] = ($v[4] >> 5) & 0x1 == 1;
        $dataArray['开关跳闸'] = ($v[4] >> 14) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['开关跳闸'] = ($v[4] >> 14) & 0x1 == 1;
        $dataArray['1组开关跳闸'] = ($v[4] >> 15) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['1组开关跳闸'] = ($v[4] >> 15) & 0x1 == 1;
        $dataArray['2组开关跳闸'] = ($v[4] >> 16) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['2组开关跳闸'] = ($v[4] >> 16) & 0x1 == 1;

        if (($v[5] >> 3) & 0x1 == 3) {
            $dataArray['ATS状态'] = "ATS在1位";
        } else if (($v[5] >> 3) & 0x1 == 1) {
            $dataArray['ATS状态'] = "ATS在2位";
        } else if (($v[5] >> 3) & 0x1 == 0) {
            $dataArray['ATS状态'] = "ATS在中间";
        }else{
            $dataArray['ATS状态'] = "无效数值";
        }


        $dataArray['温度上限告警'] = $v[6] & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['温度上限告警'] = $v[6] & 0x1 == 1;
        $lineNo = 1;
        $lineIndex = 1;
        for($i = 0;$i < 9;$i++) {
            for($j = 0;$j < 16;$j++) {
                $key = "Q" . $lineNo . "F" . $lineIndex++;
                $dataArray[$key.'馈出开关分闸'] = ($v[7][$i] >> $j) & 0x1 == 1 ? "告警" : "正常";
                $dataArray['AlertArray'][$key.'馈出开关分闸'] = ($v[7][$i] >> $j) & 0x1 == 1;
                $dataArray[$key.'馈出电流下下限告警'] = ($v[8][$i] >> $j) & 0x1 == 1 ? "告警" : "正常";
                $dataArray['AlertArray'][$key.'馈出电流下下限告警'] = ($v[8][$i] >> $j) & 0x1 == 1;
                $dataArray[$key.'馈出电流下限告警'] = ($v[9][$i] >> $j) & 0x1 == 1 ? "告警" : "正常";
                $dataArray['AlertArray'][$key.'馈出电流下限告警'] = ($v[9][$i] >> $j) & 0x1 == 1;
                $dataArray[$key.'馈出电流上限告警'] = ($v[10][$i] >> $j) & 0x1 == 1 ? "告警" : "正常";
                $dataArray['AlertArray'][$key.'馈出电流上限告警'] = ($v[10][$i] >> $j) & 0x1 == 1;
                $dataArray[$key.'馈出电流上上限告警'] = ($v[11][$i] >> $j) & 0x1 == 1 ? "告警" : "正常";
                $dataArray['AlertArray'][$key.'馈出电流上上限告警'] = ($v[11][$i] >> $j) & 0x1 == 1;
                if ($lineIndex == 73) {
                    $lineNo = 2;
                    $lineIndex = 1;
                }
            }
        }
        
        $dataArray['输入监测单元通讯故障'] = ($v[12][0] >> 0) & 0x1 == 1 ? "是" : "否";
        $dataArray['输入监测单元1通讯故障'] = ($v[12][0] >> 1) & 0x1 == 1 ? "是" : "否";
        $dataArray['输入监测单元2通讯故障'] = ($v[12][0] >> 2) & 0x1 == 1 ? "是" : "否";
        $dataArray['馈出监测单元通讯故障'] = ($v[12][1] >> 0) & 0x1 == 1 ? "是" : "否";
        $dataArray['馈出监测单元1通讯故障'] = ($v[12][1] >> 1) & 0x1 == 1 ? "是" : "否";
        $dataArray['馈出监测单元2通讯故障'] = ($v[12][1] >> 2) & 0x1 == 1 ? "是" : "否";
        $dataArray['馈出监测单元3通讯故障'] = ($v[12][1] >> 3) & 0x1 == 1 ? "是" : "否";
        $dataArray['馈出监测单元4通讯故障'] = ($v[12][1] >> 4) & 0x1 == 1 ? "是" : "否";
        $dataArray['馈出监测单元5通讯故障'] = ($v[12][1] >> 5) & 0x1 == 1 ? "是" : "否";
        $dataArray['馈出监测单元6通讯故障'] = ($v[12][1] >> 6) & 0x1 == 1 ? "是" : "否";
        $dataArray['远控单元通讯故障'] = ($v[12][2] >> 0) & 0x1 == 1 ? "是" : "否";
        $dataArray['远控单元1通讯故障'] = ($v[12][2] >> 1) & 0x1 == 1 ? "是" : "否";
        $dataArray['远控单元2通讯故障'] = ($v[12][2] >> 2) & 0x1 == 1 ? "是" : "否";

        $v = unpack('v', substr($memData, 4 + 4 * 34 + 18 * 72 * 4 + 2 * 2 * 3 + 2 * 3 + 2 * 9 * 5 + 2 * 3, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData,  4 + 4 * 34 + 18 * 72 * 4 + 2 * 2 * 3 + 2 * 3 + 2 * 9 * 5 + 2 * 3 + 2, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
   }
}

 ?>
