<?php
function Get_jzlcharger_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case 'all':
            return array(0, $dataArray);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}


function Get_jzlcharger_RtData($memData, &$dataArray, $extraPara = false)
{
   if(empty($memData)) {
       $dataArray['无数据'] = true;
       $dataArray['更新时间'] = '无';
       $dataArray['错误'] = '数据长度不一致';
   } else {
       $dataArray['无数据'] = false;
       $dataArray['AlertArray'] = array();
       $v = unpack('f*', substr($memData, 4, 4*4));
       $dataArray["实际输出电压"] = number_format($v[1], 2)."V";
       $dataArray["电池电压"] = number_format($v[2], 2)."V";
       $dataArray["实际输出电流"] = number_format($v[3], 2)."A";
       $dataArray["充入容量"] = number_format($v[4], 2)."AH";
    
       $v = unpack("C", substr($memData, 4 + 4*4, 1));
       switch($v[1]){
            case 0:
                $dataArray["工作状态"] = "关机";
                break;
            case 1:
                $dataArray["工作状态"] = "充电中";
                break;
       }
       $v = unpack("S", substr($memData, 4 + 4*4 + 1, 2));
       $dataArray["模块限流点百分数"] = $v[1]."%"; 
       $val = unpack('v', substr($memData, 4 + 4*4 + 1 + 2 , 2));
       $year = $val[1];
       $val = unpack('C*', substr($memData, 4 + 4*4 + 1 + 2 + 2, 5));
       $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $val[1] . '-' . $val[2] . ' ' . $val[3] . ':' . $val[4] . ':' . $val[5]));
   }
}
