<?php
function Get_jzlcharger3_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case 'all':
            return array(0, $dataArray);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}


function Get_jzlcharger3_RtData($memData, &$dataArray, $extraPara = false)
{
   if(empty($memData)) {
       $dataArray['无数据'] = true;
       $dataArray['更新时间'] = '无';
       $dataArray['错误'] = '数据长度不一致';
   } else {
       $dataArray['无数据'] = false;
       $dataArray['AlertArray'] = array();
       $v = unpack('f*', substr($memData, 4, 4*2));
       $dataArray["实际输出电压"] = number_format($v[1], 2)."V";
       $dataArray["实际输出电流"] = number_format($v[2], 2)."A";
       $v = unpack('S*', substr($memData, 4 + 4*2, 2));
       $dataArray["模块限流点百分数"] = $v[1];
       $v = unpack('f*', substr($memData, 4 + 4*2 + 2, 4*2));
       $dataArray["模块当前输出电压上限"] = number_format($v[1], 2)."V";
       $dataArray["模块当前输出电压下限"] = number_format($v[2], 2)."V";
       $v = unpack('S*', substr($memData, 4 + 4*2 + 2 + 4*2, 2*8));
       $dataArray["模块开关状态量DI"] = $v[1];
       $dataArray["模块当前输出电压"] = number_format($v[2]/10, 1)."V";
       $dataArray["模块均充电压"] = number_format($v[3]/10, 1)."V";
       $dataArray["模块当前限流告警值"] = $v[4];
       $dataArray["模块手动电压"] = number_format($v[5]/10, 1)."V";
       switch($v[6]){
         case 0:
	    $dataArray["模式"] = "关机";
	    break;
         case 1:
	    $dataArray["模式"] = "充电";
	    break;
         case 2:
	    $dataArray["模式"] = "放电";
	    break;
       }
       $dataArray["boost输出电压"] = number_format($v[7]/10, 1)."V";
       $dataArray["模块输出电压采样"] = $v[8];
       $v = unpack('f*', substr($memData, 4 + 4*2 + 2 + 4*2 + 2*8, 4));
       $dataArray["充入容量"] = number_format($v[1], 2)."AH";
       $v = unpack('C', substr($memData, 4 + 4*2 + 2 + 4*2 + 2*8 + 4, 1));
       $dataArray["工作状态"] = $v[1] == 0 ? "关机" : "工作中";
    
       $val = unpack('v', substr($memData, 4 + 4*2 + 2 + 4*2 + 2*8 + 4 + 1 , 2));
       $year = $val[1];
       $val = unpack('C*', substr($memData, 4 + 4*2 + 2 + 4*2 + 2*8 + 4 + 1 + 2, 5));
       $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $val[1] . '-' . $val[2] . ' ' . $val[3] . ':' . $val[4] . ':' . $val[5]));
   }
}
