<?php
function Get_jzlmcc_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case 'all':
            return array(0, $dataArray);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}


function Get_jzlmcc_RtData($memData, &$dataArray, $extraPara = false)
{
   if(empty($memData)) {
       $dataArray['无数据'] = true;
       $dataArray['更新时间'] = '无';
       $dataArray['错误'] = '数据长度不一致';
   } else {
       $dataArray['无数据'] = false;
       $v = unpack('f*', substr($memData, 4, 24 * 4));
       foreach ($v as $key => $val) {
           $dataArray["电池".($key)."电压"] = number_format($val,3)."V";
       }
       $val = unpack('v', substr($memData, 4 + 24 * 4 , 2));
       $year = $val[1];
       $val = unpack('C*', substr($memData, 4 + 24 * 4 + 2, 5));
       $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $val[1] . '-' . $val[2] . ' ' . $val[3] . ':' . $val[4] . ':' . $val[5]));
   }
}
