<?php
function Get_k200_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '温度设定点':
            return array(0,  $dataArray['设定温度（C°）']);
        case '回风温度':
            return array(0, $dataArray['回风温度（C°）']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}       

//20230309潘注释掉，换新写法
//function Get_k200_RtData($memData , &$dataArray , $extraPara = false)
//{
//    if (strlen($memData) != 52) {
//        $dataArray['无数据'] = true;
//        $dataArray['更新时间'] = '无';
//        $dataArray['错误'] = '数据长度不一致';
//    } else {
//	$dataArray['无数据'] = false;
//        $v = unpack('f*', substr($memData, 5, 4));
//        $dataArray['设定温度（C°）'] = number_format($v[1], 2);
//        $v = unpack('f*', substr($memData, 16, 4));
//        $dataArray['回风温度（C°）'] = number_format($v[1], 2);
//        $v = unpack('v', substr($memData, 45, 2));
//        $year = $v[1] ;
//        $v = unpack('C*', substr($memData, 47, 5));
//        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
//    }
//}

function Get_k200_RtData($memData , &$dataArray , $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $v = unpack('C*', substr($memData, 4, 1));
        $dataArray['设置开关机'] = ($v[1] == 1) ? "开机" : "关机";
        $v = unpack('f*', substr($memData, 5, 4*2));
        $dataArray['设定温度（℃）'] = number_format($v[1], 2);
        $dataArray['设定湿度（％）'] = number_format($v[2], 2);
        $v = unpack('C*', substr($memData, 5 + 4*2, 6 ));
        $dataArray['加湿'] = $v[1] > 0 ? "启动" : "未启动" ;
        $dataArray['除湿'] = $v[2] > 0 ? "启动" : "未启动" ;
        $dataArray['制热'] = $v[3] > 0 ? "启动" : "未启动" ;
        $dataArray['制冷'] = $v[4] > 0 ? "启动" : "未启动" ;
        $dataArray['风机'] = $v[5] > 0 ? "启动" : "未启动" ;
        $v = unpack('f*', substr($memData, 5 + 4*2 + 6, 4*2));
        $dataArray['回风温度（℃）'] = number_format($v[1], 2);
        $dataArray['回风湿度（％）'] = number_format($v[2], 2);
        $v = unpack('C*', substr($memData, 5 + 4*2 + 6 + 4*2, 15));
        $dataArray['压缩机低压'] = $v[1] > 0 ? "告警" : "正常" ;
        $dataArray['压缩机高压'] = $v[2] > 0 ? "告警" : "正常" ;
        $dataArray['气流丢失'] = $v[3] > 0 ? "告警" : "正常" ;
        $dataArray['风机过载'] = $v[4] > 0 ? "告警" : "正常" ;
        $dataArray['加热器过载']  = $v[5] > 0 ? "告警" : "正常" ;
        $dataArray['空气过滤网']  = $v[6] > 0 ? "告警" : "正常" ;
        $dataArray['高温告警']  = $v[7] > 0 ? "告警" : "正常" ;
        $dataArray['低温告警']  = $v[8] > 0 ? "告警" : "正常" ;
        $dataArray['高湿告警']  = $v[9] > 0 ? "告警" : "正常" ;
        $dataArray['回风温度探头故障']  = $v[11] > 0 ? "告警" : "正常" ;
        $dataArray['送风温度探头故障']  = $v[12] > 0 ? "告警" : "正常" ;
        $dataArray['回风湿度探头告警']  = $v[13] > 0 ? "告警" : "正常" ;
        $dataArray['室外温度探头告警']  = $v[14] > 0 ? "告警" : "正常" ;
        $dataArray['送风温度告警']  = $v[15] > 0 ? "告警" : "正常" ;
        $v = unpack('C*', substr($memData, 5 + 4*2 + 6 + 4*2 + 15, 9));
        $dataArray['加湿器电流过大']  = $v[1] > 0 ? "告警" : "正常" ;
        $dataArray['加湿器缺水']  = $v[2] > 0 ? "告警" : "正常" ;
        $dataArray['无加湿电流']  = $v[3] > 0 ? "告警" : "正常" ;
        $dataArray['溢流告警']  = $v[4] > 0 ? "告警" : "正常" ;
        $dataArray['用户告警']  = $v[5] > 0 ? "告警" : "正常" ;
        $dataArray['烟雾告警']  = $v[6] > 0 ? "告警" : "正常" ;
        $dataArray['压缩机2高压']  = $v[7] > 0 ? "告警" : "正常" ;
        $dataArray['压缩机2低压']  = $v[8] > 0 ? "告警" : "正常" ;
        $dataArray['水流开关告警']  = $v[9] > 0 ? "告警" : "正常" ;
        $v = unpack('v', substr($memData, 5 + 4*2 + 6 + 4*2 + 15 + 9, 2));
        $year = $v[1] ;
        $v = unpack('C*', substr($memData, 5 + 4*2 + 6 + 4*2 + 15 + 9 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

?>
