<?php

function Get_kn10_DeviceIoControl_ErrorMsg($ret){
    switch($ret){
        case 1:
            return "执行成功";
        case 3:
            return "执行失败，校验不符";
        default:
            return "未知错误";
        }
}

function Get_kn10_DeviceIoControl_Parameter($action, $parameter)
{
    if(in_array($action, array(106,108)) && count($parameter) == 1){
        return pack("S", intval($parameter[0]));
    }
    return -1;
}

function Get_kn10_Standard_Variable($dataArray, $varname){

    switch ($varname){
        case '温度设定点':
            return array(0,  $dataArray['温度设定点']);
        case '回风温度':
            return array(0, $dataArray['回风温度']);
        case '回风湿度':
            return array(0, $dataArray['回风湿度']);
        case '开关机状态':
            return array(0, $dataArray['开关机状态']);
        case "冷冻水进水温度":
            return array(0,$dataArray['传感器NTC2']);
        case "冷冻水出水温度":
            return array(0,$dataArray['传感器NTC4']);            
         case '风机输出比例':
            return array(0,  $dataArray['风机输出']);
        case '普通空调制冷状态运行':
            return array(0, $dataArray['制冷输出']);
        case '普通空调加热状态运行':
            return array(0, $dataArray['加热输出']);

         case '精密空调加湿状态':
            return array(0,  $dataArray['加湿输出']);
        case '专用空调温度过高告警':
            return array(0, $dataArray['温度高限']);
        case '专用空调温度过低告警':
            return array(0, $dataArray['温度低限']);

         case '专用空调湿度过高告警':
            return array(0,  $dataArray['加湿高限']);
        case '专用空调湿度过低告警':
            return array(0, $dataArray['加湿低限']);
        case '专用空调湿度':
            return array(0, $dataArray['温度设定值']);
        case '专用空调温度':
            return array(0, $dataArray['湿度阈值']);
        case '专用空调冷冻水进水温度高告警':
            return array(0, $dataArray['冷冻水进水温度高限']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_kn10_RtData($memData , &$dataArray , $extraPara = false)
{
    //$memData = $CI->cache->get(416075368);
    if(empty($memData)){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $v = unpack('C*',substr($memData,4,1));
        $dataArray['开关机状态'] = $v[1] == 1 ? "开机" : "关机";

        $v = unpack('S*',substr($memData,129,210*2));
        $dataArray["风机输出"] = intval($v[1]*100/255);
        $dataArray["制冷输出"]= intval($v[2]*100/255);
        $dataArray["加热输出"] = intval($v[3]*100/255);
        $dataArray["加湿输出"]= intval($v[4]*100/255);
        $dataArray["温度高限"]=$v[181];
        $dataArray["温度低限"]= $v[182];
        $dataArray["加湿高限"]= $v[183];
        $dataArray["加湿低限"] = $v[184];
        $dataArray["温度设定值"]= $v[187];
        $dataArray["湿度阈值"]= $v[190];
         $dataArray["冷冻水进水温度高限"]= $v[203];

        $dataArray["回风温度"] = $v[5]/10;
        $dataArray["回风湿度"] = $v[6]/10;

        $dataArray["传感器NTC2"] = $v[10]/10;
        $dataArray["传感器NTC4"] = $v[12]/10;

        $dataArray["湿度设定点"] =  $v[189];
        $dataArray["温度设定点"] = $v[187];
        $dataArray["风机最大输出值"] = $v[174];
        $v = unpack('v',substr($memData,549,2));

        $year = $v[1];
        $v = unpack('C*',substr($memData,551,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

?>
