<?php
function _kstarups_ShowAlert(&$dataArray, $label, $value, $vsValue)
{
    // if($value == 0xFFFF || $value == 0x20){
    //   $dataArray[$label] = "无效值";
    // }else{
      $dataArray[$label] = $value == $vsValue ? '正常' : '告警';
      $dataArray['AlertArray'][$label] = $value != $vsValue;
    //}
}

function _kstarups_BatteryV(&$dataArray, $memData, $prefix, $index  )
{
    $offset = 0;
      $v = unpack("S*" , $memData);
      
        $name = $prefix.sprintf("#%s电池电压", strval($index));
          $dataArray[$name] = number_format($v[1]/100, 2)."V";
}
function _kstarups_BatteryT(&$dataArray, $memData, $prefix, $index  )
{
    $offset = 0;
      $v = unpack("s*" , $memData);
      
        $name = $prefix.sprintf("#%s电池温度", strval($index));
          $dataArray[$name]  = ( ($v[1] == 0x7FFF) ? "" : (($v[1]/10)."°C"));
}
function _kstarups_BatteryR(&$dataArray, $memData, $prefix, $index  )
{
    $offset = 0;
      $v = unpack("S*" , $memData);
      
        $name = $prefix.sprintf("#%s电池内阻", strval($index));
          $dataArray[$name] = number_format($v[1]/100, 2)."mΩ";
}
function _kstarups_BatteryInfo(&$dataArray, $memData, $prefix, $index  )
{
    $offset = 0;
    $v = unpack("S*" , $memData);
      
      $lMemData = substr($memData, $offset, 2);
      _kstarups_BatteryV($dataArray, $lMemData, $prefix, $index);
      
      $lMemData = substr($memData, $offset, 2);
      _kstarups_BatteryT($dataArray, $lMemData, $prefix, $index);
      
      $lMemData = substr($memData, $offset, 2);
      _kstarups_BatteryR($dataArray, $lMemData, $prefix, $index);
}
function _kstarups_ModuleData1(&$dataArray, $memData, $prefix, $index  )
{
    $offset = 0;
      $v = unpack("S*" , $memData);
      
        $name = $prefix.sprintf("模块%s-（逆变）正母线电压", $index);
          $dataArray[$name] = number_format($v[1]/10, 2)."V";
      
        $name = $prefix.sprintf("模块%s-（逆变）负母线电压", $index);
          $dataArray[$name] = number_format($v[2]/10, 2)."V";
      
        $name = $prefix.sprintf("模块%s-逆变A相电压", $index);
          $dataArray[$name] = number_format($v[3]/10, 2)."V";
      
        $name = $prefix.sprintf("模块%s-逆变B相电压", $index);
          $dataArray[$name] = number_format($v[4]/10, 2)."V";
      
        $name = $prefix.sprintf("模块%s-逆变C相电压", $index);
          $dataArray[$name] = number_format($v[5]/10, 2)."V";
      
        $name = $prefix.sprintf("模块%s-逆变A相电流", $index);
          $dataArray[$name] = number_format($v[6]/10, 2)."A";
      
        $name = $prefix.sprintf("模块%s-逆变B相电流", $index);
          $dataArray[$name] = number_format($v[7]/10, 2)."A";
      
        $name = $prefix.sprintf("模块%s-逆变C相电流", $index);
          $dataArray[$name] = number_format($v[8]/10, 2)."A";
      
        $name = $prefix.sprintf("模块%s-逆变频率", $index);
          $dataArray[$name] = number_format($v[9]/10, 2)."Hz";
      
        $name = $prefix.sprintf("模块%s-整流温度", $index);
          $dataArray[$name] = number_format($v[10]/10, 2)."℃";
      
        $name = $prefix.sprintf("模块%s-逆变温度", $index);
          $dataArray[$name] = number_format($v[11]/10, 2)."℃";
      
        $name = $prefix.sprintf("模块%s-整流模块通讯联机", $index);
          $dataArray[$name]  = (($v[13] >> 15)&0x1) ? "通讯联机" : "通讯无";
      
        $name = $prefix.sprintf("模块%s-整流模块负组电池均浮充", $index);
          $dataArray[$name]  = (($v[12] >> 6)&0x1) ? "均充" : "浮充";
      
        $name = $prefix.sprintf("模块%s-整流模块正组电池均浮充", $index);
          $dataArray[$name]  = (($v[12] >> 7)&0x1) ? "均充" : "浮充";
      
        $name = $prefix.sprintf("模块%s-整流模块电池充电", $index);
          $dataArray[$name]  = (($v[12] >> 8)&0x1) ? "电池充电" : "未充电";
      
        $name = $prefix.sprintf("模块%s-整流模块电池自检", $index);
          $dataArray[$name]  = (($v[12] >> 9)&0x1) ? "电池自检中" : "未自检";
      
        $name = $prefix.sprintf("模块%s-整流模块输入供电模式", $index);
          $dataArray[$name]  = (($v[12] >> 10)&0x1) ? "输入供电" : "电池供电";
      
        $name = $prefix.sprintf("模块%s-整流模块输入供电状态", $index);
          $dataArray[$name]  = (($v[12] >> 11)&0x1) ? "工作" : "不工作";
      
        $name = $prefix.sprintf("模块%s-整流模块整流器限流", $index);
          $dataArray[$name]  = (($v[12] >> 12)&0x1) ? "限流状态" : "不限流";
      
        $name = $prefix.sprintf("模块%s-整流模块紧急关机", $index);
          $dataArray[$name]  = (($v[12] >> 13)&0x1) ? "紧急关机" : "正常";
      
        $name = $prefix.sprintf("模块%s-整流模块整流器状态", $index);
          $dataArray[$name]  = (($v[12] >> 14)&0x1) ? "工作" : "停止";
      
        $name = $prefix.sprintf("模块%s-整流模块输入空开状态", $index);
          $dataArray[$name]  = (($v[12] >> 15)&0x1) ? "闭合" : "断开";
      
        $name = $prefix.sprintf("模块%s-逆变模块逆变待机(ECO状态位)", $index);
          $dataArray[$name]  = (($v[15] >> 11)&0x1) ? "有效" : "无效";
      
        $name = $prefix.sprintf("模块%s-逆变模块LBS系统激活", $index);
          $dataArray[$name]  = (($v[15] >> 12)&0x1) ? "有效" : "无效";
      
        $name = $prefix.sprintf("模块%s-并机系统转旁路", $index);
          $dataArray[$name]  = (($v[15] >> 13)&0x1) ? "有效" : "无效";
      
        $name = $prefix.sprintf("模块%s-逆变模块负载冲击切旁路", $index);
          $dataArray[$name]  = (($v[15] >> 14)&0x1) ? "有效" : "无效";
      
        $name = $prefix.sprintf("模块%s-逆变模块过载延时到关机", $index);
          $dataArray[$name]  = (($v[15] >> 15)&0x1) ? "有效" : "无效";
      
        $name = $prefix.sprintf("模块%s-逆变模块切换次数到", $index);
          $dataArray[$name]  = (($v[14] >> 0)&0x1) ? "有效" : "无效";
      
        $name = $prefix.sprintf("模块%s-逆变模块逆变主机", $index);
          $dataArray[$name]  = (($v[14] >> 1)&0x1) ? "有效" : "无效";
      
        $name = $prefix.sprintf("模块%s-逆变模块启动容量不足", $index);
          $dataArray[$name]  = (($v[14] >> 2)&0x1) ? "有效" : "无效";
      
        $name = $prefix.sprintf("模块%s-逆变模块紧急关机提示", $index);
          $dataArray[$name]  = (($v[14] >> 3)&0x1) ? "有效" : "无效";
      
        $name = $prefix.sprintf("模块%s-逆变模块关机将导致过载告警", $index);
          $dataArray[$name]  = (($v[14] >> 4)&0x1) ? "有效" : "无效";
      
        $name = $prefix.sprintf("模块%s-逆变模块关机将导致断电告警", $index);
          $dataArray[$name]  = (($v[14] >> 5)&0x1) ? "闭合" : "无效";
      
        $name = $prefix.sprintf("模块%s-逆变模块间断切换提示", $index);
          $dataArray[$name]  = (($v[14] >> 6)&0x1) ? "闭合" : "无效";
      
        $name = $prefix.sprintf("模块%s-逆变模块UPS供电状态", $index);
          $dataArray[$name]  = (($v[14] >> 8)&0x1) ? "旁路供电" : "均不供电";
      
        $name = $prefix.sprintf("模块%s-逆变模块开关机状态", $index);
          
          switch((($v[14] >> 9)&0x3)){
            case 0:
            $dataArray[$name] = "关机";
              break;
            case 1:
            $dataArray[$name] = "软启动";
              break;
            case 2:
            $dataArray[$name] = "启动完毕未供电";
              break;
            case 3:
            $dataArray[$name] = "正常供电中";
              break;
            default:
            $dataArray[$name]  = "无效值";
              break;
          }
      
        $name = $prefix.sprintf("模块%s-逆变模块外部输出空开状态", $index);
          $dataArray[$name]  = (($v[14] >> 11)&0x1) ? "闭合" : "断开";
      
        $name = $prefix.sprintf("模块%s-逆变模块旁路柜旁路空开状态", $index);
          $dataArray[$name]  = (($v[14] >> 12)&0x1) ? "闭合" : "断开";
      
        $name = $prefix.sprintf("模块%s-逆变模块维修旁路空开状态", $index);
          $dataArray[$name]  = (($v[14] >> 13)&0x1) ? "闭合" : "断开";
      
        $name = $prefix.sprintf("模块%s-逆变模块输出空开状态", $index);
          $dataArray[$name]  = (($v[14] >> 14)&0x1) ? "闭合" : "断开";
      
        $name = $prefix.sprintf("模块%s-逆变模块旁路空开状态", $index);
          $dataArray[$name]  = (($v[14] >> 15)&0x1) ? "闭合" : "断开";
      
        $name = $prefix.sprintf("模块%s-整流模块市电电压异常", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[17] >> 6)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块市电频率异常", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[17] >> 7)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块电池电压预告警", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[17] >> 8)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块电池电压高", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[17] >> 9)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块电池电压低", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[17] >> 10)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块负组电池充电器故障", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[17] >> 11)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块正组电池充电器故障", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[17] >> 12)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块电池无", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[17] >> 13)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块电池反", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[17] >> 14)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块输入缺零", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[17] >> 15)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块软启动失败", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[16] >> 0)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块输入电压相序反", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[16] >> 1)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块正负母线压差大", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[16] >> 2)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块母线电压欠压", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[16] >> 3)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块母线电压过压", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[16] >> 4)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块风扇电源故障", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[16] >> 5)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块风扇故障", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[16] >> 6)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块电池充电晶闸管故障", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[16] >> 7)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块电池放电晶闸管故障", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[16] >> 8)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块输入晶闸管故障", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[16] >> 9)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块辅助电源2故障", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[16] >> 10)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块辅助电源1故障", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[16] >> 11)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块整流过流故障", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[16] >> 12)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块逆变模块过温", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[16] >> 13)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块整流模块过温", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[16] >> 14)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-整流模块整流器故障", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[16] >> 15)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块BUS电压异常", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[19] >> 7)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块回馈保护", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[19] >> 8)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块旁路过流", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[19] >> 9)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块逆变直流分量过大", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[19] >> 10)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块并机过载", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[19] >> 11)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块过载", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[19] >> 12)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块开机无效", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[19] >> 13)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块上电初始化故障", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[19] >> 14)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块LBS超跟踪", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[19] >> 15)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块并机继电器故障", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[18] >> 0)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块并机连线故障", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[18] >> 1)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块熔丝断", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[18] >> 2)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块IGBT过流", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[18] >> 3)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块旁路超保护", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[18] >> 4)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块旁路超跟踪", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[18] >> 5)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块不同步", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[18] >> 6)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块旁路反序", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[18] >> 7)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块并机均流故障", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[18] >> 8)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块CAN通信故障", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[18] >> 9)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块旁路晶闸管断路故障", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[18] >> 10)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块旁路晶闸管短路故障", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[18] >> 11)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块逆变晶闸管断路故障", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[18] >> 12)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块逆变晶闸管短路故障", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[18] >> 13)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块逆变桥臂直通", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[18] >> 14)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-逆变模块逆变器故障", $index);
          _kstarups_ShowAlert($dataArray, $name, (($v[18] >> 15)&0x1), 0);
      
        $name = $prefix.sprintf("模块%s-（整流）正母线电压", strval($index));
          $dataArray[$name] = number_format($v[20]/10, 2)."V";
      
        $name = $prefix.sprintf("模块%s-（整流）负母线电压", strval($index));
          $dataArray[$name] = number_format($v[21]/10, 2)."V";
}

function Get_kstarups_RtData($memData, &$dataArray, $extraPara = false){
    if($memData == false){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        $offset = 4;
            $v = unpack("C*" , substr($memData , $offset, 31));
$lMemData = substr($memData , $offset, 31);
      $lOffset = 0;
      
        switch($v[1]){
          case 0:
          $dataArray["整机状态位"]["输入空开状态"] = "闭合";
            break;
          case 1:
          $dataArray["整机状态位"]["输入空开状态"] = "断开";
            break;
          default:
            $dataArray["整机状态位"]["输入空开状态"] = "无效值";
            break;
        }
      

      
        switch($v[2]){
          case 0:
          $dataArray["整机状态位"]["输出空开状态"] = "闭合";
            break;
          case 1:
          $dataArray["整机状态位"]["输出空开状态"] = "断开";
            break;
          default:
            $dataArray["整机状态位"]["输出空开状态"] = "无效值";
            break;
        }
      

      
        switch($v[3]){
          case 0:
          $dataArray["整机状态位"]["维修旁路空开状态"] = "闭合";
            break;
          case 1:
          $dataArray["整机状态位"]["维修旁路空开状态"] = "断开";
            break;
          default:
            $dataArray["整机状态位"]["维修旁路空开状态"] = "无效值";
            break;
        }
      

      
        switch($v[6]){
          case 0:
          $dataArray["整机状态位"]["外部输出空开状态"] = "闭合";
            break;
          case 1:
          $dataArray["整机状态位"]["外部输出空开状态"] = "断开";
            break;
          default:
            $dataArray["整机状态位"]["外部输出空开状态"] = "无效值";
            break;
        }
      

      
        switch($v[7]){
          case 0:
          $dataArray["整机状态位"]["逆变主机"] = "不在位";
            break;
          case 1:
          $dataArray["整机状态位"]["逆变主机"] = "在位";
            break;
          default:
            $dataArray["整机状态位"]["逆变主机"] = "无效值";
            break;
        }
      

      
        switch($v[8]){
          case 0:
          $dataArray["整机状态位"]["逆变主机(ECO状态)"] = "不在位";
            break;
          case 1:
          $dataArray["整机状态位"]["逆变主机(ECO状态)"] = "在位";
            break;
          default:
            $dataArray["整机状态位"]["逆变主机(ECO状态)"] = "无效值";
            break;
        }
      

      
        switch($v[10]){
          case 0:
          $dataArray["整机状态位"]["电池自检"] = "未自检";
            break;
          case 1:
          $dataArray["整机状态位"]["电池自检"] = "自检中";
            break;
          default:
            $dataArray["整机状态位"]["电池自检"] = "无效值";
            break;
        }
      

      
        switch($v[11]){
          case 0:
          $dataArray["整机状态位"]["电池充电"] = "未充电";
            break;
          case 1:
          $dataArray["整机状态位"]["电池充电"] = "电池充电";
            break;
          default:
            $dataArray["整机状态位"]["电池充电"] = "无效值";
            break;
        }
      

      
        switch($v[12]){
          case 0:
          $dataArray["整机状态位"]["正组电池均充"] = "未均充";
            break;
          case 1:
          $dataArray["整机状态位"]["正组电池均充"] = "均充";
            break;
          default:
            $dataArray["整机状态位"]["正组电池均充"] = "无效值";
            break;
        }
      

      
        switch($v[13]){
          case 0:
          $dataArray["整机状态位"]["负组电池均充"] = "未均充";
            break;
          case 1:
          $dataArray["整机状态位"]["负组电池均充"] = "均充";
            break;
          default:
            $dataArray["整机状态位"]["负组电池均充"] = "无效值";
            break;
        }
      

      
        switch($v[14]){
          case 0:
          $dataArray["整机状态位"]["整流器状态"] = "停止";
            break;
          case 1:
          $dataArray["整机状态位"]["整流器状态"] = "工作";
            break;
          default:
            $dataArray["整机状态位"]["整流器状态"] = "无效值";
            break;
        }
      

      
        switch($v[15]){
          case 0:
          $dataArray["整机状态位"]["整流器限流"] = "不限流";
            break;
          case 1:
          $dataArray["整机状态位"]["整流器限流"] = "限流";
            break;
          default:
            $dataArray["整机状态位"]["整流器限流"] = "无效值";
            break;
        }
      

      
        switch($v[16]){
          case 0:
          $dataArray["整机状态位"]["输入供电状态"] = "不工作";
            break;
          case 1:
          $dataArray["整机状态位"]["输入供电状态"] = "工作";
            break;
          default:
            $dataArray["整机状态位"]["输入供电状态"] = "无效值";
            break;
        }
      

      
        switch($v[17]){
          case 0:
          $dataArray["整机状态位"]["输入供电模式"] = "电池供电";
            break;
          case 1:
          $dataArray["整机状态位"]["输入供电模式"] = "输入供电";
            break;
          default:
            $dataArray["整机状态位"]["输入供电模式"] = "无效值";
            break;
        }
      

      
        switch($v[18]){
          case 0:
          $dataArray["整机状态位"]["逆变开关机状态1"] = "关机";
            break;
          case 1:
          $dataArray["整机状态位"]["逆变开关机状态1"] = "软启动";
            break;
          case 2:
          $dataArray["整机状态位"]["逆变开关机状态1"] = "启动完毕未供电";
            break;
          case 3:
          $dataArray["整机状态位"]["逆变开关机状态1"] = "正常供电中";
            break;
          default:
            $dataArray["整机状态位"]["逆变开关机状态1"] = "无效值";
            break;
        }
      

      
        switch($v[19]){
          case 0:
          $dataArray["整机状态位"]["逆变开关机状态2"] = "关机";
            break;
          case 1:
          $dataArray["整机状态位"]["逆变开关机状态2"] = "软启动";
            break;
          case 2:
          $dataArray["整机状态位"]["逆变开关机状态2"] = "启动完毕未供电";
            break;
          case 3:
          $dataArray["整机状态位"]["逆变开关机状态2"] = "正常供电中";
            break;
          default:
            $dataArray["整机状态位"]["逆变开关机状态2"] = "无效值";
            break;
        }
      

      
        switch($v[20]){
          case 0:
          $dataArray["整机状态位"]["UPS供电状态1"] = "无状态";
            break;
          case 1:
          $dataArray["整机状态位"]["UPS供电状态1"] = "逆变供电";
            break;
          default:
            $dataArray["整机状态位"]["UPS供电状态1"] = "无效值";
            break;
        }
      

      
        switch($v[21]){
          case 0:
          $dataArray["整机状态位"]["UPS供电状态2"] = "无状态";
            break;
          case 1:
          $dataArray["整机状态位"]["UPS供电状态2"] = "旁路供电";
            break;
          default:
            $dataArray["整机状态位"]["UPS供电状态2"] = "无效值";
            break;
        }
      

      
        switch($v[22]){
          case 0:
          $dataArray["整机状态位"]["间断切换提示"] = "无效";
            break;
          case 1:
          $dataArray["整机状态位"]["间断切换提示"] = "有效";
            break;
          default:
            $dataArray["整机状态位"]["间断切换提示"] = "无效值";
            break;
        }
      

      
        switch($v[23]){
          case 0:
          $dataArray["整机状态位"]["关机将导致断电告警"] = "无效";
            break;
          case 1:
          $dataArray["整机状态位"]["关机将导致断电告警"] = "有效";
            break;
          default:
            $dataArray["整机状态位"]["关机将导致断电告警"] = "无效值";
            break;
        }
      

      
        switch($v[24]){
          case 0:
          $dataArray["整机状态位"]["关机将导致过载告警"] = "无效";
            break;
          case 1:
          $dataArray["整机状态位"]["关机将导致过载告警"] = "有效";
            break;
          default:
            $dataArray["整机状态位"]["关机将导致过载告警"] = "无效值";
            break;
        }
      

      
        switch($v[26]){
          case 0:
          $dataArray["整机状态位"]["启动容量不足"] = "无效";
            break;
          case 1:
          $dataArray["整机状态位"]["启动容量不足"] = "有效";
            break;
          default:
            $dataArray["整机状态位"]["启动容量不足"] = "无效值";
            break;
        }
      

      
        switch($v[27]){
          case 0:
          $dataArray["整机状态位"]["过载延时到关机"] = "无效";
            break;
          case 1:
          $dataArray["整机状态位"]["过载延时到关机"] = "有效";
            break;
          default:
            $dataArray["整机状态位"]["过载延时到关机"] = "无效值";
            break;
        }
      

      
        switch($v[28]){
          case 0:
          $dataArray["整机状态位"]["负载冲击切旁路"] = "无效";
            break;
          case 1:
          $dataArray["整机状态位"]["负载冲击切旁路"] = "有效";
            break;
          default:
            $dataArray["整机状态位"]["负载冲击切旁路"] = "无效值";
            break;
        }
      

      
        switch($v[29]){
          case 0:
          $dataArray["整机状态位"]["并机系统转旁路"] = "无效";
            break;
          case 1:
          $dataArray["整机状态位"]["并机系统转旁路"] = "有效";
            break;
          default:
            $dataArray["整机状态位"]["并机系统转旁路"] = "无效值";
            break;
        }
      

      
        switch($v[30]){
          case 0:
          $dataArray["整机状态位"]["电池电压低关机"] = "无效";
            break;
          case 1:
          $dataArray["整机状态位"]["电池电压低关机"] = "有效";
            break;
          default:
            $dataArray["整机状态位"]["电池电压低关机"] = "无效值";
            break;
        }
      

      
        switch($v[31]){
          case 0:
          $dataArray["整机状态位"]["切换次数到"] = "无效";
            break;
          case 1:
          $dataArray["整机状态位"]["切换次数到"] = "有效";
            break;
          default:
            $dataArray["整机状态位"]["切换次数到"] = "无效值";
            break;
        }
      

      $offset += 31;

            $v = unpack("C*" , substr($memData , $offset, 33));
$lMemData = substr($memData , $offset, 33);
      $lOffset = 0;
      
        _kstarups_ShowAlert($dataArray["整机告警位"], "整流器故障", $v[1], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "逆变器故障", $v[2], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "辅助电源故障", $v[3], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "风扇故障", $v[4], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "输入晶闸管故障", $v[5], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "逆变晶闸管故障", $v[6], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "旁路晶闸管故障", $v[7], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "熔丝断", $v[8], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "母线电压异常", $v[9], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "初始化故障", $v[10], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "充电器故障", $v[12], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "并机故障", $v[13], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "开机无效", $v[14], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "逆变直流分量过大", $v[15], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "输入电压相序反", $v[16], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "输入缺零", $v[17], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "旁路反序", $v[18], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "电池反", $v[19], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "电池无", $v[20], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "回馈保护", $v[21], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "过载", $v[24], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "并机过载", $v[25], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "电池电压低", $v[26], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "电池电压高", $v[27], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "电池欠压预告警", $v[28], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "市电频率异常", $v[29], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "市电电压异常", $v[30], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "旁路超跟踪", $v[31], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "旁路超保护", $v[32], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位"], "旁路过流", $v[33], 0);
      

      $offset += 33;

            $v = unpack("S*" , substr($memData , $offset, 2*40));
$lMemData = substr($memData , $offset, 2*40);
      $lOffset = 0;
      
        $dataArray["整机数据"]["输入A相电压"] = number_format($v[1]/10, 2)."V";
      

      
        $dataArray["整机数据"]["输入B相电压"] = number_format($v[2]/10, 2)."V";
      

      
        $dataArray["整机数据"]["输入C相电压"] = number_format($v[3]/10, 2)."V";
      

      
        $dataArray["整机数据"]["输入频率"] = number_format($v[4]/10, 2)."Hz";
      

      
        $dataArray["整机数据"]["输入A相电流"] = number_format($v[5]/10, 2)."A";
      

      
        $dataArray["整机数据"]["输入B相电流"] = number_format($v[6]/10, 2)."A";
      

      
        $dataArray["整机数据"]["输入C相电流"] = number_format($v[7]/10, 2)."A";
      

      
        $dataArray["整机数据"]["输入A相功率因数"] = number_format($v[8]/100, 2);
      

      
        $dataArray["整机数据"]["输入B相功率因数"] = number_format($v[9]/100, 2);
      

      
        $dataArray["整机数据"]["输入C相功率因数"] = number_format($v[10]/100, 2);
      

      
        $dataArray["整机数据"]["输出A相电压"] = number_format($v[11]/10, 2)."V";
      

      
        $dataArray["整机数据"]["输出B相电压"] = number_format($v[12]/10, 2)."V";
      

      
        $dataArray["整机数据"]["输出C相电压"] = number_format($v[13]/10, 2)."V";
      

      
        $dataArray["整机数据"]["输出频率"] = number_format($v[14]/10, 2)."Hz";
      

      
        $dataArray["整机数据"]["输出A相电流"] = number_format($v[15]/10, 2)."A";
      

      
        $dataArray["整机数据"]["输出B相电流"] = number_format($v[16]/10, 2)."A";
      

      
        $dataArray["整机数据"]["输出C相电流"] = number_format($v[17]/10, 2)."A";
      

      
        $dataArray["整机数据"]["输出A相有功功率"] = number_format($v[18]/100, 2);
      

      
        $dataArray["整机数据"]["输出B相有功功率"] = number_format($v[19]/100, 2);
      

      
        $dataArray["整机数据"]["输出C相有功功率"] = number_format($v[20]/100, 2);
      

      
        $dataArray["整机数据"]["输出A相负载率"] = number_format($v[21], 2)."%";
      

      
        $dataArray["整机数据"]["输出B相负载率"] = number_format($v[22], 2)."%";
      

      
        $dataArray["整机数据"]["输出C相负载率"] = number_format($v[23], 2)."%";
      

      
        $dataArray["整机数据"]["输入A相负载峰值比"] = number_format($v[24]/100, 2);
      

      
        $dataArray["整机数据"]["输入B相负载峰值比"] = number_format($v[25]/100, 2);
      

      
        $dataArray["整机数据"]["输入C相负载峰值比"] = number_format($v[26]/100, 2);
      

      
        $dataArray["整机数据"]["旁路A相电压"] = number_format($v[27]/10, 2)."V";
      

      
        $dataArray["整机数据"]["旁路B相电压"] = number_format($v[28]/10, 2)."V";
      

      
        $dataArray["整机数据"]["旁路C相电压"] = number_format($v[29]/10, 2)."V";
      

      
        $dataArray["整机数据"]["旁路频率"] = number_format($v[30]/10, 2)."Hz";
      

      
        $dataArray["整机数据"]["正组电池电压"] = number_format($v[31]/10, 2)."V";
      

      
        $dataArray["整机数据"]["负组电池电压"] = number_format($v[32]/10, 2)."V";
      

      
        $dataArray["整机数据"]["正组电池放电电流"] = number_format($v[33]/10, 2)."A";
      

      
        $dataArray["整机数据"]["负组电池放电电流"] = number_format($v[34]/10, 2)."A";
      

      
        $dataArray["整机数据"]["正组电池充电电流"] = number_format($v[35]/10, 2)."A";
      

      
        $dataArray["整机数据"]["负组电池充电电流"] = number_format($v[36]/10, 2)."A";
      

      
        $dataArray["整机数据"]["电池容量率"] = number_format($v[37], 2)."%";
      

      
        $dataArray["整机数据"]["电池后备时间"] = number_format($v[38], 2)."分钟";
      

      
        $dataArray["整机数据"]["电池温度"] = number_format($v[39]/10, 2)."℃";
      

      
        $dataArray["整机数据"]["环境温度"] = number_format($v[40]/10, 2)."℃";
      

      $offset += 80;

            $v = unpack("S*" , substr($memData , $offset, 2*8));
$lMemData = substr($memData , $offset, 2*8);
      $lOffset = 0;
      
        $dataArray["并机数据"]["并机上电总台数"] = number_format($v[1], 2);
      

      
        $dataArray["并机数据"]["并机逆变供电台数"] = number_format($v[2], 2);
      

      
        $dataArray["并机数据"]["并机输出A相总视在功率"] = number_format($v[3]/1000, 2)."kVA";
      

      
        $dataArray["并机数据"]["并机输出B相总视在功率"] = number_format($v[4]/1000, 2)."kVA";
      

      
        $dataArray["并机数据"]["并机输出C相总视在功率"] = number_format($v[5]/1000, 2)."kVA";
      

      
        $dataArray["并机数据"]["并机输出A相有功功率"] = number_format($v[6]/1000, 2)."kW";
      

      
        $dataArray["并机数据"]["并机输出B相有功功率"] = number_format($v[7]/1000, 2)."kW";
      

      
        $dataArray["并机数据"]["并机输出C相有功功率"] = number_format($v[8]/1000, 2)."kW";
      

      $offset += 16;

            $v = unpack("S*" , substr($memData , $offset, 2*1));
$lMemData = substr($memData , $offset, 2*1);
      $lOffset = 0;
      
        switch($v[1]){
          case 0:
          $dataArray["整机状态数据"]["运行状态"] = "初始化";
            break;
          case 1:
          $dataArray["整机状态数据"]["运行状态"] = "待机状态";
            break;
          case 2:
          $dataArray["整机状态数据"]["运行状态"] = "无输出状态";
            break;
          case 3:
          $dataArray["整机状态数据"]["运行状态"] = "旁路状态";
            break;
          case 4:
          $dataArray["整机状态数据"]["运行状态"] = "市电状态";
            break;
          case 5:
          $dataArray["整机状态数据"]["运行状态"] = "电池状态";
            break;
          case 6:
          $dataArray["整机状态数据"]["运行状态"] = "电池自检状态";
            break;
          case 7:
          $dataArray["整机状态数据"]["运行状态"] = "逆变启动中";
            break;
          case 8:
          $dataArray["整机状态数据"]["运行状态"] = "经济模式";
            break;
          case 9:
          $dataArray["整机状态数据"]["运行状态"] = "EPO状态";
            break;
          case 10:
          $dataArray["整机状态数据"]["运行状态"] = "维护旁路模式";
            break;
          case 11:
          $dataArray["整机状态数据"]["运行状态"] = "故障模式";
            break;
          default:
            $dataArray["整机状态数据"]["运行状态"] = "无效值";
            break;
        }
      

      $offset += 2;

            $v = unpack("S*" , substr($memData , $offset, 2*4));
$lMemData = substr($memData , $offset, 2*4);
          $lMemData = '';
          for($j=1;$j<=count($v);$j++)
          {
              for($k = 0; $k <8; $k++)
              {
                $lMemData .= pack("C", ($v[$j]>>$k)&0x1);
              }
          }
      $lOffset = 0;
      
        $dataArray["整机状态位"]["逆变待机(ECO 状态位)"] = number_format($v[12], 2);
      

      
        $dataArray["整机状态位"]["LBS系统激活"] = number_format($v[13], 2);
      

      
        $dataArray["整机状态位"]["并机系统转旁路"] = number_format($v[14], 2);
      

      
        $dataArray["整机状态位"]["负载冲击切旁路"] = number_format($v[15], 2);
      

      
        $dataArray["整机状态位"]["过载延时到关机"] = number_format($v[16], 2);
      

      
        $dataArray["整机状态位"]["切换次数到"] = number_format($v[17], 2);
      

      
        $dataArray["整机状态位"]["逆变主机"] = number_format($v[18], 2);
      

      
        $dataArray["整机状态位"]["启动容量不足"] = number_format($v[19], 2);
      

      
        $dataArray["整机状态位"]["紧急关机提示"] = number_format($v[20], 2);
      

      
        $dataArray["整机状态位"]["关机将导致过载告警"] = number_format($v[21], 2);
      

      
        $dataArray["整机状态位"]["关机将导致断电告警"] = number_format($v[22], 2);
      

      
        $dataArray["整机状态位"]["间断切换提示"] = number_format($v[23], 2);
      

      
        switch(($v[25] << 1)  & $v[24]){
          case 0:
          $dataArray["整机状态位"]["UPS供电状态"] = "均不供电";
            break;
          case 1:
          $dataArray["整机状态位"]["UPS供电状态"] = "旁路供电";
            break;
          case 2:
          $dataArray["整机状态位"]["UPS供电状态"] = "逆变供电";
            break;
          default:
            $dataArray["整机状态位"]["UPS供电状态"] = "无效值";
            break;
        }
      

      
        switch(($v[27] << 1)  & $v[26]){
          case 0:
          $dataArray["整机状态位"]["逆变开关机状态"] = "关机";
            break;
          case 1:
          $dataArray["整机状态位"]["逆变开关机状态"] = "软启动";
            break;
          case 2:
          $dataArray["整机状态位"]["逆变开关机状态"] = "启动完毕未供电";
            break;
          case 3:
          $dataArray["整机状态位"]["逆变开关机状态"] = "正常供电中";
            break;
          default:
            $dataArray["整机状态位"]["逆变开关机状态"] = "无效值";
            break;
        }
      

      
        switch($v[28]){
          case 0:
          $dataArray["整机状态位"]["外部输出空开状态"] = "闭合";
            break;
          case 1:
          $dataArray["整机状态位"]["外部输出空开状态"] = "断开";
            break;
          default:
            $dataArray["整机状态位"]["外部输出空开状态"] = "无效值";
            break;
        }
      

      
        switch($v[29]){
          case 0:
          $dataArray["整机状态位"]["旁路柜旁路空开状态"] = "闭合";
            break;
          case 1:
          $dataArray["整机状态位"]["旁路柜旁路空开状态"] = "断开";
            break;
          default:
            $dataArray["整机状态位"]["旁路柜旁路空开状态"] = "无效值";
            break;
        }
      

      
        switch($v[30]){
          case 0:
          $dataArray["整机状态位"]["维修旁路空开状态"] = "闭合";
            break;
          case 1:
          $dataArray["整机状态位"]["维修旁路空开状态"] = "断开";
            break;
          default:
            $dataArray["整机状态位"]["维修旁路空开状态"] = "无效值";
            break;
        }
      

      
        switch($v[31]){
          case 0:
          $dataArray["整机状态位"]["输出空开状态"] = "闭合";
            break;
          case 1:
          $dataArray["整机状态位"]["输出空开状态"] = "断开";
            break;
          default:
            $dataArray["整机状态位"]["输出空开状态"] = "无效值";
            break;
        }
      

      
        switch($v[32]){
          case 0:
          $dataArray["整机状态位"]["旁路空开状态"] = "闭合";
            break;
          case 1:
          $dataArray["整机状态位"]["旁路空开状态"] = "断开";
            break;
          default:
            $dataArray["整机状态位"]["旁路空开状态"] = "无效值";
            break;
        }
      

      
        switch($v[55]){
          case 0:
          $dataArray["整机状态位"]["负组电池均浮充"] = "浮充";
            break;
          case 1:
          $dataArray["整机状态位"]["负组电池均浮充"] = "均充";
            break;
          default:
            $dataArray["整机状态位"]["负组电池均浮充"] = "无效值";
            break;
        }
      

      
        switch($v[56]){
          case 0:
          $dataArray["整机状态位"]["正组电池均浮充"] = "浮充";
            break;
          case 1:
          $dataArray["整机状态位"]["正组电池均浮充"] = "均充";
            break;
          default:
            $dataArray["整机状态位"]["正组电池均浮充"] = "无效值";
            break;
        }
      

      
        switch($v[57]){
          case 0:
          $dataArray["整机状态位"]["电池充电"] = "未充电";
            break;
          case 1:
          $dataArray["整机状态位"]["电池充电"] = "充电";
            break;
          default:
            $dataArray["整机状态位"]["电池充电"] = "无效值";
            break;
        }
      

      
        switch($v[58]){
          case 0:
          $dataArray["整机状态位"]["电池自检"] = "未自检";
            break;
          case 1:
          $dataArray["整机状态位"]["电池自检"] = "自检";
            break;
          default:
            $dataArray["整机状态位"]["电池自检"] = "无效值";
            break;
        }
      

      
        switch($v[59]){
          case 0:
          $dataArray["整机状态位"]["输入供电模式"] = "输入供电";
            break;
          case 1:
          $dataArray["整机状态位"]["输入供电模式"] = "电池供电";
            break;
          default:
            $dataArray["整机状态位"]["输入供电模式"] = "无效值";
            break;
        }
      

      
        switch($v[60]){
          case 0:
          $dataArray["整机状态位"]["输入供电状态"] = "工作";
            break;
          case 1:
          $dataArray["整机状态位"]["输入供电状态"] = "不工作";
            break;
          default:
            $dataArray["整机状态位"]["输入供电状态"] = "无效值";
            break;
        }
      

      
        switch($v[61]){
          case 0:
          $dataArray["整机状态位"]["整流器限流"] = "未限流";
            break;
          case 1:
          $dataArray["整机状态位"]["整流器限流"] = "限流";
            break;
          default:
            $dataArray["整机状态位"]["整流器限流"] = "无效值";
            break;
        }
      

      
        switch($v[62]){
          case 0:
          $dataArray["整机状态位"]["紧急关机"] = "正常";
            break;
          case 1:
          $dataArray["整机状态位"]["紧急关机"] = "紧急关机状态";
            break;
          default:
            $dataArray["整机状态位"]["紧急关机"] = "无效值";
            break;
        }
      

      
        switch($v[63]){
          case 0:
          $dataArray["整机状态位"]["整流器状态"] = "工作";
            break;
          case 1:
          $dataArray["整机状态位"]["整流器状态"] = "停止";
            break;
          default:
            $dataArray["整机状态位"]["整流器状态"] = "无效值";
            break;
        }
      

      
        switch($v[64]){
          case 0:
          $dataArray["整机状态位"]["输入空开状态"] = "闭合";
            break;
          case 1:
          $dataArray["整机状态位"]["输入空开状态"] = "断开";
            break;
          default:
            $dataArray["整机状态位"]["输入空开状态"] = "无效值";
            break;
        }
      

      $offset += 8;

            $v = unpack("S*" , substr($memData , $offset, 2*4));
$lMemData = substr($memData , $offset, 2*4);
          $lMemData = '';
          for($j=1;$j<=count($v);$j++)
          {
              for($k = 0; $k <8; $k++)
              {
                $lMemData .= pack("C", ($v[$j]>>$k)&0x1);
              }
          }
      $lOffset = 0;
      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "BUS电压异常", $v[8], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "回馈保护", $v[9], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "旁路过流", $v[10], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "逆变直流分量过大", $v[11], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "并机过载", $v[12], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "过载", $v[13], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "开机无效", $v[14], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "上电初始化故障", $v[15], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "LBS超跟踪", $v[16], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "并机继电器故障", $v[17], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "并机连线故障", $v[18], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "熔丝断", $v[19], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "IGBT过流", $v[20], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "旁路超保护", $v[21], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "旁路超跟踪", $v[22], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "不同步", $v[23], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "旁路反序", $v[24], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "并机均流故障", $v[25], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "CAN通信故障", $v[26], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "旁路晶闸管断路故障", $v[27], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "逆变晶闸管断路故障", $v[28], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "逆变晶闸管断路故障", $v[29], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "逆变晶闸管短路故障", $v[30], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "逆变桥臂直通", $v[31], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "逆变器故障", $v[32], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "市电电压异常", $v[39], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "市电频率异常", $v[40], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "电池电压预告警", $v[41], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "电池电压高", $v[42], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "电池电压低", $v[43], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "负组电池充电器故障", $v[44], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "正组电池充电器故障", $v[45], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "电池无", $v[46], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "电池反", $v[47], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "输入缺零", $v[48], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "软启动失败", $v[49], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "输入电压相序反", $v[50], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "正负母线压差大", $v[51], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "母线电压欠压", $v[52], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "母线电压过压", $v[53], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "风扇电源故障", $v[54], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "风扇故障", $v[55], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "电池充电晶闸管故障", $v[56], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "电池放电晶闸管故障", $v[57], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "输入晶闸管故障", $v[58], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "辅助电源2故障", $v[59], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "辅助电源1故障", $v[60], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "整流过流故障", $v[61], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "逆变模块过温", $v[62], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "整流模块过温", $v[63], 0);
      

      
        _kstarups_ShowAlert($dataArray["整机告警位位"], "整流器故障", $v[64], 0);
      

      $offset += 8;

            $v = unpack("S*" , substr($memData , $offset, 2*1));
$lMemData = substr($memData , $offset, 2*1);
          $lMemData = '';
          for($j=1;$j<=count($v);$j++)
          {
              for($k = 0; $k <8; $k++)
              {
                $lMemData .= pack("C", ($v[$j]>>$k)&0x1);
              }
          }
      $lOffset = 0;
      
        switch($v[7]){
          case 0:
          $dataArray["整机系统状态"]["后备时间计算位"] = "未计算";
            break;
          case 1:
          $dataArray["整机系统状态"]["后备时间计算位"] = "已计算";
            break;
          default:
            $dataArray["整机系统状态"]["后备时间计算位"] = "无效值";
            break;
        }
      

      
        switch($v[8]){
          case 0:
          $dataArray["整机系统状态"]["充电率计算位"] = "未计算";
            break;
          case 1:
          $dataArray["整机系统状态"]["充电率计算位"] = "已计算";
            break;
          default:
            $dataArray["整机系统状态"]["充电率计算位"] = "无效值";
            break;
        }
      

      
        switch($v[9]){
          case 0:
          $dataArray["整机系统状态"]["序列号注册位"] = "未注册";
            break;
          case 1:
          $dataArray["整机系统状态"]["序列号注册位"] = "已注册";
            break;
          default:
            $dataArray["整机系统状态"]["序列号注册位"] = "无效值";
            break;
        }
      

      
        switch($v[10]){
          case 0:
          $dataArray["整机系统状态"]["电池监控系统接入位"] = "未接入";
            break;
          case 1:
          $dataArray["整机系统状态"]["电池监控系统接入位"] = "已接入";
            break;
          default:
            $dataArray["整机系统状态"]["电池监控系统接入位"] = "无效值";
            break;
        }
      

      
        switch($v[11]){
          case 0:
          $dataArray["整机系统状态"]["避雷动作信号"] = "状态无效";
            break;
          case 1:
          $dataArray["整机系统状态"]["避雷动作信号"] = "状态有效";
            break;
          default:
            $dataArray["整机系统状态"]["避雷动作信号"] = "无效值";
            break;
        }
      

      
        switch($v[12]){
          case 0:
          $dataArray["整机系统状态"]["定期自检开始"] = "状态无效";
            break;
          case 1:
          $dataArray["整机系统状态"]["定期自检开始"] = "状态有效";
            break;
          default:
            $dataArray["整机系统状态"]["定期自检开始"] = "无效值";
            break;
        }
      

      
        switch($v[13]){
          case 0:
          $dataArray["整机系统状态"]["定时关机"] = "状态无效";
            break;
          case 1:
          $dataArray["整机系统状态"]["定时关机"] = "状态有效";
            break;
          default:
            $dataArray["整机系统状态"]["定时关机"] = "无效值";
            break;
        }
      

      
        switch($v[14]){
          case 0:
          $dataArray["整机系统状态"]["定时开机"] = "状态无效";
            break;
          case 1:
          $dataArray["整机系统状态"]["定时开机"] = "状态有效";
            break;
          default:
            $dataArray["整机系统状态"]["定时开机"] = "无效值";
            break;
        }
      

      
        switch($v[15]){
          case 0:
          $dataArray["整机系统状态"]["电池电压低关机状态位"] = "状态无效";
            break;
          case 1:
          $dataArray["整机系统状态"]["电池电压低关机状态位"] = "状态有效";
            break;
          default:
            $dataArray["整机系统状态"]["电池电压低关机状态位"] = "无效值";
            break;
        }
      

      
        switch($v[16]){
          case 0:
          $dataArray["整机系统状态"]["发电机接入"] = "状态无效";
            break;
          case 1:
          $dataArray["整机系统状态"]["发电机接入"] = "状态有效";
            break;
          default:
            $dataArray["整机系统状态"]["发电机接入"] = "无效值";
            break;
        }
      

      $offset += 2;

            $v = unpack("S*" , substr($memData , $offset, 2*1));
$lMemData = substr($memData , $offset, 2*1);
          $lMemData = '';
          for($j=1;$j<=count($v);$j++)
          {
              for($k = 0; $k <8; $k++)
              {
                $lMemData .= pack("C", ($v[$j]>>$k)&0x1);
              }
          }
      $lOffset = 0;
      
        switch($v[9]){
          case 0:
          $dataArray["整机系统状态"]["预防性维护时间到"] = "状态无效";
            break;
          case 1:
          $dataArray["整机系统状态"]["预防性维护时间到"] = "状态有效";
            break;
          default:
            $dataArray["整机系统状态"]["预防性维护时间到"] = "无效值";
            break;
        }
      

      
        switch($v[10]){
          case 0:
          $dataArray["整机系统状态"]["机型错误"] = "状态无效";
            break;
          case 1:
          $dataArray["整机系统状态"]["机型错误"] = "状态有效";
            break;
          default:
            $dataArray["整机系统状态"]["机型错误"] = "无效值";
            break;
        }
      

      
        switch($v[11]){
          case 0:
          $dataArray["整机系统状态"]["烟雾报警"] = "状态无效";
            break;
          case 1:
          $dataArray["整机系统状态"]["烟雾报警"] = "状态有效";
            break;
          default:
            $dataArray["整机系统状态"]["烟雾报警"] = "无效值";
            break;
        }
      

      
        switch($v[12]){
          case 0:
          $dataArray["整机系统状态"]["火灾报警"] = "状态无效";
            break;
          case 1:
          $dataArray["整机系统状态"]["火灾报警"] = "状态有效";
            break;
          default:
            $dataArray["整机系统状态"]["火灾报警"] = "无效值";
            break;
        }
      

      
        switch($v[13]){
          case 0:
          $dataArray["整机系统状态"]["电池电压低"] = "状态无效";
            break;
          case 1:
          $dataArray["整机系统状态"]["电池电压低"] = "状态有效";
            break;
          default:
            $dataArray["整机系统状态"]["电池电压低"] = "无效值";
            break;
        }
      

      
        switch($v[14]){
          case 0:
          $dataArray["整机系统状态"]["电池电压高"] = "状态无效";
            break;
          case 1:
          $dataArray["整机系统状态"]["电池电压高"] = "状态有效";
            break;
          default:
            $dataArray["整机系统状态"]["电池电压高"] = "无效值";
            break;
        }
      

      
        switch($v[15]){
          case 0:
          $dataArray["整机系统状态"]["电池过温"] = "状态无效";
            break;
          case 1:
          $dataArray["整机系统状态"]["电池过温"] = "状态有效";
            break;
          default:
            $dataArray["整机系统状态"]["电池过温"] = "无效值";
            break;
        }
      

      
        switch($v[16]){
          case 0:
          $dataArray["整机系统状态"]["电池损坏"] = "状态无效";
            break;
          case 1:
          $dataArray["整机系统状态"]["电池损坏"] = "状态有效";
            break;
          default:
            $dataArray["整机系统状态"]["电池损坏"] = "无效值";
            break;
        }
      

      $offset += 2;

            $v = unpack("S*" , substr($memData , $offset, 2*21));
$lMemData = substr($memData , $offset, 2*21);
      $lOffset = 0;
      
      $lMemData = substr($memData, $offset, 42);
      _kstarups_ModuleData1($dataArray, $lMemData, "",  "1"  );

      $offset += 42;

            $v = unpack("S*" , substr($memData , $offset, 2*21));
$lMemData = substr($memData , $offset, 2*21);
      $lOffset = 0;
      
      $lMemData = substr($memData, $offset, 42);
      _kstarups_ModuleData1($dataArray, $lMemData, "",  "2"  );

      $offset += 42;

            $v = unpack("S*" , substr($memData , $offset, 2*21));
$lMemData = substr($memData , $offset, 2*21);
      $lOffset = 0;
      
      $lMemData = substr($memData, $offset, 42);
      _kstarups_ModuleData1($dataArray, $lMemData, "",  "3"  );

      $offset += 42;

            $v = unpack("S*" , substr($memData , $offset, 2*21));
$lMemData = substr($memData , $offset, 2*21);
      $lOffset = 0;
      
      $lMemData = substr($memData, $offset, 42);
      _kstarups_ModuleData1($dataArray, $lMemData, "",  "4"  );

      $offset += 42;

            $v = unpack("S*" , substr($memData , $offset, 2*21));
$lMemData = substr($memData , $offset, 2*21);
      $lOffset = 0;
      
      $lMemData = substr($memData, $offset, 42);
      _kstarups_ModuleData1($dataArray, $lMemData, "",  "5"  );

      $offset += 42;

            $v = unpack("S*" , substr($memData , $offset, 2*21));
$lMemData = substr($memData , $offset, 2*21);
      $lOffset = 0;
      
      $lMemData = substr($memData, $offset, 42);
      _kstarups_ModuleData1($dataArray, $lMemData, "",  "6"  );

      $offset += 42;

            $v = unpack("S*" , substr($memData , $offset, 2*21));
$lMemData = substr($memData , $offset, 2*21);
      $lOffset = 0;
      
      $lMemData = substr($memData, $offset, 42);
      _kstarups_ModuleData1($dataArray, $lMemData, "",  "7"  );

      $offset += 42;

            $v = unpack("S*" , substr($memData , $offset, 2*21));
$lMemData = substr($memData , $offset, 2*21);
      $lOffset = 0;
      
      $lMemData = substr($memData, $offset, 42);
      _kstarups_ModuleData1($dataArray, $lMemData, "",  "8"  );

      $offset += 42;

            $v = unpack("S*" , substr($memData , $offset, 2*21));
$lMemData = substr($memData , $offset, 2*21);
      $lOffset = 0;
      
      $lMemData = substr($memData, $offset, 42);
      _kstarups_ModuleData1($dataArray, $lMemData, "",  "9"  );

      $offset += 42;

            $v = unpack("S*" , substr($memData , $offset, 2*21));
$lMemData = substr($memData , $offset, 2*21);
      $lOffset = 0;
      
      $lMemData = substr($memData, $offset, 42);
      _kstarups_ModuleData1($dataArray, $lMemData, "",  "10"  );

      $offset += 42;

            $v = unpack("S*" , substr($memData , $offset, 2*120));
$lMemData = substr($memData , $offset, 2*120);
      $lOffset = 0;
      
          for($i=1;$i<=30;$i++)
          {
            $tMemData = substr($lMemData, $lOffset, 8);            
            _kstarups_BatteryInfo($dataArray, $tMemData, "", $i);
            $lOffset += 8;
          }

      $offset += 240;

        $v = unpack('v', substr($memData, $offset , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, $offset + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

