<?php

function Get_liebert_pex_DeviceIoControl_ErrorMsg($ret){
    switch($ret){
        case 1:
            return "执行成功";
        case 3:
            return "执行失败，校验不符";
        default:
            return "未知错误";
        }
}

function Get_liebert_pex_DeviceIoControl_Parameter($action, $parameter)
{
    if($action == 106 && count($parameter) == 1){
        return pack("S", intval($parameter[0]));
    }
    return -1;
}


function Get_liebert_pex_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '温度设定点':
            return array(0,  floatval($dataArray['温度设定点（℃）']));
        case '回风温度':
            return array(0, floatval($dataArray['回风温度（℃）']));
        case '开关机状态':
            return array(0, $dataArray['机组开关机状态']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}


function _GetLibertPexSist($val)
{
    $hour = floor($val/256);
    $min = fmod($val,256);
    $data = $hour."小时".":".$min."分钟";
    return $data;
}

function Get_liebert_pex_RtData($memData, &$dataArray, $extraPara = false)
{
        if ($memData == false) {
            $dataArray['无数据'] = true;
            $dataArray['更新时间'] = '无';
            $dataArray['错误'] = '无数据';
        } else {
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            $v = unpack('C*', substr($memData, 4, 1 * 93));
            $signalArr1 = array("星期一睡眠","星期二睡眠","星期三睡眠","星期四睡眠","星期五睡眠","星期六睡眠","星期天睡眠","送风温限使能","再加热锁定","加湿器锁定","温度单位","定时器运行模式",
                "最低冷冻水温度使能","压缩机Pump down使能","自然冷源和压缩机同时运行使能","自动设置使能","除湿使能","使用热水","T/H报警使能","传感器A报警使能","压缩机锁定","VSD风机控制使能",
                "风机开","制冷开","自然冷源开","热水开","电加热开","加湿开","除湿开","告警峰鸣器开");
            foreach($signalArr1 as $key=>$signal){
                $offset = $key + 1;
                $dataArray[$signal] = $v[$offset] > 0 ? '是' : '否';
            }
            $signalArr2 = array("风机过载","气流丢失","水流丢失","压缩机1高压","压缩机1低压","压缩机1过载","压缩机1Pump donw失败","压缩机2高压","压缩机2低压","压缩机2过载",
                "压缩机2Pump donw失败","数码漩涡1高温","数码漩涡2高温","烟感报警","地板漏水","加湿器故障","备用乙二醇泵运行","备用机组运行","冷凝泵高水位","室内T/H传感器故障","压缩机掉电","鼓风机气流丢失",
                "加湿器低水位","加湿器电流过高","高温","系统掉电","未知告警","冷冻水高温","室内高温","室内低温","室内高湿","室内低湿","传感器A高温","传感器A低温","传感器A高湿","传感器A低湿","冷冻水水流流失",
                "过滤网堵塞","送风传感器故障","自然冷源温度传感器故障","传感器A故障","机组运行超时","压缩机1运行超时","压缩机2运行超时","自然冷源运行超时","电加热1运行超时","电加热2运行超时","电加热3运行超时",
                "热水热气运行超时","加湿器运行超时","除湿器运行超时","组网失败","无法和机组1连接","其他机组没有连接","机组码丢失","机组码不匹配","需要维护","自定义输入1报警","自定义输入2报警","自定义输入3报警",
                "自定义输入4报警","数码漩涡1传感器失败","数码漩涡2传感器失败");
            foreach($signalArr2 as $key=>$signal2){
                $offset = $key + 31;
                $dataArray[$signal2] = $v[$offset] > 0 ? '告警' : '正常';
                $dataArray['AlertArray'][$signal2] = $v[$offset] > 0;
            }

            $v = unpack('S*', substr($memData, 97, 2 * 92));
            $dataArray["压缩机数"] = $v[1];
            $dataArray["电加热数"] = $v[2];
            $dataArray["电加热级数"] = $v[3];
            $dataArray['Teamwork机组数'] = $v[4];
            $dataArray['压缩机运行顺序'] = $v[5];
            $dataArray['热气控制'] = $v[6];
            $dataArray['再加热控制'] = $v[7];
            $dataArray['定时运行'] = $v[8] == 1 ? '是' : '否';
            switch ($v[9]){
                case 0 : $dataArray['室内温差控制'] = '否'; break;
                case 1 : $dataArray['室内温差控制'] = '差值'; break;
                case 2 : $dataArray['室内温差控制'] = '绝对值'; break;
                default : $dataArray['室内温差控制'] = '无效';
            }
            switch ($v[10]){
                case 0 : $dataArray['湿度控制方式'] = '相对'; break;
                case 1 : $dataArray['湿度控制方式'] = '补偿'; break;
                case 2 : $dataArray['湿度控制方式'] = '预测'; break;
                default : $dataArray['湿度控制方式'] = '无效';
            }
            $dataArray['VSD设定点（%(HP)）'] = $v[11] == 0x8000 ? "无效" : $v[11];
            $dataArray['送风温限（℃）'] = $v[12] == 0xFFFF ? "无效" : $v[12]/10;
            $dataArray['室内和自然冷源温差（℃）'] = $v[13] == 0xFFFF ? "无效" : $v[13]/10;
            $dataArray['最低冷冻水温度（℃）'] = $v[14] == 0xFFFF ? "无效" : $v[14]/10;
            $dataArray['温度设定点（℃）'] = $v[15]/10;
            $dataArray['温度比例带（℃）'] = $v[16]/10;
            $dataArray['温度死区（℃）'] = $v[17]/10;
            $dataArray['温度积分时间（Min）'] = $v[18];
            $dataArray['湿度设定点（%）'] = $v[19];
            $dataArray['湿度比例带（%）'] = $v[20];
            $dataArray['湿度积分时间（Min）'] = $v[21];
            $dataArray['湿度死区（%）'] = $v[22];
            $dataArray['单机组重启动延时（Sec）'] = $v[23];
            $dataArray['红外冲刷比例（%）'] = $v[24];
            switch ($v[25]){
                case 0 : $dataArray['温度控制方式'] = '比例'; break;
                case 1 : $dataArray['温度控制方式'] = 'P1'; break;
                case 2 : $dataArray['温度控制方式'] = 'PID'; break;
                case 3 : $dataArray['温度控制方式'] = '智能'; break;
                default : $dataArray['温度控制方式'] = '无效';
            }
            $dataArray['睡眠间隔1开始时间'] = _GetLibertPexSist($v[26]);
            $dataArray['睡眠间隔1结束时间'] = _GetLibertPexSist($v[27]);
            $dataArray['睡眠间隔2开始时间'] = _GetLibertPexSist($v[28]);
            $dataArray['睡眠间隔2结束时间'] = _GetLibertPexSist($v[29]);
            $dataArray['定时方式温度死区（℃）'] = $v[30]/10;
            $dataArray['VSD手动方式定时长度'] = $v[31];
            $dataArray['高温报警点（℃）'] = $v[32]/10;
            $dataArray['低温报警点（℃）'] = $v[33]/10;
            $dataArray['传感器A高温报警点（℃）'] = $v[34] == 0xFFFF ? "无效" :$v[34]/10;
            $dataArray['传感器A低温报警点（℃）'] = $v[35] == 0xFFFF ? "无效" :$v[35]/10;
            $dataArray['高湿报警点（%）'] = $v[36];
            $dataArray['低湿报警点（%）'] = $v[37];
            $dataArray['传感器A高湿报警点（%）'] = $v[38] == 0xFFFF ? "无效" :$v[38];
            $dataArray['传感器A低湿报警点（%）'] = $v[39] == 0xFFFF ? "无效" :$v[39];
            $dataArray['风机运行时间限值（Hour）'] = $v[40];
            $dataArray['压缩机1运行时间限值（Hour）'] = $v[41];
            $dataArray['压缩机2运行时间限值（Hour）'] = $v[42];
            $dataArray['加湿器运行时间限值（Hour）'] = $v[43];
            $dataArray['除湿运行时间限值（Hour）'] = $v[44];
            $dataArray['冷冻死/自然冷源运行时间限值（Hour）'] = $v[45];
            $dataArray['电加热1运行时间限值（Hour）'] = $v[46];
            $dataArray['电加热2运行时间限值（Hour）'] = $v[47];
            $dataArray['电加热3运行时间限值（Hour）'] = $v[48];
            $dataArray['热气/热水运行时间限值（Hour）'] = $v[49];
            //运行状态
            switch($v[50] & 0x3){
                case 0 : $dataArray['机组开关机状态'] = '关机'; break;
                case 1 : $dataArray['机组开关机状态'] = '开机'; break;
                case 2 : $dataArray['机组开关机状态'] = '待机'; break;
                default : $dataArray['机组开关机状态'] = '无效';
            }
            switch(($v[50] >> 2) & 0x3){
                case 0 : $dataArray['机组运行模式'] = '自动'; break;
                case 1 : $dataArray['机组运行模式'] = '手动'; break;
                default : $dataArray['机组开关机状态'] = '无效';
            }
            switch(($v[50] >> 4) & 0xF){
                case 0: $dataArray['机组关机原因'] = '无'; break;
                case 1: $dataArray['机组关机原因'] = '本地'; break;
                case 2: $dataArray['机组关机原因'] = '告警'; break;
                case 3: $dataArray['机组关机原因'] = '调度'; break;
                case 4: $dataArray['机组关机原因'] = '监控'; break;
                case 5: $dataArray['机组关机原因'] = '远程'; break;
                case 6: $dataArray['机组关机原因'] = '显示'; break;
                default : $dataArray['机组关机原因'] = '无效';
            }
            $dataArray['当前告警/时间数量'] = $v[51];
            $dataArray['报警复位状态'] = ($v[52] & 0x1) == 1 ? '是' : '否';
            $dataArray['报警有效状态'] = (($v[52] >> 1) & 0x1) == 1 ? '是' : '否';
            $dataArray['报警确认状态'] = (($v[52] >> 2) & 0x1) == 1 ? '是' : '否';
            switch (($v[52] >> 3) & 0x1F){
                case 0 : $dataArray['机组告警类型'] = '消息'; break;
                case 1 : $dataArray['机组告警类型'] = '警告'; break;
                case 2 : $dataArray['机组告警类型'] = '报警'; break;
                default : $dataArray['机组告警类型'] = '无效';
            }
            $dataArray['风机需求（%）'] = $v[53];
            $dataArray['制冷需求（%）'] = $v[54];
            $dataArray['自然冷源需求（%）'] = $v[55];
            $dataArray['加热需求（%）'] = $v[56];
            $dataArray['加湿需求（%）'] = $v[57];
            $dataArray['除湿需求（%）'] = $v[58];
            switch ($v[59]){
                case 0 : $dataArray['自然冷源状态'] = '关'; break;
                case 1 : $dataArray['自然冷源状态'] = '启动'; break;
                case 2 : $dataArray['自然冷源状态'] = '运行'; break;
                default : $dataArray['自然冷源状态'] = '无效';
            }
            $dataArray['回风温度（℃）'] = $v[60]/10;
            $dataArray['实际温度设定点（℃）'] = $v[61]/10;
            $dataArray['送风温度（℃）'] = $v[62] == 0xFFFF ? "无效" :$v[62]/10;
            $dataArray['实际送风温度设定点（℃）'] = $v[63]/10;
            $dataArray['自然冷源温度（℃）'] = $v[64] == 0xFFFF ? "无效" :$v[64]/10;
            $dataArray['传感器A温度（℃）'] = $v[65] == 0xFFFF ? "无效" :$v[65]/10;
            $dataArray['传感器B温度（℃）'] = $v[66] == 0xFFFF ? "无效" :$v[66]/10;
            $dataArray['传感器C温度（℃）'] = $v[67] == 0xFFFF ? "无效" :$v[67]/10;
            $dataArray['数码涡旋1温度（℃）'] = $v[68]/10;
            $dataArray['数码涡旋2温度（℃）'] = $v[69]/10;
            $dataArray['回风湿度（%）'] = $v[70];
            $dataArray['实际回风湿度设定点（%）'] = $v[71];
            $dataArray['传感器A湿度（%）'] = $v[72] == 0xFFFF ? "无效" :$v[72];
            $dataArray['传感器B湿度（%）'] = $v[73] == 0xFFFF ? "无效" :$v[73];
            $dataArray['传感器C湿度（%）'] = $v[74] == 0xFFFF ? "无效" :$v[74];
            $dataArray['风机运行时间（Hour）'] = $v[75];
            $dataArray['压缩机1运行时间（Hour）'] = $v[76];
            $dataArray['压缩机2运行时间（Hour）'] = $v[77];
            $dataArray['加湿运行时间（Hour）'] = $v[78];
            $dataArray['除湿运行时间（Hour）'] = $v[79];
            $dataArray['自然冷源运行时间（Hour）'] = $v[80];
            $dataArray['电加热1运行时间（Hour）'] = $v[81];
            $dataArray['电加热2运行时间（Hour）'] = $v[82];
            $dataArray['电加热3运行时间（Hour）'] = $v[83];
            $dataArray['热水/热气运行时间（Hour）'] = $v[84];
            $dataArray['当日高温温度（℃）'] = $v[85]/10;
            $dataArray['当日高温时间（Hh:mm）'] = _GetLibertPexSist($v[86]);
            $dataArray['当日低温温度（℃）'] = $v[87]/10;
            $dataArray['当日低温时间（Hh:mm）'] = _GetLibertPexSist($v[88]);
            $dataArray['当日高湿湿度（%）'] = $v[89];
            $dataArray['当日高湿时间（Hh:mm）'] = _GetLibertPexSist($v[90]);
            $dataArray['当日低湿湿度（%）'] = $v[91];
            $dataArray['当日低湿时间（Hh:mm）'] = _GetLibertPexSist($v[92]);
            $v = unpack('v', substr($memData, 97 + 2 * 92, 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, 99 + 2 * 92, 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}
