<?php
function Get_liebert_ups_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[UPS输出线电压Uab]':
            return array(0, $dataArray['AB相输出电压(V)']);
        case '[UPS输出线电压Ubc]':
            return array(0, $dataArray['BC相输出电压(V)']);
        case '[UPS输出线电压Uca]':
            return array(0, $dataArray['CA相输出电压(V)']); 
        case '[UPS输出频率]':
            return array(0 , $dataArray['旁路频率(Hz)']);
        case 'A相输出电流':
            return array(0, $dataArray['A相输出电流(A)']);
        case 'B相输出电流':
            return array(0, $dataArray['B相输出电流(A)']);
        case 'C相输出电流':
            return array(0, $dataArray['C相输出电流(A)']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_liebert_ups_RtData($memData, &$dataArray, $extraPara = false)
{
        if ($memData == false) {
            $dataArray['无数据'] = true;
            $dataArray['更新时间'] = '无';
        } else {
            $dataArray['无数据'] = false;
            $v = unpack('S*', substr($memData, 4, 2 * 32));
            //模拟量
            $dataArray['AlertArray'] = array();
            $dataArray['AB相输出电压(V)'] = $v[1];
            $dataArray['BC相输出电压(V)'] = $v[2];
            $dataArray['CA相输出电压(V)'] = $v[3];
            $dataArray['A相输出电压(V)'] = $v[4];
            $dataArray['B相输出电压(V)'] = $v[5];
            $dataArray['C相输出电压(V)'] = $v[6];
            $dataArray['A相输出电流(A)'] = $v[7];
            $dataArray['B相输出电流(A)'] = $v[8];
            $dataArray['C相输出电流(A)'] = $v[9];
            $dataArray['N相输出电流(A)'] = $v[10];
            $dataArray['A相实际输出功率(KW)'] = $v[11];
            $dataArray['B相实际输出功率(KW)'] = $v[12];
            $dataArray['C相实际输出功率(KW)'] = $v[13];
            $dataArray['旁路频率(Hz)'] = $v[14];
            $dataArray['逆变器频率(Hz)'] = $v[15];
            $dataArray['旁路AB相电压(V)'] = $v[16];
            $dataArray['旁路BC相电压(V)'] = $v[17];
            $dataArray['旁路CA相电压(V)'] = $v[18];
            $dataArray['电池电压(V)'] = $v[19];
            $dataArray['电池电流(A)'] = $v[20];
            $dataArray['A相视在输出功率(KVA)'] = $v[21];
            $dataArray['B相视在输出功率(KVA)'] = $v[22];
            $dataArray['C相视在输出功率(KVA)'] = $v[23];
            $dataArray['A相负载百分比(%)'] = $v[24];
            $dataArray['B相负载百分比(%)'] = $v[25];
            $dataArray['C相负载百分比(%)'] = $v[26];
            $dataArray['电池充电比例(%)'] = $v[27];
            $dataArray['电池剩余时间'] = $v[28];
            $dataArray['电池温度(℃)'] = $v[29];
            $v = unpack('I*', substr($memData, 4 + 2 * 32, 4 * 3));
            $dataArray['旁路开关断开'] = ($v[1] >> 2) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['输出开关断开'] = ($v[1] >> 3) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['整流器开关断开'] = ($v[1] >> 4) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['电池开关断开'] = ($v[1] >> 5) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['手工旁路开关断开'] = ($v[1] >> 6) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['风扇故障'] = ($v[1] >> 8) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['旁路无电压告警'] = ($v[1] >> 10) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['旁路过压告警'] = ($v[1] >> 11) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['旁路欠压告警'] = ($v[1] >> 12) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['旁路频率异常'] = ($v[1] >> 13) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['旁路相位异常'] = ($v[1] >> 14) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['旁路晶闸管故障'] = ($v[1] >> 15) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['旁路供电'] = ($v[1] >> 18) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['旁路过温'] = ($v[1] >> 19) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['整流器关闭'] = ($v[1] >> 20) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['面板关闭整流器'] = ($v[1] >> 21) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['整流器封锁'] = ($v[1] >> 22) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['整流器限流'] = ($v[1] >> 23) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['整流器过温'] = ($v[1] >> 24) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['整流器熔丝故障'] = ($v[1] >> 25) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['逆变供电'] = ($v[1] >> 29) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['逆变器关闭'] = ($v[1] >> 30) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['面板关闭逆变器'] = ($v[1] >> 31) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['AlertArray']['旁路开关断开'] = ($v[1] >> 2) & 0x1 == 1;
            $dataArray['AlertArray']['输出开关断开'] = ($v[1] >> 3) & 0x1 == 1;
            $dataArray['AlertArray']['整流器开关断开'] = ($v[1] >> 4) & 0x1 == 1;
            $dataArray['AlertArray']['电池开关断开'] = ($v[1] >> 5) & 0x1 == 1;
            $dataArray['AlertArray']['手工旁路开关断开'] = ($v[1] >> 6) & 0x1 == 1;
            $dataArray['AlertArray']['风扇故障'] = ($v[1] >> 8) & 0x1 == 1;
            $dataArray['AlertArray']['旁路无电压告警'] = ($v[1] >> 10) & 0x1 == 1;
            $dataArray['AlertArray']['旁路过压告警'] = ($v[1] >> 11) & 0x1 == 1;
            $dataArray['AlertArray']['旁路欠压告警'] = ($v[1] >> 12) & 0x1 == 1;
            $dataArray['AlertArray']['旁路频率异常'] = ($v[1] >> 13) & 0x1 == 1;
            $dataArray['AlertArray']['旁路相位异常'] = ($v[1] >> 14) & 0x1 == 1;
            $dataArray['AlertArray']['旁路晶闸管故障'] = ($v[1] >> 15) & 0x1 == 1;
            $dataArray['AlertArray']['旁路供电'] = ($v[1] >> 18) & 0x1 == 1;
            $dataArray['AlertArray']['旁路过温'] = ($v[1] >> 19) & 0x1 == 1;
            $dataArray['AlertArray']['整流器关闭'] = ($v[1] >> 20) & 0x1 == 1;
            $dataArray['AlertArray']['面板关闭整流器'] = ($v[1] >> 21) & 0x1 == 1;
            $dataArray['AlertArray']['整流器封锁'] = ($v[1] >> 22) & 0x1 == 1;
            $dataArray['AlertArray']['整流器限流'] = ($v[1] >> 23) & 0x1 == 1;
            $dataArray['AlertArray']['整流器过温'] = ($v[1] >> 24) & 0x1 == 1;
            $dataArray['AlertArray']['整流器熔丝故障'] = ($v[1] >> 25) & 0x1 == 1;
            $dataArray['AlertArray']['逆变供电'] = ($v[1] >> 29) & 0x1 == 1;
            $dataArray['AlertArray']['逆变器关闭'] = ($v[1] >> 30) & 0x1 == 1;
            $dataArray['AlertArray']['面板关闭逆变器'] = ($v[1] >> 31) & 0x1 == 1;
            $dataArray['逆变器封锁'] = $v[2] & 0x1 == 1 ? "告警" : "正常";
            $dataArray['逆变器限流'] = ($v[2] >> 1) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['逆变器过温'] = ($v[2] >> 2) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['逆变器不同步'] = ($v[2] >> 3) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['逆变器过压'] = ($v[2] >> 4) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['逆变器欠压'] = ($v[2] >> 5) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['逆变器熔丝故障'] = ($v[2] >> 6) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['输出过压'] = ($v[2] >> 7) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['输出欠压'] = ($v[2] >> 8) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['输出无电压'] = ($v[2] >> 9) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['输出波形异常'] = ($v[2] >> 10) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['输出频率异常'] = ($v[2] >> 11) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['逆变并机错误'] = ($v[2] >> 12) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['接触器故障'] = ($v[2] >> 13) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['逆变台数不够'] = ($v[2] >> 14) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['并机线未连接'] = ($v[2] >> 15) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['一台或多台UPS不工作'] = ($v[2] >> 16) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['电池充电故障'] = ($v[2] >> 17) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['电池供电'] = ($v[2] >> 20) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['电池放电结束'] = ($v[2] >> 21) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['均充时间超限'] = ($v[2] >> 22) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['母线慢速过压'] = ($v[2] >> 23) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['电池电压低'] = ($v[2] >> 24) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['电池熔丝故障'] = ($v[2] >> 25) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['母线快速过压'] = ($v[2] >> 26) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['电池接地故障'] = ($v[2] >> 27) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['旁路逆变切换次数到'] = ($v[2] >> 28) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['UPS过载关机'] = ($v[2] >> 29) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['UPS过温关机'] = ($v[2] >> 30) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['UPS紧急关机'] = ($v[2] >> 31) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['AlertArray']['逆变器封锁'] = $v[2] & 0x1 == 1;
            $dataArray['AlertArray']['逆变器限流'] = ($v[2] >> 1) & 0x1 == 1;
            $dataArray['AlertArray']['逆变器过温'] = ($v[2] >> 2) & 0x1 == 1;
            $dataArray['AlertArray']['逆变器不同步'] = ($v[2] >> 3) & 0x1 == 1;
            $dataArray['AlertArray']['逆变器过压'] = ($v[2] >> 4) & 0x1 == 1;
            $dataArray['AlertArray']['逆变器欠压'] = ($v[2] >> 5) & 0x1 == 1;
            $dataArray['AlertArray']['逆变器熔丝故障'] = ($v[2] >> 6) & 0x1 == 1;
            $dataArray['AlertArray']['输出过压'] = ($v[2] >> 7) & 0x1 == 1;
            $dataArray['AlertArray']['输出欠压'] = ($v[2] >> 8) & 0x1 == 1;
            $dataArray['AlertArray']['输出无电压'] = ($v[2] >> 9) & 0x1 == 1;
            $dataArray['AlertArray']['输出波形异常'] = ($v[2] >> 10) & 0x1 == 1;
            $dataArray['AlertArray']['输出频率异常'] = ($v[2] >> 11) & 0x1 == 1;
            $dataArray['AlertArray']['逆变并机错误'] = ($v[2] >> 12) & 0x1 == 1;
            $dataArray['AlertArray']['接触器故障'] = ($v[2] >> 13) & 0x1 == 1;
            $dataArray['AlertArray']['逆变台数不够'] = ($v[2] >> 14) & 0x1 == 1;
            $dataArray['AlertArray']['并机线未连接'] = ($v[2] >> 15) & 0x1 == 1;
            $dataArray['AlertArray']['一台或多台UPS不工作'] = ($v[2] >> 16) & 0x1 == 1;
            $dataArray['AlertArray']['电池充电故障'] = ($v[2] >> 17) & 0x1 == 1;
            $dataArray['AlertArray']['电池供电'] = ($v[2] >> 20) & 0x1 == 1;
            $dataArray['AlertArray']['电池放电结束'] = ($v[2] >> 21) & 0x1 == 1;
            $dataArray['AlertArray']['均充时间超限'] = ($v[2] >> 22) & 0x1 == 1;
            $dataArray['AlertArray']['母线慢速过压'] = ($v[2] >> 23) & 0x1 == 1;
            $dataArray['AlertArray']['电池电压低'] = ($v[2] >> 24) & 0x1 == 1;
            $dataArray['AlertArray']['电池熔丝故障'] = ($v[2] >> 25) & 0x1 == 1;
            $dataArray['AlertArray']['母线快速过压'] = ($v[2] >> 26) & 0x1 == 1;
            $dataArray['AlertArray']['电池接地故障'] = ($v[2] >> 27) & 0x1 == 1;
            $dataArray['AlertArray']['旁路逆变切换次数到'] = ($v[2] >> 28) & 0x1 == 1;
            $dataArray['AlertArray']['UPS过载关机'] = ($v[2] >> 29) & 0x1 == 1;
            $dataArray['AlertArray']['UPS过温关机'] = ($v[2] >> 30) & 0x1 == 1;
            $dataArray['AlertArray']['UPS紧急关机'] = ($v[2] >> 31) & 0x1 == 1;
            $dataArray['回灌故障'] = $v[3] & 0x1 == 1 ? "告警" : "正常";
            $dataArray['UPS过载'] = ($v[3] >> 2) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['UPS过载关机'] = ($v[3] >> 3) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['内部电池电压低'] = ($v[3] >> 12) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['AlertArray']['回灌故障'] = $v[3] & 0x1 == 1;
            $dataArray['AlertArray']['UPS过载'] = ($v[3] >> 2) & 0x1 == 1;
            $dataArray['AlertArray']['UPS过载关机'] = ($v[3] >> 3) & 0x1 == 1;
            $dataArray['AlertArray']['内部电池电压低'] = ($v[3] >> 12) & 0x1 == 1;
            $v = unpack('v', substr($memData, 16 + 2 * 32, 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, 18 + 2 * 32, 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }

}
