<?php

function Get_m810g_419_UnicomCategory()
{
    return "419";
}

function Get_m810g_config()
{
    $config = array("ac" => array(
        "airlock" => 8, "p40_43" => 2, "p40_41" => 0, "p40_44" => 7,
        "p40_41_label" => array(),
        "p40_43_label" => array("事故照明灯状态" => true, "当前工作路号" => true),
        "p40_43_rules" => array(0 => array(array(0xE2 => "照明开", 0xE3 => "照明关"), "无效状态"), 1 => array(array(0xE4 => "第一路", 0xE5 => "第二路", 0xE6 => "第三路", 0xE7 => "无工作路号"), "无效状态")),
        "p40_44_label" => array("交流输入空开" => true, "交流输出空开" => true, "防雷器" => true, "交流输入1" => true, "交流输入2" => true, "交流输入3" => true, "交流屏通讯" => true),
        "p40_44_rules" => array(
                0 => array(array(0 => "正常", 5 => "故障"), "无效"),
                1 => array(array(0 => "正常", 5 => "故障"), "无效"),
                2 => array(array(0 => "正常", 5 => "故障"), "无效"),
                3 => array(array(0 => "正常", 0xe1 => "故障"), "无效"),
                4 => array(array(0 => "正常", 0xe1 => "故障"), "无效"),
                5 => array(array(0 => "正常", 0xe1 => "故障"), "无效"),
                6 => array(array(0 => "正常", 0xe3 => "故障"), "无效")
        ),
        "ia_support" => true, "ib_support" => true, "ic_support" => true,
        "ia_alert_support" => true, "ib_alert_support" => true, "ic_alert_support" => true
    ),
    "rc" => array( 
        "p42_46" => 26, "p42_46_size" => 104, "p41_41" => 7, "p41_43" => 5, "p41_44" => 7,
        'p41_41_label' => array('模块温度' => true, '整流模块限流点（百分数）' => true, '模块输出电压' => true, "交流AB线电压" => true, "交流BC线电压" => true, "交流CA线电压" => true, "模块位置号" => true),
        "p41_43_label" => array("模块交流限功率" => true, "模块温度限功率" => true, "风扇全速" => true, "WALK-In模式" => true, "过压脱离" => true),
        "p41_43_rules" => array(
                0 => array(array(0x0 => "正常", 0x1 => "限功率"), "无效"), 
                1 => array(array(0x0 => "正常", 0x1 => "限功率"), "无效"),
                2 => array(array(0 => "正常", 0x1 => "全速"), "无效"),
                3 => array(array(0 => "使能", 0x1 => "禁止"), "无效"),
                4 => array(array(0 => "正常", 0x1 => "动作"), "无效")
        ),
        "p41_44_label" => array("模块保护" => true, "风扇故障" => true, "模块过温" => true, "模块限功率" => true, "模块交流停电" => true, "模块通讯中断" => true, "模块交流欠压" => true),
        'p41_44_rules' => array(
                0 => array(array(0 => "正常", 1 => "故障"), "无效"),
                1 => array(array(0 => "正常", 1 => "故障"), "无效"),
                2 => array(array(0 => "正常", 1 => "故障"), "无效"),
                3 => array(array(0 => "正常", 1 => "限功率"), "无效"),
                4 => array(array(0 => "正常", 0xe1 => "停电"), "无效"),
                5 => array(array(0 => "正常", 0xe2 => "故障"), "无效"),
                6 => array(array(0 => "正常", 1 => "欠压"), "无效")
        ),
        'params' => array()
    ),
    "dc" => array(
        "m" => 4, "n" => 9, "p" => 11, "alert_m" => 64, "alert_p" => 17,
        "p_label" => array('温度1' => true, '温度2' => true, "温度3" => true, "电池组1电压" => true, "电池组1实际容量百分比" => true, "电池组2电压" => true, "电池组2实际容量百分比" => true, "电池组3电压" => true, "电池组3>实际容量百分比" => true, "电池组4电压" => true, "电池组4实际容量百分比" => true,),
        "alert_p_label" => array('LVD1(低压脱离模块)' => true, 'LVD2(低压脱离模块)' => true, '温度1告警状态' => true, '温度2告警状态' => true, '温度3告警状态' => true, '直流屏通讯中断' => true, '温度1传感器故障' => true, '温度2传感器故障' => true, '温度3传感器故障' => true, '电池组1熔丝断' => true, '电池组1充电过流' => true, '电池组2熔丝断' => true, '电池组2充电过流' => true, '电池组3熔丝断' => true, '电池组3充电过流' => true, '电池组4熔丝断' => true, '电>池组4充电过流' => true),
        "alert_p_rules" => array(
                0 => array(array(0x0 => "正常", 0xE3 => "LVD1断开(负载下电)"), "无效"),
                1 => array(array(0x0 => "正常", 0xe4 => "LVD2断开(电池保护)"), "无效"),
                2 => array(array(0x0 => "正常", 0xe1 => "过温"), "无效"),
                3 => array(array(0x0 => "正常", 0xE1 => "过温"), "无效"),
                4 => array(array(0x0 => "正常", 0xE1 => "过温"), "无效"),
                5 => array(array(0x0 => "正常", 0xe2 => "通讯中断"), "无效"),
                6 => array(array(0x0 => "正常", 0x06 => "传感器故障"), "无效"),
                7 => array(array(0x0 => "正常", 0x06 => "传感器故障"), "无效"),
                8 => array(array(0x0 => "正常", 0x06 => "传感器故障"), "无效"),
                9 => array(array(0x0 => "正常", 0x03 => "熔丝断"), "无效"),
                10 => array(array(0x0 => "正常", 0x02 => "高于上限"), "无效"),
                11 => array(array(0x0 => "正常", 0x03 => "熔丝断"), "无效"),
                12 => array(array(0x0 => "正常", 0x02 => "高于上限"), "无效"),
                13 => array(array(0x0 => "正常", 0x03 => "熔丝断"), "无效"),
                14 => array(array(0x0 => "正常", 0x02 => "高于上限"), "无效"),
                15 => array(array(0x0 => "正常", 0x03 => "熔丝断"), "无效"),
                16 => array(array(0x0 => "正常", 0x02 => "高于上限"), "无效"),
        )
    ));
    return $config;
}

function Get_m810g_419_RtData($memData,&$dataArray,$extraPara = false) {
	if (!$memData) {
		$dataArray['无数据'] = true;
		$dataArray['更新时间'] = '无';
		$dataArray['错误'] = '数据长度不一致';
	} else {       
        $dataArray['无数据'] = false;
        $config = Get_m810g_config();
        require_once "./application/helpers/device/pmbuspower_419.php";
        _Get_PMBusPower_RtData($memData, $dataArray, $extraPara, $config);
    }
}


?>
