<?php
function Get_m816_DeviceIoControl_ErrorMsg($ret){
    switch($ret){
        case 1:
            return "执行成功";
        case 3:
            return "执行失败，校验不符";
        default:
            return "未知错误";
        }
}
function Get_m816_DeviceIoControl_Parameter($action, $parameter)
{
    if($action == 106 && count($parameter) == 1){
        return pack("S", intval($parameter[0]));
    }
    return -1;
}

function Get_m816_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '回风温度':
            return array(0, floatval($dataArray['本机温度']));
        case '温度设定点':
            return array(0, floatval($dataArray['温度设定值']));
        case '开关机状态':
            return array(0, $dataArray['当前机组状态']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_m816_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $dataArray["无数据"] = false;
        $dataArray["AlertArray"] = array();
        $v = unpack('S*',substr($memData, 4,2*4));
        $dataArray["本机温度"] = number_format($v[1]/10, 1).' ℃';
        $dataArray["本机湿度"] = number_format($v[2]/10, 1).' %';
        $dataArray["场地温度"] = number_format($v[3]/10, 1).' ℃';
        $dataArray["场地湿度"] = number_format($v[4]/10, 1).' %';
        $v = unpack('C',substr($memData, 4 + 2*4, 1));
        $dataArray["当前机组状态"] = $v[1] == 0 ? "关机" : "开机";

        $v = unpack('S',substr($memData, 4 + 2*4 + 1, 2));
        $dataArray["温度设定值"] = $v[1];
        $v = unpack('C*',substr($memData, 4 + 2*4 + 1 +2, 4));

        $dataArray['积水告警'] = ($v[1] >> 7) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['积水告警'] = ($v[1] >> 7) & 0x1;

        $dataArray['湿度1高限报警'] = ($v[1] >> 6) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['湿度1高限报警'] = ($v[1] >> 6) & 0x1;

        $dataArray['湿度2高限报警'] = ($v[1] >> 5) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['湿度2高限报警'] = ($v[1] >> 5) & 0x1;

        $dataArray['温度1高限报警'] = ($v[1] >> 4) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['温度1高限报警'] = ($v[1] >> 4) & 0x1;

        $dataArray['温度2高限报警'] = ($v[1] >> 3) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['温度2高限报警'] = ($v[1] >> 3) & 0x1;

        $dataArray['电压高限报警'] = ($v[1] >> 2) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['电压高限报警'] = ($v[1] >> 2) & 0x1;

        $dataArray['湿度1低限报警'] = ($v[1] >> 1) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['湿度1低限报警'] = ($v[1] >> 1) & 0x1;

        $dataArray['湿度2低限报警'] = ($v[1]) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['湿度2低限报警'] = ($v[1]) & 0x1;

        $dataArray['温度1低限报警'] = ($v[2] >> 7) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['温度1低限报警'] = ($v[2] >> 7) & 0x1;

        $dataArray['温度2低限报警'] = ($v[2] >> 6) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['温度2低限报警'] = ($v[2] >> 6) & 0x1;

        $dataArray['电压低限报警'] = ($v[2] >> 5) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['电压低限报警'] = ($v[2] >> 5) & 0x1;

        $dataArray['风机报警'] = ($v[3] >> 7) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['风机报警'] = ($v[3] >> 7) & 0x1;

        $dataArray['空气流量低'] = ($v[3] >> 6) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['空气流量低'] = ($v[3] >> 6) & 0x1;

        $dataArray['压缩机高压'] = ($v[3] >> 5) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['压缩机高压'] = ($v[3] >> 5) & 0x1;

        $dataArray['压缩机低压'] = ($v[3] >> 4) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['压缩机低压'] = ($v[3] >> 4) & 0x1;

        $dataArray['加湿器报警'] = ($v[3] >> 3) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['加湿器报警'] = ($v[3] >> 3) & 0x1;

        $dataArray['加热器报警'] = ($v[3] >> 2) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['加热器报警'] = ($v[3] >> 2) & 0x1;

        $dataArray['隔尘网淤塞'] = ($v[3] >> 1) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['隔尘网淤塞'] = ($v[3] >> 1) & 0x1;

        $dataArray['火灾报警'] = ($v[3]) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['火灾报警'] = ($v[3]) & 0x1;
        //alarm 3
        $dataArray['压缩机1高压报警'] = ($v[4] >> 6) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['压缩机1高压报警'] = ($v[4] >> 6) & 0x1;

        $dataArray['压缩机1低压报警'] = ($v[4] >> 5) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['压缩机1低压报警'] = ($v[4] >> 5) & 0x1;

        $dataArray['压缩机1过载报警'] = ($v[4] >> 4) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['压缩机1过载报警'] = ($v[4] >> 4) & 0x1;

        $dataArray['压缩机2高压报警'] = ($v[4] >> 3) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['压缩机2高压报警'] = ($v[4] >> 3) & 0x1;

        $dataArray['压缩机2低压报警'] = ($v[4] >> 2) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['压缩机2低压报警'] = ($v[4] >> 2) & 0x1;

        $dataArray['压缩机2过载报警'] = ($v[4] >> 1) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['压缩机2过载报警'] = ($v[4] >> 1) & 0x1;

        $v = unpack('C',substr($memData, 4 + 2*4 + 1 + 2+ 4, 1));
        $dataArray["风机"] = ($v[1] >> 7) & 0x1 ? "使能" : "关闭";
        $dataArray["压缩机"] = ($v[1] >> 6) & 0x1 ? "使能" : "关闭";
        $dataArray["压缩机正启动"] = ($v[1] >> 5) & 0x1 ? "使能" : "关闭";
        $dataArray["能效控制"] = ($v[1] >> 4) & 0x1 ? "使能" : "关闭";
        $dataArray["加湿器"] = ($v[1] >> 3) & 0x1 ? "使能" : "关闭";
        $dataArray["加热器"] = ($v[1] >> 2) & 0x1 ? "使能" : "关闭";
        $dataArray["除湿器"] = ($v[1] >> 1) & 0x1 ? "使能" : "关闭";
        $dataArray["矽控加热器"] = ($v[1]) & 0x1 ? "使能" : "关闭";

        $v = unpack('v',substr($memData, 4 + 2*4 + 1 + 2 + 4 + 1, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData, 4 + 2*4 + 1 + 2 + 4 + 1 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}
