<?php

 function Get_m822e_Standard_Variable($dataArray, $varname){
    var_dump($dataArray);die;
   
    switch ($varname){
        case '智能电表UPS配电屏电流不平衡率':
            return array(0, $dataArray['系统数据']['电流不平衡告警']);
        case '模块UPS模块故障告警':
            return array(0, $dataArray['系统数据']['多模块故障告警']);
        case '240V电池放电不平衡告警':
            return array(0, $dataArray['系统数据']['放电电流不平衡告警']);
        case 'UPS主机模块输出电流':    
            return array(0,$dataArray['整流模块1']['输出电流']);
        case '240V整流模块温度':    
            return array(0,$dataArray['整流模块1']['模块温度']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
} 
function Get_m822e_RtData($memData , &$dataArray , $extraPara = false){
             if($memData == false){
             	 $dataArray['无数据'] = true;
             	 $dataArray['更新时间'] = '无';
             	 $dataArray['错误'] = '数据长度不一致';
             }else{
                 $dataArray['无数据'] = false;
                 $dataArray['AlertArray'] = array();
                 $system_data = array();
                 $system_data['AlertArray'] = array();
             	 $v = unpack('C',substr($memData , 4 , 1));
             	 $system_data['整流模块数'] = $moduleNum = $v[1];
             	 $v = unpack('f*',substr($memData , 4 + 1, 4*2));
             	 $system_data['系统电压'] = number_format($v[1] , 2).' V';
             	 $system_data['系统负载'] = number_format($v[2] , 2).' A';
                 $v = unpack('C*', substr($memData, 4 + 1 + 4*2, 4));
                 $system_data['系统控制状态'] = $v[1] == 0xe0 ? '自动控制' : $v[1] == 0xe1 ? '手动控制' : '无效';
                 $system_data['EBU模块数'] = $ebuNum = $v[2];
                 $system_data['HDU模块数'] = $hduNum = $v[3];
                 $system_data['SMPDU模块数'] = $smpduNum = $v[4];
                 //M822E_41_41_t  整流模块模拟量
                 $v = unpack('f*',substr($memData , 4 + 1*5 + 4*2 , 4));
                 $system_data['整流模块输出平均电压'] = number_format($v[1] , 2).' V';
                 $offset = 21;
             	 for($i = 0 ; $i < $moduleNum ; $i++){
             	     $j = $i+1;
             	     $dataArray['整流模块'.$j] = array();
             	     $v = unpack('f*' , substr($memData, $offset , 4*1));
             	     $dataArray['整流模块'.$j]['输出电流'] = number_format($v[1] , 2).' A';
             	     $v = unpack('C*' , substr($memData, $offset + 4*1 , 1*1));
             	     //$dataArray['整流模块'.$j]['userP1'] = $v[1];
             	     $v = unpack('f*' , substr($memData, $offset + 4*1 + 1*1 , 4*7));
             	     $dataArray['整流模块'.$j]['模块温度'] = number_format($v[1] , 2).' ℃';
             	     $dataArray['整流模块'.$j]['模块限流点'] = number_format($v[2] , 2).' %';
             	     $dataArray['整流模块'.$j]['输出电压'] = number_format($v[3] , 2).' V';
             	     $dataArray['整流模块'.$j]['交流AB线电压'] = number_format($v[4] , 2).' V';
             	     $dataArray['整流模块'.$j]['交流BC线电压'] = number_format($v[5] , 2).' V';
             	     $dataArray['整流模块'.$j]['交流CA线电压'] = number_format($v[6] , 2).' V';
             	     $dataArray['整流模块'.$j]['模块位置号'] = $v[7];
             	     
             	     $offset += 33;;
             	 }
             	 $offset = 21 + $moduleNum * 33;
             	 //M822E_41_43_t  整流模块状态量
             	 for($i = 0 ; $i < $moduleNum ; $i++){
             	     $j = $i+1;
             	     $v = unpack('C*' , substr($memData, $offset , 1*9));
             	     $dataArray['整流模块'.$j]['开机/关机状态'] = $v[1] == 0 ? '开机' : '关机';
             	     $dataArray['整流模块'.$j]['限流状态'] = $v[2] == 0 ? '限流' : '不限流';
             	     switch($v[3]){
             	         case 0 : $dataArray['整流模块'.$j]['充电状态'] = '浮充'; break;
             	         case 1 : $dataArray['整流模块'.$j]['充电状态'] = '均充'; break;
             	         case 2 : $dataArray['整流模块'.$j]['充电状态'] = '测试'; break;
             	         case 3 : $dataArray['整流模块'.$j]['充电状态'] = '交流停电'; break;
             	         default : $dataArray['整流模块'.$j]['充电状态'] = '无效';
             	     }
             	     //$dataArray['整流模块'.$j]['userP2'] = $v[4];
             	     $dataArray['整流模块'.$j]['交流限功率'] = $v[5] == 1 ? '限功率' : '正常';
             	     $dataArray['整流模块'.$j]['温度限功率'] = $v[6] == 1 ? '限功率' : '正常';
             	     $dataArray['整流模块'.$j]['风扇全速'] = $v[7] == 1 ? '全速' : '正常';
             	     $dataArray['整流模块'.$j]['WALK－IN'] = $v[8] == 1 ? '使能' : '正常';
             	     $dataArray['整流模块'.$j]['过压脱离'] = $v[9] == 1 ? '动作' : '正常';
             	     
             	     $offset += 9;
             	 }
             	 $offset = 21 + $moduleNum * 42;
             	 //M822E_41_44_t  整流模块告警量
             	 for($i = 0 ; $i < $moduleNum ; $i++){
             	     $j = $i+1;
             	     $dataArray['整流模块'.$j]['AlertArray'] = array();
             	     $v = unpack('C*' , substr($memData, $offset , 1*9));
             	     $dataArray['整流模块'.$j]['模块故障'] = $v[1] == 1 ? '告警' : $v[1] == 0xE2 ? '通讯中断' : '正常';
             	     //$dataArray['整流模块'.$j]['userP3'] = $v[2];
             	     $dataArray['整流模块'.$j]['模块保护'] = $v[3] == 1 ? '告警' : '正常';
             	     $dataArray['整流模块'.$j]['风扇故障'] = $v[4] == 1 ? '告警' : '正常';
             	     $dataArray['整流模块'.$j]['模块过温'] = $v[5] == 1 ? '告警' : '正常';
             	     $dataArray['整流模块'.$j]['限功率'] = $v[6] == 1 ? '告警' : '正常';
             	     $dataArray['整流模块'.$j]['交流停电'] = $v[7] == 0xE1 ? '告警' : '正常';
             	     $dataArray['整流模块'.$j]['通讯中断'] = $v[8] == 0xE2 ? '告警' : '正常';
             	     $dataArray['整流模块'.$j]['交流欠压'] = $v[9] == 1 ? '告警' : '正常';
             	    
             	     $dataArray['整流模块'.$j]['AlertArray']['模块故障'] = ($v[1] == 1 || $v[1] == 0xE2);
             	     //$dataArray['整流模块'.$j]['userP3'] = $v[2];
             	     $dataArray['整流模块'.$j]['AlertArray']['模块保护'] = $v[3] == 1;
             	     $dataArray['整流模块'.$j]['AlertArray']['风扇故障'] = $v[4] == 1;
             	     $dataArray['整流模块'.$j]['AlertArray']['模块过温'] = $v[5] == 1;
             	     $dataArray['整流模块'.$j]['AlertArray']['限功率'] = $v[6] == 1;
             	     $dataArray['整流模块'.$j]['AlertArray']['交流停电'] = $v[7] == 0xE1;
             	     $dataArray['整流模块'.$j]['AlertArray']['通讯中断'] = $v[8] == 0xE2;
             	     $dataArray['整流模块'.$j]['AlertArray']['交流欠压'] = $v[9] == 1;
             	      
             	     $offset += 9;
             	 }
             	 $offset  = 21 + 51 * $moduleNum;
             	 //M822E_E1_41_t 系统模拟量
             	 //M822E_E1_43_t 系统状态量
             	 $v = unpack('C*' , substr($memData , $offset , 1*3));
             	 $system_data['系统是否告警状态'] = $v[1] == 1 ? '告警' : '正常';
             	 $system_data['AlertArray']['系统是否告警状态'] = $v[1] == 1;
             	 $system_data['电池手动/自动'] = $v[2] == 0xE0 ? '自动' : $v[2] == 0xE1 ? '手动' : '无效';
             	 switch ($v[3]){
             	     case 0 : $system_data['电池均充/浮充'] = '浮充'; break;
             	     case 1 : $system_data['电池均充/浮充'] = '均充'; break;
             	     case 2 : $system_data['电池均充/浮充'] = '测试'; break;
             	     case 3 : $system_data['电池均充/浮充'] = '交流停电'; break;
             	     default : $system_data['电池均充/浮充'] = '无效';
             	 }
             	 //M822E_E1_44_t 系统告警
             	 $v = unpack('C*' , substr($memData , $offset + 1*3 , 1*22));
             	 $system_data['电流不平衡告警'] = $v[1] == 1 ? '告警' : '正常';
             	 $system_data['重载告警'] = $v[2] == 1 ? '告警' : '正常';
             	 $system_data['CAN通讯故障告警'] = $v[3] == 1 ? '告警' : '正常';
             	 //$system_data['userP'] = $v[4];
             	 $system_data['多模块故障告警'] = $v[5] == 1 ? '告警' : '正常';
             	 $system_data['模块丢失告警'] = $v[6] == 1 ? '告警' : '正常';
             	 $system_data['电池放电告警'] = $v[7] == 1 ? '告警' : '正常';
             	 $system_data['短测试告警'] = $v[8] == 1 ? '告警' : '正常';
             	 $system_data['坏电池告警'] = $v[9] == 1 ? '告警' : '正常';
             	 $system_data['计划测试告警'] = $v[10] == 1 ? '告警' : '正常';
             	 $system_data['交流停电测试告警'] = $v[11] == 1 ? '告警' : '正常';
             	 $system_data['手动测试告警'] = $v[12] == 1 ? '告警' : '正常';
             	 $system_data['放电电流不平衡告警'] = $v[13] == 1 ? '告警' : '正常';
             	 $system_data['周期均充告警'] = $v[14] == 1 ? '告警' : '正常';
             	 $system_data['自动均充告警'] = $v[15] == 1 ? '告警' : '正常';
             	 $system_data['手动均充告警'] = $v[16] == 1 ? '告警' : '正常';
             	 $system_data['异常电池电流告警'] = $v[17] == 1 ? '告警' : '正常';
             	 $system_data['温补激活告警'] = $v[18] == 1 ? '告警' : '正常';
             	 $system_data['限流告警'] = $v[19] == 1 ? '告警' : '正常';
             	 $system_data['预均充告警'] = $v[20] == 1 ? '告警' : '正常';
             	 $system_data['模块组交流停电告警'] = $v[21] == 1 ? '告警' : '正常';
             	 $system_data['交流屏组交流停电告警'] = $v[22] == 1 ? '告警' : '正常';
             	 
             	 $system_data['AlertArray']['电流不平衡告警'] = $v[1] == 1;
             	 $system_data['AlertArray']['重载告警'] = $v[2] == 1;
             	 $system_data['AlertArray']['CAN通讯故障告警'] = $v[3] == 1;
             	 $system_data['AlertArray']['多模块故障告警'] = $v[5] == 1;
             	 $system_data['AlertArray']['模块丢失告警'] = $v[6] == 1;
             	 $system_data['AlertArray']['电池放电告警'] = $v[7] == 1;
             	 $system_data['AlertArray']['短测试告警'] = $v[8] == 1;
             	 $system_data['AlertArray']['坏电池告警'] = $v[9] == 1;
             	 $system_data['AlertArray']['计划测试告警'] = $v[10] == 1;
             	 $system_data['AlertArray']['交流停电测试告警'] = $v[11] == 1;
             	 $system_data['AlertArray']['手动测试告警'] = $v[12] == 1;
             	 $system_data['AlertArray']['放电电流不平衡告警'] = $v[13] == 1;
             	 $system_data['AlertArray']['周期均充告警'] = $v[14] == 1;
             	 $system_data['AlertArray']['自动均充告警'] = $v[15] == 1;
             	 $system_data['AlertArray']['手动均充告警'] = $v[16] == 1;
             	 $system_data['AlertArray']['异常电池电流告警'] = $v[17] == 1;
             	 $system_data['AlertArray']['温补激活告警'] = $v[18] == 1;
             	 $system_data['AlertArray']['限流告警'] = $v[19] == 1;
             	 $system_data['AlertArray']['预均充告警'] = $v[20] == 1;
             	 $system_data['AlertArray']['模块组交流停电告警'] = $v[21] == 1;
             	 $system_data['AlertArray']['交流屏组交流停电告警'] = $v[22] == 1;
             	 
                 $offset += 25; 
                 $dataArray['系统数据'] = $system_data;

                 //ebu module
                 for($i = 0 ; $i < $ebuNum ; $i++){
                     $j = $i+1;
                     $dataArray['EBU模块'.$j] = array();
                     $v = unpack('f*' , substr($memData , $offset, 4*2));
                     $dataArray['EBU模块'.$j]['电池串电压'] = number_format($v[1] , 2).' V';
                     $dataArray['EBU模块'.$j]['电池串电流'] = number_format($v[2] , 2).' A';
                     $v = unpack('C' , substr($memData , $offset + 4*2, 1));
                     $dataArray['EBU模块'.$j]['温度数量'] = $temNum = $v[1];
                     $v = unpack('f*' , substr($memData , $offset + 4*2 + 1, 4*$temNum));
                     for($m = 1 ; $m <= $temNum ; $m++){
                         $dataArray['EBU模块'.$j]['电池温度'.$m] = number_format($v[$m] , 2).' ℃';
                     }
                     $v = unpack('C' , substr($memData , $offset + 4*(2 + $temNum) + 1, 1));
                     $dataArray['EBU模块'.$j]['电池块数'] = $batteryNum = $v[1];
                     $v = unpack('f*' , substr($memData , $offset + 4*(2 + $temNum) + 1*2, 4*$batteryNum));
                     for($n = 1 ; $n <= $batteryNum ; $n++){
                         $dataArray['EBU模块'.$j]['电池电压'.$n] = number_format($v[$n] , 2).' V';
                     }
                     $offset += 10 + 4*$temNum + 4*$batteryNum;
                 }
                 //ebu module alert
                 for($i = 0; $i < $ebuNum; $i++){
                     $j = $i+1;
                     $dataArray['EBU告警'.$j] = array();
                     $dataArray['EBU告警'.$j]['AlertArray'] = array();
                     $v = unpack('C' , substr($memData , $offset, 1));
                     $dataArray['EBU告警'.$j]['电池块数'] = $batteryNum = $v[1];
                     $v = unpack('C*' , substr($memData , $offset + 1, 2*($batteryNum +1)));
                     for($m = 1; $m <= $batteryNum ; $m++)
                     {
                         $dataArray['EBU告警'.$j]['电池'.$m.'电压过压'] = $v[($m * 2 - 1)] ==  0xE2 ? '通讯中断' : $v[($m * 2 - 1)] == 1 ? '告警' : '正常';
                         $dataArray['EBU告警'.$j]['电池'.$m.'电压欠压'] = $v[($m * 2)] ==  0xE2 ? '通讯中断' : $v[($m * 2)] == 1 ? '告警' : '正常';
                     }
                     $dataArray['EBU告警'.$j]['尾电池电压过压'] = $v[(2*$batteryNum+1)] ==  0xE2 ? '通讯中断' : $v[(2*$batteryNum+1)] == 1 ? '告警' : '正常';
                     $dataArray['EBU告警'.$j]['尾电池电压欠压'] = $v[(2*$batteryNum+2)] ==  0xE2 ? '通讯中断' : $v[(2*$batteryNum+2)] == 1 ? '告警' : '正常';
                     $v = unpack('C*' , substr($memData , $offset + 1 + 2*($batteryNum +1), 2));
                     $dataArray['EBU告警'.$j]['通讯状态'] = $v[1] ==  0xE2 ? '通讯中断' : $v[1] == 1 ? '告警' : '正常';
                     $dataArray['EBU告警'.$j]['温度路数'] = $temNum = $v[2];
                     $v = unpack('C*' , substr($memData , $offset + 3 + 2*($batteryNum +1), 2*$temNum));
                     for($n = 1; $n <= $temNum; $n++)
                     {
                         $dataArray['EBU告警'.$j]['温度'.$n.'过温'] = $v[($n * 2 - 1)] ==  0xE2 ? '通讯中断' : $v[($n * 2 - 1)] == 1 ? '告警' : '正常';
                         $dataArray['EBU告警'.$j]['温度'.$n.'欠温'] = $v[($n * 2)] ==  0xE2 ? '通讯中断' : $v[($n * 2)] == 1 ? '告警' : '正常';
                     }
                     $offset += 3 + 2*($batteryNum +1) + 2*$temNum;
                 }
                 //hdu模拟量
                 for($j = 0; $j < $hduNum ; $j++){
                     $hduModule = array();
                     $hduModule['AlertArray'] = array();
                     //header1
                     $v = unpack('C' , substr($memData , $offset, 1));
                     $hduModule['HDU序号'] = $v[1];
                     $v = unpack('f*' , substr($memData , $offset + 1 , 4*4));
                     $hduModule['母排电压'] = number_format($v[1] , 2).' V';
                     $hduModule['负载总电流'] = number_format($v[2] , 2).' A';
                     $hduModule['温度1'] = number_format($v[3] , 2).' ℃';
                     $hduModule['温度2'] = number_format($v[4] , 2).' ℃';
                     $v = unpack('C' , substr($memData , $offset + 1 + 16, 1));
                     $hduModule['支路数量'] = $branch_n = $v[1];
                     //header2
                     $v = unpack('f*' , substr($memData , $offset + 2 + 16, 12*4));
                     $hduModule['一路A相电压'] = number_format($v[1] , 2).' V';
                     $hduModule['一路B相电压'] = number_format($v[2] , 2).' V';
                     $hduModule['一路C相电压'] = number_format($v[3] , 2).' V';
                     $hduModule['二路A相电压'] = number_format($v[4] , 2).' V';
                     $hduModule['二路B相电压'] = number_format($v[5] , 2).' V';
                     $hduModule['二路C相电压'] = number_format($v[6] , 2).' V';
                     $hduModule['一路交流A相电流'] = number_format($v[7] , 2).' A';
                     $hduModule['一路交流B相电流'] = number_format($v[8] , 2).' A';
                     $hduModule['一路交流C相电流'] = number_format($v[9] , 2).' A';
                     $hduModule['二路交流A相电流'] = number_format($v[10] , 2).' A';
                     $hduModule['二路交流B相电流'] = number_format($v[11] , 2).' A';
                     $hduModule['二路交流C相电流'] = number_format($v[12] , 2).' A';
                     $v = unpack('C*' , substr($memData , $offset + 2 + 16*4, 3 ));
                     $hduModule['交流支路数量'] = $ac_branch_z = $v[1];
                     //header3
                     $hduModule['主路绝缘状态'] = $v[2] == 1 ? '异常' : '正常';
                     $hduModule['AlertArray']['主路绝缘状态'] = $v[2] == 1;
                     $hduModule['主从状态'] = $v[3] == 1 ? '主机' : '从机';
                     $v = unpack('f*' , substr($memData , $offset + 5 + 16*4, 2*4));
                     $hduModule['正对地保护电阻'] = number_format($v[1] , 2).' KΩ';
                     $hduModule['负对地保护电阻'] = number_format($v[2] , 2).' KΩ';
                     $v = unpack('C*' , substr($memData , $offset + 5 + 18*4, 2));
                     $hduModule['电池数量'] = $battery_k = $v[1];
                     $hduModule['HDU地址'] = $v[2];
                     $v = unpack('f*' , substr($memData , $offset + 7 + 18*4, $branch_n * 4));
                     for($k = 0 ; $k < $branch_n ; $k++){
                         $hduModule['支路'.($k+1).'电流'] = number_format($v[$k+1] , 2).' A';
                     }
                     $v = unpack('f*' , substr($memData , $offset + 7 + 18*4 + $branch_n * 4 , $ac_branch_z * 4));
                     for($m = 0 ; $m < $ac_branch_z ; $m++){
                         $hduModule['交流支路'.($m+1).'电流'] = number_format($v[$m+1] , 2).' A';
                     }
                     $v = unpack('f*' , substr($memData , $offset + 7 + 18*4 + $branch_n * 4 + $ac_branch_z * 4, $ac_branch_z * 4));
                     for($n = 0 ; $n < $ac_branch_z ; $n++){
                         $hduModule['交流支路'.($n+1).'负载率'] = number_format($v[$n+1] , 2);
                     }
                     $v = unpack('f*' , substr($memData , $offset + 7 + 18*4 + $branch_n * 4 + $ac_branch_z * 4 * 2, $battery_k * 12));
                     for($p = 0 ; $p < $battery_k ; $p++){
                         $hduModule['电池电流'.($p+1)] = number_format($v[$n*3+1] , 2).' A';
                         $hduModule['电池容量'.($p+1)] = number_format($v[$n*3+2] , 2).' AH';
                         $hduModule['容量百分比'.($p+1)] = number_format($v[$n*3+3] , 2).' %';
                     }
                     $dataArray['HDU模块'.($j+1)] = $hduModule;
                     $offset += 7 + 18*4 + $branch_n*4 + $ac_branch_z*4*2 + $battery_k*12;
                 }
                //hdu alert
                 $hduAlarmArr1 = array('通信中断','交流1路输入停电','交流1路A相欠压','交流1路A相过压','交流1路A相缺相','交流1路B相欠压','交流1路B相过压','交流1路B相缺相','交流1路C相欠压','交流1路C相过压','交流1路C相缺相',
                     '交流2路输入停电','交流2路A相欠压','交流2路A相过压','交流2路A相缺相','交流2路B相欠压','交流2路B相过压','交流2路B相缺相','交流2路C相欠压','交流2路C相过压','交流2路C相缺相');
                 $hduAlarmArr2 = array('直流欠压','直流过压','温度1高','温度2高','温度1传感器未接','温度2传感器未接','温度1传感器故障','温度2传感器故障','监控故障','电池1开关故障','电池2开关故障');
                 $hduAlarmArr3 = array('电池支路1告警','电池支路2告警','电池支路3告警','电池支路4告警','总负载熔丝断','LVD1下电','LVD2下电','LVD1回采错','LVD2回采错');
                 for($i = 0 ; $i < $hduNum ; $i++){
                     $hduAlarm = array();
                     $hduAlarm['AlertArray'] = array();
                     $v = unpack('C*' , substr($memData , $offset + $i*555, 555));
                     $hduAlarm['HDU序号'] = $v[1];
                     foreach($hduAlarmArr1 as $key=>$alarm){
                         $hduAlarm[$alarm] = $v[$key+2] == 1 ? '告警' : '正常';
                         $hduAlarm['AlertArray'][$alarm] = $v[$key+2] == 1;
                     }
                     for($j = 0 ; $j < 100 ; $j++){
                         $hduAlarm['交流支路'.($j+1).'电流告警'] = $v[$j+23] == 1 ? '重载' : $v[$j+23] == 2 ? '过载' : '正常';
                         $hduAlarm['AlertArray']['交流支路'.($j+1).'电流告警'] = ($v[$j+23] == 1 || $v[$j+23] == 2);
                     }
                     for($k = 0 ; $k < 100 ; $k++){
                         $hduAlarm['交流熔丝'.($k+1).'断'] = $v[$k+123] == 1 ? '告警' : '正常';
                         $hduAlarm['AlertArray']['交流熔丝'.($k+1).'断'] = $v[$k+123] == 1;
                     }
                     $hduAlarm['HDU电池数量'] = $v[223];
                     //rsv 6
                     $hduAlarm['温度1低'] = $v[230] == 1 ? '告警' : '正常';
                     $hduAlarm['温度2低'] = $v[231] == 1 ? '告警' : '正常';
                     //数字输入  1 2 3 4
                     $hduAlarm['负载辅助支路断'] = $v[236] == 1 ? '告警' : '正常';
                     $hduAlarm['AlertArray']['温度1低'] = $v[230] == 1;
                     $hduAlarm['AlertArray']['温度2低'] = $v[231] == 1;
                     $hduAlarm['AlertArray']['负载辅助支路断'] = $v[236] == 1;
                     for($m = 0 ; $m < 100 ; $m++){
                         $hduAlarm['负载熔丝'.($m+1).'断'] = $v[$m+237] == 1 ? '告警' : '正常';
                         $hduAlarm['AlertArray']['负载熔丝'.$m.'断'] = $v[$m+237] == 1;
                     }
                     foreach($hduAlarmArr2 as $key=>$alarm){
                         $hduAlarm[$alarm] = $v[$key+337] == 1 ? '告警' : '正常';
                         $hduAlarm['AlertArray'][$alarm] = $v[$key+337] == 1;
                     }
                     for($n = 0 ; $n < 100 ; $n++){
                         $hduAlarm['支路'.($n+1).'电流告警'] = $v[$n+348] == 1 ? '重载' : $v[$n+348] == 2 ? '过载' : '正常';
                         $hduAlarm['AlertArray']['支路'.$n.'电流告警'] = ($v[$n+348] == 1 || $v[$n+348] == 2);
                     }
                     foreach($hduAlarmArr3 as $key=>$alarm){
                         $hduAlarm[$alarm] = $v[$key+448] == 1 ? '告警' : '正常';
                         $hduAlarm['AlertArray'][$alarm] = $v[$key+448] == 1;
                     }
                     switch($v[457]){
                         case 1 : $hduAlarm['主路绝缘故障'] = '绝缘故障'; break;
                         case 2 : $hduAlarm['主路绝缘故障'] = '支路互感器坏'; break;
                         case 3 : $hduAlarm['主路绝缘故障'] = '正绝缘故障'; break;
                         case 4 : $hduAlarm['主路绝缘故障'] = '负绝缘故障'; break;
                         case 5 : $hduAlarm['主路绝缘故障'] = '正负绝缘故障'; break;
                         default : $hduAlarm['主路绝缘故障'] = '正常';
                     }
                     switch($v[457]){
                         case 1 : 
                         case 2 : 
                         case 3 : 
                         case 4 : 
                         case 5 : $hduAlarm['AlertArray']['主路绝缘故障'] = true ; break;
                         default : $hduAlarm['AlertArray']['主路绝缘故障'] = false ;
                     }
                     //egu1 2 3 4
                     for($p = 0 ; $p < 90 ; $p++){
                         switch($v[$p+462]){
                             case 1 : $hduAlarm['支路'.($p+1).'绝缘故障'] = '绝缘故障'; break;
                             case 2 : $hduAlarm['支路'.($p+1).'绝缘故障'] = '支路互感器坏'; break;
                             case 3 : $hduAlarm['支路'.($p+1).'绝缘故障'] = '正绝缘故障'; break;
                             case 4 : $hduAlarm['支路'.($p+1).'绝缘故障'] = '负绝缘故障'; break;
                             case 5 : $hduAlarm['支路'.($p+1).'绝缘故障'] = '正负绝缘故障'; break;
                             default : $hduAlarm['支路'.($p+1).'绝缘故障'] = '正常';
                         }
                         switch($v[$p+462]){
                             case 1 :
                             case 2 :
                             case 3 :
                             case 4 :
                             case 5 : $hduAlarm['AlertArray']['支路'.($p+1).'绝缘故障'] = true ; break;
                             default : $hduAlarm['AlertArray']['支路'.($p+1).'绝缘故障'] = false ;
                         }
                     }
                     //egu 1 2 3 4    552-555
                     $dataArray['HDU告警'.($i+1)] = $hduAlarm;
                 }
                 $offset += $hduNum * 555;

             	 $v = unpack('v', substr($memData, $offset , 2));
             	 $year = $v[1];
             	 $v = unpack('C*', substr($memData, $offset + 2 , 5));
             	 $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
             }
}