//处理页面显示table
function GetDeviceTableString(signalArr){
	var pTr= '<table class="table table-bordered responsive table-striped table-sortable "><thead>'+
	'<tr><th>序号</th><th>信号名称</th><th>当前值</th><th>序号</th><th>信号名称</th><th>当前值</th><th>序号</th><th>信号名称</th><th>当前值</th>'+
	'<th>序号</th><th>信号名称</th><th>当前值</th></tr></thead><tbody>';
    var pTr_signal = '';
    for(var j = 0 ; j < signalArr.length ; j++){
        if (j % 4 == 0) {
        	pTr_signal += "<tr>";
	        }
        pTr_signal += '<td>'+(j+1)+'</td><td class="device_property_label">'+ signalArr[j] +'</td><td><span class="label label-success"></span></td>';
        if (j % 4 == 3) {
        	pTr_signal += "</tr>";
	        }
    }
    if(signalArr.length % 4 != 0)
    {
        for(var k = 0 ; k < (4 - signalArr.length % 4); k++){
        	pTr_signal += "<td></td><td></td><td></td>";
        }
        pTr_signal += '</tr>';
    }
    pTr += pTr_signal;
    pTr += '</tbody></table>';
    return pTr;
}

function show_m822e_data(displayBody, dataObj){
	//系统数据
	if(dataObj['系统数据'] != undefined){
		ShowDeviceData(displayBody.find('.systemData tbody'), dataObj['系统数据']);
	}
	//整流模块数据
	displayBody.find('.rcModuleAlarm').empty();
	displayBody.find('.rcModuleStatus').empty();
	displayBody.find('.rcModuleSignal').empty();
	for(var i = 0 ; i < dataObj['系统数据']['整流模块数'] ; i++){
		var j = i+1;
		var pTr_rcAlarm = $('<h5>整流模块 '+ j +' 告警</h5>\
				<table class="table table-bordered responsive table-striped table-sortable ">\
			<thead>\
				<tr>\
					<th>序号</th>\
					<th>信号名称</th>\
					<th>当前值</th>\
			        <th>序号</th>\
			        <th>信号名称</th>\
			        <th>当前值</th>\
			        <th>序号</th>\
			        <th>信号名称</th>\
			        <th>当前值</th>\
			        <th>序号</th>\
			        <th>信号名称</th>\
			        <th>当前值</th>\
				</tr>\
			</thead>\
			<tbody>\
		        <tr>\
					<td>1</td>\
					<td class="device_property_label">模块故障</td>\
					<td><span class="label label-success"></span></td>\
					<td>2</td>\
					<td class="device_property_label">模块保护</td>\
					<td><span class="label label-success"></span></td>\
					<td>3</td>\
					<td class="device_property_label">风扇故障</td>\
					<td><span class="label label-success"></span></td>\
					<td>4</td>\
					<td class="device_property_label">模块过温</td>\
					<td><span class="label label-success"></span></td>\
			    </tr>\
			    <tr>\
					<td>5</td>\
					<td class="device_property_label">限功率</td>\
					<td><span class="label label-success"></span></td>\
					<td>6</td>\
					<td class="device_property_label">交流停电</td>\
					<td><span class="label label-success"></span></td>\
					<td>7</td>\
					<td class="device_property_label">通讯中断</td>\
					<td><span class="label label-success"></span></td>\
					<td>8</td>\
					<td class="device_property_label">交流欠压</td>\
					<td><span class="label label-success"></span></td>\
			    </tr>\
                </tbody>\
		    </table>');
		var pTr_rcStatus = $('<h5>整流模块 '+ j +' 状态</h5>\
				<table class="table table-bordered responsive table-striped table-sortable ">\
				<thead>\
					<tr>\
						<th>序号</th>\
						<th>信号名称</th>\
						<th>当前值</th>\
				        <th>序号</th>\
				        <th>信号名称</th>\
				        <th>当前值</th>\
				        <th>序号</th>\
				        <th>信号名称</th>\
				        <th>当前值</th>\
				        <th>序号</th>\
				        <th>信号名称</th>\
				        <th>当前值</th>\
					</tr>\
				</thead>\
				<tbody>\
			        <tr>\
						<td>1</td>\
						<td class="device_property_label">开机/关机状态</td>\
						<td><span class="label label-success"></span></td>\
						<td>2</td>\
						<td class="device_property_label">限流状态</td>\
						<td><span class="label label-success"></span></td>\
						<td>3</td>\
						<td class="device_property_label">充电状态</td>\
						<td><span class="label label-success"></span></td>\
						<td>4</td>\
						<td class="device_property_label">交流限功率</td>\
						<td><span class="label label-success"></span></td>\
				    </tr>\
				    <tr>\
						<td>5</td>\
						<td class="device_property_label">温度限功率</td>\
						<td><span class="label label-success"></span></td>\
						<td>6</td>\
						<td class="device_property_label">风扇全速</td>\
						<td><span class="label label-success"></span></td>\
						<td>7</td>\
						<td class="device_property_label">WALK－IN</td>\
						<td><span class="label label-success"></span></td>\
						<td>8</td>\
						<td class="device_property_label">过压脱离</td>\
						<td><span class="label label-success"></span></td>\
				    </tr>\
                    </tbody>\
			    </table>');
		var pTr_rcSignal = $('<h5>整流模块 '+ j +' 数据</h5>\
				<table class="table table-bordered responsive table-striped table-sortable ">\
				<thead>\
					<tr>\
						<th>序号</th>\
						<th>信号名称</th>\
						<th>当前值</th>\
				        <th>序号</th>\
				        <th>信号名称</th>\
				        <th>当前值</th>\
				        <th>序号</th>\
				        <th>信号名称</th>\
				        <th>当前值</th>\
				        <th>序号</th>\
				        <th>信号名称</th>\
				        <th>当前值</th>\
					</tr>\
				</thead>\
				<tbody>\
			        <tr>\
						<td>1</td>\
						<td class="device_property_label">输出电流</td>\
						<td><span class="label label-success"></span></td>\
						<td>2</td>\
						<td class="device_property_label">模块温度</td>\
						<td><span class="label label-success"></span></td>\
						<td>3</td>\
						<td class="device_property_label">模块限流点</td>\
						<td><span class="label label-success"></span></td>\
						<td>4</td>\
						<td class="device_property_label">输出电压</td>\
						<td><span class="label label-success"></span></td>\
				    </tr>\
				    <tr>\
						<td>5</td>\
						<td class="device_property_label">交流AB线电压</td>\
						<td><span class="label label-success"></span></td>\
						<td>6</td>\
						<td class="device_property_label">交流BC线电压</td>\
						<td><span class="label label-success"></span></td>\
						<td>7</td>\
						<td class="device_property_label">交流CA线电压</td>\
						<td><span class="label label-success"></span></td>\
						<td>8</td>\
						<td class="device_property_label">模块位置号</td>\
						<td><span class="label label-success"></span></td>\
				    </tr>\
                    </tbody>\
			    </table>');
		displayBody.find('.rcModuleAlarm').append(pTr_rcAlarm);
		displayBody.find('.rcModuleStatus').append(pTr_rcStatus);
		displayBody.find('.rcModuleSignal').append(pTr_rcSignal);
	}
	for(var m = 0 ; m < dataObj['系统数据']['整流模块数'] ; m++){
		if(dataObj['整流模块'+ (m+1)] != undefined){
			ShowDeviceData(displayBody.find('.rcModuleAlarm tbody:eq('+ m +')'),dataObj['整流模块'+(m+1)]);
			ShowDeviceData(displayBody.find('.rcModuleStatus tbody:eq('+ m +')'),dataObj['整流模块'+(m+1)]);
			ShowDeviceData(displayBody.find('.rcModuleSignal tbody:eq('+ m +')'),dataObj['整流模块'+(m+1)]);
		}
	}

	//EBU数据
	displayBody.find('.ebuModuleSignal').empty();
	displayBody.find('.ebuModuleAlarm').empty();
	for(var i = 0 ; i < dataObj['系统数据']['EBU模块数'] ; i++){
		var signalArr = new Array('电池串电压','电池串电流','温度数量','电池块数');
		var alarmArr = new Array('电池块数','温度路数','通讯状态');
		if(dataObj['EBU模块'+(i+1)]['温度数量'] > 0){
			for(var m = 0 ; m < dataObj['EBU模块'+(i+1)]['温度数量'] ; m++){
				signalArr.push('电池温度'+(m+1));
			}
		}
		if(dataObj['EBU模块'+(i+1)]['电池块数'] > 0){
			for(var n = 0 ; n < dataObj['EBU模块'+(i+1)]['电池块数'] ; n++){
				signalArr.push('电池电压'+(n+1));
			}
		}
		if(dataObj['EBU告警'+(i+1)]['温度路数'] > 0){
			for(var p = 0 ; p < dataObj['EBU告警'+(i+1)]['温度路数'] ; p++){
				alarmArr.push('温度'+(p+1)+'过温');
				alarmArr.push('温度'+(p+1)+'欠温');
			}
		}
		if(dataObj['EBU告警'+(i+1)]['电池块数'] > 0){
			for(var q = 0 ; q < dataObj['EBU告警'+(i+1)]['电池块数'] ; q++){
				alarmArr.push('电池'+(q+1)+'电压过压');
				alarmArr.push('电池'+(q+1)+'电压欠压');
			}
		}
		alarmArr.push('尾电池电压过压');
		alarmArr.push('尾电池电压欠压');
		//ebu模拟量页面信号
		var pTr_ebuSignal= '<h5>EBU模块 '+ (i+1) +' 数据</h5>';
		pTr_ebuSignal += GetDeviceTableString(signalArr);
		pTr = $(pTr_ebuSignal);
		displayBody.find('.ebuModuleSignal').append(pTr);
		//ebu告警页面信号
		var pTr_ebuAlarm= '<h5>EBU模块 '+ (i+1) +' 告警</h5>';
		pTr_ebuAlarm += GetDeviceTableString(alarmArr);
		pTr = $(pTr_ebuAlarm);
		displayBody.find('.ebuModuleAlarm').append(pTr);
	}
	for(var m = 0 ; m < dataObj['系统数据']['EBU模块数'] ; m++){
		if(dataObj['EBU模块'+(m+1)] != undefined){
			ShowDeviceData(displayBody.find('.ebuModuleSignal tbody:eq('+ m +')') , dataObj['EBU模块'+(m+1)]);
		}
		if(dataObj['EBU告警'+(m+1)] != undefined){
			ShowDeviceData(displayBody.find('.ebuModuleAlarm tbody:eq('+ m +')') , dataObj['EBU告警'+(m+1)]);
		}
	}

	//HDU数据
	displayBody.find('.hduModuleSignal').empty();
	displayBody.find('.hduModuleAlarm').empty();
	for(var j = 0 ; j < dataObj['系统数据']['HDU模块数'] ; j++){
		//hdu模拟量
		var hduSignalArr = new Array('HDU序号','HDU地址','主路绝缘状态','主从状态','支路数量','交流支路数量','电池数量','母排电压','负载总电流','温度1','温度2','一路A相电压','一路B相电压',
				'一路C相电压','二路A相电压','二路B相电压','二路C相电压','一路交流A相电流','一路交流B相电流','一路交流C相电流','二路交流A相电流','二路交流B相电流','二路交流C相电流','正对地保护电阻',
				'负对地保护电阻');
		if(dataObj['HDU模块'+(j+1)]['支路数量'] > 0){
			for(var m = 0 ; m < dataObj['HDU模块'+(j+1)]['支路数量'] ; m++){
				hduSignalArr.push('支路'+(m+1)+'电流');
			}
		}
		if(dataObj['HDU模块'+(j+1)]['交流支路数量'] > 0){
			for(var n = 0 ; n < dataObj['HDU模块'+(j+1)]['交流支路数量'] ; n++){
				hduSignalArr.push('交流支路'+(n+1)+'电流');
			}
			for(var p = 0 ; p < dataObj['HDU模块'+(j+1)]['交流支路数量'] ; p++){
				hduSignalArr.push('交流支路'+(p+1)+'负载率');
			}
		}
		if(dataObj['HDU模块'+(j+1)]['电池数量'] > 0){
			for(var q = 0 ; q < dataObj['HDU模块'+(j+1)]['电池数量'] ; q++){
				hduSignalArr.push('电池电流'+(q+1));
				hduSignalArr.push('电池容量'+(q+1));
				hduSignalArr.push('容量百分比'+(q+1));
			}
		}
		var pTr_hduSignal = '<h5>HDU模块 '+(j+1)+' 数据</h5>';
		pTr_hduSignal += GetDeviceTableString(hduSignalArr);
		pTr = $(pTr_hduSignal);
		displayBody.find('.hduModuleSignal').append(pTr);
		//hdu告警
		var hduAlarmArr = new Array();
		for(var alarmKey in dataObj['HDU告警'+(j+1)]){
			if(alarmKey != 'AlertArray'){
				hduAlarmArr.push(alarmKey);
			}
		}
		var pTr_hduAlarm = '<h5>HDU模块 '+(j+1)+' 告警</h5>';
		pTr_hduAlarm += GetDeviceTableString(hduAlarmArr);
		pTr = $(pTr_hduAlarm);
		displayBody.find('.hduModuleAlarm').append(pTr);
	}
	for(var k = 0 ; k <dataObj['系统数据']['HDU模块数'] ; k++){
		if(dataObj['HDU模块'+(k+1)] != undefined){
			ShowDeviceData(displayBody.find('.hduModuleSignal tbody:eq('+k+')') , dataObj['HDU模块'+(k+1)]);
		}
		if(dataObj['HDU告警'+(k+1)] != undefined){
			ShowDeviceData(displayBody.find('.hduModuleAlarm tbody:eq('+k+')') , dataObj['HDU告警'+(k+1)]);
		}
	}

  displayBody.find(".childTabs li").off("click").on("click", function () {
      $(this).addClass("active");
      $(this).siblings().removeClass("active");
      var i = $(this).index();
      $(this).parent().parent().parent().find(".tab-content").eq(i).show();
      $(this).parent().parent().parent().find(".tab-content").eq(i).siblings(".tab-content").hide();
  })
}
