<?php
function _ma01dh_ShowAlert(&$dataArray, $label, $value, $vsValue)
{
    $dataArray[$label] = $value == $vsValue ? '正常' : '告警';
    $dataArray['AlertArray'][$label] = $value != $vsValue;
}

function Get_ma01dh_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, floatval($dataArray['A路进线_电压']));
        case '[B相电压]':
            return array(0, floatval($dataArray['B路进线_电压']));
        case "[总功率]":
            return array(0, floatval($dataArray['A路进线-有功功率']) + floatval($dataArray["B路进线-有功功率"]));
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_ma01dh_Active_Power($dataArray){
    return array(0 , floatval($dataArray["A路进线-有功电能"]) + floatval($dataArray["B路进线-有功电能"]));
}

function Get_ma01dh_RtData($memData, &$dataArray, $extraPara = false)
{
    if($memData == false){
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
        $dataArray['无数据'] = true;
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        //模拟量
        $v = unpack('S*',substr($memData,4,28*2));
        $dataArray["A路进线电压"] = ((((int)$v[1]) << 16) + $v[2] )/100 ."V";
        $dataArray["A路进线电流"] = ((((int)$v[3]) << 16) + $v[4] )/100 ."A";
        $dataArray["A路进线有功功率"] = ((((int)$v[5]) << 16) + $v[6] )/1000 ."KW";
        $dataArray["A路进线有功电能"] = ((((int)$v[7]) << 16) + $v[8] )/10 ."KWh";
        $dataArray["A路进线正极绝缘电阻"] = ((((int)$v[9]) << 16) + $v[10] )/100 ."KΩ";
        $dataArray["A路进线负极绝缘电阻"] = ((((int)$v[11]) << 16) + $v[12] )/100 ."KΩ";
        $dataArray["A路进线电流负载比"] = ((((int)$v[13]) << 16) + $v[14] )/100 ."%";

        $dataArray["B路进线电压"] = ((((int)$v[15]) << 16) + $v[16] )/100 ."V";
        $dataArray["B路进线电流"] = ((((int)$v[17]) << 16) + $v[18] )/100 ."A";
        $dataArray["B路进线有功功率"] = ((((int)$v[19]) << 16) + $v[20] )/1000 ."KW";
        $dataArray["B路进线有功电能"] = ((((int)$v[21]) << 16) + $v[22] )/10 ."KWh";
        $dataArray["B路进线正极绝缘电阻"] = ((((int)$v[23]) << 16) + $v[24] )/100 ."KΩ";
        $dataArray["B路进线负极绝缘电阻"] = ((((int)$v[25]) << 16) + $v[26] )/100 ."KΩ";
        $dataArray["B路进线电流负载比"] = ((((int)$v[27]) << 16) + $v[28] )/100 ."%";

        for($i=0;$i<32;$i++)
        {
            $offset = 3*$i;
            $l1 = str_pad(3*$i+1, 2, "0", STR_PAD_LEFT);
            $l2 = str_pad(3*$i+2, 2, "0", STR_PAD_LEFT);
            $l3 = str_pad(3*$i+3, 2, "0", STR_PAD_LEFT);
            $v = unpack('S*',substr($memData, 4 + 28*2 + 2*36*$i, 2*36));
            $dataArray["出线支路{$l1}/A{$l1}电压"] = ((((int)$v[1]) << 16) + $v[2] )/100 ."V";
            $dataArray["出线支路{$l2}/A{$l2}电压"] = ((((int)$v[3]) << 16) + $v[4] )/100 ."V";
            $dataArray["出线支路{$l3}/A{$l3}电压"] = ((((int)$v[5]) << 16) + $v[6] )/100 ."V";
    
            $dataArray["出线支路{$l1}/A{$l1}电流"] = ((((int)$v[7]) << 16) + $v[8] )/100 ."A";
            $dataArray["出线支路{$l2}/A{$l2}电流"] = ((((int)$v[9]) << 16) + $v[10] )/100 ."A";
            $dataArray["出线支路{$l3}/A{$l3}电流"] = ((((int)$v[11]) << 16) + $v[12] )/100 ."A";
    
            $dataArray["出线支路{$l1}/A{$l1}绝缘电阻"] = ((((int)$v[13]) << 16) + $v[14] )/100 ."KΩ";
            $dataArray["出线支路{$l2}/A{$l2}绝缘电阻"] = ((((int)$v[15]) << 16) + $v[16] )/100 ."KΩ";
            $dataArray["出线支路{$l3}/A{$l3}绝缘电阻"] = ((((int)$v[17]) << 16) + $v[18] )/100 ."KΩ";
    
            $dataArray["出线支路{$l1}/A{$l1}有功功率"] = ((((int)$v[19]) << 16) + $v[20] )/1000 ."KW";
            $dataArray["出线支路{$l2}/A{$l2}有功功率"] = ((((int)$v[21]) << 16) + $v[22] )/1000 ."KW";
            $dataArray["出线支路{$l3}/A{$l3}有功功率"] = ((((int)$v[23]) << 16) + $v[24] )/1000 ."KW";
    
            $dataArray["出线支路{$l1}/A{$l1}有功电能"] = ((((int)$v[25]) << 16) + $v[26] )/10 ."KWh";
            $dataArray["出线支路{$l2}/A{$l2}有功电能"] = ((((int)$v[27]) << 16) + $v[28] )/10 ."KWh";
            $dataArray["出线支路{$l3}/A{$l3}有功电能"] = ((((int)$v[29]) << 16) + $v[30] )/10 ."KWh";
    
            $dataArray["出线支路{$l1}/A{$l1}电流负载比"] = ((((int)$v[31]) << 16) + $v[32] )/100 ."%";
            $dataArray["出线支路{$l2}/A{$l2}电流负载比"] = ((((int)$v[33]) << 16) + $v[34] )/100 ."%";
            $dataArray["出线支路{$l3}/A{$l3}电流负载比"] = ((((int)$v[35]) << 16) + $v[36] )/100 ."%";
        }
        $v = unpack('S*',substr($memData, 4 + 28*2 + 2*36*32, 2*101));

        _ma01dh_ShowAlert($dataArray, "单路/Ⅰ路进线开关告警状态", $v[1]  == 1, 0);
        _ma01dh_ShowAlert($dataArray, "单路/Ⅰ路进线防雷器告警状态", $v[2]  == 1, 0);
        _ma01dh_ShowAlert($dataArray, "Ⅱ路进线开关告警状态", $v[3]  == 1, 0);
        _ma01dh_ShowAlert($dataArray, "Ⅱ路进线防雷器告警状态", $v[4]  == 1, 0);
        
        for($i=0;$i<24;$i++)
        {
            $name = "出线支路".($i+1)."/Ⅰ".($i+1)."开关告警状态";
            _ma01dh_ShowAlert($dataArray, $name, $v[5+$i] == 1, 0);
        }
        for($i=0;$i<24;$i++)
        {
            $name = "出线支路".($i+1)."/Ⅱ".($i+1)."开关告警状态";
            _ma01dh_ShowAlert($dataArray, $name, $v[29+$i] == 1, 0);
        }
        for($i=0;$i<24;$i++)
        {
            $name = "出线支路".($i+1)."/Ⅰ".($i+1)." 开关告警状态";
            _ma01dh_ShowAlert($dataArray, $name, $v[53 +$i ] == 1, 0);
        }
        for($i=0;$i<24;$i++)
        {
            $name = "出线支路".($i+1)."/Ⅱ".($i+1)."开关告警状态";
            _ma01dh_ShowAlert($dataArray, $name, $v[77+$i] == 1, 0);
        }
        
        $dataArray['智能电表电流和'] = (floatval($dataArray['A路进线_电流']) + floatval($dataArray['B路进线_电流'])) . ' A';
        $dataArray['智能电表电压'] = $dataArray['A路进线_电压'];
        $dataArray['智能电表有功功率'] = number_format((floatval($dataArray['智能电表电流和']) * floatval($dataArray['智能电表电压']))/1000,2 ,'.','') . ' kW';
        //$dataArray['智能电表耗电量'] = number_format((floatval($dataArray['智能电表有功功率']) * 24),2 ,'.','') . ' kWh';
        $dataArray['智能电表耗电量'] = number_format((floatval($dataArray["A路进线-有功电能"]) + floatval($dataArray["B路进线-有功电能"])),2 ,'.','') . ' kWh';
        $dataArray['直流列柜电能'] = $dataArray['智能电表耗电量'];

        $v = unpack('v',substr($memData, 4 + 28*2 + 2*36*32 + 2*101, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData, 4 + 28*2 + 2*36*32 + 2*101 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}

?>
