<?php

function _GetMars16EngineState($v)
{
    switch ($v) {
        case 17: return "初始化";
        case 18: return "准备未就绪";
        case 19: return "Prestart";
        case 20: return "曲柄启动";
        case 21: return "暂停";
        case 22: return "启动";
        case 23: return "正在运行";
        case 24: return "加载";
        case 25: return "停止";
        case 26: return "关机";
        case 27: return "准备就绪";
        case 28: return "冷却";
        case 29: return "EmergMan";
        case 30: return "ManIdle";
        case 31: return "电源操作";
        case 32: return "电源故障";
        case 33: return "电源故障";
        case 34: return "IslOper";
        case 35: return "MainsRet";
        case 36: return "停机";
        case 37: return "没有定时器";
        case 38: return "MCB关闭";
        case 39: return "ReturnDel";
        case 40: return "Trans Del";
        case 41: return "Idle Run";
        case 42: return "MinStabTO";
        case 43: return "MaxStabTO";
        case 44: return "AfterCool";
        case 45: return "GCB开启";
        case 46: return "StopValve";
        case 47: return "开始删除";
        case 48: return "(1Ph)";
        case 49: return "(3PD)";
        case 50: return "(3PY)";
        case 51: return "MRS模式";
    }
    return "无效";
}
function _GetMars16ControllerMode($v)
{
    switch ($v) {
        case 0: return "关闭";
        case 1: return "手动";
        case 2: return "自动";
    }
    return "无效";
}

function Get_mars16_RtData($memData, &$dataArray, $extraPara = false)
{
    //后台多浪费点存储，反正一段时间后就回收了
    if (empty($memData)) {
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    } else {
        $dataArray["无数据"] = false;
        $dataArray["AlertArray"] = array();
        $v = unpack('S*', substr($memData, 4, 2 * 11));
        $dataArray["L1相电压"] = number_format($v[1], 2) .' V';
        $dataArray["L2相电压"] = number_format($v[2], 2) .' V';
        $dataArray["L3相电压"] = number_format($v[3], 2) .' V';
        $dataArray["L1-L2线电压"] = number_format($v[4], 2) .' V';
        $dataArray["L2-L3线电压"] = number_format($v[5], 2) .' V';
        $dataArray["L3-L1线电压"] = number_format($v[6], 2) .' V';
        $dataArray["L1相电流"] = number_format($v[7], 2) .' A';
        $dataArray["L2相电流"] = number_format($v[8], 2) .' A';
        $dataArray["L3相电流"] = number_format($v[9], 2) .' A';
        $dataArray["发动机转速"] = number_format($v[10], 2) .' RPM';
        $dataArray["频率"] = number_format($v[11]/10, 2) .' Hz';
        $v = unpack('s*', substr($memData, 4 + 2 * 11, 2 * 13));
        $dataArray["有功功率"] = number_format($v[1], 2) .' KW';
        $dataArray["L1相有功功率"] = number_format($v[2], 2).' KW';
        $dataArray["L2相有功功率"] = number_format($v[3], 2).' KW';
        $dataArray["L3相有功功率"] = number_format($v[4], 2).' KW';
        $dataArray["标称视在功率"] = number_format($v[5], 2).' KVA';
        $dataArray["无功功率"] = number_format($v[6], 2) .' KVAr';
        $dataArray["L1相无功功率"] = number_format($v[7], 2).' KVAr';
        $dataArray["L2相无功功率"] = number_format($v[8], 2).' KVAr';
        $dataArray["L3相无功功率"] = number_format($v[9], 2).' KVAr';
        $dataArray["总功率因数"] = number_format($v[10], 2) ."%";
        $dataArray["L1功率因数"] = number_format($v[11], 2)."%";
        $dataArray["L2功率因数"] = number_format($v[12], 2)."%";
        $dataArray["L3功率因数"] = number_format($v[13], 2)."%";
        $v = unpack('S*', substr($memData, 4 + 2 * 24, 2 * 8));
        //$dataArray["Gen_Char"] = number_format($v[1], 2);
        //$dataArray["Gen_Char_L1"] = number_format($v[2], 2);
        //$dataArray["Gen_Char_L2"] = number_format($v[3], 2);
        //$dataArray["Gen_Char_L3"] = number_format($v[4], 2);
        $dataArray["总视在功率"] = number_format($v[5], 2).' KVA';
        $dataArray["L1视在功率"] = number_format($v[6], 2).' KVA';
        $dataArray["L2视在功率"] = number_format($v[7], 2).' KVA';
        $dataArray["L3视在功率"] = number_format($v[8], 2).' KVA';
        $v = unpack('S*', substr($memData, 4 + 2 * 32, 2));
        $dataArray["接地故障"] = $v[1];
        if($v[1] == 1)
        {
            $dataArray["AlertArray"]["接地故障"] = 1;
        }
        $v = unpack('s*', substr($memData, 4 + 2 * 33, 2 * 9));
        $dataArray["电池电压(V)"] = number_format($v[1]/10, 2)." V";
        $dataArray["D"] = number_format($v[2], 2);
        $dataArray["油压"] =  ($v[3] == 0x8000) ? "0.0" : number_format($v[3], 2);
        $dataArray["发电机温度"] =  ($v[4] == 0x8000) ? "0.0" : number_format($v[4], 2);
        $dataArray["备用"] = $v[5];
        //$dataArray["IOM_AI1"] = number_format($v[6], 2);
        //$dataArray["IOM_AI2"] = number_format($v[7], 2);
        //$dataArray["IOM_AI3"] = number_format($v[8], 2);
        //$dataArray["IOM_AI4"] = number_format($v[9], 2);
        $v = unpack('S*', substr($memData, 4 + 2 * 42, 2 * 3));
        $Bin_Inputs = $v[1];
        $dataArray["远程 启动/停止"] = ($Bin_Inputs  & 0x1) == 1 ? '启动' : '停止';
        $Bin_Outputs = $v[2];
        $dataArray["启动器 开/关"] = ($Bin_Outputs & 0x1) == 1 ? '开' : '关';
        $dataArray["供油阀 开/关"] = (($Bin_Outputs >> 1) & 0x1) == 1 ? '开' : '关';
        $dataArray["运行状态"] = (($Bin_Outputs >> 1) & 0x1) == 1 ? '运行' : '停机';
        $IOM_Bin_Inp = $v[3];
        $dataArray["IOM BI1 报警"] = ($IOM_Bin_Inp & 0x1) == 1 ? "告警" : "正常";
        $dataArray["AlertArray"]["IOM BI1 报警"] = ($IOM_Bin_Inp & 0x1) == 1;
        $dataArray["IOM BI2 报警"] = (($IOM_Bin_Inp>>1) & 0x1) == 1 ? "告警" : "正常";
        $dataArray["AlertArray"]["IOM BI2 报警"] = (($IOM_Bin_Inp>>1) & 0x1) == 1;
        $dataArray["IOM BI3 报警"] = (($IOM_Bin_Inp>>2) & 0x1) == 1 ? "告警" : "正常";
        $dataArray["AlertArray"]["IOM BI3 报警"] = (($IOM_Bin_Inp>>2) & 0x1) == 1;
        $dataArray["IOM BI4 报警"] = (($IOM_Bin_Inp>>3) & 0x1) == 1 ? "告警" : "正常";
        $dataArray["AlertArray"]["IOM BI4 报警"] = (($IOM_Bin_Inp>>3) & 0x1) == 1;
        $dataArray["IOM BI5 报警"] = (($IOM_Bin_Inp>>4) & 0x1) == 1 ? "告警" : "正常";
        $dataArray["AlertArray"]["IOM BI5 报警"] = (($IOM_Bin_Inp>>4) & 0x1) == 1;
        $dataArray["IOM BI6 报警"] = (($IOM_Bin_Inp>>5) & 0x1) == 1 ? "告警" : "正常";
        $dataArray["AlertArray"]["IOM BI6 报警"] = (($IOM_Bin_Inp>>5) & 0x1) == 1;
        $dataArray["IOM BI7 报警"] = (($IOM_Bin_Inp>>6) & 0x1) == 1 ? "告警" : "正常";
        $dataArray["AlertArray"]["IOM BI7 报警"] = (($IOM_Bin_Inp>>6) & 0x1) == 1;
        $dataArray["IOM BI8 报警"] = (($IOM_Bin_Inp>>7) & 0x1) == 1 ? "告警" : "正常";
        $dataArray["AlertArray"]["IOM BI8 报警"] = (($IOM_Bin_Inp>>7) & 0x1) == 1;

        $v = unpack('S*', substr($memData, 4 + 2 * 45, 2 * 6));
        //$dataArray["Led_GCB_Green"] = $v[1];
        //$dataArray["Led_MCB_Green"] = $v[2];
        //$dataArray["Led_GEN_Green"] = $v[3];
        //$dataArray["Led_GEN_Red"] = $v[4];
        //$dataArray["Led_MAINSGreen"] = $v[5];
        //$dataArray["Led_MAINS_Red"] = $v[6];
        $v = unpack('S*', substr($memData, 4 + 2 * 51, 2 * 3));
        $EngineState = $v[1];
        $dataArray["发动机状态"] = _GetMars16EngineState($v[1]);
        $dataArray["断路器状态"] = _GetMars16EngineState($v[2]);
        //$dataArray["Timer_Text"] = $v[3];
        $v = unpack('S*', substr($memData, 4 + 2 * 54, 2 * 17));
        //$dataArray["Timer_Values"] = $v[1];
        //$dataArray["FW_Branch"] = $v[2];
        //$dataArray["FW_Version"] = $v[3];
        //$dataArray["Application"] = $v[4];
        //$dataArray["ControllerMode_1"] = _GetMars16ControllerMode($v[5]);
        //$dataArray["ControllerMode_2"] = _GetMars16ControllerMode($v[6]);
        //$dataArray["Ig_Nom"] = $v[7];
        //$dataArray["IgMax"] = $v[8];
        //$dataArray["ST_1"] = $v[9];
        //$dataArray["ST_2"] = $v[10];
        //$dataArray["ST_3"] = $v[11];
        //$dataArray["ST_4"] = $v[12];
        //$dataArray["NomAn1_CU"] = $v[13];
        //$dataArray["NomAn2_CU"] = $v[14];
        //$dataArray["NomAn3_CU"] = $v[15];
        //$dataArray["NomAn1_IOM"] = $v[16];
        $dataArray["控制模式"] = _GetMars16ControllerMode($v[17]);
        //这里开始告警
        $v = unpack('C', substr($memData, 4 + 2 * 71, 1));
        $dataArray["告警总数"] = $v[1];

        $dataArray["告警列表"] = array();
        for($i=0; $i < $dataArray["告警总数"]; $i++)
        {
            $v = unpack('C*', substr($memData, 4 + 2*71 + 1 + 51*$i, 51));
            $dataArray["告警列表"][] = implode("", array_slice($v,1) );
        }


        $v = unpack('v', substr($memData, 4 + 2 * 71 + 1 + 51*15, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 2 * 71 + 1 + 51*15 + 2, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));


        if($EngineState == 28 || $EngineState == 25 || $EngineState == 26){//运行状态    紧急停机  低油压  告警
			$dataArray["紧急停机"] = (($Bin_Inputs >> 2) & 0x1) == 0 ? '告警' : '正常';
			$dataArray["低油压"] = (($Bin_Inputs >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray["AlertArray"]["紧急停机"] = (($Bin_Inputs >> 2) & 0x1) == 0;
            $dataArray["AlertArray"]["低油压"] = (($Bin_Inputs >> 3) & 0x1) == 1;
		}else{
			$dataArray["紧急停机"] = '正常';
			$dataArray["低油压"] = '正常';
            $dataArray["AlertArray"]["紧急停机"] = 0;
            $dataArray["AlertArray"]["低油压"] = 0;
		}
        $dataArray["高水温"] = (($Bin_Inputs >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["高水温"] = (($Bin_Inputs >> 4) & 0x1) == 1;

    }
}


?>
