<?php


function Get_mb5000l_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
        /* $dataObj->isEmpty = true;
        $dataObj->update_datetime = '无'; */
    } else {
        $dataArray["无数据"] = false;
        $dataArray['AlertArray'] = array();
        $v = unpack('C*', substr($memData, 4, 3));
        $dataArray["市电电压过低告警"] = $v[1] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["市电电压过低告警"] = $v[1] == 1;
        $dataArray["市电电压过高告警"] = $v[2] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["市电电压过高告警"] = $v[2] == 1;
        $dataArray["市电电压停电告警"] = $v[3] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["市电电压停电告警"] = $v[3] == 1;
        $v = unpack('f*', substr($memData, 4 + 3, 4*3));
        $dataArray["重合闸"]["过压阀值"] = number_format($v[1], 2)."V";
        $dataArray["重合闸"]["低压阀值"] = number_format($v[2], 2)."V";
        $dataArray["重合闸"]["停电阈值"] = number_format($v[3], 2)."V";
        $v = unpack('C', substr($memData, 4 + 3 + 4*3, 1));
        $dataArray["重合闸"]["状态"] = $v[1] == 0 ? "分闸" : "合闸";
        //front door
        $v = unpack('C', substr($memData, 4 + 3 + 4*3 + 1, 17));
        $dataArray["前门"] = array();
        $dataArray["前门"]["卡号"] = chr($v[1]).chr($v[2]).chr($v[3]).chr($v[4]).chr($v[5]).chr($v[6]).chr($v[7]).chr($v[8]);
        $dataArray["前门"]["卡号2"] = chr($v[9]).chr($v[10]).chr($v[11]).chr($v[12]).chr($v[13]).chr($v[14]).chr($v[15]).chr($v[16]);
        $dataArray["前门"]["卡有效"] = $v[1] == 0 ? "授权卡" : "非授权卡";
        $v = unpack("S", substr($memData, 4 + 3 + 4*3 + 1 + 17, 2));
        $dataArray["前门"]["机号"] = $v[1];
        $v = unpack("C*", substr($memData, 4 + 3 + 4*3 + 1 + 17 + 2, 4));
        $dataArray["前门"]["有效期"] = $v[1]."-".$v[2]."-".$v[3]."-".$v[4];
        $v = unpack("S*", substr($memData, 4 + 3 + 4*3 + 1 + 17 + 2 + 4, 2*4));
        $dataArray["前门"]["权限"] = $v[1];
        $dataArray["前门"]["区号"] = $v[2];
        $dataArray["前门"]["锁状态"] = $v[3] == 0 ? "关闭" : "开启";
        switch($v[4])
        {
            case 1:
                $dataArray["前门"]["锁事件"] = "正常开门";
                break;
            case 2:
                $dataArray["前门"]["锁事件"] = "非正常开门";
                break;
            case 3:
                $dataArray["前门"]["锁事件"] = "正常开门后关门";
                break;
            case 4:
                $dataArray["前门"]["锁事件"] = "非正常开门后关门";
                break;
            default:
                $dataArray["前门"]["锁事件"] = "无事件";
                break;
        }
        //back door
        $v = unpack('C', substr($memData, 4 + 3 + 4*3 + 1 + 17 + 2 + 4 + 2*4, 17));
        $dataArray["后门"] = array();
        $dataArray["后门"]["卡号"] = chr($v[1]).chr($v[2]).chr($v[3]).chr($v[4]).chr($v[5]).chr($v[6]).chr($v[7]).chr($v[8]);
        $dataArray["后门"]["卡号2"] = chr($v[9]).chr($v[10]).chr($v[11]).chr($v[12]).chr($v[13]).chr($v[14]).chr($v[15]).chr($v[16]);
        $dataArray["后门"]["卡有效"] = $v[1] == 0 ? "授权卡" : "非授权卡";
        $v = unpack("S", substr($memData, 4 + 3 + 4*3 + 1 + 17 + 2 + 4 + 2*4 + 17, 2));
        $dataArray["后门"]["机号"] = $v[1];
        $v = unpack("C*", substr($memData, 4 + 3 + 4*3 + 1 + 17 + 2 + 4 + 2*4 + 17 + 2, 4));
        $dataArray["后门"]["有效期"] = $v[1]."-".$v[2]."-".$v[3]."-".$v[4];
        $v = unpack("S*", substr($memData, 4 + 3 + 4*3 + 1 + 17 + 2 + 4 + 2*4 + 17 + 2 + 4, 2*4));
        $dataArray["后门"]["权限"] = $v[1];
        $dataArray["后门"]["区号"] = $v[2];
        $dataArray["后门"]["锁状态"] = $v[3] == 0 ? "关闭" : "开启";
        switch($v[4])
        {
            case 1:
                $dataArray["后门"]["锁事件"] = "正常开门";
                break;
            case 2:
                $dataArray["后门"]["锁事件"] = "非正常开门";
                break;
            case 3:
                $dataArray["后门"]["锁事件"] = "正常开门后关门";
                break;
            case 4:
                $dataArray["后门"]["锁事件"] = "非正常开门后关门";
                break;
            default:
                $dataArray["后门"]["锁事件"] = "无事件";
                break;
        }
        //env
        $offset = 4 + 3 + 4*3 + 1 + 17 + 2 + 4 + 2*4 + 17 + 2 + 4 + 2*4;
        $v = unpack('C*', substr($memData, $offset, 5));
        
        $dataArray["烟感告警"] = $v[1] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["烟感告警"] = $v[1] == 1;
        $dataArray["前门告警"] = $v[2] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["前门告警"] = $v[2] == 1;
        $dataArray["后门告警"] = $v[3] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["后门告警"] = $v[3] == 1;
        $dataArray["倾斜震动告警"] = $v[4] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["倾斜震动告警"] = $v[4] == 1;
        $dataArray["水浸告警"] = $v[5] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["水浸告警"] = $v[5] == 1;

        $v = unpack('f*', substr($memData, $offset + 5, 4*2));
        $dataArray["温度"] = number_format($v[1], 2)."℃";
        $dataArray["湿度"] = number_format($v[2], 2)."%RH";

        $v = unpack('C*', substr($memData, $offset + 5 + 4*2, 3));
        $dataArray["温度过高告警"] = $v[1] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["温度过高告警"] = $v[1] == 1;
        $dataArray["温度过低告警"] = $v[2] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["温度过低告警"] = $v[2] == 1;
        $dataArray["湿度过高告警"] = $v[3] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["湿度过高告警"] = $v[3] == 1;

        $v = unpack('f*', substr($memData, $offset + 5 + 4*2 + 3, 4*3));
        $dataArray["温度过高阈值"] = number_format($v[1], 2)."℃";
        $dataArray["温度过低阈值"] = number_format($v[2], 2)."℃";
        $dataArray["湿度过高阈值"] = number_format($v[3], 2)."%RH";
        //AC
        $offset = $offset + 5 + 4*2 + 3 + 4*3;
        $v = unpack('C*', substr($memData, $offset, 4));
        $dataArray["空调设备通讯状态"] = $v[1] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["空调设备通讯状态"] = $v[1] == 1;
        $dataArray["空调"]["压缩机状态"] = $v[2] == 0 ? "关闭" : "开启";
        $dataArray["空调"]["内风机状态"] = $v[3] == 0 ? "关闭" : "开启";
        $dataArray["空调"]["外风机状态"] = $v[4] == 0 ? "关闭" : "开启";

        $v = unpack('f*', substr($memData, $offset + 4, 4*7));
        $dataArray["空调"]["普通空调工作电流"] = number_format($v[1], 2)."A";
        $dataArray["空调"]["回风温度"] = number_format($v[2], 2)."℃";
        $dataArray["空调"]["运行温度设定"] = number_format($v[3], 2)."℃";
        $dataArray["空调"]["制冷点"] = number_format($v[4], 2)."℃";
        $dataArray["空调"]["加热点"] = number_format($v[5], 2)."℃";
        $dataArray["空调"]["高温点"] = number_format($v[6], 2)."℃";
        $dataArray["空调"]["低温点"] = number_format($v[7], 2)."℃";
        //reclosing
        $offset = $offset + 4 + 4*7;
        $v = unpack('f*', substr($memData, $offset, 4*2));
        $dataArray["重合闸"]["市电电压"] = number_format($v[1], 2)."V";
        $dataArray["重合闸"]["市电电流"] = number_format($v[2], 2)."A";

        $v = unpack('C*', substr($memData, $offset + 4*2, 15));
        $dataArray["重合闸设备通讯状态"] = $v[1] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["重合闸设备通讯状态"] = $v[1] == 1;

        $dataArray["空调"]["设备工作状态"] = $v[2] == 0 ? "关闭" : "开启";

        $dataArray["前门设备通讯状态"] = $v[3] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["前门设备通讯状态"] = $v[3] == 1;
        $dataArray["后门设备通讯状态"] = $v[4] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["后门设备通讯状态"] = $v[4] == 1;
        //Heat exchanger
        $dataArray["热交换机设备通讯状态"] = $v[5] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["热交换机设备通讯状态"] = $v[5] == 1;
        $dataArray["热交换机"]["机组运行状态"] = $v[6] == 0 ? "关闭" : "开启";
        $dataArray["热交换机"]["自检状态"] = $v[7] == 0 ? "关闭" : "开启";
        $dataArray["热交换机"]["内分机运行状态"] = $v[8] == 0 ? "关闭" : "开启";
        $dataArray["热交换机"]["外风机运行状态"] = $v[9] == 0 ? "关闭" : "开启";
        $dataArray["热交换机"]["制热运行状态"] = $v[10] == 0 ? "关闭" : "开启";
        
        $dataArray["热交换机回风温度传感器故障"] = $v[11] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["热交换机回风温度传感器故障"] = $v[11] == 1;
        $dataArray["热交换机柜内高温告警"] = $v[12] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["热交换机柜内高温告警"] = $v[12] == 1;
        $dataArray["热交换机柜内低温告警"] = $v[13] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["热交换机柜内低温告警"] = $v[13] == 1;
        $dataArray["热交换机外部输入告警"] = $v[14] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["热交换机外部输入告警"] = $v[14] == 1;
        $dataArray["热交换机柜外温度传感器故障"] = $v[15] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["热交换机柜外温度传感器故障"] = $v[15] == 1;

        $v = unpack('f*', substr($memData, $offset + 4*2 + 15, 4*10));
        $dataArray["热交换机"]["内分机启动温度"] = number_format($v[1], 2)."℃";
        $dataArray["热交换机"]["内分机停止回差值"] = number_format($v[2], 2)."℃";
        $dataArray["热交换机"]["外风机启动温度"] = number_format($v[3], 2)."℃";
        $dataArray["热交换机"]["外风机停止回差值"] = number_format($v[4], 2)."℃";
        $dataArray["热交换机"]["制热启动温度"] = number_format($v[5], 2)."℃";
        $dataArray["热交换机"]["制热停止回差值"] = number_format($v[6], 2)."℃";
        $dataArray["热交换机"]["高温告警温度值"] = number_format($v[7], 2)."℃";
        $dataArray["热交换机"]["低温告警温度值"] = number_format($v[8], 2)."℃";
        $dataArray["热交换机"]["柜内回风温度"] = number_format($v[9], 2)."℃";
        $dataArray["热交换机"]["柜外环境温度"] = number_format($v[10], 2)."℃";
        
        $offset = $offset + 4*2 + 15 + 4*10;
        $v = unpack('C*', substr($memData, $offset, 4));
        $dataArray["重合闸电源过流"] = $v[1] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["重合闸电源过流"] = $v[1] == 1;
        $dataArray["重合闸电源短路"] = $v[1] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["重合闸电源短路"] = $v[1] == 1;
        $dataArray["重合闸漏电报警"] = $v[1] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["重合闸漏电报警"] = $v[1] == 1;
        $dataArray["重合闸缺相报警"] = $v[1] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["重合闸缺相报警"] = $v[1] == 1;

        $v = unpack('f*', substr($memData, $offset + 4, 4*2));
        $dataArray["空调"]["制冷回差"] = number_format($v[1], 2)."℃";
        $dataArray["空调"]["加热回差"] = number_format($v[2], 2)."℃";

        $v = unpack('C', substr($memData, $offset + 4 + 4*2, 1));
        $dataArray["烟感2告警"] = $v[1] == 0 ? "正常" : "告警";
        $dataArray["AlertArray"]["烟感2告警"] = $v[1] == 1;

        $offset = $offset + 4 + 4*2 + 1;
        $v = unpack('v', substr($memData, $offset, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, $offset + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}


?>
