<?php

function Get_mc2600_UnicomCategory()
{
    return "419";
}

function _GetPMBusCheckMsg($value, $model = '')
{
        switch ($value) {
            case 0:
                return "正常";
            case 1:
                return "低于下限";
            case 2:
                return "高于上限";
            case 3:
                return "缺相";
            case 4:
                return "熔丝断";
            case 5:
                return "开关断开";
            case 0xe0:
                return "交流输入不平衡";
            case 0xe1:
                return "交流停电";
            case 0xe2:
                return "通讯中断";
            case 0xe3:
                return "市电切换失败";
            default:
                return "正常";
        }
        return "无效";
}

function _CheckAlertMap($value, $rules)
{
        if (isset($rules)) {
            if (isset($rules[0][$value])) {
                return $rules[0][$value];
            }
            return $rules[1];
        }
        //default handler
        if ($value == 0) {
            return "正常";
        } else if ($value == 1) {
            return "故障";
        }
        return "无效";
}

function _GetPMBus41_44Msg($v, $model = '')
{
        switch ($v) {
            case 0:
                return "正常";
            case 1:
                return "故障";
        }
        return "未知告警" . dechex($v);
}

function _GetAlertM($value)
{
        switch ($value) {
            case 0:
                return "正常";
            case 3:
                return "熔丝断";
            case 4:
                return "开";
            default:
                break;
        }

        return "无效";
}

function Get_mc2600_RtData($memData,&$dataArray,$extraPara = false) {
	if (!$memData) {
		$dataArray['无数据'] = true;
		$dataArray['更新时间'] = '无';
		$dataArray['错误'] = '数据长度不一致';
	} else {
		$dataArray['无数据'] = false;
        $p40_41_number = 0;
        $p40_44_number = 7;

        $v = unpack('f*', substr($memData, 4, 3 * 4));
        $dataArray["交流屏输出电流A"] = number_format($v[1], 2);
        $dataArray["交流屏输出电流B"] = number_format($v[2], 2);
        $dataArray["交流屏输出电流C"] = number_format($v[3], 2);
        $acChannelLen = (16 + 6 + 4 * 0 + 7);
        for ($i = 0; $i < 2; $i++) {
            $channelData = substr($memData, 4 + 3 * 4 + $i * $acChannelLen, $acChannelLen);
            $v = unpack('f*', substr($channelData, 0, 4 * 4));
            $dataArray["交流输入".($i+1)."输入线/相电压AB/A"] = number_format($v[1], 2);
            $dataArray["交流输入".($i+1)."输入线/相电压BC/B"] = number_format($v[2], 2);
            $dataArray["交流输入".($i+1)."输入线/相电压CA/C"] = number_format($v[3], 2);
            $dataArray["交流输入".($i+1)."输入频率"] = number_format($v[4], 2);
            $v = unpack('C', substr($channelData, 4 * 4, 1));
            
            // $channelObj->p40_41_count = $v[1];
            // if ($channelObj->p40_41_count != $p40_41_number) {
            //     $dataObj->isMatch = false;
            // }
            // $v = unpack('f*', substr($channelData, 4 * 4 + 1, 4 * $p40_41_number));
            // $channelObj->p40_41 = array();
            // foreach ($v as $val) {
            //     if (abs($val - (-0.1)) < 0.1) {
            //         $channelObj->p40_41[] = "未监测";
            //     } else {
            //         $channelObj->p40_41[] = number_format($val, 2);
            //     }
            // }
            $v = unpack('C*', substr($channelData, 4 * 4 + 1 + 4 * $p40_41_number, 5));
            $dataArray["交流输入".($i+1)."输入线/相电压AB/A告警"] = _GetPMBusCheckMsg($v[1], '');
            $dataArray["交流输入".($i+1)."输入线/相电压BC/B告警"] = _GetPMBusCheckMsg($v[2], '');
            $dataArray["交流输入".($i+1)."输入线/相电压CA/C告警"] = _GetPMBusCheckMsg($v[3], '');
            $dataArray["交流输入".($i+1)."频率告警"] = _GetPMBusCheckMsg($v[4], '');
            //$channelObj->p40_44_count = $v[5];
            $v = unpack('C*', substr($channelData, 4 * 4 + 1 + 4 * $p40_41_number + 5, $p40_44_number));
            $p40_44_label = array("交流输入空开跳"=>true,"交流输出空开跳"=>true,"交流防雷器故障"=>true,"交流输入1停电"=>true,"交流输入2停电"=>true,"交流输入3停电"=>true,"交流屏通讯中断"=>true);
            $p40_44_rules = array(0 => array(array(0=>"正常", 5=>"故障"), "无效"),
                                        1 => array(array(0=>"正常", 5=>"故障"), "无效"),
                                        2 => array(array(0=>"正常", 5=>"故障"), "无效"),
                                        3 => array(array(0=>"正常", 0xe1=>"故障"), "无效"),
                                        4 => array(array(0=>"正常", 0xe1=>"故障"), "无效"),
                                        5 => array(array(0=>"正常", 0xe1=>"故障"), "无效"),
                                        6 => array(array(0=>"正常", 0xe2=>"故障"), "无效"));

            $p40_44_index = -1;
            foreach ($p40_44_label as $key => $show) {
                $p40_44_index++;
                $dataArray["交流输入".($i+1).$key] = _CheckAlertMap($v[$p40_44_index + 1], $p40_44_rules[$p40_44_index]);
            }        
        }
        //alert交流告警数据
        $v = unpack('C*', substr($memData, 4 + 3 * 4 + 2 * $acChannelLen, 3));
        $dataArray["A相输入电流告警状态"] = _GetPMBusCheckMsg($v[1], '');
        $dataArray["B相输入电流告警状态"] = _GetPMBusCheckMsg($v[2], '');
        $dataArray["C相输入电流告警状态"] = _GetPMBusCheckMsg($v[3], '');
        //rc
        $v = unpack('f', substr($memData, 4 + 3 * 4 + 2 * $acChannelLen + 3, 4));
        $dataArray["整流模块输出电压"] = number_format($v[1], 2);
        $v = unpack('C', substr($memData, 4 + 3 * 4 + 2 * $acChannelLen + 3 + 4, 1));
        $dataArray["整流模块数量"] = $v[1];
        $rcChannelLen = (1 + 7) * 4 + 7 + 1 + 8;
        for ($i = 0; $i < $dataArray["整流模块数量"]; $i++) {
            $label = "整流模块".($i+1);
            $channelData = substr($memData, 4 + 3 * 4 + 2 * $acChannelLen + 3 + 4 + 1 + $rcChannelLen * $i, $rcChannelLen);
            $v = unpack('f', substr($channelData, 0, 4));
            $dataArray[$label."输出电流"] = number_format($v[1], 2);
            //$dataArray[$label."输出电压"] = number_format($v[1], 2);
            $v = unpack('C', substr($channelData, 4, 1));

            $p41_41_label = array('模块限流点'=>true,'模块输出电压'=>true,"模块输入电压"=>true,"模块类型"=>true,"浮点型预留1"=>true,"浮点型预留2"=>true,"浮点型预留3"=>true);
            $p41_41_index = 0;
            foreach ($p41_41_label as $key => $show) {
                $p41_41_index++;
                $dataArray[$label.$key] = number_format($v[$p41_41_index], 2);
              
            }
            $v = unpack('C*', substr($channelData, 4 + 1 + 4 * 7, 4));
            if ($v[1] == 0) {
                $dataArray[$label."开关机状态"] = "开机";
            } else if ($v[1] == 1) {
                $dataArray[$label."开关机状态"] = "关机";
            } else {
                $dataArray[$label."开关机状态"] = "未知";
            }
            if ($v[2] == 0) {
                $dataArray[$label."限流/不限流状态"] = "限流";
            } else if ($v[2] == 1) {
                $dataArray[$label."限流/不限流状态"] = "不限流";
            } else {
                $dataArray[$label."限流/不限流状态"] = "未知";
            }
            if ($v[3] == 0) {
                $dataArray[$label."浮充/均充/测试状态"] = "浮充";
            } else if ($v[3] == 1) {
                $dataArray[$label."浮充/均充/测试状态"] = "均充";
            } else if ($v[3] == 2) {
                $dataArray[$label."浮充/均充/测试状态"] = "测试";
            } else {
                $dataArray[$label."浮充/均充/测试状态"] = "未知";
            }

            $v = unpack('C', substr($channelData, 4 + 1 + 4 * 7 + 4, 1));
            $p41_43_label = array("自动/手动状态"=>true);
            $p41_43_rules = array(0 => array(array(0x0=>"正常", 0xE0=>"自动", 0xE1=>"手动"),"无效"));

            $p41_43_index = -1;
            foreach ($p41_43_label as $key => $show) {
                $p41_43_index++;
                $dataArray[$label.$key] = _CheckAlertMap($v[$p41_43_index + 1], $p41_43_rules[$p41_43_index]);
            }

            $v = unpack('C*', substr($channelData, 4 + 1 + 4 * 7 + 4 + 1, 2));
            $dataArray[$label."故障"] = _GetPMBus41_44Msg($v[1]);
            //$channelObj->p41_44_count = $v[2];

            $v = unpack('C*', substr($channelData, 4 + 1 + 4 * 7 + 4 + 1 + 2, 8));
            $p41_44_label = array("模块保护"=>true,"风扇故障"=>true,"模块过温"=>true,"模块通讯中断"=>true,"模块交流停电"=>true,"模块输出短路"=>true,"模块输出过压"=>true,"模块不均流"=>true);
            $p41_44_rules = array( 0 => array(array(0=>"正常", 1=>"故障"), "无效"),
                            1 => array(array(0=>"正常", 1=>"故障"), "无效"),
                            2 => array(array(0=>"正常", 1=>"故障"), "无效"),
                            3=> array(array(0=>"正常", 0xe2=>"故障"), "无效"),
                            4 => array(array(0=>"正常", 1=>"限功率"), "无效"),
                            5 => array(array(0=>"正常", 0x1=>"交流停电"), "无效"),
                            6 => array(array(0=>"正常", 0x1=>"不均流"), "无效"),
                            7 => array(array(0=>"正常", 0x1=>"过压关机"), "无效"),);

         
            $p41_44_index = -1;
            foreach ($p41_44_label as $key => $show) {
                $p41_44_index++;
                $dataArray[$label.$key] = _CheckAlertMap($v[$p41_44_index + 1], $p41_44_rules[$p41_44_index]);
            }
        }
        //DC
        $dcOffset = 4 + 3 * 4 + 2 * $acChannelLen + 3 + 4 + 1 + $rcChannelLen * 20;
        $m_number = 2;
        $n_number = 0;
        $p_number = 20;
        $alert_m_number = 2;
        $alert_p_number = 39;
        $v = unpack("I", substr($memData, $dcOffset, 4));
        //$dataObj->data_id = $v[1];
        $v = unpack('f*', substr($memData, $dcOffset + 4, 4 * 2));
        $dataArray["直流输出电压"] = number_format($v[1], 2) . "V";
        $dataArray["总负载电流"] = number_format($v[2], 2) . "A";
        $v = unpack('C', substr($memData, $dcOffset + 4 + 4 * 2, 1));
        $dataArray["蓄电池组数"] = $v[1];
        $v = unpack('f*', substr($memData, $dcOffset + 4 + 4 * 2 + 1, $m_number * 4));
        //$dataObj->dc_i = array();
        for($index=1; $index <= $dataArray["蓄电池组数"]; $index++) {
            $dataArray["电池".($index)."电流"] = number_format($v[$index], 2) . "A";
        }
        $v = unpack('C', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4, 1));
        $dataArray["监测直流分路电流数"] = $v[1];
        $v = unpack('f*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1, $n_number * 4));
        foreach ($v as $index=>$val) {
            if (is_nan($val)) {
                $dataArray["直流分路".($index)."电流"] = 0.0;
            } else {
                $dataArray["直流分路".($index)."电流"] = $val;
            }            
        }

        $v = unpack('C', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4, 1));

        $v = unpack('f*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1, $p_number * 4));
  
        $p_label = array("电池组1电压","电池组2电压","电池组1实际容量百分比","电池组2实际容量百分比","电池1温度","电池4温度","电池3温度","电池2温度","环境湿度","负载1电流","负载2电流","负载3电流","负载4电流","浮点型预留1","浮点型预留2","浮点型预留3","浮点型预留4","浮点型预留5","浮点型预留6","浮点型预留7");
        foreach ($v as $index=>$val) {
            $dataArray[$p_label[$index-1]] = number_format($val, 2);
        }
        $v = unpack('C*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4, 2));
        $dataArray["直流电压告警"] = _GetPMBusCheckMsg($v[1]);
        $dataArray["直流熔断丝数量"] = $v[2];
        $v = unpack('C*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4 + 2, $alert_m_number));
        //$dataObj->alert_m = array();
        foreach ($v as $index=>$k) {
            $dataArray["负载熔丝/开关".($index)] = _GetAlertM($k);
        }
        $v = unpack('C', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4 + 2 + $alert_m_number, 1));
        //$dataObj->alert_p_count = $v[1];

        $v = unpack('C*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4 + 2 + $alert_m_number + 1, $alert_p_number));
        $alert_p_label = array('电池组1熔丝/空开断'=>true,'电池组2熔丝/空开断'=>true,'电池组1充电过流'=>true,'电池组2充电过流'=>true,'电池保护告警'=>true,'负载下电告警'=>true,
                                '电池1温度告警'=>true,'电池4温度告警'=>true,'电池3温度告警'=>true,'电池2温度告警'=>true,'环境湿度告警'=>true,'电池组1电压异常'=>true,'电池组2电压异常'=>true,'预留0'=>true,
                                '电池放电'=>true,'电流不平衡'=>true,'电池短测试告警'=>true,'电池测试告警'=>true,"预留0"=>true,'1路数字输入告警状态'=>true,'2路数字输入告警状态'=>true,'3路数字输入告警状态'=>true,'4路数字输入告警状态'=>true,'防雷告警'=>true,
                                '5路数字输入告警状态'=>true,'6路数字输入告警状态'=>true,'7路数字输入告警状态'=>true,'8路数字输入告警状态'=>true,'预留1'=>true,'传感器1故障状态'=>true,'传感器2故障状态'=>true,'传感器3故障状态'=>true,'负载电流告警状态'=>true,
                                '传感器4故障状态'=>true,'预留2'=>true,'预留3'=>true,'负载2下电'=>true,'负载3下电'=>true,'负载4下电'=>true);
        $alert_p_rules = array();
        for($i=0;$i<39;$i++)
        {
            $alert_p_rules[] = array(array(0=>"正常", 1=>"低于下限", 2=>"高于上限", 3=>"熔丝断",4=>"开关断开",0xe3=>"负载下电",0xE4=>"电池保护",0xE5=>"电池放电",0xE6=>"不平衡",0xE7=>"电池短测试告警",0xE8=>"电池测试告警",0xE9=>"直流电压差别大告警"),"无效");
        }
        $alert_p_index = -1;
        foreach ($alert_p_label as $key => $show) {
            $alert_p_index++;
            $dataArray[$key] = _CheckAlertMap($v[$alert_p_index + 1], $alert_p_rules[$alert_p_index]);
        }
        //jump dc 7 datetime
		$v = unpack('v',substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4 + 2 + $alert_m_number + 1 + $alert_p_number + 7 , 2));
        $year = $v[1];		
		$v = unpack('C*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4 + 2 + $alert_m_number + 1 + $alert_p_number + 7 + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
	}
}





?>
