<?php
function Get_mcgs_3au3_RtData($memData, &$dataArray, $extraPara = false){
        if(empty($memData)){
            $dataArray['无数据'] = true;
            $dataArray['更新时间'] = '无';
            $dataArray['错误'] = '数据长度不一致';
        }else{
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            //MCGS_3AU1_3AU3_02_t  模块开关状态
            $v = unpack('c*',substr($memData,4,8));
            $dataArray['2QF1模块开关'] = $v[1] == 1 ? '闭合' : '断开';
            $dataArray['2QF2模块开关'] = $v[2] == 1 ? '闭合' : '断开';
            $dataArray['3QF1模块开关'] = $v[3] == 1 ? '闭合' : '断开';
            $dataArray['3QF2模块开关'] = $v[4] == 1 ? '闭合' : '断开';
            $dataArray['4QF1模块开关'] = $v[5] == 1 ? '闭合' : '断开';
            $dataArray['4QF2模块开关'] = $v[6] == 1 ? '闭合' : '断开';
            $dataArray['4QF3模块开关'] = $v[7] == 1 ? '闭合' : '断开';
            $dataArray['4QF4模块开关'] = $v[8] == 1 ? '闭合' : '断开';
            //模块模拟量数据
            $offset = 12;
            $moduleArr1 = array('PZ96L-E4','2QF1','2QF2','3QF1','3QF2','4QF1');
            foreach($moduleArr1 as $key=>$module){
                $v = unpack('S*',substr($memData, $offset, 26*2));
                $dataArray[$module.' A相电压'] = ($v[1]/100).' V';
                $dataArray[$module.' B相电压'] = ($v[2]/100).' V';
                $dataArray[$module.' C相电压'] = ($v[3]/100).' V';
                $dataArray[$module.' A相电流'] = ($v[4]/100).' A';
                $dataArray[$module.' B相电流'] = ($v[5]/100).' A';
                $dataArray[$module.' C相电流'] = ($v[6]/100).' A';
                $dataArray[$module.' A相负载率'] = $v[7]/100;
                $dataArray[$module.' B相负载率'] = $v[8]/100;
                $dataArray[$module.' C相负载率'] = $v[9]/100;
                $dataArray[$module.' A相有功功率'] = $v[10].' W';
                $dataArray[$module.' B相有功功率'] = $v[11].' W';
                $dataArray[$module.' C相有功功率'] = $v[12].' W';
                $dataArray[$module.' 合相有功功率'] = $v[13].' W';
                $dataArray[$module.' A相无功功率'] = $v[14].' Var';
                $dataArray[$module.' B相无功功率'] = $v[15].' Var';
                $dataArray[$module.' C相无功功率'] = $v[16].' Var';
                $dataArray[$module.' 合相无功功率'] = $v[17].' Var';
                $dataArray[$module.' A相视在功率'] = $v[18].' VA';
                $dataArray[$module.' B相视在功率'] = $v[19].' VA';
                $dataArray[$module.' C相视在功率'] = $v[20].' VA';
                $dataArray[$module.' 合相视在功率'] = $v[21].' VA';
                $dataArray[$module.' A相功率因数'] = $v[22]/100;
                $dataArray[$module.' B相功率因数'] = $v[23]/100;
                $dataArray[$module.' C相功率因数'] = $v[24]/100;
                $dataArray[$module.' 合相功率因数'] = $v[25]/100;
                $dataArray[$module.' 频率'] = ($v[26]/100).' Hz';
                $v = unpack('I*',substr($memData, $offset + 26*2, 4));
                $dataArray[$module.' 有功电能'] = ($v[1]/100).' KWh';
                $offset += 56;
            }
            $moduleArr2 = array('4QF2','4QF3','4QF4');
            foreach($moduleArr2 as $key=>$module){
                $v = unpack('S*',substr($memData, $offset, 6*2));
                $dataArray[$module.' A相电压'] = ($v[1]/100).' V';
                $dataArray[$module.' A相电流'] = ($v[2]/100).' A';
                $dataArray[$module.' B相电压'] = ($v[3]/100).' V';
                $dataArray[$module.' B相电流'] = ($v[4]/100).' A';
                $dataArray[$module.' C相电压'] = ($v[5]/100).' V';
                $dataArray[$module.' C相电流'] = ($v[6]/100).' A';
                $v = unpack('I*',substr($memData, $offset + 12 , 4));
                $dataArray[$module.' 有功电能'] = ($v[1]/100).' KWh';
                $v = unpack('S*',substr($memData, $offset + 16 , 3*2));
                $dataArray[$module.' 有功功率'] = $v[1].' W';
                $dataArray[$module.' 功率因数'] = $v[2]/100;//保留一位
                $offset += 22;
            }
            $v = unpack('v', substr($memData, $offset, 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, $offset +2, 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}
