<?php

function Get_mcs6000_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '直流负载电流':
            return array(0, $dataArray['负载总电流']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}


function Get_mcs6000_RtData($memData, &$dataArray, $extraPara = false)
{
    if($memData == false){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '无数据';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        //StatusPacket   系统状态数据
        $v = unpack('S*', substr($memData, 2, 2 * 2));
        $dataArray['系统电压'] = ($v[1] / 10).' V';
        $dataArray['负载总电流'] = $v[2].' A';
        $v = unpack('s*', substr($memData, 2 + 2 * 2, 2 * 4));
        $dataArray['电池组1电流'] = $v[1].' A';
        $dataArray['电池组2电流'] = $v[2].' A';
        $dataArray['电池组3电流'] = $v[3].' A';
        $dataArray['电池组4电流'] = $v[4].' A';
        $v = unpack('C*', substr($memData, 2 + 2 * 6, 1 * 4));
        //alarm1
        $dataArray['EEPROM值超出范围'] = ($v[1] & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['EEPROM值超出范围'] = ($v[1] & 0x1);
        $dataArray['整流模块非紧急告警'] = (($v[1] >> 1) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['整流模块非紧急告警'] = (($v[1] >> 1) & 0x1);
        $dataArray['整流模块紧急告警'] = (($v[1] >> 2) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['整流模块紧急告警'] = (($v[1] >> 2) & 0x1);
        $dataArray['电池熔丝故障告警'] = (($v[1] >> 3) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['电池熔丝故障告警'] = (($v[1] >> 3) & 0x1);
        $dataArray['低压关机'] = (($v[1] >> 4) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['低压关机'] = (($v[1] >> 4) & 0x1);
        $dataArray['输出电压过高告警'] = (($v[1] >> 5) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['输出电压过高告警'] = (($v[1] >> 5) & 0x1);
        $dataArray['输出电压过低告警'] = (($v[1] >> 6) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['输出电压过低告警'] = (($v[1] >> 6) & 0x1);
        $dataArray['电池供电告警'] = (($v[1] >> 7) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['电池供电告警'] = (($v[1] >> 7) & 0x1);
        //alarm2
        $dataArray['整流模块通信状态告警'] = (($v[2]) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['整流模块通信状态告警'] = (($v[2]) & 0x1);
        $dataArray['交流电电压故障'] = (($v[2] >> 1) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['交流电电压故障'] = (($v[2] >> 1) & 0x1);
        $dataArray['交流电频率故障'] = (($v[2] >> 2) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['交流电频率故障'] = (($v[2] >> 2) & 0x1);
        $dataArray['环境温度过高告警'] = (($v[2] >> 3) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['环境温度过高告警'] = (($v[2] >> 3) & 0x1);
        $dataArray['电池温度过高告警'] = (($v[2] >> 4) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['电池温度过高告警'] = (($v[2] >> 4) & 0x1);
        $dataArray['限电流'] = (($v[2] >> 5) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['限电流'] = (($v[2] >> 5) & 0x1);
        $dataArray['电池放电不平衡告警'] = (($v[2] >> 6) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['电池放电不平衡告警'] = (($v[2] >> 6) & 0x1);
        $dataArray['漏电流告警'] = (($v[2] >> 7) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['漏电流告警'] = (($v[2] >> 7) & 0x1);
        //alarm3
        $dataArray['正在均充'] = (($v[3]) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['正在均充'] = (($v[3]) & 0x1);
        $dataArray['熔丝熔断'] = (($v[3] >> 1) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['熔丝熔断'] = (($v[3] >> 1) & 0x1);
        $dataArray['LVDS2跳脱'] = (($v[3] >> 2) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['LVDS2跳脱'] = (($v[3] >> 2) & 0x1);
        $dataArray['整流模块过压关机告警'] = (($v[3] >> 3) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['整流模块过压关机告警'] = (($v[3] >> 3) & 0x1);
        $dataArray['电池开关分离'] = (($v[3] >> 4) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['电池开关分离'] = (($v[3] >> 4) & 0x1);
        $dataArray['电池温度传感器故障'] = (($v[3] >> 5) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['电池温度传感器故障'] = (($v[3] >> 5) & 0x1);
        $dataArray['SMR没有被校正'] = (($v[3] >> 6) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['SMR没有被校正'] = (($v[3] >> 6) & 0x1);
        $dataArray['电解液低'] = (($v[3] >> 7) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['电解液低'] = (($v[3] >> 7) & 0x1);
        //alarm4
        $dataArray['电池单元电压高'] = (($v[4]) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['电池单元电压高'] = (($v[4]) & 0x1);
        $dataArray['电池单元电压低'] = (($v[4] >> 1) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['电池单元电压低'] = (($v[4] >> 1) & 0x1);
        $dataArray['电池单元电压偏移过高'] = (($v[4] >> 2) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['电池单元电压偏移过高'] = (($v[4] >> 2) & 0x1);
        $dataArray['电池单元电压偏移过低'] = (($v[4] >> 3) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['电池单元电压偏移过低'] = (($v[4] >> 3) & 0x1);
        $dataArray['SMR参数超出范围'] = (($v[4] >> 4) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['SMR参数超出范围'] = (($v[4] >> 4) & 0x1);
        $dataArray['直流侦测板告警'] = (($v[4] >> 5) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['直流侦测板告警'] = (($v[4] >> 5) & 0x1);
        $dataArray['电池放电电压过低告警'] = (($v[4] >> 6) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['电池放电电压过低告警'] = (($v[4] >> 6) & 0x1);
        $dataArray['电池放电测试失败'] = (($v[4] >> 7) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['电池放电测试失败'] = (($v[4] >> 7) & 0x1);


        $v = unpack('s*', substr($memData, 2 + 2 * 6 + 1 * 4, 2 * 2));
        $dataArray['电池温度'] = ($v[1]).' ℃';
        $dataArray['环境温度'] = ($v[2]).' ℃';
        $v = unpack('I*', substr($memData, 2 + 2 * 6 + 1 * 4 + 2 * 2, 4 * 4));
        $dataArray['电池组1当前容量'] = number_format($v[1] / 41199, 2).' ATH';//单位:AmpTickHour
        $dataArray['电池组2当前容量'] = number_format($v[2] / 41199, 2).' ATH';
        $dataArray['电池组3当前容量'] = number_format($v[3] / 41199, 2).' ATH';//单位:AmpTickHour
        $dataArray['电池组4当前容量'] = number_format($v[4] / 41199, 2).' ATH';
        $v = unpack('S*', substr($memData, 2 + 2*6 + 1*4 + 2*2 + 4*4 , 2*19));
        $dataArray['单相交流输入电压'] = ($v[1]/100).' V';
        $dataArray['单相交流输入电流'] = ($v[2]/100).' A';
        $dataArray['单相交流输入频率'] = ($v[3] / 10).' Hz';
        $dataArray['三相交流输入电压1'] = ($v[4]/100).' V';
        $dataArray['三相交流输入电压2'] = ($v[5]/100).' V';
        $dataArray['三相交流输入电压3'] = ($v[6]/100).' V';
        $dataArray['三相交流输入电流1'] = ($v[7]/100).' A';
        $dataArray['三相交流输入电流2'] = ($v[8]/100).' A';
        $dataArray['三相交流输入电流3'] = ($v[9]/100).' A';
        $dataArray['三相交流输入频率'] = ($v[10] / 10).' Hz';

        $dataArray['电池组数量'] = $v[11];
        $dataArray['直流侦测板'] = $v[12] & 0x1 ? "开" : "关";

        $dataArray['电池侦测单元类型'] = ($v[12] >> 1) & 0x1 ? "96节" : "标准";
        switch( ($v[12] >> 4) & 0x3){
            case 0:
                $dataArray["面板类型"] = "一类界面板";
                break;
            case 1:
                $dataArray["面板类型"] = "二类界面板";
                break;
            case 2:
                $dataArray["面板类型"] = "三类界面板";
                break;
            default:
                $dataArray["面板类型"] = "未知";
                break;
        }
        switch($v[14])
        {
            case 0:
                $dataArray["上次电池放电测试结果"] = "失败";
                break;
            case 1:
                $dataArray["上次电池放电测试结果"] = "通过";
                break;
            case 2:
                $dataArray["上次电池放电测试结果"] = "不可用";
                break;
            case 3:
                $dataArray["上次电池放电测试结果"] = "低负载，取消";
                break;
            case 4:
                $dataArray["上次电池放电测试结果"] = "系统过载，取消";
                break;
        }
        $dataArray["上次电池放电测试结束电压"] = ($v[15]/100)."V";
        $dataArray["上次电池放电测试持续时间"] = ($v[16])."M";
        $dataArray["上次电池放电测试时间"] = $v[19]."-".$v[18]."-".$v[17];
        $v = unpack('c*', substr($memData, 2 + 2*6 + 1*4 + 2*2 + 4*4 + 2*19, 2 ));
        //alarm5
        $dataArray['系统超载告警'] = (($v[2]) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['系统超载告警'] = (($v[2]) & 0x1);
        $dataArray['SMR总线短路'] = (($v[2] >> 1) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['SMR总线短路'] = (($v[2] >> 1) & 0x1);
        $dataArray['交流电正常但电池放电'] = (($v[2] >> 2) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['交流电正常但电池放电'] = (($v[2] >> 2) & 0x1);
        $dataArray['电池测试正在运行'] = (($v[2] >> 3) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['电池测试正在运行'] = (($v[2] >> 3) & 0x1);

        $dataArray['系统电压钳制'] = (($v[2] >> 6) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['系统电压钳制'] = (($v[2] >> 6) & 0x1);
        $dataArray['电池 Hall 告警'] = (($v[2] >> 7) & 0x1) ? '告警' : '正常';
        $dataArray['AlertArray']['电池 Hall 告警'] = (($v[2] >> 7) & 0x1);

        $v = unpack('S*', substr($memData, 2 + 2*6 + 1*4 + 2*2 + 4*4 + 2*19 + 2, 2*4 ));
        $dataArray["上次电池放电测试结束时电池1容量"] = $v[1];
        $dataArray["上次电池放电测试结束时电池2容量"] = $v[2];
        $dataArray["上次电池放电测试结束时电池3容量"] = $v[3];
        $dataArray["上次电池放电测试结束时电池4容量"] = $v[4];
        //DK04C_ParamPacket
        //skip 2*(4+7)
        $start = 100;
        $v = unpack('S*', substr($memData, $start +2 , 2 * 12 ));
        //$v[1] 数据包类型
        $dataArray['单相交流输入电压过高告警点'] = $v[1].' V';
        $dataArray['单相交流输入电压过低告警点'] = $v[2].' V';
        $dataArray['单相交流输入频率过高告警点'] = ($v[3] / 10).' Hz';
        $dataArray['单相交流输入频率过低告警点'] = ($v[4] / 10).' Hz';
        $dataArray['单相交流输入电流检测满量程'] = ($v[5] * 10).' A';
        $dataArray['环境温度过高告警点'] = $v[6].' ℃';
        $dataArray['电池温度过高告警点'] = $v[7].' ℃';
        $dataArray['输出电压过高告警点'] = ($v[8] / 10).' V';
        $dataArray['输出电压过低告警点'] = ($v[9] / 10).' V';
        $dataArray['整流模块个数'] = $v[10];
        $dataArray['整流模块类型'] = $rcModuleType = $v[11] == 0 ? 'A型' : $v[12] == 1 ? 'B型' : $v[12];
        $dataArray['电池电流传感器满量程'] = $v[12].' A';
        $v = unpack('C*', substr($memData, $start + 2 + 2 * 12, 2 ));
        $dataArray["电池组数量"] = $v[1];
        $dataArray['MODEM是否启用'] = $v[2] == 0 ? '不启用' : '启用';
        $v = unpack('C*', substr($memData, $start + 2 + 2 * 12 + 2, 2*5));
        $dataArray['告警回拨'] = $v[1] == 0 ? '不启用' : $v[1] == 1 ? '启用' : '无效';
        $dataArray['每日回拨'] = $v[2] == 0 ? '不启用' : $v[2] == 1 ? '启用' : '无效';
        $dataArray['每日回拨时间'] = $v[3].'时'.$v[4].'分';
        $dataArray['扩展口1功能是否启用'] = $v[5] == 0 ? '不启用' : '单相交流检测';
        $v = unpack('C*', substr($memData, $start + 2 + 2*12 + 2 + 2*5, 20 * 3));
        //回报电话1 2 3
        $v = unpack('S', substr($memData, $start + 2 + 2*12 + 2 + 2*5 + 20*3, 2));
        $dataArray['电池标称容量'] = $v[1].' AH';
        $v = unpack('C*', substr($memData, $start + 2 +  2*12 + 2 + 2*5 + 20*3 + 2, 2));
        $dataArray['电池充电温度补偿系数'] = $v[1] == 0 ? '不启用' : ($v[1] / 10).' mV/℃/cell';
        $dataArray['电池温度补偿基准'] = $v[2];
        $v = unpack('S*', substr($memData, $start + 2 + 2*12 + 2 + 2*5 + 20*3 + 2 + 2, 2 * 18));
        $dataArray['电池限电流Vb<VDD限流'] = $v[1].' A';
        $dataArray['电池限电流浮充限流'] = $v[2].' A';
        $dataArray['电池限电流均充限流'] = $v[3].' A';
        $dataArray['电池深放电电压点'] = ($v[4] / 10).' V';
        $dataArray['系统浮充电压'] = ($v[5] / 10).' V';
        $dataArray['均充电压'] = ($v[6] / 10).' V';
        $dataArray['系统补偿电压'] = ($v[7] / 10).' V';
        $dataArray['电池放电告警'] = ($v[8] / 10).' V';
        $dataArray['电压启动均充'] = $v[9] ? "启用" : "不启用";
        $dataArray['启动均充的电压'] = ($v[10] / 100).' V';
        $dataArray['容量启动均充'] = $v[11] ? "启用" : "不启用";
        $dataArray['启动均充的容量'] = $v[12]."AH";
        $dataArray['均充结束时电流'] = $v[13] ? $v[13].'A' : "禁用";
        $dataArray['均充持续时间'] = $v[14]."小时";
        $dataArray['均充周期'] = $v[15].' 星期';
        $dataArray['放电不平衡告警'] = $v[16].' A';
        $dataArray['低压关机电压'] = ($v[17] / 10).' V';
        switch ($v[18]){
            case 0 : $dataArray['LVDS模式'] = '断开'; break;
            case 1 : $dataArray['LVDS模式'] = '合上'; break;
            case 2 : $dataArray['LVDS模式'] = '自动'; break;
            default : $dataArray['LVDS模式'] = '无效';
        }

        $v = unpack("C*", substr($memData, $start + 2 + 2*12 + 2 + 2*5 + 20*3 + 2 + 2 + 2 * 18, 6));//Day,Month,Year,Cent,Hour,Min,Sec;
        $dataArray["CSU系统时间"] = $v[3] . "-" . $v[2] . "-" . $v[1] . " " . $v[4] . ":" . $v[4] . ":" . $v[6];
        //$v[8] reserve
        $v = unpack("S*", substr($memData, $start + 2 + 2*12 + 2 + 2*5 + 20*3 + 2 + 2 + 2 * 18 + 6, 2*5));
        $dataArray['三相交流输入电压过高告警点'] = $v[1].' V';
        $dataArray['三相交流输入电压过低告警点'] = $v[2].' V';
        $dataArray['三相交流输入频率过高告警点'] = ($v[3] / 10).' Hz';
        $dataArray['三相交流输入频率过低告警点'] = ($v[4] / 10).' Hz';
        $dataArray['三相交流电流检测满量程'] = $v[5].' A';
        $v = unpack("C*", substr($memData, $start + 2 + 2*12 + 2 + 2*5 + 20*3 + 2 + 2 + 2 * 18 + 6 + 2*5, 4));
        $dataArray['扩展口2功能是否启用'] = $v[1] == 0 ? '不启用' : '启用';
        $dataArray['电池温度传感器告警'] = $v[2] == 0 ? '不启用' : '启用';
        $dataArray['电池单元开/关'] = $v[3] == 0 ? '不启用' : '启用';
        switch($v[4])
        {
            case 0:
                $dataArray['电池单元配置'] = 'A型号';
                break;
            case 1:
                $dataArray['电池单元配置'] = 'B型号';
                break;
            case 2:
                $dataArray['电池单元配置'] = 'C型号';
                break;
            case 3:
                $dataArray['电池单元配置'] = 'D型号';
                break;
            case 4:
                $dataArray['电池单元配置'] = 'E型号';
                break;
        }

        $v = unpack("C*", substr($memData, $start + 2 + 2*12 + 2 + 2*5 + 20*3 + 2 + 2 + 2 * 18 + 6 + 2*5 + 4, 2*5));
        $dataArray['电池单元电压高报警'] = ($v[1]/100).'V';
        $dataArray['电池单元电压低报警'] = ($v[2]/100).'V';
        $dataArray['电池单元电压超过平均值百分比报警'] = ($v[3]).'%';
        $dataArray['电池单元电压低于平均值百分比报警'] = ($v[4]).'%';
        $dataArray['电池单元纪录间隔时间'] = ($v[5]).'M';
        $v = unpack("S", substr($memData, $start + 2 + 2*12 + 2 + 2*5 + 20*3 + 2 + 2 + 2 * 18 + 6 + 2*5 + 4 + 2*5 + 6, 2));
        $dataArray["负载电流满量程"] = $v[1]."A";

        $v = unpack("C*", substr($memData, $start + 2 + 2*12 + 2 + 2*5 + 20*3 + 2 + 2 + 2 * 18 + 6 + 2*5 + 4 + 2*5 + 6 + 2, 2));
        $dataArray["二类接口板开/关设定"] = $v[1] == 0 ? '不启用' : '启用';
        $dataArray["负载传感器"] = $v[1] == 0 ? '不启用' : '启用';

        $v = unpack("S*", substr($memData, $start + 2 + 2*12 + 2 + 2*5 + 20*3 + 2 + 2 + 2 * 18 + 6 + 2*5 + 4 + 2*5 + 6 + 2 + 2, 2*8));
        $dataArray["电池放电测试周期"] = $v[1]."天";
        $dataArray["电池放电测试时间"] = $v[2]."分钟";
        $dataArray["电池放电测试结束电压"] = ($v[3]/10)."V";
        $dataArray["电池放电测试开始时间"] = $v[4]."H".$v[5]."M";
        $dataArray["单体电池数量"] = $v[6];
        $v = unpack("C*", substr($memData, $start + 2 + 2*12 + 2 + 2*5 + 20*3 + 2 + 2 + 2 * 18 + 6 + 2*5 + 4 + 2*5 + 6 + 2 + 2 + 2*8, 2));
        $dataArray["漏电流告警"] = ($v[1]/100)."V";
        $v = unpack("S*", substr($memData, $start + 2 + 2*12 + 2 + 2*5 + 20*3 + 2 + 2 + 2 * 18 + 6 + 2*5 + 4 + 2*5 + 6 + 2 + 2 + 2*8 + 2, 2*10));
        $dataArray["电池放电测试电流"] = $v[1] == 0 ? "测试电流=负载电流" : $v[1]."A";
        $dataArray["电池放电结束时容量"] = $v[2]."AH";
        $dataArray["电流启动均充"] = $v[3] ? "启用":"禁用";
        $dataArray["启动均充的电流"] = $v[4]."A";
        $dataArray["系统超载值"] = $v[8];
        $dataArray["系统类型"] = $v[9] ? "UPS" :"备用";
        $dataArray["均衡开关"] = $v[10] ? "开" : "关";

        $v = unpack("C*", substr($memData,$start + 2 + 2*12 + 2 + 2*5 + 20*3 + 2 + 2 + 2 * 18 + 6 + 2*5 + 4 + 2*5 + 6 + 2 + 2 + 2*8 + 2 + 2*10, 5));
        $dataArray["模块分组"] = $v[1] ? "分组" : "不分组";
        $dataArray["第1组最后一个SMR编号"] = $v[2];
        $dataArray["第2组最后一个SMR编号"] = $v[3];
        $dataArray["第3组最后一个SMR编号"] = $v[4];
        $dataArray["第4组最后一个SMR编号"] = $v[5];
        //跳过reverse9
        $start = 330;
        //MCS6000_SMRstatPacket
        //46 + 164 DK04C_SMRstatPacket   整流模块状态数据
        $v = unpack('S*', substr($memData, $start, 4));
        //$v[1] 数据包类型
        $Num_SMRs = $v[2];
        $offset = $start + 4;
        for($i = 0 ; $i < $Num_SMRs ; $i++){
            $j = $i+1;
            $dataArray['整流模块'.$j] = array();
            $dataArray['整流模块'.$j]['AlertArray'] = array();
            $v = unpack('C*' , substr($memData , $offset, 6));
            $dataArray['整流模块'.$j]['输出电压过高告警'] = ($v[1] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['输出电压过低告警'] = (($v[1] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块地址错误'] = (($v[1] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块输入开关断开'] = (($v[1] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块内部直流部分故障'] = (($v[1] >> 4) & 0x1) == 1 ? '告警' : '正常';
            //$dataArray['整流模块'.$j]['内部控制回路电压低'] = (($v[1] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块温度过高'] = (($v[1] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['内部控制回路故障'] = (($v[1] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['AlertArray']['输出电压过高告警'] = ($v[1] & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['输出电压过低告警'] = (($v[1] >> 1) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块地址错误'] = (($v[1] >> 2) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块输入开关断开'] = (($v[1] >> 3) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块内部直流部分故障'] = (($v[1] >> 4) & 0x1) == 1;
            //$dataArray['整流模块'.$j]['AlertArray']['内部控制回路电压低'] = (($v[1] >> 5) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块温度过高'] = (($v[1] >> 6) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['内部控制回路故障'] = (($v[1] >> 7) & 0x1) == 1;

            $dataArray['整流模块'.$j]['整流模块输出限流状态'] = ($v[2] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['风扇故障'] = (($v[2] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['负载过轻'] = (($v[2] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['输入开关跳开'] = (($v[2] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块关机'] = (($v[2] >> 4) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块接收MCSU指令而关机'] = (($v[2] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块内部参考电压超出范围'] = (($v[2] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块通信故障'] = (($v[2] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['AlertArray']['整流模块输出限流状态'] = ($v[2] & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['风扇故障'] = (($v[2] >> 1) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['负载过轻'] = (($v[2] >> 2) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['输入开关跳开'] = (($v[2] >> 3) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块关机'] = (($v[2] >> 4) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块接收MCSU指令而关机'] = (($v[2] >> 5) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块内部参考电压超出范围'] = (($v[2] >> 6) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块通信故障'] = (($v[2] >> 7) & 0x1) == 1;

            $dataArray['整流模块'.$j]['整流模块输出电压过高关机'] = ($v[3] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['交流输入故障'] = (($v[3] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块输出功率限制'] = (($v[3] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['继电器故障'] = (($v[3] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块故障关机'] = (($v[3] >> 4) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块处于均衡工作状态'] = (($v[3] >> 5) & 0x1) == 1 ? '是' : '否';
            $dataArray['整流模块'.$j]['整流模块告警'] = (($v[3] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块警告'] = (($v[3] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['AlertArray']['整流模块输出电压过高关机'] = ($v[3] & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['交流输入故障'] = (($v[3] >> 1) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块输出功率限制'] = (($v[3] >> 2) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['继电器故障'] = (($v[3] >> 3) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块故障关机'] = (($v[3] >> 4) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块告警'] = (($v[3] >> 6) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块警告'] = (($v[3] >> 7) & 0x1) == 1;

            $dataArray['整流模块'.$j]['整流模块输出电流'] = $v[4].' A';
            $dataArray['整流模块'.$j]['散热器温度'] = $v[5].' ℃';
            $dataArray['整流模块'.$j]['温度传感器故障'] = ($v[6] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['内部直流-直流变换部分故障'] = (($v[6] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['AlertArray']['温度传感器故障'] = ($v[6] & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['内部直流-直流变换部分故障'] = (($v[6] >> 1) & 0x1) == 1;
            $v = unpack('S*' , substr($memData , $offset + 6, 2));
            $dataArray['整流模块'.$j]['整流模块电压'] = ($v[1] / 100).' V';
            $offset += 8;
        }
        $start = $start + 484;//整流模块状态数据  定长   60个模块
        //SMRparamPacket  整流模块参数
        $offset = $start + 2;
        for($i = 1 ; $i <= $Num_SMRs ; $i++){
            $v = unpack('S*', substr($memData , $offset , 2 * 6));
            $dataArray['整流模块'.$i]['浮充电压'] = ($v[2] / 100).' V';
            $dataArray['整流模块'.$i]['均衡电压'] = ($v[3] / 100).' V';
            $dataArray['整流模块'.$i]['电压高告警'] = ($v[4] / 100).' V';
            $dataArray['整流模块'.$i]['电压低告警'] = ($v[5] / 100).' V';
            $dataArray['整流模块'.$i]['高压关机阈值电压'] = ($v[6] / 100).' V';
            $v = unpack('C*', substr($memData, $offset + 10 , 1 * 4));
            $dataArray['整流模块'.$i]['限流值'] = $v[1].' A';
            $dataArray['整流模块'.$i]['均流调节值'] = $v[2];
            $dataArray['整流模块'.$i]['保密功能开启'] = $v[3] == 1 ? '启用' : '不启用';
            $offset += 23;
        }
        $start = $start + 23 * $Num_SMRs;
        $v = unpack('v', substr($memData, $start, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, $start + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        //echo $start;die();
    }
}
