<?php 
 function Get_mcs_fc3_Standard_Variable($dataArray, $varname){
    switch ($varname){
       case "中央空调主机温度设定值":
            return array(0, $dataArray["环境温度（℃）"]);
       case "冷凝器进水压":
            return array(0, $dataArray["系统#1冷凝压力（kPa）"]); 
       case "蒸发器进水压":
            return array(0, $dataArray["系统#1蒸发压力（kPa）"]);
        
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_mcs_fc3_RtData($memData, &$dataArray, $extraPara = false)
{
   if(empty($memData) ) {
       $dataArray['无数据'] = true;
       $dataArray['更新时间'] = '无';
       $dataArray['错误'] = '数据长度不一致';
   } else {
       $dataArray['无数据'] = false;
       $v = unpack('S*',substr($memData,4,2*52));
       $dataArray["机组报警"] = $v[1] == 1 ? "告警" : "正常";
       $dataArray["蒸发器水流开关状态"] = $v[2] == 1 ? "闭合" : "断开";
       $dataArray["机组开关"] = $v[3] == 1 ? "开机" : "关机";
       $dataArray["清除机组报警"] = $v[4] == 1 ? "否" : "是";
       $dataArray["冷水实际设定值（℃）"] = $v[5] / 10;
       $dataArray["机组实际能力（%）"] = $v[6] / 10;
       $dataArray["机组实际能力限定（%）"] = $v[7] / 10;
       switch ($v[8]) {
       	case 1:
       		$dataArray["机组状态"] = "停机";
       		break;
       	case 3:
       		$dataArray["机组状态"] = "自动";
       		break;
       	case 4:
       		$dataArray["机组状态"] = "抽空";
       		break;
       	case 5:
       		$dataArray["机组状态"] = "测试";
       		break;
       	default:
       		$dataArray["机组状态"] = "无效";
       		break;
       }

       $dataArray["蒸发器进水温度（℃）"] = $v[9] / 10;
       $dataArray["蒸发器出水温度（℃）"] = $v[10] / 10;
       $dataArray["环境温度（℃）"] = $v[11] / 10;

       $dataArray["水温设定值调整错误"] = $v[12] == 2049 ? "告警" : "正常";
       $dataArray["需求限制输入错误"] = $v[12] == 2305 ? "告警" : "正常";
       $dataArray["机组外部事件"] = $v[12] == 3329 ? "告警" : "正常";

       $dataArray["系统1运行时掉电"] = $v[13] == 16418 ? "告警" : "正常";
       $dataArray["系统2运行时掉电"] = $v[13] == 16450 ? "告警" : "正常";
       $dataArray["禁止启动 环境温度过低"] = $v[13] == 16642 ? "告警" : "正常";

       $dataArray["系统1压缩机1停机 压缩比过低"] = $v[14] == 32551 ? "告警" : "正常";
       $dataArray["系统2压缩机1停机 压缩比过低"] = $v[14] == 32583 ? "告警" : "正常";
       $dataArray["机组停机 环境温度传感器故障"] = $v[14] == 32771 ? "告警" : "正常";
       $dataArray["系统1压缩机1停机 压缩机过载"] = $v[14] == 34343 ? "告警" : "正常";
       $dataArray["系统2压缩机1停机 压缩机过载"] = $v[14] == 34375 ? "告警" : "正常";
       $dataArray["系统1压缩机1停机 电机温度过高"] = $v[14] == 34599 ? "告警" : "正常";
       $dataArray["系统2压缩机1停机 电机温度过高"] = $v[14] == 34631 ? "告警" : "正常";
       $dataArray["系统1压缩机1停机 电机温度传感器故障"] = $v[14] == 34855 ? "告警" : "正常";
       $dataArray["系统2压缩机1停机 电机温度传感器故障"] = $v[14] == 34887 ? "告警" : "正常";
       $dataArray["系统1压缩机1停机 高压传感器故障"] = $v[14] == 36391 ? "告警" : "正常";
       $dataArray["系统2压缩机1停机 高压传感器故障"] = $v[14] == 36423 ? "告警" : "正常";
       $dataArray["系统1压缩机1停机 高压过高"] = $v[14] == 37159 ? "告警" : "正常";
       $dataArray["系统2压缩机1停机 高压过高"] = $v[14] == 37191 ? "告警" : "正常";
       $dataArray["系统1压缩机1停机 排气温度传感器故障"] = $v[14] == 37671 ? "告警" : "正常";

       $dataArray["系统2传感器1停机 排气温度传感器故障"] = $v[14] == 37703 ? "告警" : "正常";
       $dataArray["系统1压缩机1停机 排气温度过高"] = $v[14] == 37927 ? "告警" : "正常";
       $dataArray["系统2压缩机1停机 排气温度过高"] = $v[14] == 37959 ? "告警" : "正常";
       $dataArray["机组停机 蒸发器水流开关报警"] = $v[14] == 38403 ? "告警" : "正常";
       $dataArray["机组停机 制冷防冻报警"] = $v[14] == 38659 ? "告警" : "正常";
       $dataArray["系统1压缩机1停机 低压过低"] = $v[14] == 39207 ? "告警" : "正常";
       $dataArray["系统2压缩机1停机 低压过低"] = $v[14] == 39239 ? "告警" : "正常";
       $dataArray["系统1压缩机1停机 低压传感器故障"] = $v[14] == 39719 ? "告警" : "正常";
       $dataArray["系统2压缩机1停机 低压传感器故障"] = $v[14] == 39751 ? "告警" : "正常";
       $dataArray["系统1压缩机1停机 重启失败"] = $v[14] == 41255 ? "告警" : "正常";

       $dataArray["系统2压缩机1停机 重启失败"] = $v[14] == 41287 ? "告警" : "正常";
       $dataArray["机组停机 出水温度传感器故障"] = $v[14] == 41475 ? "告警" : "正常";
       $dataArray["机组停机 进水温度传感器故障"] = $v[14] == 41731 ? "告警" : "正常";
       $dataArray["系统1压缩机1停机 高压开关报警"] = $v[14] == 42535 ? "告警" : "正常";
       $dataArray["系统2压缩机1停机 高压开关报警"] = $v[14] == 42567 ? "告警" : "正常";
       $dataArray["系统1压缩机1停机 油压差过高"] = $v[14] == 44071 ? "告警" : "正常";
       $dataArray["系统2压缩机1停机 油压差过高"] = $v[14] == 44103 ? "告警" : "正常";
       $dataArray["系统1压缩机1停机 油压传感器故障"] = $v[14] == 44327 ? "告警" : "正常";
       $dataArray["系统2压缩机1停机 油压传感器故障"] = $v[14] == 44359 ? "告警" : "正常";
       $dataArray["机组停机 逆缺相保护"] = $v[14] == 45059 ? "告警" : "正常";

       $dataArray["系统1压缩机1停机 启动器故障"] = $v[14] == 45351 ? "告警" : "正常";
       $dataArray["系统2压缩机1停机 启动器故障"] = $v[14] == 45383 ? "告警" : "正常";
       $dataArray["系统1压缩机1停机 回气温度传感器故障"] = $v[14] == 46887 ? "告警" : "正常";
       $dataArray["系统2压缩机1停机 回气温度传感器故障"] = $v[14] == 46919 ? "告警" : "正常";
       $dataArray["机组停机 报警输出控制板通信失败"] = $v[14] == 48131 ? "告警" : "正常";
       $dataArray["系统1停机 压缩机控制板通信失败"] = $v[14] == 48163 ? "告警" : "正常";
       $dataArray["系统2停机 压缩机控制板通信失败"] = $v[14] == 48195 ? "告警" : "正常";
       $dataArray["系统1停机 启动时无压力变化"] = $v[14] == 48419 ? "告警" : "正常";
       $dataArray["系统2停机 启动时无压力变化"] = $v[14] == 48451 ? "告警" : "正常";
       $dataArray["系统1停机 启动时无压力"] = $v[14] == 48675 ? "告警" : "正常";

       $dataArray["系统2停机 启动时无压力"] = $v[14] == 48707 ? "告警" : "正常";
       $dataArray["系统1压缩机1停机 能力传感器故障"] = $v[14] == 48935 ? "告警" : "正常";
       $dataArray["系统2压缩机1停机 能力传感器故障"] = $v[14] == 48967 ? "告警" : "正常";
       $dataArray["机组停机 急停开关"] = $v[14] == 49155 ? "告警" : "正常";
       $dataArray["机组停机 蒸发器进出水温度探头接反"] = $v[14] == 49411 ? "告警" : "正常";
       $dataArray["机组停机 外部报警"] = $v[14] == 49667 ? "告警" : "正常";
       $dataArray["系统1压缩机1停机 排气过热度过低"] = $v[14] == 51751 ? "告警" : "正常";
       $dataArray["系统2压缩机1停机 排气过热度过低"] = $v[14] == 51783 ? "告警" : "正常";

       $dataArray['AlertArray']["水温设定值调整错误"] = $v[12] == 2049;
       $dataArray['AlertArray']["需求限制输入错误"] = $v[12] == 2305;
       $dataArray['AlertArray']["机组外部事件"] = $v[12] == 3329;
       $dataArray['AlertArray']["系统1运行时掉电"] =$v[13] == 16418;
       $dataArray['AlertArray']["系统2运行时掉电"] =$v[13] == 16450;
       $dataArray['AlertArray']["禁止启动 环境温度过低"] = $v[13] == 16642;
       $dataArray['AlertArray']["系统1压缩机1停机 压缩比过低"] = $v[14] == 32551;
       $dataArray['AlertArray']["系统2压缩机1停机 压缩比过低"] = $v[14] == 32583;
       $dataArray['AlertArray']["机组停机 环境温度传感器故障"] = $v[14] == 32771;
       $dataArray['AlertArray']["系统1压缩机1停机 压缩机过载"] = $v[14] == 34343;
       $dataArray['AlertArray']["系统2压缩机1停机 压缩机过载"] = $v[14] == 34375;
       $dataArray['AlertArray']["系统1压缩机1停机 电机温度过高"] = $v[14] == 34599;
       $dataArray['AlertArray']["系统2压缩机1停机 电机温度过高"] = $v[14] == 34631;
       $dataArray['AlertArray']["系统1压缩机1停机 电机温度传感器故障"] = $v[14] == 34855;
       $dataArray['AlertArray']["系统2压缩机1停机 电机温度传感器故障"] = $v[14] == 34887;
       $dataArray['AlertArray']["系统1压缩机1停机 高压传感器故障"] = $v[14] == 36391;
       $dataArray['AlertArray']["系统2压缩机1停机 高压传感器故障"] = $v[14] == 36423;
       $dataArray['AlertArray']["系统1压缩机1停机 高压过高"] = $v[14] == 37159;
       $dataArray['AlertArray']["系统2压缩机1停机 高压过高"] = $v[14] == 37191;
       $dataArray['AlertArray']["系统1压缩机1停机 排气温度传感器故障"] = $v[14] == 37671;
       $dataArray['AlertArray']["系统2传感器1停机 排气温度传感器故障"] = $v[14] == 37703;
       $dataArray['AlertArray']["系统1压缩机1停机 排气温度过高"] = $v[14] == 37927;
       $dataArray['AlertArray']["系统2压缩机1停机 排气温度过高"] = $v[14] == 37959;
       $dataArray['AlertArray']["机组停机 蒸发器水流开关报警"] = $v[14] == 38403;
       $dataArray['AlertArray']["机组停机 制冷防冻报警"] = $v[14] == 38659;
       $dataArray['AlertArray']["系统1压缩机1停机 低压过低"] = $v[14] == 39207;
       $dataArray['AlertArray']["系统2压缩机1停机 低压过低"] = $v[14] == 39239;
       $dataArray['AlertArray']["系统1压缩机1停机 低压传感器故障"] = $v[14] == 39719;
       $dataArray['AlertArray']["系统2压缩机1停机 低压传感器故障"] = $v[14] == 39751;
       $dataArray['AlertArray']["系统1压缩机1停机 重启失败"] = $v[14] == 41255;
       $dataArray['AlertArray']["系统2压缩机1停机 重启失败"] = $v[14] == 41287;
       $dataArray['AlertArray']["机组停机 出水温度传感器故障"] = $v[14] == 41475;
       $dataArray['AlertArray']["机组停机 进水温度传感器故障"] = $v[14] == 41731;
       $dataArray['AlertArray']["系统1压缩机1停机 高压开关报警"] = $v[14] == 42535;
       $dataArray['AlertArray']["系统2压缩机1停机 高压开关报警"] = $v[14] == 42567;
       $dataArray['AlertArray']["系统1压缩机1停机 油压差过高"] = $v[14] == 44071;
       $dataArray['AlertArray']["系统2压缩机1停机 油压差过高"] = $v[14] == 44103;
       $dataArray['AlertArray']["系统1压缩机1停机 油压传感器故障"] = $v[14] == 44327;
       $dataArray['AlertArray']["系统2压缩机1停机 油压传感器故障"] = $v[14] == 44359;
       $dataArray['AlertArray']["机组停机 逆缺相保护"] = $v[14] == 45059;
       $dataArray['AlertArray']["系统1压缩机1停机 启动器故障"] = $v[14] == 45351;
       $dataArray['AlertArray']["系统2压缩机1停机 启动器故障"] = $v[14] == 45383;
       $dataArray['AlertArray']["系统1压缩机1停机 回气温度传感器故障"] = $v[14] == 46887;
       $dataArray['AlertArray']["系统2压缩机1停机 回气温度传感器故障"] = $v[14] == 46919;
       $dataArray['AlertArray']["机组停机 报警输出控制板通信失败"] = $v[14] == 48131;
       $dataArray['AlertArray']["系统1停机 压缩机控制板通信失败"] = $v[14] == 48163;
       $dataArray['AlertArray']["系统2停机 压缩机控制板通信失败"] = $v[14] == 48195;
       $dataArray['AlertArray']["系统1停机 启动时无压力变化"] = $v[14] == 48419;
       $dataArray['AlertArray']["系统2停机 启动时无压力变化"] = $v[14] == 48451;
       $dataArray['AlertArray']["系统1停机 启动时无压力"] = $v[14] == 48675;
       $dataArray['AlertArray']["系统2停机 启动时无压力"] = $v[14] == 48707;
       $dataArray['AlertArray']["系统1压缩机1停机 能力传感器故障"] = $v[14] == 48935;
       $dataArray['AlertArray']["系统2压缩机1停机 能力传感器故障"] = $v[14] == 48967;
       $dataArray['AlertArray']["机组停机 急停开关"] = $v[14] == 49155;
       $dataArray['AlertArray']["机组停机 蒸发器进出水温度探头接反"] = $v[14] == 49411;
       $dataArray['AlertArray']["机组停机 外部报警"] = $v[14] == 49667;
       $dataArray['AlertArray']["系统1压缩机1停机 排气过热度过低"] = $v[14] == 51751;
       $dataArray['AlertArray']["系统2压缩机1停机 排气过热度过低"] = $v[14] == 51783;
       
       $dataArray["机组模式设置"] = $v[15] == 2  ? "制冷" : "无效";
       $dataArray["冷水温度设定（℃）"] = $v[16] / 10;
       $dataArray["冰蓄冷温度设定（℃）"] = $v[17] / 10;
       $dataArray["机组能力限制设定（%）"] = $v[18] / 10;
       $dataArray["系统#1冷凝压力（kPa）"] = $v[19] / 10;
       $dataArray["系统#1冷凝温度（℃）"] = $v[20] / 10;
       $dataArray["系统#1蒸发压力（kPa）"] = $v[21] / 10;
       $dataArray["系统#1蒸发温度（℃）"] = $v[22] / 10;
       $dataArray["系统#2冷凝压力（kPa）"] = $v[23] / 10;
       $dataArray["系统#2冷凝温度（℃）"] = $v[24] / 10;
       $dataArray["系统#2蒸发压力（kPa）"] = $v[25] / 10;
       $dataArray["系统#2蒸发温度（℃）"] = $v[26] / 10;
       $dataArray["系统#1吸气温度（℃）"] = $v[27] / 10;
       $dataArray["系统#1排气温度（℃）"] = $v[28] / 10;
       $dataArray["系统#1压缩机启动次数"] = $v[29];
       $dataArray["系统#1压缩机运行时间（h）"] = $v[30];
       $dataArray["系统#2吸气温度（℃）"] = $v[31] / 10;	
       $dataArray["系统#2排气温度（℃）"] = $v[32] / 10;
       $dataArray["系统#2压缩机启动次数"] = $v[33];
       $dataArray["系统#2压缩机运行时间（h）"] = $v[34];
       $dataArray["蒸发器水泵#1运行时间（h）"] = $v[35];
       $dataArray["蒸发器水泵#2运行时间（h）"] = $v[37];
       $dataArray["蒸发器水泵1运行状态"] = $v[36] == 1 ? "运行" : "停机";
       $dataArray["蒸发器水泵2运行状态"] = $v[38] == 1 ? "运行" : "停机";
       $dataArray["GF进水温度（℃）"] = $v[39] / 10;
       $dataArray["GF出水温度（℃）"] = $v[40] / 10;

       $dataArray["自然冷却电动蝶阀"] = $v[41] == 1 ? "闭合" : "断开";
       $dataArray["自然冷却电动蝶阀关反馈"] = $v[42] == 1 ? "闭合" : "断开";
       $dataArray["自然冷却电动蝶阀开反馈"] = $v[43] == 1 ? "闭合" : "断开";
       $dataArray["自然冷却水泵状态"] = $v[44] == 1 ? "运行" : "停机";
       $dataArray["自然冷却运行"] = $v[45] == 1 ? "运行" : "停机";
       $dataArray["系统#2能力（%）"] = $v[46] / 10;
       $dataArray["系统#2系统油压（kPa）"] = $v[47] / 10;
      
       $dataArray["系统#2压缩机状态"] = $v[48] == 1 ? "运行" : "停机";
       $dataArray["系统#1能力（%）"] = $v[49] / 10;
       $dataArray["系统#1系统油压（kPa）"] = $v[50] / 10;
       $dataArray["系统#1压缩机状态"] = $v[51] == 1 ? "运行" : "停机";
       $dataArray["机组降噪"] = $v[52] == 1 ? "开启" : "关闭";
       $v = unpack('v', substr($memData, 4 + 2*52, 2));
       $year = $v[1];
       $v = unpack('C*', substr($memData,  4 + 2*52 + 2, 5));
       $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
   }
}

