<?php
function Get_mec048_h42c0_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '直流负载电流':
            return array(0, $dataArray["总负载电流"]);        
        case '整流模块数量':
            return array(0, 20);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_mec048_h42c0_RtData($memData, &$dataArray, $extraPara = false){
        if(empty($memData) ){
            $dataArray['无数据'] = true;
            $dataArray['更新时间'] = '无';
            $dataArray['错误'] = '数据长度不一致';
        }else{
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            $v = unpack('S*', substr($memData, 4, 2*2));
           
            $dataArray['A相电压'] = number_format($v[1]/10, 1)."V";
            $dataArray['A相电流'] = number_format($v[2]/10, 1)."A";
            $v = unpack("C", substr($memData, 4 + 2*2, 1));
            $dataArray["交流掉电"] = (($v[1] >> 7) & 0x1) == 0 ? "正常" : "告警";
            $dataArray["AlertArray"]["交流掉电"] = (($v[1] >> 7) & 0x1);

            $dataArray["柴油机"] = (($v[1] >> 6) & 0x1) == 0 ? "启动" : "停止";
          
            $dataArray["A相交流空开"] = (($v[1] >> 5) & 0x1) == 0 ? "正常" : "告警";
            $dataArray["AlertArray"]["A相交流空开"] = (($v[1] >> 5) & 0x1);

            $dataArray["A相交流电流过高"] = (($v[1] >> 4) & 0x1) == 0 ? "正常" : "告警";
            $dataArray["AlertArray"]["A相交流电流过高"] = (($v[1] >> 4) & 0x1);

            $dataArray["A相电压过高"] = (($v[1] >> 2) & 0x1) == 0 ? "正常" : "告警";
            $dataArray["AlertArray"]["A相电压过高"] = (($v[1] >> 2) & 0x1);

            $dataArray["A相电压过低"] = (($v[1] >> 1) & 0x1) == 0 ? "正常" : "告警";
            $dataArray["AlertArray"]["A相电压过低"] = (($v[1] >> 1) & 0x1);

            $dataArray["A相电压缺相"] = (($v[1] >> 0) & 0x1) == 0 ? "正常" : "告警";
            $dataArray["AlertArray"]["A相电压缺相"] = (($v[1] >> 0) & 0x1);

            $v = unpack('S*', substr($memData, 4 + 2*2 + 1, 2*2));
           
            $dataArray['B相电压'] = number_format($v[1]/10, 1)."V";
            $dataArray['B相电流'] = number_format($v[2]/10, 1)."A";
            $v = unpack("C", substr($memData, 4 + 2*2 + 1 + 2*2, 1));

            $dataArray["电池对称故障"] = (($v[1] >> 6) & 0x1) == 0 ? "正常" : "告警";
            $dataArray["AlertArray"]["电池对称故障"] = (($v[1] >> 6) & 0x1);

            $dataArray["B相交流空开"] = (($v[1] >> 5) & 0x1) == 0 ? "正常" : "告警";
            $dataArray["AlertArray"]["B相交流空开"] = (($v[1] >> 5) & 0x1);

            $dataArray["B相交流电流过高"] = (($v[1] >> 4) & 0x1) == 0 ? "正常" : "告警";
            $dataArray["AlertArray"]["B相交流电流过高"] = (($v[1] >> 4) & 0x1);

            $dataArray["B相电压过高"] = (($v[1] >> 2) & 0x1) == 0 ? "正常" : "告警";
            $dataArray["AlertArray"]["B相电压过高"] = (($v[1] >> 2) & 0x1);

            $dataArray["B相电压过低"] = (($v[1] >> 1) & 0x1) == 0 ? "正常" : "告警";
            $dataArray["AlertArray"]["B相电压过低"] = (($v[1] >> 1) & 0x1);

            $dataArray["B相电压缺相"] = (($v[1] >> 0) & 0x1) == 0 ? "正常" : "告警";
            $dataArray["AlertArray"]["B相电压缺相"] = (($v[1] >> 0) & 0x1);

            $v = unpack('S*', substr($memData, 4 + 2*2 + 1 + 2*2 + 1, 2*2));
           
            $dataArray['C相电压'] = number_format($v[1]/10, 1)."V";
            $dataArray['C相电流'] = number_format($v[2]/10, 1)."A";
            $v = unpack("C", substr($memData, 4 + 2*2 + 1 + 2*2 + 1 + 2*2, 1));


            $dataArray["C相交流空开"] = (($v[1] >> 5) & 0x1) == 0 ? "正常" : "告警";
            $dataArray["AlertArray"]["C相交流空开"] = (($v[1] >> 5) & 0x1);

            $dataArray["C相交流电流过高"] = (($v[1] >> 4) & 0x1) == 0 ? "正常" : "告警";
            $dataArray["AlertArray"]["C相交流电流过高"] = (($v[1] >> 4) & 0x1);

            $dataArray["C相电压过高"] = (($v[1] >> 2) & 0x1) == 0 ? "正常" : "告警";
            $dataArray["AlertArray"]["C相电压过高"] = (($v[1] >> 2) & 0x1);

            $dataArray["C相电压过低"] = (($v[1] >> 1) & 0x1) == 0 ? "正常" : "告警";
            $dataArray["AlertArray"]["C相电压过低"] = (($v[1] >> 1) & 0x1);

            $dataArray["C相电压缺相"] = (($v[1] >> 0) & 0x1) == 0 ? "正常" : "告警";
            $dataArray["AlertArray"]["C相电压缺相"] = (($v[1] >> 0) & 0x1);


            $v = unpack('S', substr($memData, 4 + 2*2 + 1 + 2*2 + 1 + 2*2 + 1, 2));
            $dataArray['交流频率'] = number_format($v[1]/10 , 1).' Hz';
            $v = unpack("C", substr($memData, 4 + 2*2 + 1 + 2*2 + 1 + 2*2 + 1 + 2, 1));
            
            $dataArray["频率低"] = $v[1] == 1 ? "告警" : "正常";
            $dataArray["AlertArray"]["频率低"] = $v[1] == 1;

            $dataArray["频率高"] = $v[1] == 2 ? "告警" : "正常";
            $dataArray["AlertArray"]["频率高"] = $v[1] == 2;

            $offset = 4 + 2*2 + 1 + 2*2 + 1 + 2*2 + 1 + 2 + 1;

            //$dataArray["整流模块"] = array();
            for($i=0; $i < 20; $i++)
            {
		$label = "整流模块".($i+1);
                $v = unpack('S*', substr($memData, $offset + 10*$i, 2*4));
                $dataArray[$label."输出电压"] = number_format($v[1]/100, 2)."V";
                $dataArray[$label."输出电流"] = number_format($v[2]/100, 1)."A";
                $dataArray[$label."风扇转速"] = $v[3];
                $dataArray[$label."模块温度"] = number_format($v[4]/100, 2);
                $v = unpack('C*', substr($memData, $offset + 10*$i + 2*4, 2));

                $dataArray["AlertArray"] = array();
                $dataArray[$label."模块在位"] = (($v[1] >> 7) & 0x1)== 0 ? "在位" : "不在位";

                $dataArray[$label."模块保护"] = (($v[1] >> 6) & 0x1 ) == 1 ? "告警" : "正常";
                $dataArray["AlertArray"][$label."模块保护"] = (($v[1] >> 6) & 0x1 );

                $dataArray[$label."交流故障"] = (($v[1] >> 5) & 0x1 ) == 1 ? "告警" : "正常";
                $dataArray["AlertArray"][$label."交流故障"] = (($v[1] >> 5) & 0x1 );

                $dataArray[$label."模块风扇故障"] = (($v[1] >> 4) & 0x1 ) == 1 ? "告警" : "正常";
                $dataArray["AlertArray"][$label."模块风扇故障"] = (($v[1] >> 4) & 0x1 );

                $dataArray[$label."模块休眠"] = (($v[1] >> 3)&0x1) == 0 ? "正常" : "休眠";

                $dataArray[$label."模块开关机"] = (($v[1] >> 2)&0x1) == 0 ? "开机" : "关机";

                $dataArray[$label."模块故障"] = (($v[1] >> 1) & 0x1 ) == 1 ? "告警" : "正常";
                $dataArray["AlertArray"][$label."模块故障"] = (($v[1] >> 1) & 0x1 );

                $dataArray[$label."限流标志"] = (($v[1] >> 0) & 0x1 ) == 1 ? "告警" : "正常";
                $dataArray["AlertArray"][$label."限流标志"] = (($v[1] >> 0) & 0x1 );

                switch($v[2])
                {
                    case 1:
                        $dataArray[$label."保护类型"] = "短路保护";
                        break;
                    case 2:
                        $dataArray[$label."保护类型"] = "过温保护";
                        break;    
                    case 3:
                        $dataArray[$label."保护类型"] = "过压保护";
                        break;  
                    case 4:
                        $dataArray[$label."保护类型"] = "交流过压";
                        break; 
                    case 5:
                        $dataArray[$label."保护类型"] = "交流欠压";
                        break; 
                    case 6:
                        $dataArray[$label."保护类型"] = "交流掉电";
                        break; 
                    default:
                        $dataArray[$label."保护类型"] = "正常";
                        break; 
                }                
            }

            $v = unpack('C*', substr($memData, $offset + 10*20, 3));
            $dataArray["主断路器1状态"] = $v[1] == 1 ? "告警" : "正常";
            $dataArray["AlertArray"]["主断路器1状态"] = $v[1] == 1;

            $dataArray["主断路器2状态"] = $v[2] == 1 ? "告警" : "正常";
            $dataArray["AlertArray"]["主断路器2状态"] = $v[2] == 1;

            $dataArray["防雷开关状态"] = $v[3] == 1 ? "告警" : "正常";
            $dataArray["AlertArray"]["防雷开关状态"] = $v[3] == 1;

            $v = unpack('S*', substr($memData, $offset + 10*20 + 3, 2*7));
            $dataArray["电池后备时间"] = number_format($v[1]/10, 1)."小时";

            $dataArray["母排电压"] = number_format($v[2]/100, 1)."V";
            $dataArray["电池电流"] = number_format($v[3]/10, 1)."A";
            $dataArray["总负载电流"] = number_format($v[4]/10, 1)."A";
            $dataArray["电池温度"] = number_format($v[5]/10, 1);
            $dataArray["环境温度"] = number_format($v[6]/10, 1);
            $dataArray["环境湿度"] = number_format($v[7]/10, 1);

            $v = unpack('C*', substr($memData, $offset + 10*20 + 3 + 2*7, 7));
            //status 0
            $dataArray["用户4低压断开操作"] = ( ($v[2] >> 7) & 0x1) == 1 ? "告警" : "正常";
            $dataArray["AlertArray"]["用户4低压断开操作"] = ( ($v[2] >> 7) & 0x1) == 1;

            $dataArray["用户3低压断开操作"] = ( ($v[2] >> 6) & 0x1) == 1 ? "告警" : "正常";
            $dataArray["AlertArray"]["用户3低压断开操作"] = ( ($v[2] >> 6) & 0x1) == 1;

            $dataArray["电池温度传感器故障"] = ( ($v[2] >> 5) & 0x1) == 1 ? "告警" : "正常";
            $dataArray["AlertArray"]["电池温度传感器故障"] = ( ($v[2] >> 5) & 0x1) == 1;

            $dataArray["输出过压"] = ( ($v[2] >> 4) & 0x1) == 1 ? "告警" : "正常";
            $dataArray["AlertArray"]["输出过压"] = ( ($v[2] >> 4) & 0x1) == 1;

            $dataArray["用户2低压断开操作"] = ( ($v[2] >> 3) & 0x1) == 1 ? "告警" : "正常";
            $dataArray["AlertArray"]["用户2低压断开操作"] = ( ($v[2] >> 3) & 0x1) == 1;

            $dataArray["电池低压"] = ( ($v[2] >> 2) & 0x1) == 1 ? "告警" : "正常";
            $dataArray["AlertArray"]["电池低压"] = ( ($v[2] >> 2) & 0x1) == 1;

            $dataArray["系统负载电流过高"] = ( ($v[2] >> 1) & 0x1) == 1 ? "告警" : "正常";
            $dataArray["AlertArray"]["系统负载电流过高"] = ( ($v[2] >> 1) & 0x1) == 1;

            $dataArray["用户1低压断开操作"] = ( ($v[2] >> 0) & 0x1) == 1 ? "告警" : "正常";
            $dataArray["AlertArray"]["用户1低压断开操作"] = ( ($v[2] >> 0) & 0x1) == 1;
            //status 1
            $dataArray["电池状态"] = ( ($v[3] >> 7) & 0x1) == 1 ? "放电" : "充电";

            $dataArray["电池低压断开操作"] = ( ($v[3] >> 6) & 0x1) == 1 ? "告警" : "正常";
            $dataArray["AlertArray"]["电池低压断开操作"] = ( ($v[3] >> 6) & 0x1) == 1;

            $dataArray["环境温度过高"] = ( ($v[3] >> 5) & 0x1) == 1 ? "告警" : "正常";
            $dataArray["AlertArray"]["环境温度过高"] = ( ($v[3] >> 5) & 0x1) == 1;

            $dataArray["环境温度过低"] = ( ($v[3] >> 4) & 0x1) == 1 ? "告警" : "正常";
            $dataArray["AlertArray"]["环境温度过低"] = ( ($v[3] >> 4) & 0x1) == 1;

            $dataArray["负载熔丝"] = ( ($v[3] >> 2) & 0x1) == 1 ? "断" : "通";

            $dataArray["电池熔丝"] = ( ($v[3] >> 1) & 0x1) == 1 ? "断" : "通";

            $dataArray["电池电流过高"] = ( ($v[3] >> 0) & 0x1) == 1 ? "告警" : "正常";
            $dataArray["AlertArray"]["电池电流过高"] = ( ($v[3] >> 0) & 0x1) == 1;
            //status 2 - 6
	    $dataArray["电池温度过高"] = ( ($v[4] >> 6) & 0x1) == 1 ? "告警" : "正常";
	    $dataArray["AlertArray"]["电池温度过高"] = ( ($v[4] >> 6) & 0x1) == 1;

	    $dataArray["电池温度过低"] = ( ($v[4] >> 5) & 0x1) == 1 ? "告警" : "正常";
            $dataArray["AlertArray"]["电池温度过低"] = ( ($v[4] >> 5) & 0x1) == 1;
	
	    $dataArray["传感器1"] = ( ($v[4] >> 4) & 0x1) == 1 ? "断" : "通";
	    $dataArray["传感器2"] = ( ($v[4] >> 2) & 0x1) == 1 ? "断" : "通";
	    $dataArray["传感器3"] = ( ($v[4] >> 1) & 0x1) == 1 ? "断" : "通";
	    $dataArray["传感器4"] = ( ($v[4] ) & 0x1) == 1 ? "断" : "通";
	
	    $dataArray["均充"] = ( ($v[5] >> 4) & 0x1) == 1 ? "使能" : "非使能";
	    $dataArray["浮充"] = ( ($v[5] >> 2) & 0x1) == 1 ? "使能" : "非使能";
	    $dataArray["快充"] = ( ($v[5] >> 1) & 0x1) == 1 ? "使能" : "非使能";
	    $dataArray["电池测试"] = ( ($v[5] >> 0) & 0x1) == 1 ? "使能" : "非使能";

	    $dataArray["门禁"] = ( ($v[6] >> 3) & 0x1) == 1 ? "告警" : "正常";
            $dataArray["AlertArray"]["门禁"] = ( ($v[6] >> 3) & 0x1) == 1;

            $dataArray["防雷"] = ( ($v[6] >> 2) & 0x1) == 1 ? "告警" : "正常";
            $dataArray["AlertArray"]["防雷"] = ( ($v[6] >> 2) & 0x1) == 1;

	    $dataArray["水侵"] = ( ($v[6] >> 1) & 0x1) == 1 ? "告警" : "正常";
            $dataArray["AlertArray"]["水侵"] = ( ($v[6] >> 1) & 0x1) == 1;

            $dataArray["烟雾"] = ( ($v[6] ) & 0x1) == 1 ? "告警" : "正常";
            $dataArray["AlertArray"]["烟雾"] = ( ($v[6] ) & 0x1) == 1;

	    $dataArray["传感器5"] = ( ($v[7] >> 7) & 0x1) == 1 ? "断" : "通";
            $dataArray["传感器6"] = ( ($v[7] >> 6) & 0x1) == 1 ? "断" : "通";
            $dataArray["传感器7"] = ( ($v[7] >> 5) & 0x1) == 1 ? "断" : "通";
            $dataArray["传感器8"] = ( ($v[7] >> 4) & 0x1) == 1 ? "断" : "通";
            $dataArray["传感器9"] = ( ($v[7] >> 3) & 0x1) == 1 ? "断" : "通";
            $dataArray["传感器10"] = ( ($v[7] >> 2) & 0x1) == 1 ? "断" : "通";
            $dataArray["传感器11"] = ( ($v[7] >> 1) & 0x1) == 1 ? "断" : "通";
            $dataArray["传感器12"] = ( ($v[7] ) & 0x1) == 1 ? "断" : "通";


	



            $v = unpack('S*', substr($memData, $offset + 10*20 + 3 + 2*7 + 7, 2*4));
            $dataArray["负载1电流"] = number_format($v[1]/10, 1)."A";
            $dataArray["负载2电流"] = number_format($v[2]/10, 1)."A";
            $dataArray["负载3电流"] = number_format($v[3]/10, 1)."A";
            $dataArray["负载4电流"] = number_format($v[4]/10, 1)."A";

            $v = unpack('I*', substr($memData, $offset + 10*20 + 3 + 2*7 + 7 + 2*4, 4*4));
            $dataArray["用户1电量"] = $v[1];
            $dataArray["用户2电量"] = $v[2];
            $dataArray["用户3电量"] = $v[3];
            $dataArray["用户4电量"] = $v[4];

            $v = unpack('S*', substr($memData, $offset + 10*20 + 3 + 2*7 + 7 + 2*4 + 4*4, 2*6));
            $dataArray["用户1百分比"] = number_format($v[1]/10, 1)."%";
            $dataArray["用户2百分比"] = number_format($v[2]/10, 1)."%";
            $dataArray["用户3百分比"] = number_format($v[3]/10, 1)."%";
            $dataArray["用户4百分比"] = number_format($v[4]/10, 1)."%";

            $dataArray["电池1电流"] = number_format($v[5]/10, 1)."A";
            $dataArray["电池2电流"] = number_format($v[6]/10, 1)."A";



            $v = unpack('v', substr($memData, $offset + 10*20 + 3 + 2*7 + 7 + 2*4 + 4*4 + 2*6, 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, $offset + 10*20 + 3 + 2*7 + 7 + 2*4 + 4*4 + 2*6 + 2, 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}
