<?php
function _Get_Mec2x_SystemStatus($value){
    switch ($value){
        case 0: return '开关在关位置';
        case 1: return '开关不在自动位置';
        case 2: return '发电机组准备好';
        case 3: return '起动延迟';
        case 4: return '起动持续时间';
        case 5: return '复位持续时间';
        case 6: return '旁路延迟';
        case 7: return '发电机组运行';
        case 8: return '冷却';
        case 9: return '发电机组停机';
    }
    return '未定义';
}

function Get_mec2x_RtData($memData, &$dataArray, $extraPara = false){
        if(empty($memData) ){
            $dataArray['无数据'] = true;
            $dataArray['更新时间'] = '无';
            $dataArray['错误'] = '数据长度不一致';
        }else{
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            $v = unpack('c*', substr($memData, 4, 1 * 15));
            if($v[1] == 0){
                $dataArray['远程类型'] = 'MEC2X';
            }else if($v[1] == 1){
                $dataArray['远程类型'] = 'TSC-800';
            }else{
                $dataArray['远程类型'] = '未定义';
            }
            $dataArray['主要信息格式型号'] = $v[2];
            $dataArray['次要信息格式型号'] = $v[3];
            $dataArray['主要软件版本号'] = $v[4];
            $dataArray['次要软件版本号'] = $v[5];
            $dataArray['请求呼叫'] = $v[6] == 1 ? '是' : '否';
            $dataArray['停机激活'] = $v[7] == 1 ? '激活' : '未激活';
            $dataArray['报警激活'] = $v[8] == 1 ? '激活' : '未激活';
            $dataArray['速度信号出现'] = $v[9] == 1 ? '是' : '否';
            $dataArray['发动机控制器准备好'] = $v[10] == 1 ? '是' : '否';
            $dataArray['紧急停止激活'] = $v[11] == 1 ? '激活' : '未激活';
            $dataArray['允许喇叭输出'] = $v[12] == 1 ? '允许' : '不允许';
            $dataArray['允许远程起动输入'] = $v[13] == 1 ? '允许' : '不允许';
            switch ($v[14]){
                case 0: $dataArray['起动方式'] = '手动';
                    break;
                case 1: $dataArray['起动方式'] = '关';
                    break;
                case 2: $dataArray['起动方式'] = '自动';
                    break;
                case 3: $dataArray['起动方式'] = '测试';
                    break;
                default: $dataArray['起动方式'] = '未定义';
            }
            if($v[14] == 2){
                $dataArray['非自动起动告警'] = '正常';
                $dataArray['AlertArray']['非自动起动告警'] = false;
            }else{
                $dataArray['非自动起动告警'] = '告警';
                $dataArray['AlertArray']['非自动起动告警'] = true;
            }
            $dataArray['系统状态'] = _Get_Mec2x_SystemStatus($v[15]);
            $v = unpack('s*', substr($memData, 4+15, 2 * 1));
            $dataArray['系统状态计时器值'] = $v[1].' S';
            $v = unpack('c*', substr($memData, 4+15+2, 1*51));
            $mec2xAlarmList = array('紧急停止','起动失败','超速','丢失速度信号','欠压','过压','欠频','超频','过流','弱电池','电池低电压','电池高电压','发动机低温','发动机高温1','发动机高温2','低油压1','低油压2','数字故障1','数字故障2','数字故障3','数字故障4','数字故障5','数字故障6','数字故障7','数字故障8','数字故障9','数字故障10','数字故障11','数字故障12');
            foreach($mec2xAlarmList as $key=>$alarm){
                $j = $key+1;
                $dataArray[$alarm] = $v[$j] == 1 ? '告警' : '正常';
                $dataArray['AlertArray'][$alarm] = $v[$j] == 1;
            }
            $dataArray['EEPROM配置信息更改计数'] = $v[30];
            $dataArray['故障设置 停机/报警'] = $v[31] == 1 ? '停机' : '报警'; 
            $msg = "";
            for($i=32;$i<48;$i++){
                $msg .= $v[$i];
            }
            $dataArray['ASCII故障名称'] = $msg;
            $temperatureExpressType = $v[48];
            $dataArray['发电机温度单位'] = $v[48] == 1 ? '摄氏度' : '华氏度';
            $oilPressureExpressType = $v[49];
            $dataArray['油压单位'] = $v[49] == 1 ? '千帕' : '磅力/英寸²';
            //   50
            $threePhaseExpressType = $v[51];
            $dataArray['三相/单相'] = $v[51] == 1 ? '三相' : '单相';
            $v = unpack('f*', substr($memData, 4+15+2+51, 4*1));
            $dataArray['电池电压'] = number_format($v[1] , 2).' V';
            $v = unpack('i*', substr($memData, 4+15+2+51+4, 4*12));
            $dataArray['发动机转速'] = $v[1].' r/min';
            //转速超过 100 起动告警
            if($v[1] > 100){
                $dataArray['起动告警'] = '告警';
                $dataArray['AlertArray']['起动告警'] = true;
            }else{
                $dataArray['起动告警'] = '正常';
                $dataArray['AlertArray']['起动告警'] = false;
            }
            $dataArray['运行小时'] = $v[2].' h';
            if($temperatureExpressType == 1){
                $dataArray['发动机温度'] = $v[3].' ℃';
            }else{
                $dataArray['发动机温度'] = $v[3].' ℉';
            }
            if($oilPressureExpressType == 1){
                $dataArray['油压'] = $v[4].' KPa';
            }else{
                $dataArray['油压'] = $v[4].' 磅力/英寸²';
            }
            //三相  单相区分
            if($threePhaseExpressType == 1){
                $dataArray['AB相电压'] = $v[5].' V';
                $dataArray['BC相电压'] = $v[6].' V';
                $dataArray['CA相电压'] = $v[7].' V';
                $dataArray['平均电压'] = $v[8].' V';
                $dataArray['A相电流'] = $v[9].' A';
                $dataArray['B相电流'] = $v[10].' A';
                $dataArray['C相电流'] = $v[11].' A';
                $dataArray['平均电流'] = $v[12].' A';
            }else{
                $dataArray['AB相电压'] = $v[5].' V';
                $dataArray['AN相电压'] = $v[6].' V';
                $dataArray['BN相电压'] = $v[7].' V';
                $dataArray['A相电流'] = $v[10].' A';
                $dataArray['B相电流'] = $v[11].' A';
                $dataArray['平均电流'] = $v[12].' A';
            }
            $v = unpack('f*', substr($memData, 4+15+2+51+ 4 + 4*12, 4*1));
            $dataArray['交流频率'] = number_format($v[1] , 2).' Hz';
            $v = unpack('v', substr($memData, 4+15+2+51+ 4 + 4*12+4, 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, 4+15+2+51+ 4 + 4*12+4+2, 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}
