<?php
function Get_met05_ac8_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['A相线电压'] * 1.732);
        case '[B相电压]':
            return array(0, $dataArray['B相线电压'] * 1.732);
        case '[C相电压]':
            return array(0, $dataArray['C相线电压'] * 1.732);
        case '[总功率]':
            $Ua = $dataArray['A相线电压'];
            $Ub = $dataArray['B相线电压'];
            $Uc = $dataArray['C相线电压'];
            $Ia = $dataArray['主用回路 A 相电流2'];
            $Ib = $dataArray['主用回路 B 相电流2'];
            $Ic = $dataArray['主用回路 C 相电流2'];
            $Ua1 = $dataArray['备用回路 A 相电压2'];
            $Ub1 = $dataArray['备用回路 B 相电压2'];
            $Uc1 = $dataArray['备用回路 C 相电压2'];
            $Ia1 = $dataArray['备用回路 A 相电流2'];
            $Ib1 = $dataArray['备用回路 B 相电流2'];
            $Ic1 = $dataArray['备用回路 C 相电流2'];
            $power = ($Ua*$Ia + $Ub*$Ib + $Uc*$Ic + $Ua1*$Ia1 + $Ub1*$Ib1 + $Uc1*$Ic1)/1000;
            return array(0, $power);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_met05_ac8_Active_Power($dataArray){
    $kwh_A1 = explode(' ',$dataArray['主用回路 A 相电度值']);
    $kwh_B1 = explode(' ',$dataArray['主用回路 B 相电度值']);
    $kwh_C1 = explode(' ',$dataArray['主用回路 C 相电度值']);
    $kwh_A2 = explode(' ',$dataArray['备用回路 A 相电度值']);
    $kwh_B2 = explode(' ',$dataArray['备用回路 B 相电度值']);
    $kwh_C2 = explode(' ',$dataArray['备用回路 C 相电度值']);
    $active_power = $kwh_A1[0] + $kwh_B1[0] + $kwh_C1[0] + $kwh_A2[0] + $kwh_B2[0] + $kwh_C2[0];
    return array(0 , $active_power);
}

 function Get_met05_ac8_RtData($memData, &$dataArray, $extraPara = false){
     if($memData == false){
         $dataArray["无数据"] = true;
         $dataArray["更新时间"] = '无';
     }else{
         $dataArray["无数据"] = false;
         $dataArray['AlertArray'] = array();
         //MET05_0_19_reg_t
         $v = unpack('S*' , substr($memData , 4 , 2*26));
         $dataArray['主用回路电压欠压阈值'] = ($v[1] / 100).' V';
         $dataArray['主用回路电压过压阈值'] = ($v[2] / 100).' V';
         $dataArray['主用回路 A 相电流过流阈值'] = ($v[3] / 100).' A';
         $dataArray['主用回路 B 相电流过流阈值'] = ($v[4] / 100).' A';
         $dataArray['主用回路 C 相电流过流阈值'] = ($v[5] / 100).' A';
         $dataArray['备用回路电压欠压阈值'] = ($v[6] / 100).' V';
         $dataArray['备用回路电压过压阈值'] = ($v[7] / 100).' V';
         $dataArray['备用回路 A 相电流过流阈值'] = ($v[8] / 100).' A';
         $dataArray['备用回路 B 相电流过流阈值'] = ($v[9] / 100).' A';
         $dataArray['备用回路 C 相电流过流阈值'] = ($v[10] / 100).' A';
         $dataArray['主用 A 相电流CT变比'] = $v[11].' A';
         $dataArray['主用 B 相电流CT变比'] = $v[12].' A';
         $dataArray['主用 C 相电流CT变比'] = $v[13].' A';
         $dataArray['备用 A 相电流CT变比'] = $v[14].' A';
         $dataArray['备用 B 相电流CT变比'] = $v[15].' A';
         $dataArray['备用 C 相电流CT变比'] = $v[16].' A';
         $dataArray['主检测板紧急路数'] = $v[17];
         $dataArray['扩展检测板紧急路数'] = $v[18];
         //17-260x0012  没显示
/* 管理员密码第1位
0x0013  管理员密码第2位
0x0014  管理员密码第3位
0x0015  管理员密码第4位
0x0016  管理员密码第5位
0x0017  管理员密码第6位
0x0018  设置标志A
0x0019  设置标志B */
         //MET05_0_2D_reg_t
         $v = unpack('S*' , substr($memData , 4 + 2*26 , 2*46));
         $dataArray['设备类型'] = $v[1];
         $dataArray['软件版本'] = $v[2] / 10;
         $dataArray['主用回路 A 相电压'] = ($v[9] / 100).' V';
         $dataArray['A相线电压'] = ($v[9] / 100);
         $dataArray['主用回路 B 相电压'] = ($v[10] / 100).' V';
         $dataArray['B相线电压'] = ($v[10] / 100);
         $dataArray['主用回路 C 相电压'] = ($v[11] / 100).' V';
         $dataArray['C相线电压'] = ($v[11] / 100);
         $dataArray['主用回路 A 相电流'] = ($v[12] / 100).' A';
         $dataArray['主用回路 B 相电流'] = ($v[13] / 100).' A';
         $dataArray['主用回路 C 相电流'] = ($v[14] / 100).' A';
         $dataArray['主用回路 A 相电流2'] = ($v[12] / 100);
         $dataArray['主用回路 B 相电流2'] = ($v[13] / 100);
         $dataArray['主用回路 C 相电流2'] = ($v[14] / 100);
         $dataArray['备用回路 A 相电压'] = ($v[15] / 100).' V';
         $dataArray['备用回路 B 相电压'] = ($v[16] / 100).' V';
         $dataArray['备用回路 C 相电压'] = ($v[17] / 100).' V';
         $dataArray['备用回路 A 相电流'] = ($v[18] / 100).' A';
         $dataArray['备用回路 B 相电流'] = ($v[19] / 100).' A';
         $dataArray['备用回路 C 相电流'] = ($v[20] / 100).' A';
         $dataArray['备用回路 A 相电压2'] = ($v[15] / 100);
         $dataArray['备用回路 B 相电压2'] = ($v[16] / 100);
         $dataArray['备用回路 C 相电压2'] = ($v[17] / 100);
         $dataArray['备用回路 A 相电流2'] = ($v[18] / 100);
         $dataArray['备用回路 B 相电流2'] = ($v[19] / 100);
         $dataArray['备用回路 C 相电流2'] = ($v[20] / 100);
         $dataArray['主用回路 A 相电度值'] = (($v[27] * 65536 + $v[28]) * 10 + $v[21] / 1000).' KWh';
         $dataArray['主用回路 B 相电度值'] = (($v[29] * 65536 + $v[30]) * 10 + $v[22] / 1000).' KWh';
         $dataArray['主用回路 C 相电度值'] = (($v[31] * 65536 + $v[32]) * 10 + $v[23] / 1000).' KWh';
         $dataArray['备用回路 A 相电度值'] = (($v[33] * 65536 + $v[34]) * 10 + $v[24] / 1000).' KWh';
         $dataArray['备用回路 B 相电度值'] = (($v[35] * 65536 + $v[36]) * 10 + $v[25] / 1000).' KWh';
         $dataArray['备用回路 C 相电度值'] = (($v[37] * 65536 + $v[38]) * 10 + $v[26] / 1000).' KWh';
         $dataArray['主用回路 A 相频率'] = ($v[39] / 100).' Hz';
         $dataArray['备用回路 A 相频率'] = ($v[40] / 100).' Hz';
         $dataArray['主用回路 A 相功率因数'] = ($v[41] / 10000);
         $dataArray['主用回路 B 相功率因数'] = ($v[42] / 10000);
         $dataArray['主用回路 C 相功率因数'] = ($v[43] / 10000);
         $dataArray['备用回路 A 相功率因数'] = ($v[44] / 10000);
         $dataArray['备用回路 B 相功率因数'] = ($v[45] / 10000);
         $dataArray['备用回路 C 相功率因数'] = ($v[46] / 10000);
         //状态
         $dataArray['全局屏蔽已使用'] = $v[3] & 0x1 == 1 ? '使用' : '未使用';
         $dataArray['扩展空开检测板已连接'] = ($v[3] >> 1) & 0x1 == 1 ? '连接' : '未连接';
         $dataArray['管理员已登陆'] = ($v[3] >> 1) & 0x1 == 1 ? '登陆' : '未登陆';
         $dataArray['主空开检测板已连接'] = ($v[3] >> 1) & 0x1 == 1 ? '连接' : '未连接';
         if($v[4] == 1){
             $dataArray['告警类型'] = '非紧急告警';
         }else if($v[4] == 2){
             $dataArray['告警类型'] = '紧急告警';
         }else if($v[4] == 3){
             $dataArray['告警类型'] = '紧急、非紧急告警';
         }else{
             $dataArray['告警类型'] = '无告警';
         }
         //告警
         $dataArray['主用 A相欠压'] = ($v[5] >> 0) & 0x1 == 1 ? '告警' : '正常';
         $dataArray['主用 A相过压'] = ($v[5] >> 1) & 0x1 == 1 ? '告警' : '正常';
         $dataArray['主用 B相欠压'] = ($v[5] >> 2) & 0x1 == 1 ? '告警' : '正常';
         $dataArray['主用 B相过压'] = ($v[5] >> 3) & 0x1 == 1 ? '告警' : '正常';
         $dataArray['主用 C相欠压'] = ($v[5] >> 4) & 0x1 == 1 ? '告警' : '正常';
         $dataArray['主用 C相过压'] = ($v[5] >> 5) & 0x1 == 1 ? '告警' : '正常';
         $dataArray['主空开检测板上有空开断开'] = ($v[5] >> 6) & 0x1 == 1 ? '告警' : '正常';
         $dataArray['主用 A相过流'] = ($v[6] >> 0) & 0x1 == 1 ? '告警' : '正常';
         $dataArray['主用 B相过流'] = ($v[6] >> 1) & 0x1 == 1 ? '告警' : '正常';
         $dataArray['主用 C相过流'] = ($v[6] >> 2) & 0x1 == 1 ? '告警' : '正常';
         $dataArray['备用 A相欠压'] = ($v[7] >> 0) & 0x1 == 1 ? '告警' : '正常';
         $dataArray['备用 A相过压'] = ($v[7] >> 1) & 0x1 == 1 ? '告警' : '正常';
         $dataArray['备用 B相欠压'] = ($v[7] >> 2) & 0x1 == 1 ? '告警' : '正常';
         $dataArray['备用 B相过压'] = ($v[7] >> 3) & 0x1 == 1 ? '告警' : '正常';
         $dataArray['备用 C相欠压'] = ($v[7] >> 4) & 0x1 == 1 ? '告警' : '正常';
         $dataArray['备用 C相过压'] = ($v[7] >> 5) & 0x1 == 1 ? '告警' : '正常';
         $dataArray['扩展空开检测板上有空开断开'] = ($v[7] >> 6) & 0x1 == 1 ? '告警' : '正常';
         $dataArray['备用 A相过流'] = ($v[8] >> 0) & 0x1 == 1 ? '告警' : '正常';
         $dataArray['备用 B相过流'] = ($v[8] >> 1) & 0x1 == 1 ? '告警' : '正常';
         $dataArray['备用 C相过流'] = ($v[8] >> 2) & 0x1 == 1 ? '告警' : '正常';

         $dataArray['AlertArray']['主用 A相欠压'] = ($v[5] >> 0) & 0x1 == 1;
         $dataArray['AlertArray']['主用 A相过压'] = ($v[5] >> 1) & 0x1 == 1;
         $dataArray['AlertArray']['主用 B相欠压'] = ($v[5] >> 2) & 0x1 == 1;
         $dataArray['AlertArray']['主用 B相过压'] = ($v[5] >> 3) & 0x1 == 1;
         $dataArray['AlertArray']['主用 C相欠压'] = ($v[5] >> 4) & 0x1 == 1;
         $dataArray['AlertArray']['主用 C相过压'] = ($v[5] >> 5) & 0x1 == 1;
         $dataArray['AlertArray']['主空开检测板上有空开断开'] = ($v[5] >> 6) & 0x1 == 1;
         $dataArray['AlertArray']['主用 A相过流'] = ($v[6] >> 0) & 0x1 == 1;
         $dataArray['AlertArray']['主用 B相过流'] = ($v[6] >> 1) & 0x1 == 1;
         $dataArray['AlertArray']['主用 C相过流'] = ($v[6] >> 2) & 0x1 == 1;
         $dataArray['AlertArray']['备用 A相欠压'] = ($v[7] >> 0) & 0x1 == 1;
         $dataArray['AlertArray']['备用 A相过压'] = ($v[7] >> 1) & 0x1 == 1;
         $dataArray['AlertArray']['备用 B相欠压'] = ($v[7] >> 2) & 0x1 == 1;
         $dataArray['AlertArray']['备用 B相过压'] = ($v[7] >> 3) & 0x1 == 1;
         $dataArray['AlertArray']['备用 C相欠压'] = ($v[7] >> 4) & 0x1 == 1;
         $dataArray['AlertArray']['备用 C相过压'] = ($v[7] >> 5) & 0x1 == 1;
         $dataArray['AlertArray']['扩展空开检测板上有空开断开'] = ($v[7] >> 6) & 0x1 == 1;
         $dataArray['AlertArray']['备用 A相过流'] = ($v[8] >> 0) & 0x1 == 1;
         $dataArray['AlertArray']['备用 B相过流'] = ($v[8] >> 1) & 0x1 == 1;
         $dataArray['AlertArray']['备用 C相过流'] = ($v[8] >> 2) & 0x1 == 1;

         $v = unpack('v', substr($memData, 4 + 2*72 , 2));
         $year = $v[1];
         $v = unpack('C*', substr($memData, 4 + 2*72 +2, 5));
         $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
     }
 }
