<?php

function Get_modbus_bd330_DeviceIoControl_Parameter($action, $parameter)
{
    if($action == 104){
        return pack("s", $parameter[0]);
    }
    return "";
    
}


function Get_modbus_bd330_DeviceIoControl_ErrorMsg($ret){
    switch($ret){
        case 1:
            return "执行成功";
        case 3:
            return "执行失败，校验不符";
        default:
            return "未知错误";
        }
}


function Get_modbus_bd330_RtData($memData , &$dataArray , $extraPara = false)
{
    if (empty($memData) ) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $v = unpack('S*', substr($memData, 4, 2*19));
        switch($v[1])
        {
            case 1:
                $dataArray['通信控制命令'] = "正转运行";
                break;
            case 2:
                $dataArray['通信控制命令'] = "反转运行";
                break;
            case 3:
                $dataArray['通信控制命令'] = "正转点动";
                break;
            case 4:
                $dataArray['通信控制命令'] = "反转点动";
                break;
            case 5:
                $dataArray['通信控制命令'] = "停机";
                break;
            case 6:
                $dataArray['通信控制命令'] = "自由停机(紧急停机)";
                break;
            case 7:
                $dataArray['通信控制命令'] = "故障复位";
                break;
            case 8:
                $dataArray['通信控制命令'] = "点动停止";
                break;
            default:
                $dataArray['通信控制命令'] = "未知".$v[1];
                break;

        }
        switch($v[2])
        {
            case 1:
                $dataArray['变频器状态'] = "正转运行中";
                break;
            case 2:
                $dataArray['变频器状态'] = "反转运行中";
                break;
            case 3:
                $dataArray['变频器状态'] = "变频器待机中";
                break;
            case 4:
                $dataArray['变频器状态'] = "故障中";
                break;
        }
        $dataArray['通信设定值'] = $v[3];
        $dataArray['设定频率'] = $v[4];
        $dataArray['运行频率'] = $v[5];
        $dataArray['输出电流'] = $v[6];
        $dataArray['输出电压'] = $v[7]/10;
        $dataArray['运行转速'] = $v[8];
        $dataArray['输出功率'] = $v[9];
        $dataArray['输出转矩'] = $v[10];
        $dataArray['母线电压'] = $v[11]/10;
        $dataArray['PID设置值'] = $v[12];
        $dataArray['PID反馈值'] = $v[13];
        $dataArray['输入端子标志'] = $v[14];
        $dataArray['输出端子标志'] = $v[15];
        $dataArray['模拟量VI值'] = $v[16];
        $dataArray['模拟量CI值'] = $v[17];
        $dataArray['多段数当前段数'] = $v[18];
        $dataArray['变频器故障地址'] = $v[19];
        $v = unpack('v', substr($memData, 4 + 2*19, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 2*19 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

?>
