<?php

function Get_modbus_db600_DeviceIoControl_Parameter($action, $parameter)
{
    if($action == 104){
        return pack("s", $parameter[0]);
    }
    return "";
    
}


function Get_modbus_db600_DeviceIoControl_ErrorMsg($ret){
    switch($ret){
        case 1:
            return "执行成功";
        case 3:
            return "执行失败，校验不符";
        default:
            return "未知错误";
        }
}


function Get_modbus_db600_RtData($memData , &$dataArray , $extraPara = false)
{
    if ($memData == false) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $v = unpack('s*', substr($memData, 4, 2*35));
        switch($v[1])
        {
            case 1:
                $dataArray['变频器状态'] = "正转运行";
                break;
            case 2:
                $dataArray['变频器状态'] = "反转运行";
                break;
            case 3:
                $dataArray['变频器状态'] = "停机";
                break;
        }
        $dataArray['通信设定值'] = $v[2];
        $dataArray['运行频率'] = $v[3];
        $dataArray['母线电压'] = $v[4];
        $dataArray['输出电压'] = $v[5];
        $dataArray['输出电流'] = $v[6];
        $dataArray['输出功率'] = $v[7];
        $dataArray['输出扭矩'] = $v[8];
        $dataArray['运行速度'] = $v[9];
        $dataArray['输入端子标志'] = $v[10];
        $dataArray['输出端子标志'] = $v[11];
        $dataArray['AI1电压'] = $v[12];
        $dataArray['AI2电压'] = $v[13];
        $dataArray['AI3电压'] = $v[14];
        $dataArray['计数值输入'] = $v[15];
        $dataArray['长度值输入'] = $v[16];
        $dataArray['负载速度'] = $v[17];
        $dataArray['PID设置'] = $v[18];

        $dataArray['PID反馈值'] = $v[19];
        $dataArray['PLC步骤'] = $v[20];
        $dataArray['PULSE输入脉冲频率1'] = ($v[21]/100)."kHz";
        $dataArray['反馈速度'] = ($v[22]/10)."Hz";
        $dataArray['剩余运行时间'] = $v[23];
        $dataArray['AI1校正前电压'] = $v[24];
        $dataArray['AI2校正前电压'] = $v[25];
        $dataArray['AI3校正前电压'] = $v[26];
        $dataArray['线速度'] = $v[27];
        $dataArray['当前上电时间'] = $v[28];
        $dataArray['当前运行时间'] = $v[29];
        $dataArray['PULSE输入脉冲频率2'] = $v[30]."Hz";
        $dataArray['通讯设定值'] = $v[31];
        $dataArray['实际反馈速度'] = $v[32];
        $dataArray['A频率显示'] = $v[33];
        $dataArray['B频率显示'] = $v[34];

        switch($v[35])
        {
            case 0:
                $dataArray['故障状态'] = "无故障";
                break;
            case 1:
                $dataArray['故障状态'] = "加速过电流(E004)";
                break;
            case 2:
                $dataArray['故障状态'] = "减速过电流(E005)";
                break;
            case 3:
                $dataArray['故障状态'] = "恒速过电流(E006)";
                break;
            case 4:
                $dataArray['故障状态'] = "加速过电压(E002)";
                break;
            case 5:
                $dataArray['故障状态'] = "减速过电压(E00A)";
                break;
            case 6:
                $dataArray['故障状态'] = "恒速过电压(E003)";
                break;
            case 7:
                $dataArray['故障状态'] = "欠压故障(E001)";
                break;
            case 8:
                $dataArray['故障状态'] = "电机过载(E007)";
                break;
            case 9:
                $dataArray['故障状态'] = "变频器过载(E008)";
                break;
            case 0xA:
                $dataArray['故障状态'] = "输入侧缺相(E012)";
                break;
            case 0xB:
                $dataArray['故障状态'] = "输出侧缺相(E013)";
                break;
            case 0xC:
                $dataArray['故障状态'] = "逆变模块过热(E00E)";
                break;
            case 0xD:
                $dataArray['故障状态'] = "缓冲电阻过载(E014)";
                break;
            case 0xE:
                $dataArray['故障状态'] = "接触器吸合异常(E017)";
                break;
            case 0xF:
                $dataArray['故障状态'] = "外部故障(E00d)";
                break;
            case 0x10:
                $dataArray['故障状态'] = "通讯故障(E018)";
                break;
            case 0x11:
                $dataArray['故障状态'] = "电流检测故障(E015)";
                break;
            case 0x12:
                $dataArray['故障状态'] = "电机自学习故障(E016)";
                break;
            case 0x13:
                $dataArray['故障状态'] = "运行时间到达(E020)";
                break;  
            case 0x14:
                $dataArray['故障状态'] = "EEPROM故障(E00F)";
                break;
            case 0x15:
                $dataArray['故障状态'] = "电机对地短路故障(E023)";
                break; 
            case 0x16:
                $dataArray['故障状态'] = "运行时PID反馈丢失(E02E)";
                break; 
            case 0x17:
                $dataArray['故障状态'] = "编码器/PG卡异常(E026)";
                break;
            case 0x18:
                $dataArray['故障状态'] = "变频器硬件异常(E033)";
                break;
            case 0x19:
                $dataArray['故障状态'] = "上电时间到达(E029)";
                break;
            case 0x1A:
                $dataArray['故障状态'] = "掉载(E030)";
                break;
            case 0x1B:
                $dataArray['故障状态'] = "快速限流超时(E032)";
                break;
            case 0x1C:
                $dataArray['故障状态'] = "速度偏差过大(E034)";
                break;
            case 0x1D:
                $dataArray['故障状态'] = "运行时切换电机(E038)";
                break;
            case 0x1E:
                $dataArray['故障状态'] = "电机超速(E035)";
                break;
            case 0x1F:
                $dataArray['故障状态'] = "电机过温(E036)";
                break;
            case 0x20:
                $dataArray['故障状态'] = "初始位置错误(E037)";
                break;
        }
        
        $v = unpack('v', substr($memData, 4 + 2*35, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 2*35 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

?>
